/*
 * Decompiled with CFR 0.152.
 */
package hyperscout2.applet;

import hyperscout2.applet.DisplayApplet;
import hyperscout2.applet.PopupLine;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.net.URL;
import scone.ras.Connection;

class PopupWindow
extends Window {
    int lineCount = 0;
    int linePos = 1;
    int width = 0;
    int height = 0;
    public PopupLine[] lines = new PopupLine[30];
    public Image[] images = new Image[30];
    public boolean doCache = false;
    PopupLine active = null;
    PopupLine over = null;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    DisplayApplet applet = null;
    static final Color bgColor = new Color(255, 255, 255);
    static final Color borderColor = new Color(128, 128, 128);
    static final String server = "localhost";
    static final int port = 8084;
    static final String generator = "hyperscout2.LinkDataGenerator";
    static final String wbiPort = "8088";
    static final String resPath = "/_hyperscout2/resources/";

    PopupWindow(DisplayApplet displayApplet, String string) {
        super(new Frame());
        ((Component)this).setBackground(bgColor);
        this.applet = displayApplet;
        this.setFont(new Font("SansSerif", 0, 11));
        this.buildPopup(string, displayApplet.getGraphics().getFontMetrics(new Font("SansSerif", 0, 11)));
    }

    void buildPopup(String string, FontMetrics fontMetrics) {
        try {
            Connection connection = new Connection(server, 8084, generator, false);
            System.out.println("Connetion created: " + connection);
            connection.wake();
            System.out.println("Link:" + string);
            connection.write(string);
            System.out.println("Linkid written!");
            String string2 = "";
            while (!string2.equals("--begin")) {
                string2 = connection.read();
            }
            System.out.println(string2);
            string2 = connection.read();
            if (string2.equals("cache")) {
                this.doCache = true;
            }
            while (!string2.equals("--end")) {
                string2 = connection.read();
                if (!string2.equals("--line")) continue;
                String string3 = connection.read();
                String string4 = connection.read();
                String string5 = connection.read();
                String string6 = connection.read();
                if (string3.equals("--end") || string4.equals("--end") || string5.equals("--end") || string6.equals("--end")) break;
                Image image = this.applet.getImage(new URL("http://localhost:8088/_hyperscout2/resources/" + string3));
                this.prepareImage(image, this);
                PopupLine popupLine = new PopupLine(image, string4, string5, string6, 400, fontMetrics);
                this.addLine(popupLine);
            }
            connection.close();
        }
        catch (Exception exception) {
            try {
                Image image = this.applet.getImage(new URL("http://localhost:8088/_hyperscout2/resources/flash.gif"));
                PopupLine popupLine = new PopupLine(image, "Error", exception.toString(), "FF8080", 400, fontMetrics);
                this.addLine(popupLine);
            }
            catch (Exception exception2) {
                System.err.println("Error sending error message");
                exception2.printStackTrace();
            }
            exception.printStackTrace();
        }
    }

    int findLine(String string) {
        for (int i = 0; i < this.lineCount; ++i) {
            if (!this.lines[i].getTitle().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void setMinSize() {
        this.width = 0;
        this.height = 0;
        Rectangle rectangle = null;
        for (int i = 0; i < this.lineCount; ++i) {
            rectangle = this.lines[i].getBounds();
            if (rectangle.x + rectangle.width > this.width) {
                this.width = rectangle.x + rectangle.width;
            }
            if (rectangle.y + rectangle.height <= this.height) continue;
            this.height = rectangle.y + rectangle.height;
        }
        if (DisplayApplet.browser.indexOf("Netscape") >= 0) {
            this.resize(this.width + 1, this.height + 1);
        } else if (DisplayApplet.browser.indexOf("Sun Microsystems") >= 0) {
            this.resize(this.width + 1, this.height + 22);
        } else {
            this.resize(this.width + 1, this.height + 18);
        }
    }

    public int getHeight() {
        return this.height + 2;
    }

    public int getWidth() {
        return this.width + 2;
    }

    private void addLine(PopupLine popupLine) {
        popupLine.setParent(this);
        popupLine.setLocation(1, this.linePos);
        Rectangle rectangle = popupLine.getBounds();
        this.linePos += rectangle.height + 0;
        this.lines[this.lineCount] = popupLine;
        ++this.lineCount;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public synchronized void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(((Component)this).getBackground());
        this.offgraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offgraphics.setColor(borderColor);
        if (DisplayApplet.browser.indexOf("Netscape") >= 0) {
            this.offgraphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        } else {
            this.offgraphics.drawRect(0, 0, dimension.width - 1, dimension.height - 18);
        }
        for (int i = 0; i < this.lineCount; ++i) {
            this.lines[i].paint(this.offgraphics);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public PopupLine findLine(int n, int n2) {
        for (int i = 0; i < this.lineCount; ++i) {
            if (!this.lines[i].contains(n, n2)) continue;
            return this.lines[i];
        }
        return null;
    }

    public boolean doCache() {
        return this.doCache;
    }

    public void hide() {
        super.hide();
    }
}

