/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.BlockCipher;
import Acme.Crypto.CryptoUtils;

public class AesCipher
extends BlockCipher {
    public static final int KEY_SIZE = 16;
    public static final int BLOCK_SIZE = 16;
    private static final int[] alog;
    private static final int[] log;
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] T1;
    private static final int[] T2;
    private static final int[] T3;
    private static final int[] T4;
    private static final int[] T5;
    private static final int[] T6;
    private static final int[] T7;
    private static final int[] T8;
    private static final int[] U1;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final byte[] rcon;
    private static final int[][][] shifts;
    private static final char[] HEX_DIGITS;
    private int ROUNDS = AesCipher.getRounds(16, 16);
    private int BC = 4;
    private int[][] Ke = new int[this.ROUNDS + 1][this.BC];
    private int[][] Kd = new int[this.ROUNDS + 1][this.BC];
    private int[] tempInts = new int[8];

    static final int mul(int a, int b) {
        return a != 0 && b != 0 ? alog[(log[a & 0xFF] + log[b & 0xFF]) % 255] : 0;
    }

    static final int mul4(int a, byte[] b) {
        if (a == 0) {
            return 0;
        }
        a = log[a & 0xFF];
        int a0 = b[0] != 0 ? alog[(a + log[b[0] & 0xFF]) % 255] & 0xFF : 0;
        int a1 = b[1] != 0 ? alog[(a + log[b[1] & 0xFF]) % 255] & 0xFF : 0;
        int a2 = b[2] != 0 ? alog[(a + log[b[2] & 0xFF]) % 255] & 0xFF : 0;
        int a3 = b[3] != 0 ? alog[(a + log[b[3] & 0xFF]) % 255] & 0xFF : 0;
        return a0 << 24 | a1 << 16 | a2 << 8 | a3;
    }

    public static int getRounds(int keySize, int blockSize) {
        switch (keySize) {
            case 16: {
                return blockSize == 16 ? 10 : (blockSize == 24 ? 12 : 14);
            }
            case 24: {
                return blockSize != 32 ? 12 : 14;
            }
        }
        return 14;
    }

    public AesCipher(String keyStr) {
        super(16, 16);
        this.setKey(keyStr);
    }

    public AesCipher(byte[] key) {
        super(16, 16);
        this.setKey(key);
    }

    public void setKey(byte[] key) {
        int tt;
        if (key.length != 16) {
            throw new RuntimeException("Incorrect key length");
        }
        int ROUND_KEY_COUNT = (this.ROUNDS + 1) * this.BC;
        int KC = 4;
        int[] tk = new int[KC];
        int i = 0;
        int j = 0;
        while (i < KC) {
            tk[i++] = (key[j++] & 0xFF) << 24 | (key[j++] & 0xFF) << 16 | (key[j++] & 0xFF) << 8 | key[j++] & 0xFF;
        }
        int t = 0;
        j = 0;
        while (j < KC && t < ROUND_KEY_COUNT) {
            this.Ke[t / this.BC][t % this.BC] = tk[j];
            this.Kd[this.ROUNDS - t / this.BC][t % this.BC] = tk[j];
            ++j;
            ++t;
        }
        int rconpointer = 0;
        while (t < ROUND_KEY_COUNT) {
            tt = tk[KC - 1];
            tk[0] = tk[0] ^ ((S[tt >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[tt >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[tt & 0xFF] & 0xFF) << 8 ^ S[tt >>> 24 & 0xFF] & 0xFF ^ (rcon[rconpointer++] & 0xFF) << 24);
            if (KC != 8) {
                i = 1;
                j = 0;
                while (i < KC) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
            } else {
                i = 1;
                j = 0;
                while (i < KC / 2) {
                    int n = i++;
                    tk[n] = tk[n] ^ tk[j++];
                }
                tt = tk[KC / 2 - 1];
                int n = KC / 2;
                tk[n] = tk[n] ^ (S[tt & 0xFF] & 0xFF ^ (S[tt >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[tt >>> 16 & 0xFF] & 0xFF) << 16 ^ (S[tt >>> 24 & 0xFF] & 0xFF) << 24);
                j = KC / 2;
                i = j + 1;
                while (i < KC) {
                    int n2 = i++;
                    tk[n2] = tk[n2] ^ tk[j++];
                }
            }
            j = 0;
            while (j < KC && t < ROUND_KEY_COUNT) {
                this.Ke[t / this.BC][t % this.BC] = tk[j];
                this.Kd[this.ROUNDS - t / this.BC][t % this.BC] = tk[j];
                ++j;
                ++t;
            }
        }
        int r = 1;
        while (r < this.ROUNDS) {
            j = 0;
            while (j < this.BC) {
                tt = this.Kd[r][j];
                this.Kd[r][j] = U1[tt >>> 24 & 0xFF] ^ U2[tt >>> 16 & 0xFF] ^ U3[tt >>> 8 & 0xFF] ^ U4[tt & 0xFF];
                ++j;
            }
            ++r;
        }
    }

    public void encrypt(byte[] clearText, int clearOff, byte[] cipherText, int cipherOff) {
        int SC = this.BC == 4 ? 0 : (this.BC == 6 ? 1 : 2);
        int s1 = shifts[SC][1][0];
        int s2 = shifts[SC][2][0];
        int s3 = shifts[SC][3][0];
        int[] a = new int[this.BC];
        int[] t = new int[this.BC];
        int i = 0;
        while (i < this.BC) {
            t[i] = ((clearText[clearOff++] & 0xFF) << 24 | (clearText[clearOff++] & 0xFF) << 16 | (clearText[clearOff++] & 0xFF) << 8 | clearText[clearOff++] & 0xFF) ^ this.Ke[0][i];
            ++i;
        }
        int r = 1;
        while (r < this.ROUNDS) {
            i = 0;
            while (i < this.BC) {
                a[i] = T1[t[i] >>> 24 & 0xFF] ^ T2[t[(i + s1) % this.BC] >>> 16 & 0xFF] ^ T3[t[(i + s2) % this.BC] >>> 8 & 0xFF] ^ T4[t[(i + s3) % this.BC] & 0xFF] ^ this.Ke[r][i];
                ++i;
            }
            System.arraycopy(a, 0, t, 0, this.BC);
            ++r;
        }
        i = 0;
        while (i < this.BC) {
            int tt = this.Ke[this.ROUNDS][i];
            cipherText[cipherOff++] = (byte)(S[t[i] >>> 24 & 0xFF] ^ tt >>> 24);
            cipherText[cipherOff++] = (byte)(S[t[(i + s1) % this.BC] >>> 16 & 0xFF] ^ tt >>> 16);
            cipherText[cipherOff++] = (byte)(S[t[(i + s2) % this.BC] >>> 8 & 0xFF] ^ tt >>> 8);
            cipherText[cipherOff++] = (byte)(S[t[(i + s3) % this.BC] & 0xFF] ^ tt);
            ++i;
        }
    }

    public void decrypt(byte[] cipherText, int cipherOff, byte[] clearText, int clearOff) {
        int SC = this.BC == 4 ? 0 : (this.BC == 6 ? 1 : 2);
        int s1 = shifts[SC][1][1];
        int s2 = shifts[SC][2][1];
        int s3 = shifts[SC][3][1];
        int[] a = new int[this.BC];
        int[] t = new int[this.BC];
        int i = 0;
        while (i < this.BC) {
            t[i] = ((cipherText[cipherOff++] & 0xFF) << 24 | (cipherText[cipherOff++] & 0xFF) << 16 | (cipherText[cipherOff++] & 0xFF) << 8 | cipherText[cipherOff++] & 0xFF) ^ this.Kd[0][i];
            ++i;
        }
        int r = 1;
        while (r < this.ROUNDS) {
            i = 0;
            while (i < this.BC) {
                a[i] = T5[t[i] >>> 24 & 0xFF] ^ T6[t[(i + s1) % this.BC] >>> 16 & 0xFF] ^ T7[t[(i + s2) % this.BC] >>> 8 & 0xFF] ^ T8[t[(i + s3) % this.BC] & 0xFF] ^ this.Kd[r][i];
                ++i;
            }
            System.arraycopy(a, 0, t, 0, this.BC);
            ++r;
        }
        i = 0;
        while (i < this.BC) {
            int tt = this.Kd[this.ROUNDS][i];
            clearText[clearOff++] = (byte)(Si[t[i] >>> 24 & 0xFF] ^ tt >>> 24);
            clearText[clearOff++] = (byte)(Si[t[(i + s1) % this.BC] >>> 16 & 0xFF] ^ tt >>> 16);
            clearText[clearOff++] = (byte)(Si[t[(i + s2) % this.BC] >>> 8 & 0xFF] ^ tt >>> 8);
            clearText[clearOff++] = (byte)(Si[t[(i + s3) % this.BC] & 0xFF] ^ tt);
            ++i;
        }
    }

    public static void main(String[] args) {
        byte[] cipherText = new byte[16];
        byte[] decipherText = new byte[16];
        AesCipher aesa = new AesCipher("0123456789");
        byte[] clearText1 = new byte[16];
        System.out.println("cleartext: " + CryptoUtils.toStringBlock(clearText1));
        aesa.encrypt(clearText1, cipherText);
        System.out.println("encrypted: " + CryptoUtils.toStringBlock(cipherText));
        aesa.decrypt(cipherText, decipherText);
        System.out.println("decrypted: " + CryptoUtils.toStringBlock(decipherText));
        System.out.println();
        AesCipher aesb = new AesCipher("abcdefghijklmnopqrstuvwxyz");
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byte[] clearText2 = byArray;
        System.out.println("cleartext: " + CryptoUtils.toStringBlock(clearText2));
        aesb.encrypt(clearText2, cipherText);
        System.out.println("encrypted: " + CryptoUtils.toStringBlock(cipherText));
        aesb.decrypt(cipherText, decipherText);
        System.out.println("decrypted: " + CryptoUtils.toStringBlock(decipherText));
    }

    static {
        int t;
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        shifts = new int[][][]{new int[][]{new int[2], {1, 3}, {2, 2}, {3, 1}}, new int[][]{new int[2], {1, 5}, {2, 4}, {3, 3}}, new int[][]{new int[2], {1, 7}, {3, 5}, {4, 4}}};
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int ROOT = 283;
        int j = 0;
        AesCipher.alog[0] = 1;
        int i = 1;
        while (i < 256) {
            j = alog[i - 1] << 1 ^ alog[i - 1];
            if ((j & 0x100) != 0) {
                j ^= ROOT;
            }
            AesCipher.alog[i] = j;
            ++i;
        }
        i = 1;
        while (i < 255) {
            AesCipher.log[AesCipher.alog[i]] = i;
            ++i;
        }
        byte[][] byArrayArray = new byte[8][];
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[4] = 1;
        byArray2[5] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArray3[5] = 1;
        byArray3[6] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[8];
        byArray4[3] = 1;
        byArray4[4] = 1;
        byArray4[5] = 1;
        byArray4[6] = 1;
        byArray4[7] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 1;
        byArray5[4] = 1;
        byArray5[5] = 1;
        byArray5[6] = 1;
        byArray5[7] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[8];
        byArray6[0] = 1;
        byArray6[1] = 1;
        byArray6[5] = 1;
        byArray6[6] = 1;
        byArray6[7] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[8];
        byArray7[0] = 1;
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArray7[6] = 1;
        byArray7[7] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[8];
        byArray8[0] = 1;
        byArray8[1] = 1;
        byArray8[2] = 1;
        byArray8[3] = 1;
        byArray8[7] = 1;
        byArrayArray[7] = byArray8;
        byte[][] A = byArrayArray;
        byte[] byArray9 = new byte[8];
        byArray9[1] = 1;
        byArray9[2] = 1;
        byArray9[6] = 1;
        byArray9[7] = 1;
        byte[] B = byArray9;
        byte[][] box = new byte[256][8];
        box[1][7] = 1;
        i = 2;
        while (i < 256) {
            j = alog[255 - log[i]];
            t = 0;
            while (t < 8) {
                box[i][t] = (byte)(j >>> 7 - t & 1);
                ++t;
            }
            ++i;
        }
        byte[][] cox = new byte[256][8];
        i = 0;
        while (i < 256) {
            t = 0;
            while (t < 8) {
                cox[i][t] = B[t];
                j = 0;
                while (j < 8) {
                    byte[] byArray10 = cox[i];
                    int n = t;
                    byArray10[n] = (byte)(byArray10[n] ^ A[t][j] * box[i][j]);
                    ++j;
                }
                ++t;
            }
            ++i;
        }
        i = 0;
        while (i < 256) {
            AesCipher.S[i] = (byte)(cox[i][0] << 7);
            t = 1;
            while (t < 8) {
                int n = i;
                S[n] = (byte)(S[n] ^ cox[i][t] << 7 - t);
                ++t;
            }
            AesCipher.Si[AesCipher.S[i] & 0xFF] = (byte)i;
            ++i;
        }
        byte[][] G = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] AA = new byte[4][8];
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                AA[i][j] = G[i][j];
                ++j;
            }
            AA[i][i + 4] = 1;
            ++i;
        }
        byte[][] iG = new byte[4][4];
        i = 0;
        while (i < 4) {
            byte pivot = AA[i][i];
            if (pivot == 0) {
                t = i + 1;
                while (AA[t][i] == 0 && t < 4) {
                    ++t;
                }
                if (t == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                j = 0;
                while (j < 8) {
                    byte tmp = AA[i][j];
                    AA[i][j] = AA[t][j];
                    AA[t][j] = tmp;
                    ++j;
                }
                pivot = AA[i][i];
            }
            j = 0;
            while (j < 8) {
                if (AA[i][j] != 0) {
                    AA[i][j] = (byte)alog[(255 + log[AA[i][j] & 0xFF] - log[pivot & 0xFF]) % 255];
                }
                ++j;
            }
            t = 0;
            while (t < 4) {
                if (i != t) {
                    j = i + 1;
                    while (j < 8) {
                        byte[] byArray11 = AA[t];
                        int n = j;
                        byArray11[n] = (byte)(byArray11[n] ^ AesCipher.mul(AA[i][j], AA[t][i]));
                        ++j;
                    }
                    AA[t][i] = 0;
                }
                ++t;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            j = 0;
            while (j < 4) {
                iG[i][j] = AA[i][j + 4];
                ++j;
            }
            ++i;
        }
        t = 0;
        while (t < 256) {
            byte s = S[t];
            AesCipher.T1[t] = AesCipher.mul4(s, G[0]);
            AesCipher.T2[t] = AesCipher.mul4(s, G[1]);
            AesCipher.T3[t] = AesCipher.mul4(s, G[2]);
            AesCipher.T4[t] = AesCipher.mul4(s, G[3]);
            s = Si[t];
            AesCipher.T5[t] = AesCipher.mul4(s, iG[0]);
            AesCipher.T6[t] = AesCipher.mul4(s, iG[1]);
            AesCipher.T7[t] = AesCipher.mul4(s, iG[2]);
            AesCipher.T8[t] = AesCipher.mul4(s, iG[3]);
            AesCipher.U1[t] = AesCipher.mul4(t, iG[0]);
            AesCipher.U2[t] = AesCipher.mul4(t, iG[1]);
            AesCipher.U3[t] = AesCipher.mul4(t, iG[2]);
            AesCipher.U4[t] = AesCipher.mul4(t, iG[3]);
            ++t;
        }
        AesCipher.rcon[0] = 1;
        int r = 1;
        t = 1;
        while (t < 30) {
            int n = t++;
            r = AesCipher.mul(2, r);
            AesCipher.rcon[n] = (byte)r;
        }
    }
}

