/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

public class CryptoUtils {
    public static void zeroBlock(byte[] block, int off, int len) {
        int i = off;
        while (i < off + len) {
            block[i] = 0;
            ++i;
        }
    }

    public static void zeroBlock(byte[] block) {
        CryptoUtils.zeroBlock(block, 0, block.length);
    }

    public static void randomBlock(byte[] block, int off, int len) {
        int i = off;
        while (i < off + len) {
            block[i] = (byte)(Math.random() * 256.0);
            ++i;
        }
    }

    public static void randomBlock(byte[] block) {
        CryptoUtils.randomBlock(block, 0, block.length);
    }

    public static void xorBlock(byte[] a, int aOff, byte[] b, int bOff, byte[] dst, int dstOff, int len) {
        int i = 0;
        while (i < len) {
            dst[dstOff + i] = (byte)(a[aOff + i] ^ b[bOff + i]);
            ++i;
        }
    }

    public static void xorBlock(byte[] a, byte[] b, byte[] dst) {
        CryptoUtils.xorBlock(a, 0, b, 0, dst, 0, a.length);
    }

    public static void copyBlock(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        int i = 0;
        while (i < len) {
            dst[dstOff + i] = src[srcOff + i];
            ++i;
        }
    }

    public static void copyBlock(byte[] src, byte[] dst) {
        CryptoUtils.copyBlock(src, 0, dst, 0, src.length);
    }

    public static boolean equalsBlock(byte[] a, int aOff, byte[] b, int bOff, int len) {
        int i = 0;
        while (i < len) {
            if (a[aOff + i] != b[bOff + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsBlock(byte[] a, byte[] b) {
        return CryptoUtils.equalsBlock(a, 0, b, 0, a.length);
    }

    public static void fillBlock(byte[] block, int blockOff, byte b, int len) {
        int i = blockOff;
        while (i < blockOff + len) {
            block[i] = b;
            ++i;
        }
    }

    public static void fillBlock(byte[] block, byte b) {
        CryptoUtils.fillBlock(block, 0, b, block.length);
    }

    public static void squashBytesToInts(byte[] inBytes, int inOff, int[] outInts, int outOff, int intLen) {
        int i = 0;
        while (i < intLen) {
            outInts[outOff + i] = (inBytes[inOff + i * 4] & 0xFF) << 24 | (inBytes[inOff + i * 4 + 1] & 0xFF) << 16 | (inBytes[inOff + i * 4 + 2] & 0xFF) << 8 | inBytes[inOff + i * 4 + 3] & 0xFF;
            ++i;
        }
    }

    public static void spreadIntsToBytes(int[] inInts, int inOff, byte[] outBytes, int outOff, int intLen) {
        int i = 0;
        while (i < intLen) {
            outBytes[outOff + i * 4] = (byte)(inInts[inOff + i] >>> 24 & 0xFF);
            outBytes[outOff + i * 4 + 1] = (byte)(inInts[inOff + i] >>> 16 & 0xFF);
            outBytes[outOff + i * 4 + 2] = (byte)(inInts[inOff + i] >>> 8 & 0xFF);
            outBytes[outOff + i * 4 + 3] = (byte)(inInts[inOff + i] & 0xFF);
            ++i;
        }
    }

    public static void squashBytesToIntsLittle(byte[] inBytes, int inOff, int[] outInts, int outOff, int intLen) {
        int i = 0;
        while (i < intLen) {
            outInts[outOff + i] = inBytes[inOff + i * 4] & 0xFF | (inBytes[inOff + i * 4 + 1] & 0xFF) << 8 | (inBytes[inOff + i * 4 + 2] & 0xFF) << 16 | (inBytes[inOff + i * 4 + 3] & 0xFF) << 24;
            ++i;
        }
    }

    public static void spreadIntsToBytesLittle(int[] inInts, int inOff, byte[] outBytes, int outOff, int intLen) {
        int i = 0;
        while (i < intLen) {
            outBytes[outOff + i * 4] = (byte)(inInts[inOff + i] & 0xFF);
            outBytes[outOff + i * 4 + 1] = (byte)(inInts[inOff + i] >>> 8 & 0xFF);
            outBytes[outOff + i * 4 + 2] = (byte)(inInts[inOff + i] >>> 16 & 0xFF);
            outBytes[outOff + i * 4 + 3] = (byte)(inInts[inOff + i] >>> 24 & 0xFF);
            ++i;
        }
    }

    public static void squashBytesToShorts(byte[] inBytes, int inOff, int[] outShorts, int outOff, int shortLen) {
        int i = 0;
        while (i < shortLen) {
            outShorts[outOff + i] = (inBytes[inOff + i * 2] & 0xFF) << 8 | inBytes[inOff + i * 2 + 1] & 0xFF;
            ++i;
        }
    }

    public static void spreadShortsToBytes(int[] inShorts, int inOff, byte[] outBytes, int outOff, int shortLen) {
        int i = 0;
        while (i < shortLen) {
            outBytes[outOff + i * 2] = (byte)(inShorts[inOff + i] >>> 8 & 0xFF);
            outBytes[outOff + i * 2 + 1] = (byte)(inShorts[inOff + i] & 0xFF);
            ++i;
        }
    }

    public static void squashBytesToShortsLittle(byte[] inBytes, int inOff, int[] outShorts, int outOff, int shortLen) {
        int i = 0;
        while (i < shortLen) {
            outShorts[outOff + i] = inBytes[inOff + i * 2] & 0xFF | (inBytes[inOff + i * 2 + 1] & 0xFF) << 8;
            ++i;
        }
    }

    public static void spreadShortsToBytesLittle(int[] inShorts, int inOff, byte[] outBytes, int outOff, int shortLen) {
        int i = 0;
        while (i < shortLen) {
            outBytes[outOff + i * 2] = (byte)(inShorts[inOff + i] & 0xFF);
            outBytes[outOff + i * 2 + 1] = (byte)(inShorts[inOff + i] >>> 8 & 0xFF);
            ++i;
        }
    }

    public static String toStringBlock(byte[] block, int off, int len) {
        String hexits = "0123456789abcdef";
        StringBuffer buf = new StringBuffer();
        int i = off;
        while (i < off + len) {
            buf.append(hexits.charAt(block[i] >>> 4 & 0xF));
            buf.append(hexits.charAt(block[i] & 0xF));
            ++i;
        }
        return "[" + buf + "]";
    }

    public static String toStringBlock(byte[] block) {
        return CryptoUtils.toStringBlock(block, 0, block.length);
    }
}

