/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.BlockCipher;
import Acme.Crypto.CbcBlockCipher;
import Acme.Crypto.Cipher;
import Acme.Crypto.StreamCipher;
import Acme.Utils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedInputStream
extends FilterInputStream {
    private BlockCipher blockCipher;
    private StreamCipher streamCipher;
    private Cipher cipher;
    private CbcBlockCipher cbcBlockCipher;
    private int blockSize;
    private int cryptoSize;
    private byte[] cipherText;
    private byte[] clearText;
    private int byteCount;
    private int bytesRead;
    private boolean inited = false;
    private boolean decrypting = true;

    public EncryptedInputStream(BlockCipher blockCipher, InputStream in) {
        super(in);
        this.blockCipher = blockCipher;
        this.blockSize = blockCipher.blockSize();
        this.cbcBlockCipher = new CbcBlockCipher(blockCipher);
        this.cryptoSize = this.blockSize;
        this.cipherText = new byte[this.blockSize];
        this.clearText = new byte[this.blockSize];
        this.byteCount = 0;
        this.bytesRead = 0;
        this.cipher = blockCipher;
    }

    public EncryptedInputStream(StreamCipher streamCipher, InputStream in) {
        super(in);
        this.streamCipher = streamCipher;
        this.cipher = streamCipher;
    }

    private void init() throws IOException {
        if (!this.inited) {
            this.inited = true;
            if (this.blockCipher != null) {
                byte[] iv = new byte[this.blockSize];
                int r = Utils.read(this.in, iv, 0, this.blockSize);
                if (r == -1 || r != this.blockSize) {
                    throw new IOException("truncated initialization vector");
                }
                this.cbcBlockCipher.setIv(iv);
            }
        }
    }

    public void setKey(String keyStr) {
        this.cipher.setKey(keyStr);
    }

    public void setDecrypting(boolean decrypting) throws IOException {
        boolean bl = this.decrypting && !decrypting;
        this.decrypting = decrypting;
    }

    private int getBlock() throws IOException {
        int r = Utils.read(this.in, this.cipherText, 0, this.blockSize);
        if (r == -1) {
            return -1;
        }
        if (r != this.blockSize) {
            throw new IOException("truncated ciphertext block");
        }
        this.cbcBlockCipher.decrypt(this.cipherText, 0, this.clearText, 0);
        this.byteCount = this.in.read();
        if (this.byteCount == -1) {
            throw new IOException("missing ciphertext bytecount");
        }
        if (this.byteCount == 0 || this.byteCount > this.cryptoSize) {
            throw new IOException("invalid ciphertext bytecount");
        }
        this.bytesRead = 0;
        return this.byteCount;
    }

    public int read() throws IOException {
        this.init();
        if (this.decrypting) {
            if (this.blockCipher != null) {
                if (this.bytesRead >= this.byteCount && this.getBlock() == -1) {
                    return -1;
                }
                return this.clearText[this.bytesRead++] & 0xFF;
            }
            int r = this.in.read();
            if (r == -1) {
                return -1;
            }
            return this.streamCipher.decrypt((byte)r) & 0xFF;
        }
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.init();
        if (this.decrypting) {
            if (this.blockCipher != null) {
                return Utils.read(this, b, off, len);
            }
            byte[] cipherText = new byte[len];
            int r = Utils.read(this.in, cipherText, 0, len);
            if (r == -1) {
                return -1;
            }
            this.streamCipher.decrypt(cipherText, 0, b, off, r);
            return r;
        }
        return Utils.read(this.in, b, off, len);
    }
}

