/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.BlockCipher;
import Acme.Crypto.CryptoUtils;

public class Rc6Cipher
extends BlockCipher {
    private int S0;
    private int S1;
    private int S42;
    private int S43;
    private int[] Sp0 = new int[5];
    private int[] Sp1 = new int[5];
    private int[] Sp2 = new int[5];
    private int[] Sp3 = new int[5];
    private int[] Sp4 = new int[5];
    private int[] Sp5 = new int[5];
    private int[] Sp6 = new int[5];
    private int[] Sp7 = new int[5];
    private int[] tempInts = new int[4];

    public Rc6Cipher(String keyStr) {
        super(0, 16);
        this.setKey(keyStr);
    }

    public Rc6Cipher(byte[] key) {
        super(0, 16);
        this.setKey(key);
    }

    public void setKey(byte[] key) {
        int keyLength = key.length;
        if (keyLength > 255) {
            keyLength = 255;
        }
        byte[] byArray = new byte[44];
        byArray[0] = 1;
        byArray[1] = 2;
        byArray[2] = 3;
        byArray[3] = 4;
        byArray[4] = 5;
        byArray[5] = 6;
        byArray[6] = 7;
        byArray[7] = 8;
        byArray[8] = 9;
        byArray[9] = 10;
        byArray[10] = 11;
        byArray[11] = 12;
        byArray[12] = 13;
        byArray[13] = 14;
        byArray[14] = 15;
        byArray[15] = 16;
        byArray[16] = 17;
        byArray[17] = 18;
        byArray[18] = 19;
        byArray[19] = 20;
        byArray[20] = 21;
        byArray[21] = 22;
        byArray[22] = 23;
        byArray[23] = 24;
        byArray[24] = 25;
        byArray[25] = 26;
        byArray[26] = 27;
        byArray[27] = 28;
        byArray[28] = 29;
        byArray[29] = 30;
        byArray[30] = 31;
        byArray[31] = 32;
        byArray[32] = 33;
        byArray[33] = 34;
        byArray[34] = 35;
        byArray[35] = 36;
        byArray[36] = 37;
        byArray[37] = 38;
        byArray[38] = 39;
        byArray[39] = 40;
        byArray[40] = 41;
        byArray[41] = 42;
        byArray[42] = 43;
        byte[] nextScheduleDwordIndex = byArray;
        int c = (keyLength + 3 >> 2) + (keyLength - 1 >>> 31);
        int[] L = new int[c];
        short[] nextKeyDwordIndex = new short[c];
        int almostEnd = keyLength & 0xFFFFFFFC;
        int i = almostEnd - 4;
        while (i >= 0) {
            int index = i >> 2;
            L[index] = (key[i] & 0xFF) + ((key[i + 1] & 0xFF) << 8) + ((key[i + 2] & 0xFF) << 16) + ((key[i + 3] & 0xFF) << 24);
            nextKeyDwordIndex[index] = (short)(index + 1);
            i -= 4;
        }
        int remainder = keyLength & 3;
        if (remainder > 0) {
            int lastDword = key[almostEnd] & 0xFF;
            if (remainder > 1) {
                lastDword |= (key[almostEnd + 1] & 0xFF) << 8;
                if (remainder > 2) {
                    lastDword |= (key[almostEnd + 2] & 0xFF) << 16;
                }
            }
            L[c - 1] = lastDword;
        }
        nextKeyDwordIndex[c - 1] = 0;
        int[] S = new int[]{-1209970333, 1444465436, -196066091, -1836597618, 817838151, -822693376, 1831742393, 191210866, -1449320661, 1205115108, -435416419, -2075947946, 578487823, -1062043704, 1592392065, -48139462, -1688670989, 965764780, -674766747, 1979669022, 339137495, -1301394032, 1353041737, -287489790, -1928021317, 726414452, -914117075, 1740318694, 99787167, -1540744360, 1113691409, -526840118, 2127595651, 487064124, -1153467403, 1500968366, -139563161, -1780094688, 874341081, -766190446, 1888245323, 247713796, -1392817731, 1261618038};
        int i2 = 0;
        int j = 0;
        int A = 0;
        int B = 0;
        int counter = c <= 44 ? 44 : c;
        while (--counter >= 0) {
            A += S[i2] + B;
            S[i2] = A = A << 3 | A >>> 29;
            int sum = A + B;
            B = sum + L[j];
            L[j] = B = B << sum | B >>> -sum;
            i2 = nextScheduleDwordIndex[i2];
            j = nextKeyDwordIndex[j];
            A += S[i2] + B;
            S[i2] = A = A << 3 | A >>> 29;
            sum = A + B;
            B = sum + L[j];
            L[j] = B = B << sum | B >>> -sum;
            i2 = nextScheduleDwordIndex[i2];
            j = nextKeyDwordIndex[j];
            A += S[i2] + B;
            S[i2] = A = A << 3 | A >>> 29;
            sum = A + B;
            B = sum + L[j];
            L[j] = B = B << sum | B >>> -sum;
            i2 = nextScheduleDwordIndex[i2];
            j = nextKeyDwordIndex[j];
        }
        this.S0 = S[0];
        this.S1 = S[1];
        int count = 0;
        int offset = 1;
        do {
            this.Sp0[count] = S[++offset];
            this.Sp1[count] = S[++offset];
            this.Sp2[count] = S[++offset];
            this.Sp3[count] = S[++offset];
            this.Sp4[count] = S[++offset];
            this.Sp5[count] = S[++offset];
            this.Sp6[count] = S[++offset];
            this.Sp7[count] = S[++offset];
            ++count;
        } while (offset <= 33);
        this.S42 = S[42];
        this.S43 = S[43];
    }

    public void encrypt(byte[] clearText, int clearOff, byte[] cipherText, int cipherOff) {
        CryptoUtils.squashBytesToIntsLittle(clearText, clearOff, this.tempInts, 0, 4);
        int A = this.tempInts[0];
        int B = this.tempInts[1];
        int C = this.tempInts[2];
        int D = this.tempInts[3];
        B += this.S0;
        D += this.S1;
        int i = 0;
        while (i < 5) {
            int t = B * ((B << 1) + 1);
            int u = D * ((D << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            A ^= t;
            C ^= u;
            A = (A << u | A >>> -u) + this.Sp0[i];
            C = (C << t | C >>> -t) + this.Sp1[i];
            t = C * ((C << 1) + 1);
            u = A * ((A << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            B ^= t;
            D ^= u;
            B = (B << u | B >>> -u) + this.Sp2[i];
            D = (D << t | D >>> -t) + this.Sp3[i];
            t = D * ((D << 1) + 1);
            u = B * ((B << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            C ^= t;
            A ^= u;
            C = (C << u | C >>> -u) + this.Sp4[i];
            A = (A << t | A >>> -t) + this.Sp5[i];
            t = A * ((A << 1) + 1);
            u = C * ((C << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            D ^= t;
            B ^= u;
            D = (D << u | D >>> -u) + this.Sp6[i];
            B = (B << t | B >>> -t) + this.Sp7[i];
            ++i;
        }
        this.tempInts[0] = A += this.S42;
        this.tempInts[1] = B;
        this.tempInts[2] = C += this.S43;
        this.tempInts[3] = D;
        CryptoUtils.spreadIntsToBytesLittle(this.tempInts, 0, cipherText, cipherOff, 4);
    }

    public void decrypt(byte[] cipherText, int cipherOff, byte[] clearText, int clearOff) {
        CryptoUtils.squashBytesToIntsLittle(cipherText, cipherOff, this.tempInts, 0, 4);
        int A = this.tempInts[0];
        int B = this.tempInts[1];
        int C = this.tempInts[2];
        int D = this.tempInts[3];
        C -= this.S43;
        A -= this.S42;
        int i = 4;
        while (i >= 0) {
            int t = A * ((A << 1) + 1);
            int u = C * ((C << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            B -= this.Sp7[i];
            D -= this.Sp6[i];
            B = (B >>> t | B << -t) ^ u;
            D = (D >>> u | D << -u) ^ t;
            t = D * ((D << 1) + 1);
            u = B * ((B << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            A -= this.Sp5[i];
            C -= this.Sp4[i];
            A = (A >>> t | A << -t) ^ u;
            C = (C >>> u | C << -u) ^ t;
            t = C * ((C << 1) + 1);
            u = A * ((A << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            D -= this.Sp3[i];
            B -= this.Sp2[i];
            D = (D >>> t | D << -t) ^ u;
            B = (B >>> u | B << -u) ^ t;
            t = B * ((B << 1) + 1);
            u = D * ((D << 1) + 1);
            t = t << 5 | t >>> 27;
            u = u << 5 | u >>> 27;
            C -= this.Sp1[i];
            A -= this.Sp0[i];
            C = (C >>> t | C << -t) ^ u;
            A = (A >>> u | A << -u) ^ t;
            --i;
        }
        this.tempInts[0] = A;
        this.tempInts[1] = B -= this.S0;
        this.tempInts[2] = C;
        this.tempInts[3] = D -= this.S1;
        CryptoUtils.spreadIntsToBytesLittle(this.tempInts, 0, clearText, clearOff, 4);
    }

    public static void main(String[] args) {
        byte[] cipherText = new byte[16];
        byte[] decipherText = new byte[16];
        Rc6Cipher rc6a = new Rc6Cipher("0123456789");
        byte[] clearText1 = new byte[16];
        System.out.println("cleartext: " + CryptoUtils.toStringBlock(clearText1));
        rc6a.encrypt(clearText1, cipherText);
        System.out.println("encrypted: " + CryptoUtils.toStringBlock(cipherText));
        rc6a.decrypt(cipherText, decipherText);
        System.out.println("decrypted: " + CryptoUtils.toStringBlock(decipherText));
        System.out.println();
        Rc6Cipher rc6b = new Rc6Cipher("abcdefghijklmnopqrstuvwxyz");
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byte[] clearText2 = byArray;
        System.out.println("cleartext: " + CryptoUtils.toStringBlock(clearText2));
        rc6b.encrypt(clearText2, cipherText);
        System.out.println("encrypted: " + CryptoUtils.toStringBlock(cipherText));
        rc6b.decrypt(cipherText, decipherText);
        System.out.println("decrypted: " + CryptoUtils.toStringBlock(decipherText));
    }
}

