/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.HtmlEditObserver;
import Acme.HtmlObserver;
import Acme.HtmlScanner;
import Acme.Pair;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class HtmlEditScanner
extends FilterInputStream
implements HtmlObserver {
    HtmlScanner scanner;
    private Vector observers = new Vector();
    private boolean gotEOF = false;
    private byte[] buf = new byte[4096];
    private int bufSize = this.buf.length;
    private int bufOff;
    private int bufLen;

    public HtmlEditScanner(InputStream s, URL thisUrl, HtmlEditObserver observer) {
        this(s, thisUrl, observer, null);
    }

    public HtmlEditScanner(InputStream s, URL thisUrl, HtmlEditObserver observer, Object clientData) {
        this(new HtmlScanner(s, thisUrl, null), observer, clientData);
    }

    public HtmlEditScanner(HtmlScanner scanner, HtmlEditObserver observer) {
        this(scanner, observer, null);
    }

    public HtmlEditScanner(HtmlScanner scanner, HtmlEditObserver observer, Object clientData) {
        super(scanner);
        this.scanner = scanner;
        scanner.addObserver(this);
        if (observer != null) {
            this.addObserver(observer, clientData);
        }
    }

    public void addObserver(HtmlEditObserver observer) {
        this.addObserver(observer, null);
    }

    public void addObserver(HtmlEditObserver observer, Object clientData) {
        this.observers.addElement(new Pair(observer, clientData));
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = len;
        while ((this.bufLen < len || this.scanner.gettingUrl) && !this.gotEOF) {
            if (this.bufLen >= len) {
                i += 50;
            }
            this.checkBuf(i + 500);
            int r = this.in.read(this.buf, this.bufOff + this.bufLen, i - this.bufLen);
            if (r == -1) {
                this.gotEOF = true;
                continue;
            }
            this.bufLen += r;
        }
        if (this.bufLen == 0) {
            return -1;
        }
        i = Math.min(len, this.bufLen);
        System.arraycopy(this.buf, this.bufOff, b, off, i);
        this.bufOff += i;
        this.bufLen -= i;
        return i;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int r = this.read(b, 0, 1);
        if (r == -1) {
            return -1;
        }
        return b[0];
    }

    private void checkBuf(int need) {
        if (this.bufLen == 0) {
            this.bufOff = 0;
        }
        if (this.bufOff + need > this.bufSize) {
            if (need * 2 < this.bufSize) {
                System.arraycopy(this.buf, this.bufOff, this.buf, 0, this.bufLen);
            } else {
                byte[] newBuf = new byte[need * 2];
                System.arraycopy(this.buf, this.bufOff, newBuf, 0, this.bufLen);
                this.buf = newBuf;
                this.bufSize = this.buf.length;
            }
            this.bufOff = 0;
        }
    }

    public void gotAHREF(String urlStr, URL contextUrl, Object junk) {
        Enumeration en = this.observers.elements();
        while (en.hasMoreElements()) {
            Object clientData;
            Pair pair = (Pair)en.nextElement();
            HtmlEditObserver observer = (HtmlEditObserver)pair.left();
            String changedUrlStr = observer.editAHREF(urlStr, contextUrl, clientData = pair.right());
            if (changedUrlStr == null) continue;
            this.scanner.substitute(urlStr.length(), changedUrlStr);
        }
    }

    public void gotIMGSRC(String urlStr, URL contextUrl, Object junk) {
        Enumeration en = this.observers.elements();
        while (en.hasMoreElements()) {
            Object clientData;
            Pair pair = (Pair)en.nextElement();
            HtmlEditObserver observer = (HtmlEditObserver)pair.left();
            String changedUrlStr = observer.editIMGSRC(urlStr, contextUrl, clientData = pair.right());
            if (changedUrlStr == null) continue;
            this.scanner.substitute(urlStr.length(), changedUrlStr);
        }
    }

    public void gotFRAMESRC(String urlStr, URL contextUrl, Object junk) {
        Enumeration en = this.observers.elements();
        while (en.hasMoreElements()) {
            Object clientData;
            Pair pair = (Pair)en.nextElement();
            HtmlEditObserver observer = (HtmlEditObserver)pair.left();
            String changedUrlStr = observer.editFRAMESRC(urlStr, contextUrl, clientData = pair.right());
            if (changedUrlStr == null) continue;
            this.scanner.substitute(urlStr.length(), changedUrlStr);
        }
    }

    public void gotBASEHREF(String urlStr, URL contextUrl, Object junk) {
        Enumeration en = this.observers.elements();
        while (en.hasMoreElements()) {
            Object clientData;
            Pair pair = (Pair)en.nextElement();
            HtmlEditObserver observer = (HtmlEditObserver)pair.left();
            String changedUrlStr = observer.editBASEHREF(urlStr, contextUrl, clientData = pair.right());
            if (changedUrlStr == null) continue;
            this.scanner.substitute(urlStr.length(), changedUrlStr);
        }
    }

    public void gotAREAHREF(String urlStr, URL contextUrl, Object junk) {
        Enumeration en = this.observers.elements();
        while (en.hasMoreElements()) {
            Object clientData;
            Pair pair = (Pair)en.nextElement();
            HtmlEditObserver observer = (HtmlEditObserver)pair.left();
            String changedUrlStr = observer.editAREAHREF(urlStr, contextUrl, clientData = pair.right());
            if (changedUrlStr == null) continue;
            this.scanner.substitute(urlStr.length(), changedUrlStr);
        }
    }

    public void gotLINKHREF(String urlStr, URL contextUrl, Object junk) {
        Enumeration en = this.observers.elements();
        while (en.hasMoreElements()) {
            Object clientData;
            Pair pair = (Pair)en.nextElement();
            HtmlEditObserver observer = (HtmlEditObserver)pair.left();
            String changedUrlStr = observer.editLINKHREF(urlStr, contextUrl, clientData = pair.right());
            if (changedUrlStr == null) continue;
            this.scanner.substitute(urlStr.length(), changedUrlStr);
        }
    }

    public void gotBODYBACKGROUND(String urlStr, URL contextUrl, Object junk) {
        Enumeration en = this.observers.elements();
        while (en.hasMoreElements()) {
            Object clientData;
            Pair pair = (Pair)en.nextElement();
            HtmlEditObserver observer = (HtmlEditObserver)pair.left();
            String changedUrlStr = observer.editBODYBACKGROUND(urlStr, contextUrl, clientData = pair.right());
            if (changedUrlStr == null) continue;
            this.scanner.substitute(urlStr.length(), changedUrlStr);
        }
    }
}

