/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public class Enlarge
extends ImageFilterPlus {
    private int multiplier;
    private int newWidth;
    private int newHeight;

    public Enlarge(ImageProducer producer, int multiplier) {
        super(producer);
        this.multiplier = multiplier;
    }

    public void setDimensions(int width, int height) {
        this.newWidth = width * this.multiplier;
        this.newHeight = height * this.multiplier;
        this.consumer.setDimensions(this.newWidth, this.newHeight);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int newH;
        int newX = Math.min(x * this.multiplier, this.newWidth - 1);
        int newY = Math.min(y * this.multiplier, this.newHeight - 1);
        int newW = w * this.multiplier;
        if (newX + newW > this.newWidth) {
            newW = this.newWidth - newX;
        }
        if (newY + (newH = h * this.multiplier) > this.newHeight) {
            newH = this.newHeight - newY;
        }
        byte[] newPixels = new byte[newW * newH];
        int row = 0;
        while (row < h) {
            int col = 0;
            while (col < w) {
                byte pixel = pixels[row * scansize + off + col];
                int i = 0;
                while (i < this.multiplier) {
                    int j = 0;
                    while (j < this.multiplier) {
                        int newRow = row * this.multiplier + i;
                        int newCol = col * this.multiplier + j;
                        newPixels[newRow * newW + newCol] = pixel;
                        ++j;
                    }
                    ++i;
                }
                ++col;
            }
            ++row;
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int newH;
        int newX = Math.min(x * this.multiplier, this.newWidth - 1);
        int newY = Math.min(y * this.multiplier, this.newHeight - 1);
        int newW = w * this.multiplier;
        if (newX + newW > this.newWidth) {
            newW = this.newWidth - newX;
        }
        if (newY + (newH = h * this.multiplier) > this.newHeight) {
            newH = this.newHeight - newY;
        }
        int[] newPixels = new int[newW * newH];
        int row = 0;
        while (row < h) {
            int col = 0;
            while (col < w) {
                int pixel = pixels[row * scansize + off + col];
                int i = 0;
                while (i < this.multiplier) {
                    int j = 0;
                    while (j < this.multiplier) {
                        int newRow = row * this.multiplier + i;
                        int newCol = col * this.multiplier + j;
                        newPixels[newRow * newW + newCol] = pixel;
                        ++j;
                    }
                    ++i;
                }
                ++col;
            }
            ++row;
        }
        this.consumer.setPixels(newX, newY, newW, newH, model, newPixels, 0, newW);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Enlarge.usage();
        }
        Enlarge filter = new Enlarge(null, Integer.parseInt(args[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Enlarge <multiplier>");
        System.exit(1);
    }
}

