/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import Acme.JPM.Filters.RGBBlockFilter;
import java.awt.image.ImageProducer;

public class Gamma
extends RGBBlockFilter {
    private double rValue;
    private double gValue;
    private double bValue;
    private int[] rTable;
    private int[] gTable;
    private int[] bTable;
    private boolean initialized = false;

    public Gamma(ImageProducer producer, double value) {
        this(producer, value, value, value);
    }

    public Gamma(ImageProducer producer, double rValue, double gValue, double bValue) {
        super(producer);
        this.rValue = rValue;
        this.gValue = gValue;
        this.bValue = bValue;
    }

    public int[][] filterRGBBlock(int x, int y, int width, int height, int[][] rgbPixels) {
        this.initialize();
        int row = 0;
        while (row < height) {
            int col = 0;
            while (col < width) {
                int rgb = rgbPixels[row][col];
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                r = this.rTable[r];
                g = this.gTable[g];
                b = this.bTable[b];
                rgbPixels[row][col] = a << 24 | r << 16 | g << 8 | b;
                ++col;
            }
            ++row;
        }
        return rgbPixels;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.rTable = this.buildTable(this.rValue);
        this.gTable = this.gValue == this.rValue ? this.rTable : this.buildTable(this.gValue);
        this.bTable = this.bValue == this.rValue ? this.rTable : (this.bValue == this.gValue ? this.gTable : this.buildTable(this.bValue));
    }

    private int[] buildTable(double gamma) {
        int[] table = new int[256];
        double oneOverGamma = 1.0 / gamma;
        int i = 0;
        while (i < 256) {
            int v = (int)(255.0 * Math.pow((double)i / 255.0, oneOverGamma) + 0.5);
            if (v > 255) {
                v = 255;
            }
            table[i] = v;
            ++i;
        }
        return table;
    }

    public static void main(String[] args) {
        Gamma filter = null;
        if (args.length == 1) {
            filter = new Gamma(null, Double.valueOf(args[0]));
        } else if (args.length == 3) {
            filter = new Gamma(null, Double.valueOf(args[0]), Double.valueOf(args[1]), Double.valueOf(args[2]));
        } else {
            Gamma.usage();
        }
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Gamma <value>");
        System.err.println("or:    Gamma <rValue> <gValue> <bValue>");
        System.exit(1);
    }
}

