/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public abstract class RGBBlockFilter
extends ImageFilterPlus {
    public RGBBlockFilter(ImageProducer producer) {
        super(producer);
    }

    public abstract int[][] filterRGBBlock(int var1, int var2, int var3, int var4, int[][] var5);

    public void setColorModel(ColorModel model) {
        this.consumer.setColorModel(ImageFilterPlus.rgbModel);
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pixels, int offset, int scansize) {
        int[][] rgbPixels = new int[height][width];
        int row = 0;
        while (row < height) {
            int rowOffsetIn = offset + row * scansize;
            int col = 0;
            while (col < width) {
                rgbPixels[row][col] = model.getRGB(pixels[rowOffsetIn + col] & 0xFF);
                ++col;
            }
            ++row;
        }
        this.setPixels(x, y, width, height, rgbPixels);
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scansize) {
        int[][] rgbPixels = new int[height][width];
        int row = 0;
        while (row < height) {
            int rowOffsetIn = offset + row * scansize;
            int rowOffsetOut = row * width;
            if (model == ImageFilterPlus.rgbModel) {
                System.arraycopy(pixels, rowOffsetIn, rgbPixels[row], 0, width);
            } else {
                int col = 0;
                while (col < width) {
                    rgbPixels[row][col] = model.getRGB(pixels[rowOffsetIn + col]);
                    ++col;
                }
            }
            ++row;
        }
        this.setPixels(x, y, width, height, rgbPixels);
    }

    private void setPixels(int x, int y, int width, int height, int[][] rgbPixels) {
        int[][] newPixels = this.filterRGBBlock(x, y, width, height, rgbPixels);
        int row = 0;
        while (row < height) {
            this.consumer.setPixels(x, y + row, width, 1, ImageFilterPlus.rgbModel, newPixels[row], 0, width);
            ++row;
        }
    }
}

