/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.Utils;

public class Matrix {
    private int rows;
    private int cols;
    private double[][] values;

    public Matrix(int rows, int cols) throws ArithmeticException {
        this(rows, cols, 0.0);
    }

    public Matrix(int rows, int cols, double value) throws ArithmeticException {
        if (rows <= 0 || cols <= 0) {
            throw new ArithmeticException();
        }
        this.rows = rows;
        this.cols = cols;
        this.values = new double[rows][cols];
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                this.values[row][col] = value;
                ++col;
            }
            ++row;
        }
    }

    public Matrix(int size) throws ArithmeticException {
        this(size, size);
        int i = 0;
        while (i < size) {
            this.values[i][i] = 1.0;
            ++i;
        }
    }

    public Matrix(Matrix o) throws ArithmeticException {
        this(o.rows, o.cols);
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                this.values[row][col] = o.values[row][col];
                ++col;
            }
            ++row;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public double get(int row, int col) {
        return this.values[row][col];
    }

    public void set(int row, int col, double value) {
        this.values[row][col] = value;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Matrix)) {
            return false;
        }
        Matrix m = (Matrix)o;
        if (m.rows != this.rows || m.cols != this.cols) {
            return false;
        }
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                if (m.values[row][col] != this.values[row][col]) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                Double d = new Double(this.values[row][col]);
                h ^= d.hashCode();
                ++col;
            }
            ++row;
        }
        return h;
    }

    public String toString() {
        return Utils.arrayToString(this.values);
    }

    public double sum() {
        double s = 0.0;
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                s += this.values[row][col];
                ++col;
            }
            ++row;
        }
        return s;
    }

    public double mean() {
        return this.sum() / (double)(this.rows * this.cols);
    }

    public double max() {
        double m = this.values[0][0];
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                if (this.values[row][col] > m) {
                    m = this.values[row][col];
                }
                ++col;
            }
            ++row;
        }
        return m;
    }

    public double min() {
        double m = this.values[0][0];
        int row = 0;
        while (row < this.rows) {
            int col = 0;
            while (col < this.cols) {
                if (this.values[row][col] < m) {
                    m = this.values[row][col];
                }
                ++col;
            }
            ++row;
        }
        return m;
    }

    public void swapRows(int r1, int r2) {
        int col = 0;
        while (col < this.cols) {
            double t = this.values[r1][col];
            this.values[r1][col] = this.values[r2][col];
            this.values[r2][col] = t;
            ++col;
        }
    }

    public void swapCols(int c1, int c2) {
        int row = 0;
        while (row < this.rows) {
            double t = this.values[row][c1];
            this.values[row][c1] = this.values[row][c2];
            this.values[row][c2] = t;
            ++row;
        }
    }

    public static Matrix transpose(Matrix m) {
        Matrix result = new Matrix(m.cols, m.rows);
        int row = 0;
        while (row < m.rows) {
            int col = 0;
            while (col < m.cols) {
                result.values[col][row] = m.values[row][col];
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static Matrix add(Matrix a, Matrix b) throws ArithmeticException {
        if (a.rows != b.rows || a.cols != b.cols) {
            throw new ArithmeticException();
        }
        Matrix result = new Matrix(a.rows, a.cols);
        int row = 0;
        while (row < a.rows) {
            int col = 0;
            while (col < a.cols) {
                result.values[row][col] = a.values[row][col] + b.values[row][col];
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static Matrix subtract(Matrix a, Matrix b) throws ArithmeticException {
        if (a.rows != b.rows || a.cols != b.cols) {
            throw new ArithmeticException();
        }
        Matrix result = new Matrix(a.rows, a.cols);
        int row = 0;
        while (row < a.rows) {
            int col = 0;
            while (col < a.cols) {
                result.values[row][col] = a.values[row][col] - b.values[row][col];
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static Matrix multiply(Matrix a, double b) {
        Matrix result = new Matrix(a.rows, a.cols);
        int row = 0;
        while (row < a.rows) {
            int col = 0;
            while (col < a.cols) {
                result.values[row][col] = a.values[row][col] * b;
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static Matrix multiply(double a, Matrix b) {
        return Matrix.multiply(b, a);
    }

    public static Matrix multiply(Matrix a, Matrix b) throws ArithmeticException {
        if (a.cols != b.rows) {
            throw new ArithmeticException();
        }
        Matrix result = new Matrix(a.rows, b.cols);
        int row = 0;
        while (row < a.rows) {
            int col = 0;
            while (col < b.cols) {
                double sum = 0.0;
                int i = 0;
                while (i < a.cols) {
                    sum += a.values[row][i] * b.values[i][col];
                    ++i;
                }
                result.values[row][col] = sum;
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static Matrix solve(Matrix a, Matrix b) throws ArithmeticException {
        int k;
        double t;
        int j;
        if (a.rows != a.cols || a.cols != b.rows || b.cols != 1) {
            throw new ArithmeticException();
        }
        int n = a.rows;
        a = new Matrix(a);
        b = new Matrix(b);
        Matrix x = new Matrix(n, 1);
        int i = 0;
        while (i < n) {
            int max = i;
            j = i + 1;
            while (j < n) {
                if (Math.abs(a.values[j][i]) > Math.abs(a.values[max][i])) {
                    max = j;
                }
                ++j;
            }
            if (a.values[max][i] == 0.0) {
                throw new ArithmeticException();
            }
            a.swapRows(i, max);
            b.swapRows(i, max);
            j = i + 1;
            while (j < n) {
                t = a.values[j][i] / a.values[i][i];
                k = n - 1;
                while (k >= i) {
                    double[] dArray = a.values[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] - a.values[i][k] * t;
                    --k;
                }
                double[] dArray = b.values[j];
                dArray[0] = dArray[0] - b.values[i][0] * t;
                ++j;
            }
            ++i;
        }
        j = n - 1;
        while (j >= 0) {
            t = 0.0;
            k = j + 1;
            while (k < n) {
                t += a.values[j][k] * x.values[k][0];
                ++k;
            }
            x.values[j][0] = (b.values[j][0] - t) / a.values[j][j];
            --j;
        }
        return x;
    }
}

