/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Fmt;
import Acme.Serve.ServeUtils;
import Acme.Serve.ThrottleItem;
import Acme.Serve.ThrottledOutputStream;
import Acme.Serve.servlet.ServletException;
import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.HttpServlet;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import Acme.Utils;
import Acme.WildcardDictionary;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;

public class FileServlet
extends HttpServlet {
    static WildcardDictionary throttleTab = null;

    public FileServlet() {
    }

    public FileServlet(String string) throws IOException {
        this();
        this.readThrottles(string);
    }

    private void readThrottles(String string) throws IOException {
        WildcardDictionary wildcardDictionary = ThrottledOutputStream.parseThrottleFile(string);
        if (throttleTab == null) {
            throttleTab = wildcardDictionary;
            return;
        }
        Enumeration enumeration = wildcardDictionary.keys();
        Enumeration enumeration2 = wildcardDictionary.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object e2 = enumeration2.nextElement();
            throttleTab.put(e, e2);
        }
    }

    public String getServletInfo() {
        return "servlet similar to a standard httpd";
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        if (httpServletRequest.getMethod().equalsIgnoreCase("get")) {
            bl = false;
        } else if (!httpServletRequest.getMethod().equalsIgnoreCase("head")) {
            bl = true;
        } else {
            httpServletResponse.sendError(501);
            return;
        }
        String string = httpServletRequest.getServletPath();
        if (string == null || string.charAt(0) != '/') {
            httpServletResponse.sendError(400);
            return;
        }
        if (string.indexOf("/../") != -1 || string.endsWith("/..")) {
            httpServletResponse.sendError(403);
            return;
        }
        String string2 = string;
        while (string2.length() > 0 && string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        if (string2.length() == 0) {
            string2 = "./";
        }
        this.dispatchPathname(httpServletRequest, httpServletResponse, bl, string, string2);
    }

    private void dispatchPathname(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string, String string2) throws IOException {
        File file;
        String string3 = string2.replace('/', File.separatorChar);
        if (string3.charAt(string3.length() - 1) == File.separatorChar) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if ((file = new File(string3 = this.getServletContext().getRealPath(string3))).exists()) {
            if (!file.isDirectory()) {
                this.serveFile(httpServletRequest, httpServletResponse, bl, string, string3, file);
                return;
            }
            if (string2.charAt(string2.length() - 1) != '/') {
                this.redirectDirectory(httpServletRequest, httpServletResponse, string, file);
                return;
            }
            String string4 = String.valueOf(string3) + File.separatorChar + "index.html";
            File file2 = new File(string4);
            if (file2.exists()) {
                this.serveFile(httpServletRequest, httpServletResponse, bl, string, string4, file2);
                return;
            }
            this.serveDirectory(httpServletRequest, httpServletResponse, bl, string, string3, file);
            return;
        }
        if (string2.endsWith("/index.html")) {
            this.dispatchPathname(httpServletRequest, httpServletResponse, bl, string, string2.substring(0, string2.length() - 10));
            return;
        }
        if (string2.equals("index.html")) {
            this.dispatchPathname(httpServletRequest, httpServletResponse, bl, string, "./");
            return;
        }
        httpServletResponse.sendError(404);
    }

    private void serveFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string, String string2, File file) throws IOException {
        this.log("getting " + string);
        if (!file.canRead()) {
            httpServletResponse.sendError(403);
            return;
        }
        httpServletResponse.setStatus(200);
        long l = file.lastModified();
        String string3 = httpServletRequest.getHeader("If-Modified-Since");
        long l2 = -1L;
        if (string3 != null) {
            int n = string3.indexOf(59);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            try {
                l2 = DateFormat.getDateInstance().parse(string3).getTime();
            }
            catch (Exception exception) {}
        }
        if (l2 != -1L && l2 >= l) {
            httpServletResponse.setStatus(304);
            bl = true;
        }
        String string4 = httpServletRequest.getHeader("Range");
        httpServletResponse.setContentType(this.getServletContext().getMimeType(string2));
        httpServletResponse.setContentLength((int)file.length());
        httpServletResponse.setDateHeader("Last-modified", l);
        OutputStream outputStream = httpServletResponse.getOutputStream();
        if (!bl) {
            Object object;
            if (throttleTab != null && (object = (ThrottleItem)throttleTab.get(string)) != null) {
                outputStream = new ThrottledOutputStream(outputStream, ((ThrottleItem)object).getMaxBps());
            }
            object = new FileInputStream(file);
            this.copyStream((InputStream)object, outputStream);
            ((InputStream)object).close();
        }
        outputStream.close();
    }

    public void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        Utils.copyStream(inputStream, outputStream);
    }

    private void serveDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string, String string2, File file) throws IOException {
        this.log("indexing " + string);
        if (!file.canRead()) {
            httpServletResponse.sendError(403);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (!bl) {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(servletOutputStream));
            printStream.println("<HTML><HEAD>");
            printStream.println("<TITLE>Index of " + string + "</TITLE>");
            printStream.println("</HEAD><BODY BGCOLOR=\"#99cc99\">");
            printStream.println("<H2>Index of " + string + "</H2>");
            printStream.println("<PRE>");
            printStream.println("mode     bytes  last-changed  name");
            printStream.println("<HR>");
            String[] stringArray = file.list();
            Utils.sortStrings(stringArray);
            int n = 0;
            while (n < stringArray.length) {
                String string3 = String.valueOf(string2) + File.separatorChar + stringArray[n];
                File file2 = new File(string3);
                String string4 = file2.isDirectory() ? "d" : (file2.isFile() ? "-" : "?");
                String string5 = file2.canRead() ? "r" : "-";
                String string6 = file2.canWrite() ? "w" : "-";
                String string7 = Fmt.fmt(file2.length(), 8);
                String string8 = Utils.lsDateStr(new Date(file2.lastModified()));
                String string9 = file2.isDirectory() ? "/" : "";
                String string10 = file2.isDirectory() ? "/" : "";
                printStream.println(String.valueOf(string4) + string5 + string6 + "-" + "  " + string7 + "  " + string8 + "  " + "<A HREF=\"" + stringArray[n] + string9 + "\">" + stringArray[n] + string10 + "</A>");
                ++n;
            }
            printStream.println("</PRE>");
            printStream.println("<HR>");
            ServeUtils.writeAddress(printStream);
            printStream.println("</BODY></HTML>");
            printStream.flush();
        }
        servletOutputStream.close();
    }

    private void redirectDirectory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, File file) throws IOException {
        this.log("redirecting " + string);
        httpServletResponse.sendRedirect(String.valueOf(string) + "/");
    }
}

