/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.CgiServlet;
import Acme.Serve.FileServlet;
import Acme.Serve.SampleServlet;
import Acme.Serve.ServeConfig;
import Acme.Serve.ServeConnection;
import Acme.Serve.TestServlet;
import Acme.Serve.servlet.Servlet;
import Acme.Serve.servlet.ServletContext;
import Acme.Serve.servlet.ServletException;
import Acme.WildcardDictionary;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Serve
implements ServletContext {
    private static final String progName = "Serve";
    private int port;
    private PrintStream logStream;
    WildcardDictionary registry;
    protected Hashtable servlets = new Hashtable();

    public static void main(String[] stringArray) {
        int n = 9090;
        String string = null;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2 && stringArray[n3].charAt(0) == '-') {
            if (stringArray[n3].equals("-p") && n3 + 1 < n2) {
                n = Integer.parseInt(stringArray[++n3]);
            } else if (stringArray[n3].equals("-t") && n3 + 1 < n2) {
                string = stringArray[++n3];
            } else {
                System.err.println("usage:  Serve [-p port]");
                System.exit(1);
            }
            ++n3;
        }
        if (n3 != n2) {
            System.err.println("usage:  Serve [-p port]");
            System.exit(1);
        }
        Serve serve = new Serve(n);
        serve.addServlet("/SampleServlet", new SampleServlet());
        TestServlet testServlet = new TestServlet();
        serve.addServlet("/TestServlet", testServlet);
        serve.addServlet("/TestServlet/*", testServlet);
        if (string == null) {
            serve.addDefaultServlets(true);
        } else {
            try {
                serve.addDefaultServlets(true, string);
            }
            catch (IOException iOException) {
                System.err.println("Problem reading throttles file: " + iOException);
                System.exit(1);
            }
        }
        serve.serve();
        System.exit(0);
    }

    private static void usage() {
        System.err.println("usage:  Serve [-p port]");
        System.exit(1);
    }

    public Serve(int n, PrintStream printStream) {
        this.port = n;
        this.logStream = printStream;
        this.registry = new WildcardDictionary();
    }

    public Serve(int n) {
        this(n, System.err);
    }

    public Serve() {
        this(9090, System.err);
    }

    public void addServlet(String string, String string2) {
        int n;
        Servlet servlet = (Servlet)this.servlets.get(string2);
        if (servlet != null) {
            this.addServlet(string, servlet);
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string2.lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string2.substring(0, n));
            securityManager.checkPackageDefinition(string2.substring(0, n));
        }
        try {
            servlet = (Servlet)Class.forName(string2).newInstance();
            this.addServlet(string, servlet);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Class not found: " + string2);
            return;
        }
        catch (ClassCastException classCastException) {
            this.log("Class cast problem: " + classCastException.getMessage());
            return;
        }
        catch (InstantiationException instantiationException) {
            this.log("Instantiation problem: " + instantiationException.getMessage());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log("Illegal class access: " + illegalAccessException.getMessage());
            return;
        }
        catch (Exception exception) {
            this.log("Unexpected problem creating servlet: " + exception);
            return;
        }
    }

    public void addServlet(String string, Servlet servlet) {
        try {
            servlet.init(new ServeConfig(this));
            this.registry.put(string, servlet);
            this.servlets.put(servlet.getClass().getName(), servlet);
            return;
        }
        catch (ServletException servletException) {
            this.log("Problem initializing servlet: " + servletException);
            return;
        }
    }

    public void addDefaultServlets(boolean bl) {
        if (bl) {
            this.addServlet("*.cgi", new CgiServlet());
        }
        this.addServlet("*", new FileServlet());
    }

    public void addDefaultServlets(boolean bl, String string) throws IOException {
        if (bl) {
            this.addServlet("*.cgi", new CgiServlet());
        }
        this.addServlet("*", new FileServlet(string));
    }

    public void serve() {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(this.port, 1000);
        }
        catch (IOException iOException) {
            this.log("Server socket: " + iOException);
            return;
        }
        try {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    new ServeConnection(socket, this);
                }
            }
            catch (IOException iOException) {
                this.log("Accept: " + iOException);
                Object var3_6 = null;
                try {
                    serverSocket.close();
                    this.destroyAllServlets();
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            try {
                serverSocket.close();
                this.destroyAllServlets();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
    }

    public Servlet getServlet(String string) {
        return (Servlet)this.servlets.get(string);
    }

    public Enumeration getServlets() {
        return this.servlets.elements();
    }

    public Enumeration getServletNames() {
        return this.servlets.keys();
    }

    public void destroyAllServlets() {
        Enumeration enumeration = this.servlets.elements();
        while (enumeration.hasMoreElements()) {
            Servlet servlet = (Servlet)enumeration.nextElement();
            servlet.destroy();
        }
        this.servlets.clear();
    }

    public void log(String string) {
        Date date = new Date(System.currentTimeMillis());
        this.logStream.println("[" + date.toString() + "] " + string);
    }

    public void log(Exception exception, String string) {
        this.log(string);
    }

    public String getRealPath(String string) {
        return string;
    }

    public String getMimeType(String string) {
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n == -1 || n2 != -1 && n < n2) {
            return "text/plain; charset=iso-8859-1";
        }
        String string2 = string.substring(n + 1);
        if (string2.equals("html") || string2.equals("htm")) {
            return "text/html; charset=iso-8859-1";
        }
        if (string2.equals("gif")) {
            return "image/gif";
        }
        if (string2.equals("jpg") || string2.equals("jpeg")) {
            return "image/jpeg";
        }
        if (string2.equals("au")) {
            return "audio/basic";
        }
        if (string2.equals("ra") || string2.equals("ram")) {
            return "audio/x-pn-realaudio";
        }
        if (string2.equals("wav")) {
            return "audio/wav";
        }
        if (string2.equals("mpg") || string2.equals("mpeg")) {
            return "video/mpeg";
        }
        if (string2.equals("qt") || string2.equals("mov")) {
            return "video/quicktime";
        }
        if (string2.equals("class")) {
            return "application/octet-stream";
        }
        if (string2.equals("ps")) {
            return "application/postscript";
        }
        if (string2.equals("wrl")) {
            return "x-world/x-vrml";
        }
        if (string2.equals("pac")) {
            return "application/x-ns-proxy-autoconfig";
        }
        return "text/plain; charset=iso-8859-1";
    }

    public String getServerInfo() {
        return "Acme.Serve v1.7 of 13nov96 (http://www.acme.com/java/software/Acme.Serve.Serve.html)";
    }

    public Object getAttribute(String string) {
        return null;
    }
}

