/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.Serve;
import Acme.Serve.ServeInputStream;
import Acme.Serve.ServeOutputStream;
import Acme.Serve.ServeUtils;
import Acme.Serve.servlet.Servlet;
import Acme.Serve.servlet.ServletException;
import Acme.Serve.servlet.ServletInputStream;
import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.Cookie;
import Acme.Serve.servlet.http.HttpServlet;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import Acme.Serve.servlet.http.HttpSession;
import Acme.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ServeConnection
implements Runnable,
HttpServletRequest,
HttpServletResponse {
    private Socket socket;
    private Serve serve;
    private ServletInputStream in;
    private ServletOutputStream out;
    private Vector cookies = new Vector();
    private String reqMethod;
    private String reqUriPath;
    private String reqProtocol;
    private boolean oneOne;
    private boolean reqMime;
    String reqQuery;
    private Vector reqHeaderNames = new Vector();
    private Vector reqHeaderValues = new Vector();
    Vector queryNames;
    Vector queryValues;
    private int resCode = -1;
    private String resMessage;
    private Vector resHeaderNames = new Vector();
    private Vector resHeaderValues = new Vector();
    private static final String[] weekdays = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private boolean headersWritten = false;

    public ServeConnection(Socket socket, Serve serve) {
        this.socket = socket;
        this.serve = serve;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            this.in = new ServeInputStream(this.socket.getInputStream());
            this.out = new ServeOutputStream(this.socket.getOutputStream(), this);
        }
        catch (IOException iOException) {
            this.problem("Getting streams: " + iOException.getMessage(), 400);
        }
        this.parseRequest();
        try {
            this.socket.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void parseRequest() {
        byte[] byArray = new byte[4096];
        try {
            String string;
            Object object;
            int n = this.in.readLine(byArray, 0, byArray.length);
            if (n == -1 || n == 0) {
                this.problem("Empty request", 400);
                return;
            }
            String string2 = new String(byArray, 0, n);
            String[] stringArray = Utils.splitStr(string2);
            switch (stringArray.length) {
                case 2: {
                    this.reqProtocol = "HTTP/0.9";
                    this.oneOne = false;
                    this.reqMime = false;
                    break;
                }
                case 3: {
                    this.reqProtocol = stringArray[2];
                    this.oneOne = !this.reqProtocol.toUpperCase().equals("HTTP/1.0");
                    this.reqMime = true;
                    while ((n = this.in.readLine(byArray, 0, byArray.length)) != -1 && n != 0) {
                        string2 = new String(byArray, 0, n);
                        int n2 = string2.indexOf(": ");
                        if (n2 == -1) continue;
                        object = string2.substring(0, n2);
                        String string3 = string2.substring(n2 + 2);
                        this.reqHeaderNames.addElement(((String)object).toLowerCase());
                        this.reqHeaderValues.addElement(string3);
                    }
                    break;
                }
                default: {
                    this.problem("Malformed request line", 400);
                    return;
                }
            }
            this.reqMethod = stringArray[0];
            this.reqUriPath = stringArray[1];
            if (this.oneOne && (string = this.getHeader("host")) == null) {
                this.problem("Host header missing on HTTP/1.1 request", 400);
                return;
            }
            int n3 = this.reqUriPath.indexOf(63);
            if (n3 != -1) {
                this.reqQuery = this.reqUriPath.substring(n3 + 1);
                this.reqUriPath = this.reqUriPath.substring(0, n3);
            }
            this.reqUriPath = this.decode(this.reqUriPath);
            object = (Servlet)this.serve.registry.get(this.reqUriPath);
            if (object != null) {
                this.runServlet((HttpServlet)object);
                return;
            }
        }
        catch (IOException iOException) {
            this.problem("Reading request: " + iOException.getMessage(), 400);
        }
    }

    private void runServlet(HttpServlet httpServlet) {
        this.setStatus(200);
        this.setDateHeader("Date", System.currentTimeMillis());
        this.setHeader("Server", "Acme.Serve/v1.7 of 13nov96");
        this.setHeader("Connection", "close");
        try {
            httpServlet.service(this, this);
            return;
        }
        catch (IOException iOException) {
            this.problem("IO problem running servlet: " + iOException.toString(), 400);
            return;
        }
        catch (ServletException servletException) {
            this.problem("problem running servlet: " + servletException.toString(), 400);
            return;
        }
        catch (Exception exception) {
            this.problem("unexpected problem running servlet: " + exception.toString(), 500);
            return;
        }
    }

    private void problem(String string, int n) {
        this.serve.log(string);
        try {
            this.sendError(n);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private String decode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '%' && n2 + 2 < n) {
                char c2 = string.charAt(n2 + 1);
                char c3 = string.charAt(n2 + 2);
                if ("0123456789abcdefABCDEF".indexOf(c2) != -1 && "0123456789abcdefABCDEF".indexOf(c3) != -1) {
                    stringBuffer.append((char)(this.hexit(c2) * 16 + this.hexit(c3)));
                    n2 += 2;
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private boolean isHexit(char c) {
        return "0123456789abcdefABCDEF".indexOf(c) != -1;
    }

    private int hexit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    public int getContentLength() {
        return this.getIntHeader("content-length", -1);
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getProtocol() {
        return this.reqProtocol;
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().toString();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getRealPath(String string) {
        return this.serve.getRealPath(string);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.in;
    }

    public BufferedReader getReader() {
        return null;
    }

    public Enumeration getParameterNames() {
        if (this.queryNames == null) {
            this.queryNames = new Vector();
            this.queryValues = new Vector();
            String string = this.getQueryString();
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                while (stringTokenizer.hasMoreElements()) {
                    String string2;
                    String string3;
                    String string4 = (String)stringTokenizer.nextElement();
                    int n = string4.indexOf(61);
                    if (n == -1) {
                        string3 = string4;
                        string2 = "";
                    } else {
                        string3 = string4.substring(0, n);
                        string2 = string4.substring(n + 1);
                    }
                    this.queryNames.addElement(string3);
                    this.queryValues.addElement(string2);
                }
            }
        }
        return this.queryNames.elements();
    }

    public String getParameter(String string) {
        this.getParameterNames();
        int n = this.queryNames.indexOf(string);
        if (n == -1) {
            return null;
        }
        return (String)this.queryValues.elementAt(n);
    }

    public String[] getParameterValues(String string) {
        Object[] objectArray;
        Vector vector = new Vector();
        this.getParameterNames();
        int n = 0;
        while (n < this.queryNames.size()) {
            objectArray = (Object[])this.queryNames.elementAt(n);
            if (string.equals(objectArray)) {
                vector.addElement(this.queryValues.elementAt(n));
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getAttribute(String string) {
        return null;
    }

    public Cookie[] getCookies() {
        Object[] objectArray = new Cookie[this.cookies.size()];
        this.cookies.copyInto(objectArray);
        return objectArray;
    }

    public String getMethod() {
        return this.reqMethod;
    }

    public String getRequestURI() {
        String string = "";
        int n = this.getServerPort();
        if (n != 80) {
            string = ":" + n;
        }
        String string2 = "";
        String string3 = this.getQueryString();
        if (string3 != null && string3.length() > 0) {
            string2 = "?" + string3;
        }
        return "http://" + this.getServerName() + string + this.reqUriPath + string2;
    }

    public String getServletPath() {
        return this.reqUriPath;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.reqQuery;
    }

    public String getRemoteUser() {
        return null;
    }

    public String getAuthType() {
        return null;
    }

    public String getHeader(String string) {
        int n = this.reqHeaderNames.indexOf(string.toLowerCase());
        if (n == -1) {
            return null;
        }
        return (String)this.reqHeaderValues.elementAt(n);
    }

    public int getIntHeader(String string, int n) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public long getLongHeader(String string, long l) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public long getDateHeader(String string, long l) {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return l;
        }
        try {
            return DateFormat.getDateInstance().parse(string2).getTime();
        }
        catch (Exception exception) {
            return l;
        }
    }

    public Enumeration getHeaderNames() {
        return this.reqHeaderNames.elements();
    }

    public HttpSession getSession(boolean bl) {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public void setContentLength(int n) {
        this.setIntHeader("Content-Length", n);
    }

    public void setContentType(String string) {
        this.setHeader("Content-Type", string);
    }

    public ServletOutputStream getOutputStream() {
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.addElement(cookie);
    }

    public boolean containsHeader(String string) {
        return this.resHeaderNames.contains(string);
    }

    public void setStatus(int n, String string) {
        this.resCode = n;
        this.resMessage = string;
    }

    public void setStatus(int n) {
        switch (n) {
            case 100: {
                this.setStatus(n, "Continue");
                return;
            }
            case 101: {
                this.setStatus(n, "Switching protocols");
                return;
            }
            case 200: {
                this.setStatus(n, "Ok");
                return;
            }
            case 201: {
                this.setStatus(n, "Created");
                return;
            }
            case 202: {
                this.setStatus(n, "Accepted");
                return;
            }
            case 203: {
                this.setStatus(n, "Non-authoritative");
                return;
            }
            case 204: {
                this.setStatus(n, "No content");
                return;
            }
            case 205: {
                this.setStatus(n, "Reset content");
                return;
            }
            case 206: {
                this.setStatus(n, "Partial content");
                return;
            }
            case 300: {
                this.setStatus(n, "Multiple choices");
                return;
            }
            case 301: {
                this.setStatus(n, "Moved permanentently");
                return;
            }
            case 302: {
                this.setStatus(n, "Moved temporarily");
                return;
            }
            case 303: {
                this.setStatus(n, "See other");
                return;
            }
            case 304: {
                this.setStatus(n, "Not modified");
                return;
            }
            case 305: {
                this.setStatus(n, "Use proxy");
                return;
            }
            case 400: {
                this.setStatus(n, "Bad request");
                return;
            }
            case 401: {
                this.setStatus(n, "Unauthorized");
                return;
            }
            case 402: {
                this.setStatus(n, "Payment required");
                return;
            }
            case 403: {
                this.setStatus(n, "Forbidden");
                return;
            }
            case 404: {
                this.setStatus(n, "Not found");
                return;
            }
            case 405: {
                this.setStatus(n, "Method not allowed");
                return;
            }
            case 406: {
                this.setStatus(n, "Not acceptable");
                return;
            }
            case 407: {
                this.setStatus(n, "Proxy auth required");
                return;
            }
            case 408: {
                this.setStatus(n, "Request timeout");
                return;
            }
            case 409: {
                this.setStatus(n, "Conflict");
                return;
            }
            case 410: {
                this.setStatus(n, "Gone");
                return;
            }
            case 411: {
                this.setStatus(n, "Length required");
                return;
            }
            case 412: {
                this.setStatus(n, "Precondition failed");
                return;
            }
            case 413: {
                this.setStatus(n, "Request entity too large");
                return;
            }
            case 414: {
                this.setStatus(n, "Request URI too large");
                return;
            }
            case 415: {
                this.setStatus(n, "Unsupported media type");
                return;
            }
            case 500: {
                this.setStatus(n, "Internal server error");
                return;
            }
            case 501: {
                this.setStatus(n, "Not implemented");
                return;
            }
            case 502: {
                this.setStatus(n, "Bad gateway");
                return;
            }
            case 503: {
                this.setStatus(n, "Service unavailable");
                return;
            }
            case 504: {
                this.setStatus(n, "Gateway timeout");
                return;
            }
            case 505: {
                this.setStatus(n, "HTTP version not supported");
                return;
            }
        }
        this.setStatus(n, "");
    }

    public void setHeader(String string, String string2) {
        this.resHeaderNames.addElement(string);
        this.resHeaderValues.addElement(string2);
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public void setLongHeader(String string, long l) {
        this.setHeader(string, Long.toString(l));
    }

    public void setDateHeader(String string, long l) {
        this.setHeader(string, ServeConnection.to1123String(new Date(l)));
    }

    private static String to1123String(Date date) {
        int n;
        int n2 = date.getDay();
        int n3 = date.getDate();
        String string = date.toGMTString();
        int n4 = Integer.parseInt(string.substring(0, n = string.indexOf(32)));
        int n5 = n4 > n3 || n4 < n3 && n4 == 1 ? (n2 + 1) % 7 : (n3 > n4 || n3 < n4 && n3 == 1 ? (n2 + 6) % 7 : n2);
        return String.valueOf(weekdays[n5]) + (n4 < 10 ? ", 0" : ", ") + string;
    }

    void writeHeaders() throws IOException {
        if (this.headersWritten) {
            return;
        }
        this.headersWritten = true;
        if (this.reqMime) {
            this.out.println(String.valueOf(this.reqProtocol) + " " + this.resCode + " " + this.resMessage);
            int n = 0;
            while (n < this.resHeaderNames.size()) {
                String string = (String)this.resHeaderNames.elementAt(n);
                String string2 = (String)this.resHeaderValues.elementAt(n);
                if (string2 != null) {
                    this.out.println(String.valueOf(string) + ": " + string2);
                }
                ++n;
            }
            this.out.println("");
            this.out.flush();
        }
    }

    public void sendError(int n, String string) throws IOException {
        this.setStatus(n, string);
        this.realSendError();
    }

    public void sendError(int n) throws IOException {
        this.setStatus(n);
        this.realSendError();
    }

    private void realSendError() throws IOException {
        this.setContentType("text/html");
        this.out.println("<HTML><HEAD>");
        this.out.println("<TITLE>" + this.resCode + " " + this.resMessage + "</TITLE>");
        this.out.println("</HEAD><BODY BGCOLOR=\"#99cc99\">");
        this.out.println("<H2>" + this.resCode + " " + this.resMessage + "</H2>");
        String string = this.getHeader("user-agent");
        if (string != null && Utils.match("*MSIE*", string)) {
            this.out.println("<!--");
            int n = 0;
            while (n < 6) {
                this.out.println("Padding so that MSIE deigns to show this error instead of its own canned one.");
                ++n;
            }
            this.out.println("-->");
        }
        this.out.println("<HR>");
        ServeUtils.writeAddress(this.out);
        this.out.println("</BODY></HTML>");
        this.out.flush();
    }

    public void sendRedirect(String string) throws IOException {
        this.setHeader("Location", string);
        this.sendError(302);
    }

    public String encodeUrl(String string) {
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return string;
    }
}

