/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.BlockView;
import horst.Element;
import horst.FrameSetView;
import horst.HTMLPane;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class BodyView
extends BlockView
implements ImageObserver {
    Image m_bkgImage;
    Color m_bkgColor;

    public BodyView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if (this.m_bkgImage == null) {
            return false;
        }
        if ((flags & 0xC0) != 0) {
            this.m_bkgImage = null;
            return false;
        }
        if ((flags & 0x30) != 0) {
            this.m_container.repaint(this.m_bounds.x);
        }
        return true;
    }

    protected void init() {
        URL u = Utilities.setURLProperty(this.m_elem.getDocument().getBaseURL(), "background", this.m_elem.getAttributes());
        if (u != null) {
            this.m_bkgImage = Toolkit.getDefaultToolkit().getImage(u);
            if (this.m_bkgImage != null) {
                Toolkit.getDefaultToolkit().prepareImage(this.m_bkgImage, -1, -1, this);
            }
        }
        this.m_bkgColor = Utilities.setColorProperty(null, "bgcolor", this.m_elem.getAttributes());
        int leftMargin = Utilities.setIntegerProperty(this.m_container.m_props.m_marginWidth, "leftmargin", this.m_elem.getAttributes());
        int topMargin = Utilities.setIntegerProperty(this.m_container.m_props.m_marginHeight, "topmargin", this.m_elem.getAttributes());
        int rightMargin = Utilities.setIntegerProperty(this.m_container.m_props.m_marginWidth, "rightmargin", this.m_elem.getAttributes());
        int bottomMargin = Utilities.setIntegerProperty(this.m_container.m_props.m_marginHeight, "bottommargin", this.m_elem.getAttributes());
        this.setInsets(topMargin, leftMargin, bottomMargin, rightMargin);
    }

    protected boolean isFloaterClearer() {
        return true;
    }

    protected boolean isWrappable() {
        return true;
    }

    protected void makeChildren(ViewFactory factory) {
        super.makeChildren(factory);
        if (this.m_children.length > 0 && this.m_children[0] instanceof FrameSetView) {
            this.setInsets(0, 0, 0, 0);
        }
    }

    public void paint(Graphics g, Shape alloc) {
        if (this.m_bounds.intersects(alloc.getBounds())) {
            Rectangle allocation = alloc.getBounds();
            int screenWidth = Math.max(allocation.width, this.m_bounds.width + this.m_insets.left + this.m_insets.right);
            int screenHeight = Math.max(allocation.height, this.m_bounds.height + this.m_insets.top + this.m_insets.bottom);
            if (this.m_bkgColor != null) {
                g.setColor(this.m_bkgColor);
                g.fillRect(this.m_bounds.x, this.m_bounds.y, screenWidth, screenHeight);
            }
            if (this.m_bkgImage != null && this.m_container.m_props.m_bDisplayBackgroundImage) {
                double rem;
                int w = this.m_bkgImage.getWidth(null);
                int h = this.m_bkgImage.getHeight(null);
                int nCols = 1;
                int nRows = 1;
                if (screenWidth > w && (rem = (double)screenWidth / (double)w - (double)(nCols = screenWidth / w)) > 0.0) {
                    ++nCols;
                }
                if (screenHeight > h && (rem = (double)screenHeight / (double)h - (double)(nRows = screenHeight / h)) > 0.0) {
                    ++nRows;
                }
                int row = 0;
                while (row < nRows) {
                    int col = 0;
                    while (col < nCols) {
                        g.drawImage(this.m_bkgImage, col * w, row * h, w, h, null);
                        ++col;
                    }
                    ++row;
                }
            }
            super.paint(g, alloc);
        }
    }
}

