/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.HTMLAttributes;
import horst.HTMLDocument;
import horst.parser.HTMLDefs;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Element {
    public Vector m_children = new Vector();
    public Vector m_relatedElements = new Vector();
    public Vector m_origRelatedElements = new Vector();
    public Hashtable m_attributes = new Hashtable(10);
    Element m_parent;
    Element m_anchor;
    HTMLDocument m_doc;
    int m_type;
    Font m_font;
    boolean m_bDrawFocusBox;
    boolean m_bHasFocus;
    boolean m_bInPreformat = false;
    boolean m_bSplit = false;
    Color m_focusColor = Color.red;
    int m_p0;
    int m_p1;
    int m_origP0;
    int m_origP1;
    int m_textbufferPosition = -1;

    public Element(int type) {
        this.m_type = type;
        this.m_bInPreformat = false;
    }

    public Element(int type, int p0, int p1) {
        this.m_type = type;
        this.m_p0 = p0;
        this.m_p1 = p1;
        this.m_origP0 = p0;
        this.m_origP1 = p1;
    }

    public Element(Element copy) {
        this.m_origP0 = copy.m_origP0;
        this.m_origP1 = copy.m_origP1;
        this.m_p0 = copy.m_p0;
        this.m_p1 = copy.m_p1;
        this.m_attributes = copy.getAttributes();
        this.m_type = copy.getType();
        this.m_font = copy.getFont();
        this.m_bHasFocus = copy.getHasFocus();
        this.m_focusColor = copy.getFocusColor();
        this.m_bDrawFocusBox = copy.getDrawFocusBox();
        this.m_doc = copy.getDocument();
        this.m_bInPreformat = copy.m_bInPreformat;
        this.m_anchor = copy.m_anchor;
    }

    public void addChild(Element e) {
        this.m_children.addElement(e);
        e.m_parent = this;
    }

    void addRelatedElement(Element e) {
        this.m_relatedElements.addElement(e);
        this.m_origRelatedElements.addElement(e);
    }

    void dereference() {
        Enumeration e = this.m_children.elements();
        while (e.hasMoreElements()) {
            ((Element)e.nextElement()).dereference();
        }
        this.m_parent = null;
        this.m_anchor = null;
        this.m_doc = null;
        this.m_attributes.clear();
        this.m_relatedElements.removeAllElements();
        this.m_origRelatedElements.removeAllElements();
        this.m_children.removeAllElements();
    }

    public Object getAttribute(Object name) {
        return this.m_attributes.get(name);
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }

    public char[] getCharData() {
        StringBuffer buf;
        if (this.m_p0 >= 0 && this.m_p1 >= this.m_p0 && (buf = this.getDocument().getTextBuffer()) != null) {
            char[] data = new char[this.m_p1 - this.m_p0 + 1];
            buf.getChars(this.m_p0, this.m_p1 + 1, data, 0);
            return data;
        }
        return null;
    }

    public Vector getChildren() {
        return this.m_children;
    }

    public HTMLDocument getDocument() {
        return this.m_doc;
    }

    protected boolean getDrawFocusBox() {
        return this.m_bDrawFocusBox;
    }

    public Element getElementAt(int index) {
        return (Element)this.m_children.elementAt(index);
    }

    public int getElementCount() {
        return this.m_children.size();
    }

    public int getElementIndex(Element e) {
        return this.m_children.indexOf(e);
    }

    protected Color getFocusColor() {
        return this.m_focusColor;
    }

    public Font getFont() {
        return this.m_font;
    }

    protected boolean getHasFocus() {
        return this.m_bHasFocus;
    }

    public String getName() {
        return HTMLDefs.getName(this.m_type);
    }

    public Element getParent() {
        return this.m_parent;
    }

    Element[] getRelatedElements() {
        Object[] elems = new Element[this.m_relatedElements.size()];
        this.m_relatedElements.copyInto(elems);
        return elems;
    }

    public int getTextBufferPointerEnd() {
        return this.m_p1;
    }

    public int getTextBufferPointerStart() {
        return this.m_p0;
    }

    public int getType() {
        return this.m_type;
    }

    public void insertElementAt(Element e, int idx) {
        if (e != null && idx <= this.m_children.size() - 1) {
            this.m_children.insertElementAt(e, idx);
            e.m_parent = this;
        }
    }

    public boolean isAttributeDefined(Object key) {
        return this.m_attributes.containsKey(key);
    }

    public boolean isLink() {
        return this.getAttribute("href") != null;
    }

    protected void propagateDrawFocusBox(boolean bDraw) {
        Enumeration e = this.m_relatedElements.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            elem.setDrawFocusBox(bDraw);
        }
    }

    protected void propagateFocus(boolean bFocus) {
        this.m_bHasFocus = bFocus;
        if (!bFocus) {
            this.m_bDrawFocusBox = false;
        }
        Enumeration e = this.m_relatedElements.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            elem.setFocus(bFocus);
            elem.setDrawFocusBox(this.m_bDrawFocusBox);
        }
    }

    protected void propagateFocus(boolean bFocus, boolean bDrawFocusBox) {
        this.m_bHasFocus = bFocus;
        this.m_bDrawFocusBox = bDrawFocusBox;
        Enumeration e = this.m_relatedElements.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            elem.setFocus(bFocus);
            elem.setDrawFocusBox(this.m_bDrawFocusBox);
        }
    }

    public Element relatedElementAtIndex(int i) {
        return (Element)this.m_relatedElements.elementAt(i);
    }

    public int relatedElementSize() {
        return this.m_relatedElements.size();
    }

    public void removeAllRelatedElements() {
        if (this.m_relatedElements != null) {
            this.m_relatedElements.removeAllElements();
        }
    }

    public void removeAttribute(Object name) {
        this.m_attributes.remove(name);
    }

    public void replaceChildElement(Element oldChild, Element newChild) {
        int idx = this.getElementIndex(oldChild);
        if (idx != -1) {
            this.m_children.removeElementAt(idx);
            this.m_children.insertElementAt(newChild, idx);
            newChild.m_parent = this;
            oldChild.m_parent = null;
        }
    }

    public void replaceChildElement(Element oldChild, Element[] newChildren) {
        int idx = this.getElementIndex(oldChild);
        if (idx != -1) {
            oldChild.m_parent = null;
            this.m_children.removeElementAt(idx);
            int i = 0;
            while (i < newChildren.length) {
                this.m_children.insertElementAt(newChildren[i], idx + i);
                newChildren[i].m_parent = this;
                ++i;
            }
        }
    }

    void replaceRelatedElement(Element oldElem, Element[] newElems) {
        int sz = this.m_relatedElements.size();
        int i = 0;
        while (i < sz) {
            Element elem = (Element)this.m_relatedElements.elementAt(i);
            if (elem == oldElem) {
                this.m_relatedElements.removeElementAt(i);
                int j = 0;
                while (j < newElems.length) {
                    this.m_relatedElements.addElement(newElems[j]);
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    void reset() {
        this.m_p0 = this.m_origP0;
        this.m_p1 = this.m_origP1;
        Enumeration e = this.m_relatedElements.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            if (!elem.m_bSplit) continue;
            elem.m_parent = null;
            elem.m_anchor = null;
            elem.m_doc = null;
            elem.m_attributes = null;
            if (elem.m_relatedElements != null) {
                elem.m_relatedElements.removeAllElements();
            }
            if (elem.m_origRelatedElements != null) {
                elem.m_origRelatedElements.removeAllElements();
            }
            if (elem.m_children == null) continue;
            elem.m_children.removeAllElements();
        }
        this.m_relatedElements.removeAllElements();
        Enumeration e2 = this.m_origRelatedElements.elements();
        while (e2.hasMoreElements()) {
            this.m_relatedElements.addElement(e2.nextElement());
        }
        Enumeration e3 = this.m_children.elements();
        while (e3.hasMoreElements()) {
            ((Element)e3.nextElement()).reset();
        }
    }

    public void setAttribute(Object name, Object value) {
        this.m_attributes.put(name, value);
    }

    public void setAttributes(Hashtable atts) {
        this.m_attributes = atts;
    }

    public void setDocument(HTMLDocument doc) {
        this.m_doc = doc;
        Object[] elems = new Element[this.m_children.size()];
        this.m_children.copyInto(elems);
        int i = 0;
        while (i < elems.length) {
            ((Element)elems[i]).setDocument(doc);
            ++i;
        }
    }

    protected void setDrawFocusBox(boolean bDraw) {
        this.m_bDrawFocusBox = bDraw;
    }

    protected void setFocus(boolean bFocus) {
        this.m_bHasFocus = bFocus;
        if (!bFocus) {
            this.m_bDrawFocusBox = false;
        }
    }

    public void setFont(Font f) {
        this.m_font = f;
    }

    void setTextPointers(int p0, int p1) {
        this.m_origP0 = p0;
        this.m_origP1 = p1;
        this.m_p0 = p0;
        this.m_p1 = p1;
    }

    public String toString() {
        if (this.m_type == 9) {
            boolean bBold;
            String s = new String(this.getCharData());
            boolean bl = bBold = (this.m_font.getStyle() & 1) > 0;
            if (bBold) {
                System.out.println("Bold x" + s + "x");
            }
            return s;
        }
        String name = this.getName();
        if (name.length() == 0) {
            return "";
        }
        String s = "<" + this.getName();
        String attStr = "";
        Enumeration e = this.m_attributes.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!HTMLAttributes.isHTMLAttribute(key)) continue;
            Object value = this.m_attributes.get(key);
            attStr = String.valueOf(attStr) + " " + key;
            attStr = value != null && value instanceof String && ((String)value).length() > 0 ? String.valueOf(attStr) + "=\"" + value + "\"" : String.valueOf(attStr) + "=\"\"";
        }
        s = String.valueOf(s) + attStr;
        s = String.valueOf(s) + ">";
        return s;
    }
}

