/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.HTMLPane;
import horst.TextInput;
import horst.Utilities;
import horst.controls.HChoice;
import horst.controls.ImageButton;
import horst.controls.o2.O2Button;
import horst.controls.o2.O2TextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FormProcessor
implements ActionListener,
KeyListener {
    Vector m_comps = new Vector();
    Vector m_submits = new Vector();
    Hashtable m_atts;
    HTMLPane m_renderer;

    public FormProcessor(HTMLPane renderer, Hashtable atts) {
        this.m_renderer = renderer;
        this.m_atts = atts;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof O2Button || src instanceof ImageButton) {
            String method = (String)this.m_atts.get("method");
            String action = (String)this.m_atts.get("action");
            if (action != null) {
                String formString = this.getFormString();
                if (method != null && method.equalsIgnoreCase("POST")) {
                    URL u = Utilities.getURL(action);
                    if (u == null && this.m_renderer != null) {
                        u = Utilities.getURL(this.m_renderer.getDocument().getBaseURL(), action);
                    }
                    if (u != null) {
                        try {
                            URLConnection conn = u.openConnection();
                            conn.setDoInput(true);
                            conn.setDoOutput(true);
                            conn.setUseCaches(false);
                            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            DataOutputStream printout = new DataOutputStream(conn.getOutputStream());
                            printout.writeBytes(formString);
                            printout.close();
                            DataInputStream input = new DataInputStream(conn.getInputStream());
                            InputStreamReader reader = new InputStreamReader(input);
                            this.m_renderer.openPage(reader, u);
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    formString = "?" + formString;
                    URL u = Utilities.getURL(String.valueOf(action) + formString);
                    if (u == null && this.m_renderer != null) {
                        u = Utilities.getURL(this.m_renderer.getDocument().getBaseURL(), String.valueOf(action) + formString);
                    }
                    this.m_renderer.openPage(u);
                }
            }
        }
    }

    void addComponent(Element e) {
        this.m_comps.addElement(e);
        Component c = (Component)e.getAttribute("component");
        String type = (String)e.getAttribute("type");
        if (type != null && (type.equalsIgnoreCase("submit") || type.equalsIgnoreCase("image")) && c != null) {
            this.m_submits.addElement(c);
            if (c instanceof O2Button) {
                ((O2Button)c).addActionListener(this);
            } else if (c instanceof ImageButton) {
                ((ImageButton)c).addActionListener(this);
            }
        }
        if (c instanceof O2TextField) {
            ((O2TextField)c).addKeyListener(this);
        }
    }

    void dereference() {
        this.m_comps.removeAllElements();
        Enumeration e = this.m_submits.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c instanceof O2Button) {
                ((O2Button)c).removeActionListener(this);
                continue;
            }
            if (!(c instanceof ImageButton)) continue;
            ((ImageButton)c).removeActionListener(this);
        }
        this.m_submits.removeAllElements();
        this.m_renderer = null;
        this.m_atts = null;
    }

    Hashtable getComponentAttributes(Component c) {
        Enumeration e = this.m_comps.elements();
        while (e.hasMoreElements()) {
            Element e1 = (Element)e.nextElement();
            Component c1 = (Component)e1.getAttribute("component");
            if (c1 != c) continue;
            return e1.getAttributes();
        }
        return null;
    }

    public Vector getComponents() {
        return this.m_comps;
    }

    public Hashtable getFormAttributes() {
        return this.m_atts;
    }

    String getFormString() {
        String str = "";
        int nCount = 0;
        Enumeration e = this.m_comps.elements();
        while (e.hasMoreElements()) {
            Element e1 = (Element)e.nextElement();
            Component c1 = (Component)e1.getAttribute("component");
            if (c1 != null && this.m_submits.contains(c1)) continue;
            String type = (String)e1.getAttribute("type");
            String name = (String)e1.getAttribute("name");
            String value = "";
            value = c1 != null && c1 instanceof TextInput ? ((TextInput)c1).getText() : (c1 instanceof HChoice ? ((HChoice)c1).getValue() : (String)e1.getAttribute("value"));
            if (value == null || name == null) continue;
            value = URLEncoder.encode(value.trim());
            str = nCount++ == 0 ? String.valueOf(str) + name + "=" + value : String.valueOf(str) + "&" + name + "=" + value;
        }
        return str;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        String action;
        if (e.getKeyCode() == 10 && (action = (String)this.m_atts.get("action")) != null) {
            String formString = this.getFormString();
            URL u = Utilities.getURL(String.valueOf(action) + formString);
            if (u == null && this.m_renderer != null) {
                u = Utilities.getURL(this.m_renderer.getDocument().getBaseURL(), String.valueOf(action) + formString);
            }
            this.m_renderer.openPage(u);
        }
    }

    public void keyTyped(KeyEvent e) {
    }
}

