/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.FrameConstraint;
import horst.FrameSplitterBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;

public class FrameSetLayout
implements LayoutManager {
    static final int HORIZONTAL = 0;
    static final int VERTICAL = 1;
    private int m_orientation = 0;
    private Hashtable m_hash = new Hashtable();
    private int m_lastWidth = -1;
    private int m_lastHeight = -1;
    private boolean m_bAlwaysConstraintLayout = false;

    public void addLayoutComponent(Component comp, Object constraints) {
        this.m_hash.put(comp, constraints);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    private void constraintLayout(Container parent) {
        Insets insets = parent.getInsets();
        Dimension dim = parent.getSize();
        int top = insets.top;
        int bottom = dim.height - insets.bottom;
        int left = insets.left;
        int right = dim.width - insets.right;
        int xPos = left;
        int yPos = top;
        int space = this.m_orientation == 0 ? right - left : bottom - top;
        Component[] comps = parent.getComponents();
        Vector<Component> temp = new Vector<Component>();
        int nSplitBars = 0;
        int splitBarSpace = 0;
        int i = 0;
        while (i < comps.length) {
            if (!(comps[i] instanceof FrameSplitterBar)) {
                temp.addElement(comps[i]);
            } else {
                int splitBarWidth = ((FrameSplitterBar)comps[i]).getBarSize();
                splitBarSpace += splitBarWidth;
                ((FrameSplitterBar)comps[i]).setOrientation(this.m_orientation);
                if (this.m_orientation == 0) {
                    comps[i].setBounds(left, top, splitBarWidth, dim.height);
                } else {
                    comps[i].setBounds(left, top, dim.width, splitBarWidth);
                }
                ++nSplitBars;
            }
            ++i;
        }
        space = Math.max(0, space - splitBarSpace);
        int nFrames = temp.size();
        Object[] frames = new Component[nFrames];
        temp.copyInto(frames);
        int pixSpace = this.getPixelSpace((Component[])frames);
        int pctSpace = this.getPercentSpace((Component[])frames, space);
        int wildcardDivisions = this.getWildcardDivisions((Component[])frames);
        int wildcardSpace = space - pctSpace - pixSpace;
        int i2 = 0;
        while (i2 < frames.length) {
            FrameConstraint c = (FrameConstraint)this.m_hash.get(frames[i2]);
            if (c != null && c.type == 1) {
                int sz = (int)(c.percent * (float)space);
                if (this.m_orientation == 0) {
                    ((Component)frames[i2]).setBounds(0, 0, sz, dim.height);
                } else {
                    ((Component)frames[i2]).setBounds(0, 0, dim.width, sz);
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < frames.length) {
            FrameConstraint c = (FrameConstraint)this.m_hash.get(frames[i3]);
            if (c != null && c.type == 0) {
                if (this.m_orientation == 0) {
                    ((Component)frames[i3]).setBounds(0, 0, c.pixels, dim.height);
                } else {
                    ((Component)frames[i3]).setBounds(0, 0, dim.width, c.pixels);
                }
            }
            ++i3;
        }
        int leftOverSpace = wildcardSpace;
        int nDivisions = this.getWildcardDivisions((Component[])frames);
        int divisionWidth = 0;
        if (leftOverSpace > 0 && nDivisions > 0) {
            divisionWidth = wildcardSpace / nDivisions;
            int i4 = 0;
            while (i4 < frames.length) {
                FrameConstraint c = (FrameConstraint)this.m_hash.get(frames[i4]);
                if (c != null && c.type == 2) {
                    int sz = c.wildcard * divisionWidth;
                    if (this.m_orientation == 0) {
                        ((Component)frames[i4]).setBounds(0, 0, sz, dim.height);
                    } else {
                        ((Component)frames[i4]).setBounds(0, 0, dim.width, sz);
                    }
                }
                ++i4;
            }
        } else if (leftOverSpace > 0) {
            if (leftOverSpace < nFrames) {
                int i5 = 0;
                while (i5 < leftOverSpace) {
                    Rectangle b = ((Component)frames[i5]).getBounds();
                    if (this.m_orientation == 0) {
                        ((Component)frames[i5]).setBounds(0, 0, b.width + 1, dim.height);
                    } else {
                        ((Component)frames[i5]).setBounds(0, 0, dim.width, b.height + 1);
                    }
                    ++i5;
                }
            } else {
                double pct = 1.0 / (double)nFrames;
                int runningTotal = 0;
                int addAmount = 0;
                int i6 = 0;
                while (i6 < nFrames) {
                    addAmount = i6 == nFrames - 1 ? leftOverSpace - runningTotal : (int)(pct * (double)leftOverSpace);
                    runningTotal += addAmount;
                    Rectangle b = ((Component)frames[i6]).getBounds();
                    if (this.m_orientation == 0) {
                        ((Component)frames[i6]).setBounds(0, 0, b.width + addAmount, dim.height);
                    } else {
                        ((Component)frames[i6]).setBounds(0, 0, dim.width, b.height + addAmount);
                    }
                    ++i6;
                }
            }
        } else if (leftOverSpace < 0) {
            int overshoot = Math.abs(leftOverSpace);
            while (overshoot > 0 && !this.framesAtMinimum((Component[])frames, 1) || !this.framesAtMinimum((Component[])frames, 2)) {
                overshoot = this.removePixels((Component[])frames, 1, overshoot);
                overshoot = this.removePixels((Component[])frames, 2, overshoot);
            }
            while (overshoot > 0 && !this.framesAtMinimum((Component[])frames, 0)) {
                overshoot = this.removePixels((Component[])frames, 0, overshoot);
            }
        }
        int x = left;
        int y = top;
        int i7 = 0;
        while (i7 < comps.length) {
            comps[i7].setLocation(x, y);
            if (this.m_orientation == 0) {
                x += comps[i7].getBounds().width;
            } else {
                y += comps[i7].getBounds().height;
            }
            ++i7;
        }
        this.m_lastWidth = dim.width;
        this.m_lastHeight = dim.height;
    }

    void doConstraintLayout() {
        this.m_lastWidth = -1;
        this.m_lastHeight = -1;
    }

    private boolean framesAtMinimum(Component[] frames, int type) {
        int i = 0;
        while (i < frames.length) {
            FrameConstraint c = (FrameConstraint)this.m_hash.get(frames[i]);
            if (c != null && c.type == type) {
                boolean bAtMinimum;
                Rectangle b = frames[i].getBounds();
                boolean bl = this.m_orientation == 0 ? b.width == 0 : (bAtMinimum = b.height == 0);
                if (!bAtMinimum) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    private int getPercentSpace(Component[] comps, int space) {
        int pctSpace = 0;
        int i = 0;
        while (i < comps.length) {
            FrameConstraint c = (FrameConstraint)this.m_hash.get(comps[i]);
            if (c != null && c.type == 1) {
                pctSpace = (int)((float)pctSpace + (float)space * c.percent);
            }
            ++i;
        }
        return pctSpace;
    }

    private int getPixelSpace(Component[] comps) {
        int total = 0;
        int i = 0;
        while (i < comps.length) {
            FrameConstraint c = (FrameConstraint)this.m_hash.get(comps[i]);
            if (c != null && c.type == 0) {
                total += c.pixels;
            }
            ++i;
        }
        return total;
    }

    private int getWildcardDivisions(Component[] comps) {
        int nDivisions = 0;
        int i = 0;
        while (i < comps.length) {
            FrameConstraint c = (FrameConstraint)this.m_hash.get(comps[i]);
            if (c != null && c.type == 2) {
                nDivisions += c.wildcard;
            }
            ++i;
        }
        return nDivisions;
    }

    public void invalidateLayout(Container target) {
    }

    public void layoutContainer(Container parent) {
        if (this.m_bAlwaysConstraintLayout || this.m_orientation == 0 && this.m_lastWidth == -1 || this.m_orientation == 1 && this.m_lastHeight == -1) {
            this.constraintLayout(parent);
        } else {
            this.splitBarLayout(parent);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return parent.getSize();
    }

    public Dimension preferredLayoutSize(Container parent) {
        return parent.getSize();
    }

    public void removeLayoutComponent(Component comp) {
    }

    private int removePixels(Component[] frames, int type, int overshoot) {
        int i = 0;
        while (i < frames.length && overshoot > 0) {
            FrameConstraint c = (FrameConstraint)this.m_hash.get(frames[i]);
            if (c != null && c.type == type) {
                int sz;
                Rectangle b = frames[i].getBounds();
                int n = sz = this.m_orientation == 0 ? b.width : b.height;
                if (sz > 0) {
                    --overshoot;
                    --sz;
                    if (this.m_orientation == 0) {
                        b.width = sz;
                    } else {
                        b.height = sz;
                    }
                    frames[i].setBounds(b);
                }
            }
            ++i;
        }
        return overshoot;
    }

    void setAlwaysConstraintLayout(boolean bAlways) {
        this.m_bAlwaysConstraintLayout = bAlways;
    }

    void setConstraints(Component c, FrameConstraint constraints) {
        this.m_hash.put(c, constraints);
    }

    void setOrientation(int orientation) {
        this.m_orientation = orientation;
    }

    private void splitBarLayout(Container parent) {
        Insets insets = parent.getInsets();
        Dimension dim = parent.getSize();
        int top = insets.top;
        int bottom = dim.height - insets.bottom;
        int left = insets.left;
        int right = dim.width - insets.right;
        int xPos = left;
        int yPos = top;
        int space = right - left;
        Component[] comps = parent.getComponents();
        int nFrames = 0;
        int i = 0;
        while (i < comps.length) {
            if (!(comps[i] instanceof FrameSplitterBar)) {
                ++nFrames;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < comps.length) {
            Component c = comps[i2];
            if (c instanceof FrameSplitterBar) {
                Rectangle r = c.getBounds();
                int sz = ((FrameSplitterBar)c).getBarSize();
                if (this.m_orientation == 0) {
                    c.setBounds(r.x, top, sz, dim.height);
                } else {
                    c.setBounds(left, r.y, dim.width, sz);
                }
            } else if (i2 + 1 < comps.length && comps[i2 + 1] instanceof FrameSplitterBar) {
                int barWidth = ((FrameSplitterBar)comps[i2 + 1]).getBarSize();
                Point splitterPos = comps[i2 + 1].getLocation();
                if (this.m_orientation == 0) {
                    int frameWidth = splitterPos.x - left;
                    c.setBounds(left, top, frameWidth, dim.height);
                    left += frameWidth + barWidth;
                } else {
                    int frameHeight = splitterPos.y - top;
                    c.setBounds(left, top, dim.width, frameHeight);
                    top += frameHeight + barWidth;
                }
            } else if (i2 == comps.length - 1) {
                if (this.m_orientation == 0) {
                    c.setBounds(left, top, right - left, dim.height);
                } else {
                    c.setBounds(left, top, dim.width, bottom - top);
                }
            }
            ++i2;
        }
    }
}

