/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.BlockView;
import horst.Element;
import horst.FrameConstraint;
import horst.FrameSetLayout;
import horst.FrameSetPanel;
import horst.FrameSplitterBar;
import horst.HTMLPane;
import horst.HTMLWindow;
import horst.LayoutInfo;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;

public class FrameSetView
extends BlockView {
    FrameSetPanel m_panel;
    Component[] m_framesetChildren;
    URL[] m_frameURLs;
    FrameConstraint[] m_constraints;
    int m_orientation = 0;
    int m_nFrames;

    public FrameSetView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    Object getFrame(int idx) {
        HTMLWindow wnd;
        if (this.m_framesetChildren != null && this.m_framesetChildren.length > idx && this.m_framesetChildren[idx] instanceof HTMLWindow && (wnd = (HTMLWindow)this.m_framesetChildren[idx]) != null) {
            return wnd.getViewport().getView();
        }
        return null;
    }

    HTMLPane getFrame(String frameName) {
        if (frameName != null) {
            if (frameName.equalsIgnoreCase("_self")) {
                return this.m_container;
            }
            if (frameName.equalsIgnoreCase("_top")) {
                HTMLPane p = this.m_container;
                while (p != null) {
                    Container parent;
                    if (p instanceof HTMLPane) {
                        HTMLPane hp = p;
                        if (!hp.m_props.m_bIsFrame) {
                            return hp;
                        }
                    }
                    if ((parent = p.getParent()) != null) continue;
                    p = null;
                    break;
                }
                return null;
            }
            int i = 0;
            while (i < this.m_framesetChildren.length) {
                if (this.m_framesetChildren[i] instanceof HTMLWindow) {
                    HTMLWindow p = (HTMLWindow)this.m_framesetChildren[i];
                    HTMLPane html = p.getHTMLPane();
                    String name = html.m_props.m_frameName;
                    if (name != null && name.equals(frameName)) {
                        return html;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected int getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    protected int getPreferredSpan(int axis) {
        Dimension dim = this.m_container.getBrowserDimension();
        if (axis == 1) {
            return dim.width;
        }
        return dim.height;
    }

    protected void init() {
        HTMLWindow w;
        int i;
        this.m_panel = new FrameSetPanel();
        this.m_container.add(this.m_panel);
        this.m_panel.setBackground(Color.white);
        int nCount = this.m_elem.getElementCount();
        FrameSetLayout layoutManager = new FrameSetLayout();
        boolean bAddSplitterBars = true;
        String atts = (String)this.m_elem.getAttribute("frameborder");
        if (!this.m_container.m_preferences.m_bResizableFrames && atts != null && (atts.equalsIgnoreCase("0") || atts.equalsIgnoreCase("no"))) {
            layoutManager.setAlwaysConstraintLayout(true);
            bAddSplitterBars = false;
        }
        Vector<JComponent> temp = new Vector<JComponent>();
        Vector<URL> urlVec = new Vector<URL>();
        this.m_framesetChildren = new JComponent[nCount];
        URL refURL = this.m_elem.getDocument().getBaseURL();
        int i2 = 0;
        while (i2 < nCount) {
            Element elem = this.m_elem.getElementAt(i2);
            if (elem.getType() == 36) {
                ++this.m_nFrames;
                this.m_container.m_bContainsFrames = true;
                HTMLWindow htmlWnd = this.m_container.createHTMLWindowFrame();
                int margHeight = Utilities.setIntegerProperty(5, "marginheight", elem.getAttributes());
                int margWidth = Utilities.setIntegerProperty(5, "marginwidth", elem.getAttributes());
                htmlWnd.getHTMLPane().setMargins(margWidth, margHeight);
                htmlWnd.getHTMLPane().addLinkListener(this.m_container);
                if (!bAddSplitterBars) {
                    htmlWnd.hideBorder();
                }
                htmlWnd.enableDoubleBuffering(false);
                String scrolling = (String)elem.getAttribute("scrolling");
                if (scrolling != null && scrolling.equalsIgnoreCase("no")) {
                    htmlWnd.enableScrolling(false);
                }
                HTMLPane html = htmlWnd.getHTMLPane();
                html.m_preferences.m_bShowToolTip = false;
                html.m_props.m_bIsFrame = true;
                html.m_props.m_framesetView = this;
                html.m_props.m_frameBaseDocument = this.m_container.getDocument();
                String name = (String)elem.getAttribute("name");
                if (name != null) {
                    html.m_props.m_frameName = name;
                }
                String src = (String)elem.getAttribute("src");
                URL url = null;
                url = refURL != null ? Utilities.getURL(refURL, src) : Utilities.getURL(src);
                if (url != null) {
                    html.openPage(url);
                }
                urlVec.addElement(url);
                temp.addElement(htmlWnd);
            } else if (elem.getType() == 35) {
                FrameSetView fv = (FrameSetView)this.m_container.m_viewFactory.createView(null, elem, this.m_container);
                temp.addElement(fv.m_panel);
            }
            ++i2;
        }
        this.m_framesetChildren = new Component[temp.size()];
        temp.copyInto(this.m_framesetChildren);
        this.m_frameURLs = new URL[urlVec.size()];
        urlVec.copyInto(this.m_frameURLs);
        String cols = (String)this.m_elem.getAttribute("cols");
        String rows = (String)this.m_elem.getAttribute("rows");
        String attStr = null;
        if (cols != null && rows != null) {
            if (cols.trim().equalsIgnoreCase("*")) {
                layoutManager.setOrientation(1);
                attStr = rows;
            } else if (rows.trim().equalsIgnoreCase("*")) {
                layoutManager.setOrientation(0);
                attStr = cols;
            } else {
                StringTokenizer st = new StringTokenizer(cols, ",");
                int nColCount = st.countTokens();
                StringTokenizer st2 = new StringTokenizer(rows, ",");
                int nRowCount = st2.countTokens();
                if (nRowCount > nColCount) {
                    attStr = rows;
                    layoutManager.setOrientation(1);
                } else {
                    attStr = cols;
                    layoutManager.setOrientation(0);
                }
            }
        } else if (cols != null) {
            attStr = cols;
            layoutManager.setOrientation(0);
        } else if (rows != null) {
            attStr = rows;
            layoutManager.setOrientation(1);
        }
        if (attStr != null) {
            this.parseAttributes(attStr);
        } else {
            layoutManager.setOrientation(0);
            this.m_constraints = new FrameConstraint[this.m_framesetChildren.length];
            i = 0;
            while (i < this.m_framesetChildren.length) {
                this.m_constraints[i] = new FrameConstraint();
                this.m_constraints[i].percent = i == 0 ? 1.0f : 0.0f;
                ++i;
            }
        }
        this.m_panel.setLayout(layoutManager);
        i = 0;
        while (i < this.m_framesetChildren.length) {
            layoutManager.setConstraints(this.m_framesetChildren[i], this.m_constraints[i]);
            this.m_panel.add(this.m_framesetChildren[i]);
            if (bAddSplitterBars && i != this.m_framesetChildren.length - 1 && this.m_framesetChildren.length > 1) {
                FrameSplitterBar splitbar = new FrameSplitterBar(this.m_orientation);
                splitbar.setResizable(true);
                this.m_panel.add(splitbar);
            }
            ++i;
        }
        if (this.m_nFrames > 0 && (w = this.m_container.getHTMLWindow()) != null) {
            w.enableScrolling(false);
        }
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        if (!this.m_container.getFramesEnabled()) {
            this.m_bounds.setBounds(0, 0, 0, 0);
            return this.m_bounds;
        }
        Dimension d = this.m_container.getBrowserDimension();
        this.m_bounds.setBounds(x, y, width, d.height);
        this.m_panel.setBounds(this.m_bounds);
        return this.m_bounds;
    }

    protected void makeChildren(ViewFactory factory) {
    }

    public void paint(Graphics g, Shape alloc) {
        this.m_panel.invalidate();
    }

    void parseAttributes(String attStr) {
        if (attStr != null) {
            StringTokenizer st = new StringTokenizer(attStr, ",");
            int nToks = st.countTokens();
            this.m_constraints = new FrameConstraint[nToks];
            if (nToks > 0) {
                int i = 0;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    this.m_constraints[i] = new FrameConstraint();
                    Integer val = null;
                    val = Utilities.parseInteger(token, '%');
                    if (val != null) {
                        this.m_constraints[i].type = 1;
                        this.m_constraints[i].percent = (float)val.intValue() / 100.0f;
                    } else {
                        val = this.parseWildCard(token);
                        if (val != null) {
                            this.m_constraints[i].type = 2;
                            this.m_constraints[i].wildcard = val;
                        } else {
                            val = Utilities.getInteger(token);
                            this.m_constraints[i].type = 0;
                            this.m_constraints[i].pixels = val;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    Integer parseWildCard(String token) {
        Integer val = null;
        int idx = token.indexOf(42);
        if (idx != -1) {
            try {
                token = token.substring(0, idx).trim();
                val = new Integer(token);
            }
            catch (NumberFormatException numberFormatException) {
                return new Integer(1);
            }
        }
        return val;
    }
}

