/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.FrameSetPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class FrameSplitterBar
extends JPanel
implements MouseListener {
    static final int SPLITTER_WIDTH = 3;
    private int m_orientation = 0;
    private Window m_newPositionBar;
    private boolean m_bResizable = true;
    private int m_size = 3;

    public FrameSplitterBar(int orientation) {
        this.m_orientation = orientation;
        this.setBackground(UIManager.getColor("control"));
        this.setCursor(Cursor.getPredefinedCursor(11));
        this.enableEvents(48L);
        this.addMouseListener(this);
    }

    public int getBarSize() {
        return this.m_size;
    }

    Window getTraceWindow() {
        if (this.m_newPositionBar == null) {
            Container c = this;
            while (!((c = c.getParent()) instanceof Frame)) {
            }
            this.m_newPositionBar = c != null ? new Window((Frame)c) : new Window(new Frame());
            ((Component)this.m_newPositionBar).setBackground(Color.yellow);
        }
        return this.m_newPositionBar;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.m_bResizable) {
            return;
        }
        if (this.m_orientation == 0) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(8));
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.m_bResizable) {
            return;
        }
        if (this.m_newPositionBar != null) {
            int yPos;
            int xPos;
            FrameSplitterBar topBar = null;
            FrameSplitterBar leftBar = null;
            FrameSplitterBar rightBar = null;
            FrameSplitterBar bottomBar = null;
            Rectangle splitterBounds = this.getBounds();
            Container parent = this.getParent();
            Dimension parentDim = parent.getSize();
            Insets parentInsets = parent.getInsets();
            Point parentPos = parent.getLocationOnScreen();
            if (parent instanceof FrameSetPanel) {
                leftBar = ((FrameSetPanel)parent).getLeftSplitBar(this);
                rightBar = ((FrameSetPanel)parent).getRightSplitBar(this);
                topBar = leftBar;
                bottomBar = rightBar;
            }
            if (this.m_orientation == 0) {
                xPos = this.getLocationOnScreen().x + evt.getX();
                if (leftBar != null) {
                    Point leftPt = leftBar.getLocationOnScreen();
                    if (xPos <= leftPt.x + 3) {
                        xPos = leftPt.x + 3 + 1;
                    }
                }
                if (rightBar != null) {
                    Point rightPt = rightBar.getLocationOnScreen();
                    if (xPos >= rightPt.x) {
                        xPos = rightPt.x - 3;
                    }
                }
                if (xPos < parentPos.x + parentInsets.left) {
                    xPos = parentPos.x + parentInsets.left;
                } else if (xPos > parentPos.x + parentDim.width - splitterBounds.width) {
                    xPos = parentPos.x + parentDim.width - splitterBounds.width;
                }
                xPos -= parentPos.x;
                yPos = this.getBounds().y;
            } else {
                yPos = this.getLocationOnScreen().y + evt.getY();
                if (topBar != null) {
                    Point topPt = topBar.getLocationOnScreen();
                    if (yPos <= topPt.y + 3) {
                        yPos = topPt.y + 3 + 1;
                    }
                }
                if (bottomBar != null) {
                    Point bottomPt = bottomBar.getLocationOnScreen();
                    if (yPos >= bottomPt.y) {
                        yPos = bottomPt.y - 3;
                    }
                }
                if (yPos < parentPos.y + parentInsets.top) {
                    yPos = parentPos.y + parentInsets.top;
                } else if (yPos > parentPos.y + parentDim.height - splitterBounds.height) {
                    yPos = parentPos.y + parentDim.height - splitterBounds.height;
                }
                yPos -= parentPos.y;
                xPos = this.getBounds().x;
            }
            this.setBounds(xPos, yPos, splitterBounds.width, splitterBounds.height);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.m_newPositionBar.dispose();
            this.m_newPositionBar = null;
            this.invalidate();
            parent.invalidate();
            parent.validate();
        }
    }

    protected void processMouseMotionEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (!this.m_bResizable) {
            return;
        }
        Rectangle splitterBounds = this.getBounds();
        Container parent = this.getParent();
        Dimension parentDim = parent.getSize();
        Insets parentInsets = parent.getInsets();
        Point parentPos = parent.getLocationOnScreen();
        FrameSplitterBar leftBar = null;
        FrameSplitterBar rightBar = null;
        FrameSplitterBar topBar = null;
        FrameSplitterBar bottomBar = null;
        if (parent instanceof FrameSetPanel) {
            leftBar = ((FrameSetPanel)parent).getLeftSplitBar(this);
            rightBar = ((FrameSetPanel)parent).getRightSplitBar(this);
            topBar = leftBar;
            bottomBar = rightBar;
        }
        if (evt.getID() == 506) {
            Window w = this.getTraceWindow();
            if (this.m_orientation == 0) {
                int xPos = this.getLocationOnScreen().x + evt.getX();
                int yPos = this.getLocationOnScreen().y;
                if (leftBar != null) {
                    Point leftPt = leftBar.getLocationOnScreen();
                    if (xPos <= leftPt.x + 3) {
                        xPos = leftPt.x + 3;
                    }
                }
                if (rightBar != null) {
                    Point rightPt = rightBar.getLocationOnScreen();
                    if (xPos >= rightPt.x) {
                        xPos = rightPt.x - 3;
                    }
                }
                if (xPos < parentPos.x + parentInsets.left) {
                    xPos = parentPos.x + parentInsets.left;
                } else if (xPos > parentPos.x + parentDim.width - splitterBounds.width) {
                    xPos = parentPos.x + parentDim.width - splitterBounds.width;
                }
                ((Component)w).setBounds(xPos, yPos, splitterBounds.width, splitterBounds.height);
            } else {
                int xPos = this.getLocationOnScreen().x;
                int yPos = this.getLocationOnScreen().y + evt.getY();
                if (topBar != null) {
                    Point topPt = topBar.getLocationOnScreen();
                    if (yPos <= topPt.y + 3) {
                        yPos = topPt.y + 3 + 1;
                    }
                }
                if (bottomBar != null) {
                    Point bottomPt = bottomBar.getLocationOnScreen();
                    if (yPos >= bottomPt.y) {
                        yPos = bottomPt.y - 3;
                    }
                }
                if (yPos < parentPos.y + parentInsets.top) {
                    yPos = parentPos.y + parentInsets.top;
                } else if (yPos > parentPos.y + parentDim.height - 3) {
                    yPos = parentPos.y + parentDim.height - 3;
                }
                System.out.println("mousemove yPos =" + yPos);
                ((Component)w).setBounds(xPos, yPos, parentDim.width, 3);
            }
            if (!w.isVisible()) {
                ((Component)w).setVisible(true);
            }
        }
    }

    public void setBarSize(int sz) {
        this.m_size = sz;
    }

    void setOrientation(int orientation) {
        this.m_orientation = orientation;
    }

    void setResizable(boolean bResizable) {
        this.m_bResizable = bResizable;
        if (this.m_bResizable) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    void setSize(int width) {
        this.m_size = width;
    }
}

