/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.ElementViewInfo;
import horst.FrameSetPanel;
import horst.HTMLDocument;
import horst.HTMLPanePreferences;
import horst.HTMLPaneProperties;
import horst.HTMLPaneStatusEvent;
import horst.HTMLPaneStatusListener;
import horst.HTMLWindow;
import horst.LayoutInfo;
import horst.LinkEvent;
import horst.LinkListener;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import horst.parser.HTMLParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class HTMLPane
extends JPanel
implements Scrollable,
MouseMotionListener,
LinkListener {
    protected int PRINTING_MARGIN;
    protected HTMLDocument m_document;
    protected HTMLParser m_parser;
    protected LayoutInfo m_layoutInfo = new LayoutInfo();
    protected View m_rootView;
    protected ViewFactory m_viewFactory;
    protected boolean m_bParsing = false;
    protected HTMLPaneProperties m_props = new HTMLPaneProperties();
    protected HTMLPanePreferences m_preferences = new HTMLPanePreferences();
    protected int m_lastLayoutWidth = -1;
    protected int m_lastLayoutHeight = -1;
    protected boolean m_bContainsFrames = false;
    protected Thread m_parsingThread;
    protected ToolTip m_toolTip;
    protected boolean m_bPrinting = false;
    private static PrintWriter pwOut;
    private static int indent;

    public HTMLPane() {
        Utilities.initSystemProperties();
        this.m_document = this.createDocument();
        this.m_parser = new HTMLParser();
        this.m_toolTip = new ToolTip("horst");
        this.m_viewFactory = new ViewFactory();
        this.enableEvents(433L);
        this.setBackground(Color.white);
        this.setLayout(null);
    }

    protected void addFloater(View v) {
        this.m_props.m_floaters.addElement(v);
    }

    public void addLinkListener(LinkListener l) {
        this.m_props.m_linkListeners.addElement(l);
    }

    public void addStatusListener(HTMLPaneStatusListener l) {
        this.m_props.m_statusListeners.addElement(l);
    }

    public void back() {
        URL u = this.m_props.m_history.back();
        if (u != null) {
            this.loadPage(u, false);
        }
    }

    protected boolean beginParsing(Reader r, URL baseURL) {
        this.unLoadPage();
        this.m_document = this.createDocument();
        if (this.m_props.m_bIsIFrame || this.m_props.m_bIsFrame) {
            this.m_document.m_bPrintTree = false;
        }
        this.m_parser.setCallback(this.m_document);
        try {
            this.m_parser.parse(r, baseURL);
            this.m_document.m_baseURL = baseURL;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            JOptionPane.showMessageDialog(null, "IOException occurred while parsing!", "Error", 0);
            this.notifyStatusListeners(9, "");
            return false;
        }
        return true;
    }

    protected boolean beginParsing(URLConnection con) {
        this.unLoadPage();
        this.m_document = this.createDocument();
        this.m_parser.setCallback(this.m_document);
        try {
            this.m_parser.parse(con);
        }
        catch (IOException e) {
            System.out.println("Parser threw an IOException: " + e);
            String s = "";
            URL u = this.m_document.getURL();
            if (u != null) {
                s = u.toString();
            }
            this.notifyStatusListeners(9, u);
            return false;
        }
        return true;
    }

    public boolean canMoveBack() {
        return this.m_props.m_history.canMoveBack();
    }

    public boolean canMoveForward() {
        return this.m_props.m_history.canMoveForward();
    }

    private void cleanup() {
        this.m_lastLayoutWidth = -1;
        this.m_lastLayoutHeight = -1;
        this.m_bContainsFrames = false;
        if (!this.m_props.m_bIsFrame && !this.m_props.m_bIsIFrame) {
            this.getHTMLWindow().enableScrolling(true);
        }
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] instanceof HTMLWindow) {
                ((HTMLWindow)comps[i]).getHTMLPane().removeLinkListener(this);
            }
            ++i;
        }
    }

    protected void clearFocusElement() {
        this.notifyMouseOverLink(null);
        if (this.m_props.m_focusElement != null) {
            this.m_props.m_focusElement.propagateFocus(false);
            this.m_props.m_focusElement = null;
        }
        this.repaint();
    }

    public static void closeLog() {
        if (pwOut != null) {
            pwOut.close();
            pwOut = null;
        }
    }

    protected HTMLDocument createDocument() {
        return new HTMLDocument(this);
    }

    protected HTMLWindow createHTMLWindowFrame() {
        HTMLWindow wnd = new HTMLWindow();
        HTMLPane p = wnd.getHTMLPane();
        p.setLoadApplets(this.m_preferences.m_bLoadApplets);
        p.setLoadImages(this.m_preferences.m_bLoadImages);
        p.setProgressiveDisplay(this.m_preferences.m_bProgressiveDisplay);
        p.setFramesEnabled(this.m_preferences.m_bFramesEnabled);
        return wnd;
    }

    private LinkEvent createLinkEvent(ModelInfo info) {
        if (info != null) {
            Element elem = null;
            if (info.m_ev != null) {
                elem = info.m_ev.m_elem;
            }
            String href = null;
            URL u = info.getURL();
            href = u != null ? u.toString() : info.m_href;
            LinkEvent evt = new LinkEvent(this, 0);
            evt.m_href = href;
            evt.m_elem = elem;
            return evt;
        }
        return null;
    }

    protected void createViews(Element root) {
        this.cleanup();
        this.m_props.m_rootElement = root;
        this.m_rootView = this.m_viewFactory.createView(null, this.m_props.m_rootElement, this);
        if (this.m_rootView != null) {
            this.m_rootView.makeChildren(this.m_viewFactory);
            this.notifyStatusListeners(3, this.m_document.getURL());
            this.m_rootView.loadResources();
            this.notifyStatusListeners(9, this.m_document.getURL());
        }
    }

    public View elementToView(Element e) {
        if (this.m_rootView != null && e != null) {
            return this.m_rootView.elementToView(e);
        }
        return null;
    }

    public void enableDebugMessages(boolean bEnable) {
        Utilities.m_bDebugging = bEnable;
    }

    public void enableToolTips(boolean bEnable) {
        this.m_preferences.m_bShowToolTip = bEnable;
    }

    private int findFocusElement(Element[] anchors) {
        int idx = -1;
        int i = 0;
        i = 0;
        while (i < anchors.length) {
            Element elem = anchors[i];
            if (this.m_props.m_focusElement == elem || this.m_props.m_focusElement != null && this.m_props.m_focusElement.getType() == 50 && elem == this.m_props.m_focusElement) break;
            ++i;
        }
        if (i < anchors.length) {
            idx = i;
        }
        return idx;
    }

    int findText(String text, int lastPos) {
        int pos = -1;
        if (this.m_document != null && this.m_rootView != null) {
            int idx;
            StringBuffer buffer = this.m_document.getTextBuffer();
            String str = buffer.toString().toLowerCase();
            text = text.toLowerCase();
            int save = 0;
            if (lastPos >= 0) {
                save = lastPos + text.length();
                str = str.substring(save, str.length());
            }
            if ((idx = str.indexOf(text)) != -1) {
                pos = save + idx;
            }
        }
        return pos;
    }

    protected ElementViewInfo floaterHitTest(int x, int y) {
        ElementViewInfo info = null;
        Enumeration e = this.m_props.m_floaters.elements();
        while (e.hasMoreElements()) {
            info = ((View)e.nextElement()).viewToModel(x, y);
            if (info != null) break;
        }
        return info;
    }

    public void forceLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            JViewport vp = this.getViewport();
            if (vp != null) {
                this.m_lastLayoutWidth = -1;
                this.m_lastLayoutHeight = -1;
                Container parent = this.getParent();
                while (parent != null && !(parent instanceof JScrollPane)) {
                    parent = parent.getParent();
                }
                if (parent != null) {
                    vp.invalidate();
                    ((Component)parent).validate();
                }
            } else {
                Container parent = this.getParent();
                if (parent != null && parent.getSize().width > 0) {
                    this.layoutViews(parent.getSize().width, false);
                }
            }
        }
    }

    public void forward() {
        URL u = this.m_props.m_history.forward();
        if (u != null) {
            this.loadPage(u, false);
        }
    }

    protected Dimension getBrowserDimension() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            return ((JViewport)parent).getExtentSize();
        }
        return new Dimension(700, 700);
    }

    public HTMLDocument getDocument() {
        return this.m_document;
    }

    protected View[] getFloaters() {
        Object[] floats = new View[this.m_props.m_floaters.size()];
        this.m_props.m_floaters.copyInto(floats);
        return floats;
    }

    public boolean getFramesEnabled() {
        return this.m_preferences.m_bFramesEnabled;
    }

    protected HTMLWindow getHTMLWindow() {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof HTMLWindow) {
                return (HTMLWindow)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public boolean getIFramesEnabled() {
        return this.m_preferences.m_bIFramesEnabled;
    }

    protected ModelInfo getModelInfo(int x, int y) {
        ModelInfo info = new ModelInfo();
        if (this.m_rootView != null) {
            String href;
            info.m_ev = this.floaterHitTest(x, y);
            if (info.m_ev == null) {
                info.m_ev = this.m_rootView.viewToModel(x, y);
            }
            if (info.m_ev != null && info.m_ev.m_view.isLink() && (href = (String)info.m_ev.m_elem.getAttribute("href")) != null) {
                Element baseElem;
                info.m_href = href;
                info.m_target = (String)info.m_ev.m_elem.getAttribute("target");
                if (info.m_target == null && (baseElem = this.m_document.getBaseElement()) != null) {
                    info.m_target = (String)baseElem.getAttribute("target");
                }
            }
        }
        return info;
    }

    public int getNumPages(int pgWidth, int pgHeight) {
        int nPages = this.paginate(pgWidth -= 2 * this.PRINTING_MARGIN, pgHeight -= 2 * this.PRINTING_MARGIN);
        this.m_layoutInfo.bPaginate = false;
        this.forceLayout();
        return nPages;
    }

    public int getPageHeight() {
        if (this.m_rootView != null) {
            return this.m_rootView.getBounds().height;
        }
        return 0;
    }

    public Image getPageImage(int pgNum, int pgWidth, int pgHeight) {
        if (this.m_rootView == null) {
            return null;
        }
        Object img = null;
        int nPages = this.paginate(pgWidth -= 2 * this.PRINTING_MARGIN, pgHeight -= 2 * this.PRINTING_MARGIN);
        Rectangle b = this.m_rootView.getBounds();
        Frame frame = Utilities.getFrame(this);
        Image offscreen = frame.createImage(b.width + 2 * this.PRINTING_MARGIN, this.m_layoutInfo.pageHeight + 2 * this.PRINTING_MARGIN);
        Graphics og = offscreen.getGraphics();
        og.setColor(this.getBackground());
        og.fillRect(0, 0, offscreen.getWidth(null), offscreen.getHeight(null));
        og.setClip(0, 0, b.width, this.m_layoutInfo.pageHeight);
        int y = (pgNum - 1) * (this.m_layoutInfo.pageHeight + this.m_layoutInfo.pageBreakHeight);
        og.translate(this.PRINTING_MARGIN, -y + this.PRINTING_MARGIN);
        this.renderPage(og);
        this.m_layoutInfo.bPaginate = false;
        this.forceLayout();
        return offscreen;
    }

    public int getPageWidth() {
        if (this.m_rootView != null) {
            return this.m_rootView.getBounds().width;
        }
        return 0;
    }

    protected int getPaneHeight() {
        JViewport jp = this.getViewport();
        if (jp != null) {
            return jp.getExtentSize().height;
        }
        return 600;
    }

    protected int getPaneWidth() {
        JViewport jp = this.getViewport();
        if (jp != null) {
            return jp.getExtentSize().width;
        }
        return 600;
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.m_rootView != null) {
            return new Dimension(this.getPageWidth(), this.getPageHeight());
        }
        return new Dimension(2000, 2000);
    }

    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Element root;
            int portWidth = this.getPaneWidth();
            int portHeight = this.getPaneHeight();
            if (this.m_rootView == null && this.m_document != null && (root = this.m_document.getRootElement()) != null) {
                this.createViews(root);
            }
            if (this.m_rootView == null) {
                Dimension dimension = new Dimension(portWidth, portHeight);
                Object var3_7 = null;
                return dimension;
            }
            if (this.m_lastLayoutWidth != portWidth || this.m_bContainsFrames && this.m_lastLayoutHeight != portHeight) {
                this.layoutViews(portWidth, false);
            }
            Dimension dimension = new Dimension(this.m_rootView.getBounds().width, this.m_rootView.getBounds().height);
            Object var3_8 = null;
            return dimension;
        }
    }

    public int getPrintingMargin() {
        return this.PRINTING_MARGIN;
    }

    public boolean getProgressiveDisplay() {
        return this.m_preferences.m_bProgressiveDisplay;
    }

    protected Element getRootElement() {
        return this.m_props.m_rootElement;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public File getSourceFile(String path) {
        File f = null;
        if (this.m_props.m_loadedPage != null) {
            HTMLParser parser = new HTMLParser();
            f = parser.getSourceFile(this.m_props.m_loadedPage, path);
        }
        return f;
    }

    protected JViewport getViewport() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            return (JViewport)parent;
        }
        return null;
    }

    private void handleTabKey(KeyEvent e) {
        Element[] anchors = this.m_document.getAnchors();
        boolean bUp = (e.getModifiers() & 1) != 0;
        int idx = this.findFocusElement(anchors);
        if (idx == -1) {
            if (!bUp && anchors.length > 0) {
                this.setAnchorFocus(anchors[0]);
            }
        } else if (bUp && idx > 0) {
            this.setAnchorFocus(anchors[idx - 1]);
        } else if (!bUp && idx < anchors.length - 1) {
            this.setAnchorFocus(anchors[idx + 1]);
        } else {
            this.clearFocusElement();
        }
        if (this.m_props.m_focusElement != null) {
            this.scrollToVisible(this.m_props.m_focusElement.m_p0);
        }
        e.consume();
    }

    protected void imageMapHitTest(MouseEvent evt, ModelInfo info) {
        if (info.m_ev.m_elem.getType() == 11 && (info.m_ev.m_elem.isAttributeDefined("ismap") || info.m_ev.m_elem.isAttributeDefined("usemap"))) {
            int x = evt.getX() - (info.m_ev.m_view.getBounds().x + info.m_ev.m_view.m_insets.left);
            int y = evt.getY() - (info.m_ev.m_view.getBounds().y + info.m_ev.m_view.m_insets.top);
            String mapName = (String)info.m_ev.m_elem.getAttribute("usemap");
            if (mapName != null && mapName.length() > 0) {
                while (mapName.charAt(0) == '#' && mapName.length() > 1) {
                    mapName = mapName.substring(1);
                }
                Enumeration e1 = this.m_document.getMapElements();
                while (e1.hasMoreElements()) {
                    Element mapElem = (Element)e1.nextElement();
                    String name = (String)mapElem.getAttribute("name");
                    if (name == null || !name.equalsIgnoreCase(mapName)) continue;
                    Enumeration e = mapElem.getChildren().elements();
                    while (e.hasMoreElements()) {
                        Shape s;
                        Element areaElem = (Element)e.nextElement();
                        if (areaElem.getType() != 50 || !areaElem.isAttributeDefined("href")) continue;
                        String shapeName = (String)areaElem.getAttribute("shape");
                        String coordinates = (String)areaElem.getAttribute("coords");
                        if (coordinates == null || (s = Utilities.createShape(shapeName, coordinates)) == null || !s.getBounds().contains(x, y)) continue;
                        info.m_href = (String)areaElem.getAttribute("href");
                        info.m_target = (String)areaElem.getAttribute("target");
                        return;
                    }
                    break;
                }
            } else {
                String href = (String)info.m_ev.m_elem.getAttribute("href");
                if (href != null) {
                    String params = "?" + x + "," + y;
                    info.m_href = String.valueOf(href) + params;
                }
            }
        }
    }

    public boolean isPaginated() {
        return this.m_layoutInfo.bPaginate;
    }

    protected boolean isTextSelected() {
        if (this.m_document != null) {
            return this.m_document.isTextSelected();
        }
        return false;
    }

    protected Rectangle layoutViews(int width, boolean bPrinting) {
        if (this.m_rootView == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.notifyStatusListeners(2, this.m_props.m_loadedPage);
        this.m_layoutInfo.clear();
        this.m_props.m_floaters.removeAllElements();
        this.m_document.resetElements();
        this.m_rootView.reset();
        this.m_rootView.layout(0, 0, width, this.m_layoutInfo);
        if (!bPrinting) {
            int paneHeight = this.getPaneHeight();
            this.m_rootView.setDimensions(this.getPaneWidth(), paneHeight);
            this.m_lastLayoutWidth = width;
            this.m_lastLayoutHeight = paneHeight;
        }
        this.notifyStatusListeners(9, this.m_props.m_loadedPage);
        return this.m_rootView.getBounds();
    }

    protected void loadImageContent(URL u) {
        this.m_document = this.createDocument();
        this.m_props.m_rootElement = new Element(11);
        this.m_props.m_rootElement.setDocument(this.m_document);
        this.m_props.m_rootElement.setAttribute("src", u.toString());
        this.m_props.m_rootElement.setAttribute("imagecontent", "true");
        this.m_props.m_loadedPage = u;
        this.createViews(this.m_props.m_rootElement);
        this.forceLayout();
        this.notifyStatusListeners(5, this.m_props.m_loadedPage);
    }

    protected synchronized void loadPage(Reader r, URL baseURL, boolean bAddToHistory) {
        ((Component)this.m_toolTip).hide();
        this.m_bParsing = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_parsingThread = new Thread(new ParsingThread(r, baseURL, bAddToHistory));
        this.m_parsingThread.start();
    }

    protected synchronized void loadPage(URL url, boolean bAddToHistory) {
        String urlStr;
        int idx;
        if (this.m_document != null && (idx = (urlStr = url.toString()).indexOf("#")) != -1) {
            Element e;
            String anchorName = urlStr.substring(idx + 1);
            urlStr = urlStr.substring(0, idx);
            URL newURL = Utilities.getURL(urlStr);
            if (this.m_props.m_loadedPage != null && this.m_props.m_loadedPage.equals(newURL) && (e = this.m_document.getAnchor(anchorName)) != null && e.m_p0 >= 0) {
                this.m_props.m_loadedPage = url;
                this.scrollToPosition(e.m_p0);
                this.notifyStatusListeners(5, this.m_props.m_loadedPage);
                return;
            }
        }
        ((Component)this.m_toolTip).hide();
        this.m_bParsing = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_parsingThread = new Thread(new ParsingThread(url, bAddToHistory));
        this.m_parsingThread.start();
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof Component) {
            Component c = (Component)src;
            e.translatePoint(c.getBounds().x, c.getBounds().y);
            this.processMouseMotionEvent(e);
        }
    }

    public void mouseOverLink(LinkEvent evt) {
        if (evt != null) {
            Enumeration e = this.m_props.m_linkListeners.elements();
            while (e.hasMoreElements()) {
                LinkListener l = (LinkListener)e.nextElement();
                l.mouseOverLink(evt);
            }
        }
    }

    public boolean mousePressedOverLink(LinkEvent evt) {
        if (evt != null) {
            Enumeration e = this.m_props.m_linkListeners.elements();
            while (e.hasMoreElements()) {
                LinkListener l = (LinkListener)e.nextElement();
                boolean bLoad = l.mousePressedOverLink(evt);
                if (bLoad) continue;
                return false;
            }
        }
        return true;
    }

    protected void notifyMouseOverLink(ModelInfo info) {
        LinkEvent evt = this.createLinkEvent(info);
        if (evt != null) {
            Enumeration e = this.m_props.m_linkListeners.elements();
            while (e.hasMoreElements()) {
                LinkListener l = (LinkListener)e.nextElement();
                l.mouseOverLink(evt);
            }
        }
    }

    protected boolean notifyMousePressedOverLink(ModelInfo info) {
        LinkEvent evt = this.createLinkEvent(info);
        if (evt != null) {
            Enumeration e = this.m_props.m_linkListeners.elements();
            while (e.hasMoreElements()) {
                LinkListener l = (LinkListener)e.nextElement();
                boolean bLoad = l.mousePressedOverLink(evt);
                if (bLoad) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean notifyStatusListeners(int val, Object info) {
        boolean retVal = true;
        Enumeration e = this.m_props.m_statusListeners.elements();
        while (e.hasMoreElements()) {
            HTMLPaneStatusEvent evt;
            HTMLPaneStatusListener l = (HTMLPaneStatusListener)e.nextElement();
            if (l.statusChanged(evt = new HTMLPaneStatusEvent((Object)this, val, info))) continue;
            retVal = false;
        }
        return retVal;
    }

    public void openPage(Reader r, URL baseURL) {
        if (r != null) {
            this.loadPage(r, baseURL, true);
        }
    }

    public void openPage(URL u) {
        if (u != null) {
            this.loadPage(u, true);
        }
    }

    public int paginate(int pgWidth, int pgHeight) {
        int nPages = 1;
        if (this.m_rootView != null) {
            this.notifyStatusListeners(2, this.m_props.m_loadedPage);
            this.m_layoutInfo.clear();
            this.m_layoutInfo.bPaginate = true;
            this.m_layoutInfo.pageHeight = pgHeight;
            this.m_layoutInfo.pageWidth = pgWidth;
            this.m_props.m_floaters.removeAllElements();
            this.m_document.resetElements();
            this.m_rootView.reset();
            Rectangle b = this.m_rootView.layout(0, 0, pgWidth, this.m_layoutInfo);
            int start = this.m_layoutInfo.pageHeight;
            int end = start + this.m_layoutInfo.pageBreakHeight;
            while (start < b.y + b.height) {
                ++nPages;
                start = end + this.m_layoutInfo.pageHeight;
                end = start + this.m_layoutInfo.pageBreakHeight;
            }
            this.repaint();
        }
        return nPages;
    }

    public void paint(Graphics g) {
        Dimension dim = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dim.width, dim.height);
        if (this.m_rootView != null) {
            Rectangle alloc = g.getClipRect();
            if (alloc == null) {
                JViewport jp = this.getViewport();
                alloc = jp != null ? jp.getViewRect() : new Rectangle(0, 0, dim.width, dim.height);
                g.setClip(alloc);
            }
            this.m_rootView.paint(g, alloc);
            int sz = this.m_props.m_floaters.size();
            int i = sz - 1;
            while (i >= 0) {
                View v = (View)this.m_props.m_floaters.elementAt(i);
                Rectangle r = v.getBounds();
                if (r != null) {
                    v.paint(g, r);
                }
                --i;
            }
            this.paintFocusBoxes(g, alloc);
        }
        this.paintChildren(g);
        if (this.m_layoutInfo.bPaginate) {
            Rectangle b = this.m_rootView.getBounds();
            int start = this.m_layoutInfo.pageHeight;
            int end = start + this.m_layoutInfo.pageBreakHeight;
            int nPage = 1;
            while (start < b.y + b.height) {
                g.setColor(Color.blue);
                g.drawString("Y = " + start, 20, start);
                g.drawLine(0, start, 800, start);
                g.drawString("Y = " + end + " Page " + nPage++, 20, end);
                g.drawLine(0, end, 800, end);
                start = end + this.m_layoutInfo.pageHeight;
                end = start + this.m_layoutInfo.pageBreakHeight;
            }
            g.setColor(Color.blue);
            g.drawLine(this.m_layoutInfo.pageWidth, 0, this.m_layoutInfo.pageWidth, 2000);
        }
    }

    void paintFocusBoxes(Graphics g, Shape alloc) {
        this.m_rootView.paintFocusBox(g, alloc);
        Enumeration e = this.m_props.m_floaters.elements();
        while (e.hasMoreElements()) {
            View v = (View)e.nextElement();
            Rectangle r = v.getBounds();
            if (r == null) continue;
            v.paintFocusBox(g, r);
        }
        Enumeration e2 = this.m_document.getAnchorsEnumeration();
        while (e2.hasMoreElements()) {
            Shape s;
            View vw;
            Element imgElem;
            String mapName;
            Element mapElem;
            Element elem = (Element)e2.nextElement();
            if (elem.getType() != 50 || !elem.getDrawFocusBox() || (mapElem = this.m_document.getMapElement(elem)) == null || (mapName = (String)mapElem.getAttribute("name")) == null || (imgElem = this.m_document.findElement(11, "usemap", mapName = "#" + mapName)) == null || (vw = this.m_rootView.elementToView(imgElem)) == null) continue;
            String shapeName = (String)elem.getAttribute("shape");
            String coordinates = (String)elem.getAttribute("coords");
            if (coordinates == null || (s = Utilities.createShape(shapeName, coordinates)) == null) continue;
            Rectangle r = s.getBounds();
            r.x += vw.getBounds().x;
            r.y += vw.getBounds().y;
            Utilities.drawFocusBorder(g, r);
        }
    }

    private void printViewTree(View v, int index) {
        String indent = "";
        int i = 0;
        while (i < index) {
            indent = String.valueOf(indent) + ' ';
            ++i;
        }
        String name = v.getClass().getName();
        HTMLPane.toLog(String.valueOf(indent) + name, 0);
        index += 2;
        int cnt = v.m_children.length;
        int i2 = 0;
        while (i2 < cnt) {
            this.printViewTree(v.m_children[i2], index);
            ++i2;
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this.m_rootView == null) {
            return;
        }
        if (e.getID() == 401 && e.getKeyCode() == 9) {
            this.handleTabKey(e);
        } else if (e.getID() == 401 && e.getKeyCode() == 40) {
            this.scrollScreen(true);
        } else if (e.getID() == 401 && e.getKeyCode() == 38) {
            this.scrollScreen(false);
        } else if (e.getID() == 401 && e.getKeyCode() == 36 && (e.getModifiers() & 2) != 0) {
            this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        } else if (e.getID() == 401 && e.getKeyCode() == 35 && (e.getModifiers() & 2) != 0) {
            this.scrollRectToVisible(new Rectangle(0, this.m_rootView.getBounds().y + this.m_rootView.getBounds().height - 1, 1, 1));
        } else if (e.getID() == 401 && e.getKeyCode() == 10) {
            URL u;
            if (this.m_props.m_focusElement != null && this.m_props.m_focusElement.isLink() && (u = Utilities.getURL(this.m_document.getBaseURL(), (String)this.m_props.m_focusElement.getAttribute("href"))) != null) {
                this.loadPage(u, true);
            }
            e.consume();
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        if (this.m_document == null || this.m_bParsing) {
            return;
        }
        super.processMouseEvent(evt);
        int x = evt.getX();
        int y = evt.getY();
        if (evt.getID() == 501) {
            this.requestFocus();
        }
        if (evt.isPopupTrigger() && this.m_props.m_popup != null && this.m_props.m_loadedPage != null) {
            if (this.notifyStatusListeners(8, this.m_props.m_loadedPage)) {
                this.m_props.m_popup.show(this, x, y);
            }
        } else if (evt.getID() == 501 && (evt.getModifiers() & 0x10) > 0) {
            if (this.m_props.m_popup != null && this.m_props.m_popup.isShowing()) {
                this.m_props.m_popup.setVisible(false);
            }
            this.m_document.unSelectText();
            ModelInfo info = this.getModelInfo(x, y);
            if (info.m_ev != null && info.m_ev.m_elem != null) {
                this.m_document.m_selectedP0 = info.m_ev.m_elem.m_textbufferPosition;
            }
            this.clearFocusElement();
            if (info.m_href != null) {
                this.notifyMouseOverLink(info);
                this.m_props.m_focusElement = info.m_ev.m_elem;
                this.m_props.m_focusElement.propagateFocus(true);
            }
            this.repaint();
        } else if (evt.getID() == 502 && (evt.getModifiers() & 0x10) > 0) {
            ModelInfo info = this.getModelInfo(x, y);
            if (info.m_ev == null) {
                return;
            }
            this.imageMapHitTest(evt, info);
            if (info.m_href != null) {
                URL u = info.getURL();
                boolean bLoad = this.notifyMousePressedOverLink(info);
                if (bLoad && u != null && this.m_props.m_bIsFrame && this.m_props.m_framesetView != null && info.m_target != null) {
                    HTMLPane pane = this.m_props.m_framesetView.getFrame(info.m_target);
                    if (pane != null) {
                        pane.loadPage(u, false);
                        pane.repaint();
                        return;
                    }
                    Container parent = this.getParent();
                    while (parent != null) {
                        if (parent instanceof HTMLPane) {
                            ((HTMLPane)parent).loadPage(u, false);
                            return;
                        }
                        parent = parent.getParent();
                    }
                }
                if (bLoad && u != null) {
                    this.loadPage(u, true);
                }
            } else if (info.m_ev.m_elem != null && info.m_ev.m_elem.m_textbufferPosition != -1) {
                this.m_document.m_selectedP1 = info.m_ev.m_elem.m_textbufferPosition;
                if (this.m_document.m_selectedP0 > this.m_document.m_selectedP1) {
                    int temp = this.m_document.m_selectedP1;
                    this.m_document.m_selectedP1 = this.m_document.m_selectedP0;
                    this.m_document.m_selectedP0 = temp;
                }
                this.repaint();
            }
            this.clearFocusElement();
        }
    }

    protected void processMouseMotionEvent(MouseEvent evt) {
        String tipText;
        boolean bDragging;
        if (this.m_bParsing) {
            return;
        }
        super.processMouseMotionEvent(evt);
        ModelInfo info = this.getModelInfo(evt.getX(), evt.getY());
        if (info == null || info.m_ev == null || info.m_ev.m_elem == null || info.m_ev.m_view == null) {
            return;
        }
        this.imageMapHitTest(evt, info);
        boolean bl = bDragging = evt.getID() == 506 && (evt.getModifiers() & 0x10) > 0;
        if (bDragging && this.m_document != null && info.m_ev.m_elem.m_textbufferPosition != -1) {
            if (this.m_document.m_selectedP0 == -1) {
                this.m_document.m_selectedP0 = info.m_ev.m_elem.m_textbufferPosition;
            } else {
                this.m_document.m_selectedP1 = info.m_ev.m_elem.m_textbufferPosition;
            }
            if (this.m_document.isTextSelected()) {
                this.repaint();
            }
        }
        ((Component)this.m_toolTip).hide();
        if (this.m_preferences.m_bShowToolTip && (tipText = info.m_ev.m_view.getToolTipText()) != null && !Utilities.isBlankSpaces(tipText)) {
            Point p = this.getLocationOnScreen();
            this.m_toolTip.text = tipText;
            ((Component)this.m_toolTip).setLocation(p.x + evt.getX() + 15, p.y + evt.getY() + 15);
            this.m_toolTip.show();
        }
        if (info.m_ev.m_view.isLink()) {
            this.notifyMouseOverLink(info);
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (info.m_ev.m_elem.getType() == 9) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void reLoadPage() {
        if (this.m_props.m_loadedPage != null) {
            this.loadPage(this.m_props.m_loadedPage, false);
        }
    }

    public void refreshPage() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Element root = this.m_document.getRootElement();
            if (root != null) {
                this.createViews(root);
                this.forceLayout();
            }
        }
    }

    public void removeLinkListener(LinkListener l) {
        this.m_props.m_linkListeners.removeElement(l);
    }

    public void removePagination() {
        this.m_layoutInfo.bPaginate = false;
        this.forceLayout();
    }

    public void removeStatusListener(HTMLPaneStatusListener l) {
        this.m_props.m_statusListeners.removeElement(l);
    }

    void renderPage(Graphics g) {
        this.m_rootView.paint(g, g.getClipRect());
        try {
            this.paintChildren(g);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("IllegalArgumentException thrown by a Swing component");
            System.out.println("HTMLWindow Recovering...");
        }
        Enumeration e = this.m_props.m_floaters.elements();
        while (e.hasMoreElements()) {
            View v = (View)e.nextElement();
            Rectangle r = v.getBounds();
            if (r == null) continue;
            v.paint(g, r);
        }
    }

    private void scrollScreen(boolean bUp) {
        JViewport vp;
        HTMLWindow wnd;
        if (this.m_rootView != null && (wnd = this.getHTMLWindow()) != null && (vp = this.getViewport()) != null) {
            Dimension dim = vp.getExtentSize();
            Point p = vp.getViewPosition();
            int endY = this.m_rootView.getBounds().y + this.m_rootView.getBounds().height;
            int increment = dim.height / 10;
            if (bUp && p.y + dim.height < endY) {
                int newY = p.y + increment;
                if (newY > endY) {
                    newY = endY - dim.height;
                }
                wnd.scrollToYPosition(newY);
            } else if (!bUp && p.y > 0) {
                int newY = Math.max(0, p.y - increment);
                wnd.scrollToYPosition(newY);
            }
        }
    }

    private void scrollToPosition(int pos) {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof HTMLWindow) {
                ((HTMLWindow)parent).scrollToPosition(pos);
                return;
            }
            parent = parent.getParent();
        }
    }

    private void scrollToVisible(int pos) {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof HTMLWindow) {
                ((HTMLWindow)parent).scrollToVisible(pos);
                return;
            }
            parent = parent.getParent();
        }
    }

    public void selectText(int p0, int p1) {
        if (this.m_document != null) {
            this.m_document.selectText(p0, p1);
            this.repaint();
        }
    }

    private void setAnchorFocus(Element anchor) {
        this.clearFocusElement();
        if (anchor.getType() == 50) {
            this.m_props.m_focusElement = anchor;
            anchor.setDrawFocusBox(true);
        } else {
            this.m_props.m_focusElement = anchor;
            anchor.setDrawFocusBox(true);
            anchor.propagateDrawFocusBox(true);
        }
        this.repaint();
    }

    public void setDefaultFont(Font f) {
        if (f != null) {
            this.m_props.m_defaultFont = f;
        }
    }

    public void setFramesEnabled(boolean bEnable) {
        this.m_preferences.m_bFramesEnabled = bEnable;
    }

    public void setIFramesEnabled(boolean bEnable) {
        this.m_preferences.m_bIFramesEnabled = bEnable;
    }

    public void setLoadApplets(boolean bLoad) {
        this.m_preferences.m_bLoadApplets = bLoad;
    }

    public void setLoadImages(boolean bLoad) {
        this.m_preferences.m_bLoadImages = bLoad;
    }

    public void setMargins(int width, int height) {
        this.m_props.m_marginWidth = width;
        this.m_props.m_marginHeight = height;
    }

    public void setPopupMenu(JPopupMenu menu) {
        if (this.m_props.m_popup != null) {
            this.remove(this.m_props.m_popup);
        }
        this.m_props.m_popup = menu;
        this.add(this.m_props.m_popup);
    }

    public void setProgressiveDisplay(boolean bProgressive) {
        this.m_preferences.m_bProgressiveDisplay = bProgressive;
    }

    public void setResizableFrames(boolean bSizable) {
        this.m_preferences.m_bResizableFrames = bSizable;
    }

    public void setSize(Dimension d) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.m_rootView != null) {
                if (d.width != this.m_rootView.getBounds().width || this.m_bContainsFrames && this.m_lastLayoutHeight != this.getPaneHeight()) {
                    this.layoutViews(d.width, false);
                }
                super.setSize(this.m_rootView.getBounds().width, this.m_rootView.getBounds().height);
                Object var3_3 = null;
                return;
            }
            super.setSize(d);
        }
    }

    public void setViewFactory(ViewFactory factory) {
        this.m_viewFactory = factory;
    }

    public void stop() {
        if (this.m_parsingThread != null && this.m_parsingThread.isAlive()) {
            this.m_parsingThread.interrupt();
            this.m_parsingThread = null;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.notifyStatusListeners(9, this.m_props.m_loadedPage);
    }

    public void syncOpenPage(Reader r, URL baseURL) {
        Element root;
        if (this.beginParsing(r, baseURL) && this.m_document != null && (root = this.m_document.getRootElement()) != null) {
            Element elem;
            String urlStr;
            int idx;
            this.createViews(root);
            this.m_props.m_loadedPage = this.m_document.getURL();
            this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            if (this.m_props.m_loadedPage != null && (idx = (urlStr = this.m_props.m_loadedPage.toString()).indexOf("#")) != -1 && (elem = this.m_document.getAnchor(urlStr.substring(idx + 1))) != null && elem.m_p0 >= 0) {
                this.scrollToPosition(elem.m_p0);
            }
            this.forceLayout();
            this.notifyStatusListeners(5, this.m_props.m_loadedPage);
        }
    }

    public synchronized void syncOpenPage(URL u) throws IOException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ((Component)this.m_toolTip).hide();
        URLConnection con = u.openConnection();
        String contentType = con.getContentType();
        if (this.notifyStatusListeners(6, contentType)) {
            Element root;
            this.beginParsing(con);
            if (this.m_document != null && (root = this.m_document.getRootElement()) != null) {
                Element elem;
                String urlStr;
                int idx;
                this.createViews(root);
                this.m_props.m_loadedPage = this.m_document.getURL();
                this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                if (this.m_props.m_loadedPage != null && (idx = (urlStr = this.m_props.m_loadedPage.toString()).indexOf("#")) != -1 && (elem = this.m_document.getAnchor(urlStr.substring(idx + 1))) != null && elem.m_p0 >= 0) {
                    this.scrollToPosition(elem.m_p0);
                }
                this.forceLayout();
                this.notifyStatusListeners(5, this.m_props.m_loadedPage);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void toLog(String str, int nIndent) {
        if (pwOut == null) {
            try {
                String dir = System.getProperty("user.dir");
                FileOutputStream fOut = new FileOutputStream(String.valueOf(dir) + "\\viewtree.log");
                pwOut = new PrintWriter(fOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nIndent > 0) {
            indent += nIndent;
        }
        String identStr = "";
        int i = 0;
        while (i < indent) {
            identStr = String.valueOf(identStr) + " ";
            ++i;
        }
        pwOut.println(String.valueOf(identStr) + str);
        if (nIndent < 0) {
            indent += nIndent;
        }
    }

    public synchronized void unLoadPage() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.m_bContainsFrames) {
                Component[] comps = this.getComponents();
                int i = 0;
                while (i < comps.length) {
                    if (comps[i] instanceof FrameSetPanel) {
                        ((FrameSetPanel)comps[i]).unLoadFrames();
                    }
                    ++i;
                }
            }
            this.removeAll();
            if (this.m_document != null) {
                this.m_document.dereference();
                this.m_document = null;
            }
            if (this.m_rootView != null) {
                this.m_rootView.dereference();
                this.m_rootView = null;
            }
            Enumeration e = this.m_props.m_floaters.elements();
            while (e.hasMoreElements()) {
                ((View)e.nextElement()).dereference();
            }
            this.m_props.m_rootElement = null;
            this.m_props.m_focusElement = null;
            this.m_props.m_loadedPage = null;
            this.m_props.m_floaters.removeAllElements();
            this.m_props.m_loadedPage = null;
            this.m_parser.setCallback(null);
            this.m_parser.deleteStringBuffers();
            if (this.m_parsingThread != null) {
                this.m_parsingThread.interrupt();
                this.m_parsingThread = null;
            }
            System.gc();
        }
    }

    public Element viewToModel(int x, int y) {
        ElementViewInfo info = this.floaterHitTest(x, y);
        if (info != null) {
            return info.m_elem;
        }
        if (this.m_rootView != null && (info = this.m_rootView.viewToModel(x, y)) != null) {
            return info.m_elem;
        }
        return null;
    }

    class ModelInfo {
        String m_target;
        ElementViewInfo m_ev;
        String m_href;

        ModelInfo() {
            HTMLPane.this = HTMLPane.this;
        }

        URL getURL() {
            URL u = null;
            URL refURL = HTMLPane.this.m_document.getBaseURL();
            u = refURL != null ? Utilities.getURL(refURL, this.m_href) : Utilities.getURL(this.m_href);
            return u;
        }
    }

    class ToolTip
    extends Window {
        String text;

        ToolTip(String text) {
            super(new Frame());
            HTMLPane.this = HTMLPane.this;
            this.text = text;
            this.setForeground(SystemColor.textText);
            ((Component)this).setBackground(Color.yellow);
        }

        public Dimension getPreferredSize() {
            Graphics g = this.getGraphics();
            FontMetrics fm = g.getFontMetrics();
            return new Dimension(fm.stringWidth(this.text) + 4, fm.getHeight() + 4);
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            FontMetrics fm = g.getFontMetrics();
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            if (this.text.length() > 0) {
                g.drawString(this.text, 2, fm.getAscent() + 2);
            }
        }

        public void show() {
            this.pack();
            super.show();
        }
    }

    class ParsingThread
    implements Runnable {
        URL url;
        boolean bAddToHistory;
        Reader r;

        ParsingThread(Reader reader, URL baseURL, boolean bAddToHistory) {
            HTMLPane.this = HTMLPane.this;
            this.r = reader;
            this.url = baseURL;
            this.bAddToHistory = bAddToHistory;
        }

        ParsingThread(URL url, boolean bAddToHistory) {
            HTMLPane.this = HTMLPane.this;
            this.url = url;
            this.bAddToHistory = bAddToHistory;
        }

        public void run() {
            String contentType = "";
            if (this.r != null) {
                if (HTMLPane.this.beginParsing(this.r, this.url)) {
                    HTMLPane.this.unLoadPage();
                    if (this.bAddToHistory) {
                        HTMLPane.this.m_props.m_history.add(this.url);
                    }
                    SwingUtilities.invokeLater(new RenderingThread(this.r, this.url));
                }
                HTMLPane.this.m_bParsing = false;
                HTMLPane.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (this.url != null) {
                URLConnection con = null;
                try {
                    HTMLPane.this.notifyStatusListeners(0, this.url);
                    con = this.url.openConnection();
                    contentType = con.getContentType();
                }
                catch (IOException e) {
                    System.out.println("Exception : " + e.getMessage());
                    HTMLPane.this.m_bParsing = false;
                    return;
                }
                if (!HTMLPane.this.notifyStatusListeners(6, contentType)) {
                    HTMLPane.this.m_bParsing = false;
                    return;
                }
                if (contentType == null) {
                    contentType = "text/html";
                }
                contentType.trim();
                if ("image/jpeg".equals(contentType) || "image/gif".equals(contentType) || "image/jpg".equals(contentType)) {
                    HTMLPane.this.loadImageContent(this.url);
                } else if (contentType.startsWith("text/html") || contentType.startsWith("text/plain")) {
                    if (HTMLPane.this.beginParsing(con)) {
                        if (this.bAddToHistory) {
                            HTMLPane.this.m_props.m_history.add(this.url);
                        }
                        SwingUtilities.invokeLater(new RenderingThread(null));
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Invalid content type: " + contentType, "Error", 0);
                    HTMLPane.this.notifyStatusListeners(9, HTMLPane.this.m_document.getURL());
                }
                HTMLPane.this.m_bParsing = false;
            }
        }
    }

    class RenderingThread
    implements Runnable {
        URL u;
        Reader r;

        RenderingThread(Reader r, URL u) {
            HTMLPane.this = HTMLPane.this;
            this.r = r;
            this.u = u;
        }

        RenderingThread(URL u) {
            HTMLPane.this = HTMLPane.this;
            this.u = u;
        }

        public void run() {
            Object object = HTMLPane.this.getTreeLock();
            synchronized (object) {
                if (this.r == null && this.u != null) {
                    HTMLPane.this.loadImageContent(this.u);
                    HTMLPane.this.repaint();
                    Object var2_2 = null;
                    return;
                }
                HTMLPane.this.m_rootView = null;
                HTMLPane.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                HTMLPane.this.m_props.m_loadedPage = HTMLPane.this.m_document.getURL();
                if (HTMLPane.this.m_document.m_refreshURL != null) {
                    try {
                        HTMLPane.this.syncOpenPage(HTMLPane.this.m_document.m_refreshURL);
                    }
                    catch (IOException iOException) {}
                } else {
                    Element elem;
                    String urlStr;
                    int idx;
                    Element root = HTMLPane.this.m_document.getRootElement();
                    if (root != null) {
                        HTMLPane.this.createViews(root);
                        HTMLPane.this.forceLayout();
                    }
                    if (HTMLPane.this.m_props.m_loadedPage != null) {
                        HTMLPane.this.notifyStatusListeners(5, HTMLPane.this.m_props.m_loadedPage);
                    }
                    if (HTMLPane.this.m_props.m_loadedPage != null && (idx = (urlStr = HTMLPane.this.m_props.m_loadedPage.toString()).indexOf("#")) != -1 && (elem = HTMLPane.this.m_document.getAnchor(urlStr.substring(idx + 1))) != null && elem.m_p0 >= 0) {
                        HTMLPane.this.scrollToPosition(elem.m_p0);
                    }
                }
                HTMLPane.this.repaint();
            }
        }
    }
}

