/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.HTMLPane;
import horst.HTMLPaneStatusEvent;
import horst.HTMLPaneStatusListener;
import horst.View;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class HTMLWindow
extends JScrollPane
implements HTMLPaneStatusListener {
    protected HTMLPane m_renderer = this.createHTMLPane();
    protected String m_findText = "";
    protected int m_lastFindPos;

    public HTMLWindow() {
        this.setViewportView(this.m_renderer);
        this.setBackground(Color.white);
        this.getViewport().setBackingStoreEnabled(true);
    }

    protected HTMLPane createHTMLPane() {
        return new HTMLPane();
    }

    public void enableDoubleBuffering(boolean bBuffer) {
        this.getViewport().setBackingStoreEnabled(bBuffer);
    }

    public void enableScrolling(boolean bScrolling) {
        if (bScrolling) {
            this.setHorizontalScrollBarPolicy(30);
            this.setVerticalScrollBarPolicy(20);
        } else {
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
        }
    }

    public int find(String text) {
        int pos = this.m_renderer.findText(text, -1);
        if (pos > -1) {
            this.m_lastFindPos = pos;
            this.m_findText = text;
            this.highlightText(pos);
        }
        return pos;
    }

    public int findNext() {
        int pos = this.m_renderer.findText(this.m_findText, this.m_lastFindPos);
        if (pos > this.m_lastFindPos) {
            this.m_lastFindPos = pos;
            this.highlightText(pos);
        }
        return pos;
    }

    public HTMLPane getHTMLPane() {
        return this.m_renderer;
    }

    void hideBorder() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    protected void highlightText(int pos) {
        View v = this.m_renderer.m_rootView.modelToView(pos);
        if (v != null) {
            this.m_renderer.m_document.m_selectedP0 = pos;
            this.m_renderer.m_document.m_selectedP1 = pos + this.m_findText.length() - 1;
            Rectangle vb = v.getBounds();
            Rectangle vr = this.getViewport().getViewRect();
            if (vr.x <= vb.x && vr.y <= vb.y && vr.x + vr.width >= vb.x + vb.width && vr.y + vr.height >= vb.y + vb.height) {
                this.repaint();
            } else {
                this.scrollToPosition(pos);
            }
        }
    }

    public void scrollToPosition(int pos) {
        Rectangle r;
        View v = this.m_renderer.m_rootView.modelToView(pos);
        if (v != null && (r = v.getBounds()) != null) {
            int diff;
            Rectangle docRect = this.m_renderer.m_rootView.getBounds();
            Dimension portDim = this.getViewport().getExtentSize();
            int yOffset = 20;
            int xOffset = 20;
            int portY = Math.max(0, r.y - yOffset);
            int portX = Math.max(0, r.x - xOffset);
            if (portX + portDim.width > docRect.width && (portX -= (diff = portX + portDim.width - docRect.width)) < 0) {
                portX = 0;
            }
            if (portY + portDim.height > docRect.height && (portY -= (diff = portY + portDim.height - docRect.height)) < 0) {
                portY = 0;
            }
            this.getViewport().setViewPosition(new Point(portX, portY));
        }
    }

    public void scrollToVisible(int pos) {
        View v = this.m_renderer.m_rootView.modelToView(pos);
        if (v != null) {
            Rectangle vb = v.getBounds();
            Rectangle vr = this.getViewport().getViewRect();
            if (vr.x <= vb.x && vr.y <= vb.y && vr.x + vr.width >= vb.x + vb.width && vr.y + vr.height >= vb.y + vb.height) {
                this.repaint();
            } else {
                this.scrollToPosition(pos);
            }
        }
    }

    public void scrollToYPosition(int y) {
        Point pt = this.getViewport().getViewPosition();
        this.getViewport().setViewPosition(new Point(pt.x, y));
        this.getViewport().repaint();
    }

    public void setHTMLPane(HTMLPane pane) {
        this.m_renderer = pane;
        this.setViewportView(this.m_renderer);
    }

    public boolean statusChanged(HTMLPaneStatusEvent evt) {
        switch (evt.getID()) {
            case 5: {
                this.m_lastFindPos = 0;
                break;
            }
        }
        return true;
    }
}

