/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.ComponentView;
import horst.Element;
import horst.HTMLPane;
import horst.HTMLWindow;
import horst.LayoutInfo;
import horst.Utilities;
import horst.View;
import java.awt.Rectangle;
import java.net.URL;

public class IFrameView
extends ComponentView {
    int m_width;
    int m_height;

    public IFrameView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected int getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    protected int getPreferredSpan(int axis) {
        switch (axis) {
            case 1: {
                return this.m_width;
            }
            case 0: {
                return this.m_height;
            }
        }
        return 100;
    }

    protected void init() {
        int frameBorder = Utilities.setIntegerProperty(1, "frameborder", this.m_elem.getAttributes());
        boolean bScrolling = Utilities.setBooleanProperty(true, "scrolling", this.m_elem.getAttributes());
        HTMLWindow htmlWnd = this.m_container.createHTMLWindowFrame();
        if (frameBorder != 1) {
            htmlWnd.hideBorder();
        }
        if (!bScrolling) {
            htmlWnd.enableScrolling(false);
        }
        HTMLPane renderer = htmlWnd.getHTMLPane();
        renderer.addLinkListener(this.m_container);
        renderer.m_preferences.m_bShowToolTip = false;
        renderer.m_props.m_bIsIFrame = true;
        int marginWidth = Utilities.setIntegerProperty(this.m_container.m_props.m_marginWidth, "marginwidth", this.m_elem.getAttributes());
        int marginHeight = Utilities.setIntegerProperty(this.m_container.m_props.m_marginWidth, "marginheight", this.m_elem.getAttributes());
        renderer.setMargins(marginWidth, marginHeight);
        this.m_comp = htmlWnd;
        this.m_container.add(this.m_comp);
        URL u = Utilities.setURLProperty(this.m_elem.getDocument().getBaseURL(), "src", this.m_elem.getAttributes());
        if (u != null) {
            renderer.openPage(u);
        }
        this.m_alignment = Utilities.setAlignmentProperty(false, 0, "align", this.m_elem.getAttributes());
        this.m_width = Utilities.setIntegerProperty(100, "width", this.m_elem.getAttributes());
        this.m_height = Utilities.setIntegerProperty(100, "height", this.m_elem.getAttributes());
    }

    protected boolean isFloater() {
        String align = (String)this.m_elem.getAttribute("align");
        if (align != null) {
            return align.equalsIgnoreCase("left") || align.equalsIgnoreCase("right");
        }
        return false;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        this.m_bounds.setBounds(x, y, this.getPreferredSpan(1), this.getPreferredSpan(0));
        this.m_comp.setBounds(this.m_bounds);
        return this.m_bounds;
    }
}

