/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.Utilities;
import horst.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;

public class ListItemView
extends View {
    int m_bulletRadius = 6;
    int m_bulletXPos;
    static Image m_bulletImg;
    static boolean m_bHavePixels;
    static boolean m_bImageLoadFailed;
    int m_orderNum = -1;

    public ListItemView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected int getPreferredSpan(int axis) {
        if (axis == 1) {
            return super.getPreferredSpan(1);
        }
        return 0;
    }

    protected void init() {
        if (this.m_elem.getType() != 25) {
            this.setInsets(0, this.m_bulletRadius + 20, 0, 0);
        }
        if (!m_bImageLoadFailed && !m_bHavePixels) {
            m_bulletImg = Utilities.loadImage((Component)this.m_container, "horst\\icons\\bullet.gif");
            if (m_bulletImg == null) {
                m_bImageLoadFailed = true;
            } else {
                m_bHavePixels = true;
            }
        }
    }

    protected boolean isNewlineView() {
        return true;
    }

    protected boolean isWrappable() {
        return true;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        Rectangle b = super.layout(x, y, width, info);
        this.m_bulletXPos = b.x;
        if (this.m_children.length > 0 && this.m_children[0].m_bounds.x > x + this.m_insets.left) {
            this.m_bulletXPos = this.m_children[0].m_bounds.x - this.m_insets.left;
        }
        return b;
    }

    protected void move(int x, int y, boolean bMoveFloaters) {
        super.move(x, y, bMoveFloaters);
        this.m_bulletXPos += x;
    }

    public void paint(Graphics g, Shape alloc) {
        super.paint(g, alloc);
        this.paintInset(g);
    }

    protected void paintInset(Graphics g) {
        if (this.m_elem.getType() == 27) {
            if (this.m_orderNum > 0) {
                Font f = this.getFont();
                FontMetrics fmetrics = Toolkit.getDefaultToolkit().getFontMetrics(f);
                Font oldFont = g.getFont();
                g.setFont(f);
                g.setColor(Color.black);
                g.drawString(this.m_orderNum + ".", this.m_bulletXPos, this.m_bounds.y + fmetrics.getHeight() - fmetrics.getDescent());
                g.setFont(oldFont);
            } else if (m_bHavePixels) {
                int imgHeight = m_bulletImg.getHeight(null);
                int h = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).getHeight();
                int y = Math.max(0, h - imgHeight) / 2 + this.m_bounds.y;
                g.drawImage(m_bulletImg, this.m_bulletXPos + this.m_insets.left / 2 - this.m_bulletRadius / 2, y, null);
            } else {
                int h = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).getHeight();
                int y = Math.max(0, h - this.m_bulletRadius) / 2 + this.m_bounds.y;
                g.setColor(Color.black);
                g.fillOval(this.m_bulletXPos + this.m_insets.left / 2 - this.m_bulletRadius / 2, y, this.m_bulletRadius, this.m_bulletRadius);
            }
        }
    }

    protected void setLeftInset(int val) {
        this.m_insets.left = val;
    }

    protected void setOrderNumber(int orderNum) {
        this.m_orderNum = orderNum;
    }
}

