/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.TableRow;
import horst.TableView;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Hashtable;

public class TableCell
extends View {
    int m_rowSpan;
    int m_colSpan;
    int m_startColumn;
    int m_endColumn;
    int m_startRow;
    int m_endRow;
    int m_width;
    int m_height;
    int m_cellPrefWidth;
    int m_cellMinWidth;
    Color m_bgColor;
    int m_borderSize;
    int m_valign;
    TableRow m_row;
    TableView m_tableView;
    Rectangle m_cellBounds;

    public TableCell(View rowViewParent, TableView tableView, Element e, HTMLPane container) {
        super(rowViewParent, e, container);
        this.m_tableView = tableView;
        this.m_cellPrefWidth = -1;
        this.m_cellMinWidth = -1;
    }

    protected int checkWidthHeightAttributes(int axis, int span) {
        if (axis == 1) {
            if (this.m_width != -1 && this.m_width > span) {
                span = this.m_width;
            }
        } else if (this.m_height != -1 && this.m_height > span) {
            span = this.m_height;
        }
        return span;
    }

    protected void computeCellHeight() {
        this.m_cellBounds.height = this.m_height != -1 && this.m_height - 2 * this.m_tableView.m_cellPadding > this.m_bounds.height ? this.m_height + 2 * this.m_borderSize : 2 * this.m_borderSize + 2 * this.m_tableView.m_cellPadding + this.m_bounds.height;
    }

    protected int doCellVerticalAlignment(LayoutInfo info) {
        int adjustment = 0;
        Rectangle childrenBounds = super.getBounds();
        if (this.m_cellBounds != null && childrenBounds != null) {
            int availSpace;
            int cellPadding = this.m_tableView.m_cellPadding;
            if (this.m_valign == 1) {
                availSpace = this.m_cellBounds.height - 2 * cellPadding - 2 * this.m_borderSize;
                if (availSpace > childrenBounds.height) {
                    super.move(0, (availSpace - childrenBounds.height) / 2, true);
                }
            } else if (this.m_valign == 2 && (availSpace = this.m_cellBounds.height - 2 * cellPadding - 2 * this.m_borderSize) > childrenBounds.height) {
                super.move(0, availSpace - childrenBounds.height, true);
            }
            if (info.bPaginate) {
                info.setPageBreak(this.m_cellBounds.y);
                int origHeight = this.m_cellBounds.height;
                adjustment = super.pageBreakAdjust(info);
                this.m_cellBounds.height = 2 * this.m_borderSize + 2 * this.m_tableView.m_cellPadding + this.m_bounds.height;
                if (origHeight > this.m_cellBounds.height) {
                    this.increaseHeight(origHeight - this.m_cellBounds.height);
                }
                adjustment = this.m_cellBounds.height - origHeight;
            }
        }
        return adjustment;
    }

    public Rectangle getBounds() {
        return this.m_cellBounds;
    }

    protected int getMinimumSpan(int axis) {
        int paddingAndBorder;
        if (axis == 1) {
            int paddingAndBorder2;
            if (this.m_cellMinWidth != -1) {
                return this.m_cellMinWidth;
            }
            this.m_cellMinWidth = paddingAndBorder2 = 2 * this.m_tableView.m_cellPadding + 2 * this.m_borderSize;
            this.m_cellMinWidth += super.getMinimumSpan(1);
            if (!this.m_bCanWrap && this.m_width != -1 && this.m_cellMinWidth > this.m_width) {
                this.reset();
                this.setCanWrap(true);
                this.m_cellMinWidth = paddingAndBorder2;
                this.m_cellMinWidth += super.getMinimumSpan(1);
                this.setCanWrap(false);
            }
            return this.m_cellMinWidth;
        }
        if (this.m_minHeight != -1) {
            return this.m_minHeight;
        }
        int span = paddingAndBorder = 2 * this.m_tableView.m_cellPadding + 2 * this.m_borderSize;
        span = this.m_height >= 0 ? this.m_height : super.getMinimumSpan(axis);
        this.m_minHeight = span;
        return this.m_minHeight;
    }

    protected int getPreferredSpan(int axis) {
        int paddingAndBorder;
        if (axis == 1) {
            int paddingAndBorder2;
            if (this.m_cellPrefWidth != -1) {
                return this.m_cellPrefWidth;
            }
            int span = paddingAndBorder2 = 2 * this.m_tableView.m_cellPadding + 2 * this.m_borderSize;
            span += super.getPreferredSpan(1);
            if (this.m_width > 0) {
                if (this.m_width >= span) {
                    span = this.m_width;
                } else {
                    int minSpan;
                    this.reset();
                    if (!this.m_bCanWrap) {
                        this.setCanWrap(true);
                    }
                    span = (minSpan = super.getMinimumSpan(1) + paddingAndBorder2) <= this.m_width ? this.m_width : minSpan;
                }
            }
            this.m_cellPrefWidth = span;
            return this.m_cellPrefWidth;
        }
        if (this.m_prefHeight != -1) {
            return this.m_prefHeight;
        }
        int span = paddingAndBorder = 2 * this.m_tableView.m_cellPadding + 2 * this.m_borderSize;
        span = this.m_height >= 0 ? this.m_height : super.getPreferredSpan(axis);
        this.m_prefHeight = span;
        return this.m_prefHeight;
    }

    protected void increaseHeight(int yIncrease) {
        if (this.m_cellBounds != null) {
            this.m_cellBounds.height += yIncrease;
        }
    }

    protected void init() {
        this.m_row = (TableRow)this.m_parent;
        this.m_cellBounds = new Rectangle();
        Hashtable atts = this.m_elem.getAttributes();
        this.m_width = Utilities.setIntegerProperty(-1, "width", atts);
        this.m_height = Utilities.setIntegerProperty(-1, "height", atts);
        this.m_bgColor = Utilities.setColorProperty(this.m_row.m_bgColor, "bgcolor", atts);
        this.m_colSpan = Utilities.setIntegerProperty(1, "colspan", atts);
        this.m_rowSpan = Utilities.setIntegerProperty(1, "rowspan", atts);
        this.m_colSpan = Math.max(1, this.m_colSpan);
        this.m_rowSpan = Math.max(1, this.m_rowSpan);
        switch (this.m_elem.getType()) {
            case 4: {
                this.m_alignment = 1;
                break;
            }
            default: {
                this.m_alignment = Utilities.setAlignmentProperty(false, -1, "align", atts);
                if (this.m_alignment != -1) break;
                this.m_alignment = this.m_row.m_alignment;
            }
        }
        this.m_valign = Utilities.setAlignmentProperty(true, -1, "valign", atts);
        if (this.m_valign == -1) {
            this.m_valign = this.m_row.m_valign;
        }
    }

    protected void invalidate() {
        this.m_cellPrefWidth = -1;
        this.m_cellMinWidth = -1;
        super.invalidate();
    }

    protected boolean isFloaterClearer() {
        return true;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        int xPos = x + this.m_tableView.m_cellPadding + this.m_borderSize;
        int yPos = y + this.m_tableView.m_cellPadding + this.m_borderSize;
        int space = width - 2 * this.m_tableView.m_cellPadding - 2 * this.m_borderSize;
        space = Math.max(0, space);
        boolean bPaginate = info.bPaginate;
        Rectangle startPageBreak = new Rectangle(info.pageBreak);
        info.bPaginate = false;
        super.layout(xPos, yPos, space, info);
        info.bPaginate = bPaginate;
        info.pageBreak = startPageBreak;
        this.m_cellBounds = new Rectangle(x, y, width, 0);
        this.computeCellHeight();
        return this.m_cellBounds;
    }

    protected void makeChildren(ViewFactory factory) {
        super.makeChildren(factory);
        if (this.m_elem.isAttributeDefined("nowrap")) {
            super.setCanWrap(false);
        }
    }

    protected void move(int x, int y, boolean bMoveFloaters) {
        if (this.m_cellBounds != null) {
            super.move(x, y, bMoveFloaters);
            this.m_cellBounds.x += x;
            this.m_cellBounds.y += y;
        }
    }

    protected boolean occupies(int row, int col) {
        return row >= this.m_startRow && row <= this.m_endRow && col >= this.m_startColumn && col <= this.m_endColumn;
    }

    protected int pageBreakAdjust(LayoutInfo info) {
        int origHeight = this.m_cellBounds.height;
        int adjustment = super.pageBreakAdjust(info);
        this.computeCellHeight();
        this.m_cellBounds.height = Math.max(origHeight, this.m_cellBounds.height);
        return adjustment;
    }

    public void paint(Graphics g, Shape alloc) {
        Rectangle clip = alloc.getBounds();
        if (this.m_cellBounds.intersects(clip)) {
            if (this.m_bgColor != null) {
                Color oldColor = g.getColor();
                g.setColor(this.m_bgColor);
                g.fillRect(this.m_cellBounds.x, this.m_cellBounds.y, this.m_cellBounds.width, this.m_cellBounds.height);
                g.setColor(oldColor);
            }
            super.paint(g, alloc);
        }
    }

    protected void paintFocusBox(Graphics g, Shape alloc) {
        Rectangle clip = alloc.getBounds();
        if (this.m_cellBounds.intersects(clip)) {
            super.paintFocusBox(g, alloc);
        }
    }

    protected void setTableColumns(int start) {
        this.m_startColumn = start;
        this.m_endColumn = this.m_startColumn + this.m_colSpan - 1;
    }

    protected void setTableRows(int start) {
        this.m_startRow = start;
        this.m_endRow = this.m_startRow + this.m_rowSpan - 1;
    }
}

