/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.BlockView;
import horst.Element;
import horst.ElementViewInfo;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.TableCell;
import horst.TableRow;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Enumeration;
import java.util.Vector;

public class TableView
extends BlockView {
    static final int TOP_VALIGN = 0;
    static final int MIDDLE_VALIGN = 1;
    static final int BOTTOM_VALIGN = 2;
    static final int BASELINE_VALIGN = 3;
    private static final int PREFWIDTH = 0;
    private static final int MINWIDTH = 1;
    private static final int LAYOUT = 2;
    View[] m_topCaptions;
    View[] m_bottomCaptions;
    boolean[] m_hasSingleCell;
    int[] m_prefColWidths;
    int[] m_minColWidths;
    int[] m_colWidths;
    int[] m_colSpecWidths;
    int[] m_rowHeightSpecs;
    float[] m_pctColWidths;
    boolean m_bHavePctColumns;
    boolean m_bPrefMinColsComputed = false;
    Rectangle m_tableBorder;
    float m_pctValue;
    Color m_bgColor;
    int m_nColumns;
    int m_nRows;
    int m_nDefinedRows;
    int m_cellPadding;
    int m_cellSpacing;
    int m_borderSize;
    int m_width;
    int m_height;

    public TableView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    boolean allMinimum(int[] cols) {
        int i = 0;
        while (i < cols.length) {
            if (cols[i] > this.m_minColWidths[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean allSpecWidths(int[] cols) {
        int i = 0;
        while (i < cols.length) {
            if (this.m_colSpecWidths[i] != -1 && cols[i] > this.m_minColWidths[i] && cols[i] > this.m_colSpecWidths[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void checkWidthSpecification(int width) {
        int specWidth;
        int diff = 0;
        int span = 0;
        if (this.m_width != -1) {
            span = this.getColumnSum(this.m_colWidths);
            specWidth = this.m_width;
            specWidth -= 2 * this.m_borderSize;
            if ((specWidth -= 2 * this.m_cellSpacing + (this.m_nColumns - 1) * this.m_cellSpacing) > span) {
                diff = specWidth - span;
            }
        } else if (this.m_pctValue > 0.0f && this.m_pctValue <= 1.0f) {
            span = this.getColumnSum(this.m_colWidths);
            specWidth = width;
            diff = Math.max(0, specWidth - span);
        }
        if (diff > 0) {
            int runningTotal = 0;
            int addAmount = 0;
            int i = 0;
            while (i < this.m_colWidths.length) {
                if (i == this.m_colWidths.length - 1) {
                    addAmount = diff - runningTotal;
                } else {
                    double pct = (double)this.m_colWidths[i] / (double)span;
                    addAmount = (int)(pct * (double)diff);
                }
                int n = i++;
                this.m_colWidths[n] = this.m_colWidths[n] + addAmount;
                runningTotal += addAmount;
            }
        }
    }

    protected boolean columnOccupied(Vector v, int row, int col) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            RowSpanColumns x = (RowSpanColumns)e.nextElement();
            if (row > x.endRow) continue;
            int i = 0;
            while (i < x.columns.length) {
                if (x.columns[i] == col) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    int[] computeColumnWidths(int width, int mode) {
        int[] widths = new int[this.m_nColumns];
        int pass = 0;
        while (pass < 2) {
            widths = mode == 0 ? Utilities.clone(this.m_prefColWidths) : (mode == 1 ? Utilities.clone(this.m_minColWidths) : (pass == 0 ? Utilities.clone(this.m_prefColWidths) : Utilities.clone(this.m_minColWidths)));
            int row = 0;
            while (row < this.m_children.length) {
                View[] cells = ((TableRow)this.m_children[row]).m_children;
                int cellNum = 0;
                while (cellNum < cells.length) {
                    TableCell cell = (TableCell)cells[cellNum];
                    if (cell.m_colSpan > 1) {
                        int startCol = cell.m_startColumn;
                        int endCol = cell.m_endColumn;
                        int spanWidth = 0;
                        int j = startCol;
                        while (j <= endCol) {
                            spanWidth += widths[j];
                            ++j;
                        }
                        int cellSpan = 0;
                        if (mode == 1) {
                            cellSpan = cell.getMinimumSpan(1);
                        } else if (mode == 0) {
                            cellSpan = cell.getPreferredSpan(1);
                        } else {
                            int n = cellSpan = pass == 0 ? cell.getPreferredSpan(1) : cell.getMinimumSpan(1);
                        }
                        if (cellSpan > spanWidth) {
                            widths = this.distributeSpace(widths, startCol, endCol, cellSpan - spanWidth);
                        }
                    }
                    ++cellNum;
                }
                ++row;
            }
            if (mode == 0 || mode == 1) {
                return widths;
            }
            if (pass == 0 && this.getColumnSum(widths) <= width) {
                return widths;
            }
            ++pass;
        }
        int diff = width - this.getColumnSum(widths);
        if (diff > 0) {
            widths = this.distributeSpace(widths, 0, widths.length - 1, diff);
        }
        return widths;
    }

    int[] computePercentColumnWidths(int width) {
        float[] pctValues = new float[this.m_pctColWidths.length];
        float totalPctCols = 0.0f;
        int nNonPctCols = 0;
        int i = 0;
        while (i < pctValues.length) {
            pctValues[i] = this.m_pctColWidths[i];
            if (pctValues[i] > 0.0f) {
                totalPctCols += pctValues[i];
            } else {
                ++nNonPctCols;
            }
            ++i;
        }
        float nonPctCols = 1.0f - totalPctCols;
        int[] widths = new int[this.m_nColumns];
        int i2 = 0;
        while (i2 < this.m_nColumns) {
            widths[i2] = Math.max(this.m_colSpecWidths[i2], this.m_minColWidths[i2]);
            ++i2;
        }
        int layoutWidth = this.computeRequiredLayoutWidth(pctValues, totalPctCols, this.m_minColWidths);
        int availWidth = width;
        if ((this.m_width != -1 || this.m_pctValue > 0.0f && this.m_pctValue <= 1.0f) && layoutWidth < (availWidth = this.m_width != -1 ? this.m_width : (int)(this.m_pctValue * (float)width))) {
            layoutWidth = availWidth;
        }
        if (layoutWidth < availWidth) {
            int prefLayoutWidth = this.computeRequiredLayoutWidth(pctValues, totalPctCols, this.m_prefColWidths);
            layoutWidth = prefLayoutWidth <= availWidth ? prefLayoutWidth : availWidth;
        }
        if (layoutWidth <= width) {
            int overshoot;
            int i3;
            int tabWidth = layoutWidth;
            int totPctSpace = 0;
            int i4 = 0;
            while (i4 < pctValues.length) {
                if ((double)pctValues[i4] > 0.0) {
                    widths[i4] = (int)(pctValues[i4] * (float)tabWidth);
                    totPctSpace += widths[i4];
                }
                ++i4;
            }
            int space = Math.max(0, tabWidth - totPctSpace);
            while (nNonPctCols > 0 && space > 0) {
                boolean bColsAvailable = false;
                i3 = 0;
                while (i3 < this.m_nColumns) {
                    if ((double)pctValues[i3] <= 0.0 && this.m_colSpecWidths[i3] == -1 || widths[i3] < this.m_colSpecWidths[i3]) {
                        bColsAvailable = true;
                        break;
                    }
                    ++i3;
                }
                if (!bColsAvailable) break;
                int i5 = 0;
                while (i5 < pctValues.length && space > 0) {
                    if ((double)pctValues[i5] <= 0.0) {
                        int n = i5;
                        widths[n] = widths[n] + 1;
                        --space;
                    }
                    ++i5;
                }
            }
            if ((overshoot = this.getColumnSum(widths) - tabWidth) > 0) {
                boolean bAllMinimum = this.allMinimum(widths);
                boolean bAllSpecWidths = this.allSpecWidths(widths);
                while (!bAllMinimum && overshoot > 0) {
                    int i6 = 0;
                    while (i6 < widths.length && overshoot > 0) {
                        if (!bAllSpecWidths) {
                            if (this.m_colSpecWidths[i6] != -1 && widths[i6] > this.m_colSpecWidths[i6] && widths[i6] > this.m_minColWidths[i6]) {
                                int n = i6;
                                widths[n] = widths[n] - 1;
                                --overshoot;
                            }
                        } else if (widths[i6] > this.m_minColWidths[i6]) {
                            int n = i6;
                            widths[n] = widths[n] - 1;
                            --overshoot;
                        }
                        ++i6;
                    }
                    bAllMinimum = this.allMinimum(widths);
                    if (bAllSpecWidths) continue;
                    bAllSpecWidths = this.allSpecWidths(widths);
                }
            } else {
                space = Math.abs(overshoot);
                while (space > 0) {
                    i3 = 0;
                    while (i3 < pctValues.length && space > 0) {
                        if ((double)pctValues[i3] > 0.0) {
                            int n = i3;
                            widths[n] = widths[n] + 1;
                            --space;
                        }
                        ++i3;
                    }
                }
            }
        } else {
            int i7 = 0;
            while (i7 < pctValues.length) {
                widths[i7] = (double)pctValues[i7] > 0.0 ? Math.max(this.m_minColWidths[i7], (int)(pctValues[i7] * (float)width)) : Math.max(this.m_colSpecWidths[i7], this.m_minColWidths[i7]);
                ++i7;
            }
            int overshoot = this.getColumnSum(widths) - width;
            if (overshoot < 0) {
                int space = Math.abs(overshoot);
                while (nNonPctCols > 0 && space > 0) {
                    int i8 = 0;
                    while (i8 < pctValues.length) {
                        if ((double)pctValues[i8] <= 0.0) {
                            int n = i8;
                            widths[n] = widths[n] + 1;
                            --space;
                        }
                        ++i8;
                    }
                }
            } else {
                boolean bAllMinimum = this.allMinimum(widths);
                boolean bAllSpecWidths = this.allSpecWidths(widths);
                while (!bAllMinimum && overshoot > 0) {
                    int i9 = 0;
                    while (i9 < widths.length && overshoot > 0) {
                        if (!bAllSpecWidths) {
                            if (this.m_colSpecWidths[i9] != -1 && widths[i9] > this.m_colSpecWidths[i9]) {
                                int n = i9;
                                widths[n] = widths[n] - 1;
                                --overshoot;
                            }
                        } else if (widths[i9] > this.m_minColWidths[i9]) {
                            int n = i9;
                            widths[n] = widths[n] - 1;
                            --overshoot;
                        }
                        ++i9;
                    }
                    bAllMinimum = this.allMinimum(widths);
                    if (bAllSpecWidths) continue;
                    bAllSpecWidths = this.allSpecWidths(widths);
                }
            }
        }
        return widths;
    }

    void computePrefMinWidths() {
        TableCell cell;
        if (this.m_bPrefMinColsComputed) {
            return;
        }
        this.m_bPrefMinColsComputed = true;
        this.m_hasSingleCell = new boolean[this.m_nColumns];
        this.m_prefColWidths = new int[this.m_nColumns];
        this.m_minColWidths = new int[this.m_nColumns];
        int col = 0;
        while (col < this.m_nColumns) {
            boolean bFoundSingleCell = false;
            int row = 0;
            while (row < this.m_children.length) {
                TableRow rv = (TableRow)this.m_children[row];
                cell = rv.getTableColumn(col);
                if (cell != null) {
                    this.m_prefColWidths[col] = Math.max(this.m_prefColWidths[col], cell.getPreferredSpan(1));
                    this.m_minColWidths[col] = Math.max(this.m_minColWidths[col], cell.getMinimumSpan(1));
                    bFoundSingleCell = true;
                }
                ++row;
            }
            this.m_hasSingleCell[col] = bFoundSingleCell;
            ++col;
        }
        int row = 0;
        while (row < this.m_children.length) {
            TableRow rv = (TableRow)this.m_children[row];
            int col2 = 0;
            while (col2 < rv.m_children.length) {
                cell = (TableCell)rv.m_children[col2];
                if (cell != null && cell.m_colSpan > 1) {
                    int minSpan = cell.getMinimumSpan(1);
                    int prefSpan = cell.getPreferredSpan(1);
                    int currentMinSpan = 0;
                    int currentPrefSpan = 0;
                    int start = cell.m_startColumn;
                    int end = cell.m_endColumn;
                    int i = start;
                    while (i <= end) {
                        if (i >= this.m_minColWidths.length) break;
                        currentMinSpan += this.m_minColWidths[i];
                        currentPrefSpan += this.m_prefColWidths[i];
                        ++i;
                    }
                    if (currentMinSpan < minSpan) {
                        this.doWeightedDistribution(this.m_minColWidths, start, end, minSpan - currentMinSpan);
                    }
                }
                ++col2;
            }
            ++row;
        }
    }

    int computeRequiredLayoutWidth(float[] pctValues, float totalPctCols, int[] widths) {
        int requiredWidth = 0;
        int nonPctWidths = 0;
        int i = 0;
        while (i < pctValues.length) {
            if ((double)pctValues[i] > 0.0) {
                int w = (int)((float)widths[i] / pctValues[i]);
                requiredWidth = Math.max(w, requiredWidth);
            } else {
                nonPctWidths += widths[i];
            }
            ++i;
        }
        float nonPctCols = 1.0f - totalPctCols;
        int nonPctNeeded = 0;
        if (nonPctCols > 0.0f) {
            nonPctNeeded = (int)((float)nonPctWidths / nonPctCols);
        }
        requiredWidth = Math.max(requiredWidth, nonPctNeeded);
        return requiredWidth;
    }

    int[] distributeSpace(int[] colWidths, int startCol, int endCol, int amount) {
        int nCols = endCol - startCol + 1;
        int prefSum = 0;
        int colSum = 0;
        boolean bWeighted = true;
        int i = startCol;
        while (i <= endCol) {
            prefSum += this.m_prefColWidths[i];
            colSum += colWidths[i];
            if (!this.m_hasSingleCell[i]) {
                bWeighted = false;
            }
            ++i;
        }
        if (colSum + amount >= prefSum) {
            int[] differences = new int[nCols];
            int i2 = startCol;
            int j = 0;
            while (i2 <= endCol) {
                differences[j] = this.m_hasSingleCell[i2] ? this.m_prefColWidths[i2] - colWidths[i2] : -1;
                ++i2;
                ++j;
            }
            int space = amount;
            int i3 = startCol;
            int j2 = 0;
            while (i3 <= endCol) {
                if (differences[j2] > 0) {
                    int n = i3;
                    colWidths[n] = colWidths[n] + differences[j2];
                    space -= differences[j2];
                }
                ++i3;
                ++j2;
            }
            if (space > 0) {
                colWidths = this.doEvenDistribution(colWidths, startCol, endCol, space);
            }
        } else {
            colWidths = this.doEvenDistribution(colWidths, startCol, endCol, amount);
        }
        return colWidths;
    }

    int[] doEvenDistribution(int[] colWidths, int startCol, int endCol, int amount) {
        int nCols = endCol - startCol + 1;
        do {
            int nDiffs = 0;
            int[] diffs = new int[nCols];
            int i = startCol;
            int j = 0;
            while (i <= endCol) {
                diffs[j] = this.m_prefColWidths[i] - colWidths[i];
                if (diffs[j] > 0) {
                    ++nDiffs;
                }
                ++i;
                ++j;
            }
            if (nDiffs > 0) {
                int apportion = Math.max(1, amount / nDiffs);
                int i2 = 0;
                int j2 = startCol;
                while (i2 < nCols && amount > 0) {
                    if (diffs[i2] > 0) {
                        if (diffs[i2] > apportion) {
                            amount -= apportion;
                            int n = j2;
                            colWidths[n] = colWidths[n] + apportion;
                        } else {
                            amount -= diffs[i2];
                            int n = j2;
                            colWidths[n] = colWidths[n] + diffs[i2];
                        }
                    }
                    ++i2;
                    ++j2;
                }
            } else {
                if (amount < nCols) {
                    int j3 = startCol;
                    while (j3 < amount) {
                        int n = j3++;
                        colWidths[n] = colWidths[n] + 1;
                    }
                    amount = 0;
                    continue;
                }
                int origAmount = amount;
                int apportion = amount / nCols;
                int runningTotal = 0;
                int addAmount = 0;
                int i3 = 0;
                int j4 = startCol;
                while (i3 < nCols) {
                    addAmount = i3 == nCols - 1 ? origAmount - runningTotal : apportion;
                    int n = j4++;
                    colWidths[n] = colWidths[n] + addAmount;
                    runningTotal += addAmount;
                    amount -= addAmount;
                    ++i3;
                }
            }
        } while (amount > 0);
        return colWidths;
    }

    boolean doWeightedDistribution(int[] colWidths, int startCol, int endCol, int amount) {
        int nCols = endCol - startCol + 1;
        int prefSum = this.getColumnSum(this.m_prefColWidths);
        int runningTotal = 0;
        int addAmount = 0;
        int i = startCol;
        while (i <= endCol) {
            addAmount = i == endCol ? amount - runningTotal : (int)((double)this.m_prefColWidths[i] / (double)prefSum * (double)amount);
            int n = i++;
            colWidths[n] = colWidths[n] + addAmount;
            runningTotal += addAmount;
        }
        return runningTotal == amount;
    }

    protected View elementToView(Element e) {
        if (this.m_elem == e) {
            return this;
        }
        int i = 0;
        while (i < this.m_children.length) {
            View v = this.m_children[i].elementToView(e);
            if (v != null) {
                return v;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_topCaptions.length) {
            View v = this.m_topCaptions[i2].elementToView(e);
            if (v != null) {
                return v;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.m_bottomCaptions.length) {
            View v = this.m_bottomCaptions[i3].elementToView(e);
            if (v != null) {
                return v;
            }
            ++i3;
        }
        return null;
    }

    int getColumnSum(int[] cols) {
        int colSum = 0;
        int i = 0;
        while (i < cols.length) {
            colSum += cols[i];
            ++i;
        }
        return colSum;
    }

    public int getMinimumSpan(int axis) {
        if (axis == 1) {
            if (this.m_minWidth != -1) {
                return this.m_minWidth;
            }
            int m_minWidth = 0;
            this.computePrefMinWidths();
            int[] colWidths = this.computeColumnWidths(0, 1);
            int i = 0;
            while (i < colWidths.length) {
                m_minWidth += colWidths[i];
                ++i;
            }
            if (this.m_width != -1 && this.m_width > (m_minWidth += this.m_borderSize * 2 + 2 * this.m_cellSpacing)) {
                m_minWidth = this.m_width;
            }
            return m_minWidth;
        }
        return 0;
    }

    protected int getPreferredSpan(int axis) {
        if (axis == 1) {
            if (this.m_prefWidth != -1) {
                return this.m_prefWidth;
            }
            int m_prefWidth = 0;
            this.computePrefMinWidths();
            int[] colWidths = this.computeColumnWidths(0, 0);
            int i = 0;
            while (i < colWidths.length) {
                m_prefWidth += colWidths[i];
                ++i;
            }
            m_prefWidth += this.m_cellSpacing * (this.m_nColumns - 1);
            m_prefWidth += this.m_borderSize * 2 + this.m_cellSpacing * 2;
            if (this.m_width != -1 && this.m_width > 0) {
                int specWidth = this.m_width;
                int minWidth = this.getMinimumSpan(1);
                m_prefWidth = m_prefWidth > specWidth && specWidth >= minWidth ? specWidth : minWidth;
            }
            return m_prefWidth;
        }
        return 0;
    }

    protected TableRow getRow(int row) {
        if (row < this.m_children.length) {
            return (TableRow)this.m_children[row];
        }
        return null;
    }

    protected void increasePreviousCellHeights(TableRow row, int yAmount) {
        int rowIndex = 0;
        while (rowIndex < this.m_children.length) {
            TableRow rv = (TableRow)this.m_children[rowIndex];
            if (rv == row) break;
            ++rowIndex;
        }
        int i = 0;
        while (i <= rowIndex - 1) {
            TableRow rv = (TableRow)this.m_children[i];
            int j = 0;
            while (j < rv.m_children.length) {
                TableCell cell = (TableCell)rv.m_children[j];
                if (rowIndex >= cell.m_startRow && rowIndex <= cell.m_endRow) {
                    cell.increaseHeight(yAmount);
                }
                ++j;
            }
            ++i;
        }
    }

    protected void increaseRowHeight(int row, int amt) {
        if (row >= this.m_children.length) {
            return;
        }
        TableRow rv = (TableRow)this.m_children[row];
        rv.increaseHeight(amt);
        int i = row + 1;
        while (i < this.m_children.length) {
            ((TableRow)this.m_children[i]).move(0, amt, true);
            ++i;
        }
    }

    protected void init() {
        String b = (String)this.m_elem.getAttribute("border");
        this.m_borderSize = b == null ? 0 : Utilities.setIntegerProperty(1, "border", this.m_elem.getAttributes());
        this.m_bgColor = Utilities.setColorProperty(null, "bgcolor", this.m_elem.getAttributes());
        this.m_height = Utilities.setIntegerProperty(-1, "height", this.m_elem.getAttributes());
        this.m_width = Utilities.setIntegerProperty(-1, "width", this.m_elem.getAttributes());
        this.m_pctValue = -1.0f;
        if (this.m_width == -1) {
            this.m_pctValue = Utilities.setPercentageProperty(-1.0f, "width", this.m_elem.getAttributes());
        }
        this.m_cellPadding = Utilities.setIntegerProperty(1, "cellpadding", this.m_elem.getAttributes());
        this.m_cellSpacing = Utilities.setIntegerProperty(1, "cellspacing", this.m_elem.getAttributes());
        this.m_alignment = Utilities.setAlignmentProperty(false, -1, "align", this.m_elem.getAttributes());
        int hspace = Utilities.setIntegerProperty(0, "hspace", this.m_elem.getAttributes());
        int vspace = Utilities.setIntegerProperty(0, "vspace", this.m_elem.getAttributes());
        this.setInsets(vspace, hspace, vspace, hspace);
    }

    protected void initCellColumnRowValues() {
        if (this.m_children == null) {
            return;
        }
        int nRows = this.m_children.length;
        TableRow currentRow = null;
        Vector<RowSpanColumns> occupiedColumns = new Vector<RowSpanColumns>();
        this.m_nColumns = 0;
        this.m_nRows = nRows;
        int colPos = 0;
        int row = 0;
        while (row < nRows) {
            this.m_nColumns = Math.max(this.m_nColumns, colPos);
            colPos = 0;
            this.removeInvalidOccupiedColumns(occupiedColumns, row);
            currentRow = (TableRow)this.m_children[row];
            int rowExtension = currentRow.getBiggestRowSpan();
            this.m_nRows = Math.max(this.m_nRows, row + rowExtension);
            int nRowCells = currentRow.m_children.length;
            int cellIndex = 0;
            while (cellIndex < nRowCells) {
                if (this.columnOccupied(occupiedColumns, row, colPos)) {
                    ++colPos;
                    continue;
                }
                TableCell cell = currentRow.getCell(cellIndex);
                cell.setTableColumns(colPos);
                colPos += cell.m_colSpan;
                cell.setTableRows(row);
                if (cell.m_rowSpan > 1) {
                    RowSpanColumns item = new RowSpanColumns();
                    item.columns = new int[cell.m_colSpan];
                    int startCol = cell.m_startColumn;
                    int j = 0;
                    while (j < item.columns.length) {
                        item.columns[j] = startCol + j;
                        ++j;
                    }
                    item.endRow = cell.m_endRow;
                    occupiedColumns.addElement(item);
                }
                ++cellIndex;
            }
            ++row;
        }
        this.m_nColumns = Math.max(this.m_nColumns, colPos);
    }

    protected void initColumnSpecs() {
        this.m_colSpecWidths = new int[this.m_nColumns];
        int i = 0;
        while (i < this.m_colSpecWidths.length) {
            this.m_colSpecWidths[i] = -1;
            ++i;
        }
        this.m_pctColWidths = new float[this.m_nColumns];
        int i2 = 0;
        while (i2 < this.m_pctColWidths.length) {
            this.m_pctColWidths[i2] = -1.0f;
            ++i2;
        }
        int col = 0;
        while (col < this.m_nColumns) {
            int row = 0;
            while (row < this.m_children.length) {
                String width;
                TableRow rv = (TableRow)this.m_children[row];
                TableCell cell = rv.getTableColumn(col);
                if (cell != null && (width = (String)cell.getAttribute("width")) != null) {
                    int idx = width.indexOf("%");
                    if (idx > 0) {
                        Integer iVal = Utilities.getInteger(width = width.substring(0, idx));
                        if (iVal != null && iVal > 0 && iVal <= 100) {
                            this.m_pctColWidths[col] = (float)iVal.intValue() / 100.0f;
                            this.m_bHavePctColumns = true;
                        }
                    } else {
                        this.m_colSpecWidths[col] = Math.max(this.m_colSpecWidths[col], cell.m_width);
                    }
                }
                ++row;
            }
            ++col;
        }
    }

    protected void initRowSpecs() {
        this.m_rowHeightSpecs = new int[this.m_nRows];
        int i = 0;
        while (i < this.m_nRows) {
            if (i < this.m_children.length) {
                TableRow rv = (TableRow)this.m_children[i];
                this.m_rowHeightSpecs[i] = rv.getHeightSpec();
            } else {
                this.m_rowHeightSpecs[i] = -1;
            }
            ++i;
        }
    }

    protected void invalidate() {
        this.m_bPrefMinColsComputed = false;
        super.invalidate();
    }

    protected boolean isFloater() {
        return this.m_alignment == 0 || this.m_alignment == 2;
    }

    protected boolean isSelfContained() {
        return true;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        int space;
        this.m_bounds.setBounds(x, y, 0, 0);
        int xPos = x + this.m_insets.left;
        int yPos = y + this.m_insets.top;
        int layoutWidth = Math.max(0, width -= this.m_insets.left + this.m_insets.right + info.leftMargin);
        if (this.m_width != -1) {
            layoutWidth = this.m_width;
        } else if (this.m_pctValue > 0.0f && this.m_pctValue <= 1.0f) {
            layoutWidth = (int)(this.m_pctValue * (float)width);
        }
        layoutWidth -= 2 * this.m_borderSize;
        int cellSpacing = this.m_cellSpacing;
        layoutWidth -= (this.m_nColumns - 1) * cellSpacing + 2 * cellSpacing;
        layoutWidth = Math.max(0, layoutWidth);
        this.computePrefMinWidths();
        this.m_colWidths = this.layoutColumns(layoutWidth, 2);
        this.checkWidthSpecification(layoutWidth);
        this.m_bounds = this.layoutRows(xPos += this.m_borderSize + cellSpacing, yPos += this.m_borderSize + cellSpacing, layoutWidth, info);
        this.m_bounds.x = x;
        this.m_bounds.y = y;
        this.m_bounds.width += 2 * this.m_borderSize + this.m_insets.left + this.m_insets.right;
        this.m_bounds.height += 2 * this.m_borderSize + this.m_insets.top + this.m_insets.bottom;
        this.m_tableBorder = new Rectangle(this.m_bounds);
        Rectangle r = this.layoutCaptions(x, y, this.m_bounds.width, this.m_topCaptions);
        this.m_bounds.height += r.height;
        this.m_bounds.width = Math.max(this.m_bounds.width, r.width);
        if (r.height > 0 && this.m_children.length > 0) {
            this.moveRows(r.height, (TableRow)this.m_children[0]);
        }
        this.m_tableBorder.y += r.height;
        r = this.layoutCaptions(x, this.m_bounds.y + this.m_bounds.height, this.m_bounds.width, this.m_bottomCaptions);
        this.m_bounds.height += r.height;
        if (this.m_alignment == 1 && (space = width - this.m_bounds.width) > 0) {
            this.move(space / 2, 0, true);
        }
        return this.m_bounds;
    }

    Rectangle layoutCaptions(int x, int y, int width, View[] captions) {
        Rectangle bounds = new Rectangle(x, y, 0, 0);
        int xPos = x;
        int yPos = y;
        int i = 0;
        while (i < captions.length) {
            Rectangle r = captions[i].layout(xPos, yPos, width, new LayoutInfo());
            yPos += r.height;
            bounds.width = Math.max(bounds.width, r.width);
            ++i;
        }
        bounds.height = yPos - y;
        return bounds;
    }

    int[] layoutColumns(int width, int mode) {
        if (this.m_bHavePctColumns) {
            return this.computePercentColumnWidths(width);
        }
        return this.computeColumnWidths(width, 2);
    }

    Rectangle layoutRows(int x, int y, int width, LayoutInfo info) {
        int row;
        int xPos = x;
        int yPos = y;
        boolean tableHeight = false;
        boolean tableWidth = false;
        int nValidRows = 0;
        int[] rowHeights = new int[this.m_nRows];
        int h = 0;
        while (h < this.m_nRows) {
            rowHeights[h] = 0;
            ++h;
        }
        int row2 = 0;
        while (row2 < this.m_children.length) {
            TableRow rv = (TableRow)this.m_children[row2];
            rv.m_colWidths = this.m_colWidths;
            Rectangle bounds = rv.layoutSingleRowCells(xPos, yPos, width, info);
            rowHeights[row2] = bounds.height;
            if (bounds.height != 0) {
                ++nValidRows;
                yPos += bounds.height;
                yPos += this.m_cellSpacing;
            }
            ++row2;
        }
        xPos = x;
        yPos = y;
        int row3 = 0;
        while (row3 < this.m_children.length) {
            TableRow rv = (TableRow)this.m_children[row3];
            rowHeights = rv.layoutMultiRowCells(xPos, yPos, width, rowHeights, info);
            ++nValidRows;
            yPos += rowHeights[row3];
            yPos += this.m_cellSpacing;
            ++row3;
        }
        if (this.m_height != -1) {
            int row4;
            int tabHeight = 0;
            row = 0;
            while (row < rowHeights.length) {
                tabHeight += rowHeights[row];
                if (rowHeights[row] > 0 && this.m_cellSpacing > 0) {
                    tabHeight += this.m_cellSpacing;
                }
                ++row;
            }
            int[] diffs = new int[rowHeights.length];
            block4: while (this.m_height > tabHeight) {
                row4 = 0;
                while (row4 < rowHeights.length) {
                    int n = row4;
                    rowHeights[n] = rowHeights[n] + 1;
                    int n2 = row4++;
                    diffs[n2] = diffs[n2] + 1;
                    if (++tabHeight >= this.m_height) continue block4;
                }
            }
            row4 = 0;
            while (row4 < this.m_children.length && row4 < diffs.length) {
                if (diffs[row4] > 0) {
                    ((TableRow)this.m_children[row4]).increaseHeight(diffs[row4]);
                    if (row4 + 1 < this.m_children.length) {
                        this.moveRows(diffs[row4], (TableRow)this.m_children[row4 + 1]);
                    }
                }
                ++row4;
            }
        }
        int row5 = 0;
        while (row5 < this.m_children.length) {
            rowHeights = ((TableRow)this.m_children[row5]).setCellHeights(rowHeights, info);
            ++row5;
        }
        this.m_bounds.setBounds(x, y, 0, this.m_cellSpacing);
        row = 0;
        while (row < rowHeights.length) {
            this.m_bounds.height += rowHeights[row];
            if (rowHeights[row] > 0 && this.m_cellSpacing > 0) {
                this.m_bounds.height += this.m_cellSpacing;
            }
            ++row;
        }
        int row6 = 0;
        while (row6 < this.m_children.length) {
            TableRow rv = (TableRow)this.m_children[row6];
            rv.computeCellBorders();
            this.m_bounds.width = Math.max(this.m_bounds.width, rv.getBounds().width);
            ++row6;
        }
        this.m_bounds.width += 2 * this.m_cellSpacing;
        return this.m_bounds;
    }

    protected void loadResources() {
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].loadResources();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_topCaptions.length) {
            this.m_topCaptions[i2].loadResources();
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.m_bottomCaptions.length) {
            this.m_bottomCaptions[i3].loadResources();
            ++i3;
        }
    }

    protected void makeChildren(ViewFactory factory) {
        int nCount = this.m_elem.getElementCount();
        View[] childViews = new View[nCount];
        int nValidRows = 0;
        Vector<BlockView> topCaptions = new Vector<BlockView>();
        Vector<BlockView> botCaptions = new Vector<BlockView>();
        int i = 0;
        while (i < nCount) {
            Element childElement = this.m_elem.getElementAt(i);
            if (childElement.getType() == 3) {
                childViews[nValidRows++] = new TableRow(this, childElement, this.m_container);
            } else if (childElement.getType() == 45) {
                boolean bTop = true;
                String align = (String)childElement.getAttribute("align");
                if (align != null) {
                    bTop = !align.equalsIgnoreCase("bottom");
                }
                BlockView capView = new BlockView(this, childElement, this.m_container);
                capView.m_alignment = 1;
                if (bTop) {
                    topCaptions.addElement(capView);
                } else {
                    botCaptions.addElement(capView);
                }
            }
            ++i;
        }
        this.m_topCaptions = new View[topCaptions.size()];
        topCaptions.copyInto(this.m_topCaptions);
        int i2 = 0;
        while (i2 < this.m_topCaptions.length) {
            this.m_topCaptions[i2].makeChildren(factory);
            ++i2;
        }
        this.m_bottomCaptions = new View[botCaptions.size()];
        botCaptions.copyInto(this.m_bottomCaptions);
        int i3 = 0;
        while (i3 < this.m_bottomCaptions.length) {
            this.m_bottomCaptions[i3].makeChildren(factory);
            ++i3;
        }
        this.m_nDefinedRows = nValidRows;
        this.m_children = new View[nValidRows];
        int i4 = 0;
        while (i4 < nValidRows) {
            this.m_children[i4] = childViews[i4];
            ++i4;
        }
        int i5 = 0;
        while (i5 < this.m_children.length) {
            View child = this.m_children[i5];
            if (child != null) {
                child.makeChildren(factory);
            }
            ++i5;
        }
        this.initCellColumnRowValues();
        this.initColumnSpecs();
        this.initRowSpecs();
        this.notifyBorderSize();
    }

    protected View modelToView(int pos) {
        if (pos >= this.m_elem.m_p0 && pos <= this.m_elem.m_p1) {
            return this;
        }
        int i = 0;
        while (i < this.m_children.length) {
            View v = this.m_children[i].modelToView(pos);
            if (v != null) {
                return v;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_topCaptions.length) {
            View v = this.m_topCaptions[i2].modelToView(pos);
            if (v != null) {
                return v;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.m_bottomCaptions.length) {
            View v = this.m_bottomCaptions[i3].modelToView(pos);
            if (v != null) {
                return v;
            }
            ++i3;
        }
        return null;
    }

    public void move(int x, int y, boolean bMoveFloaters) {
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].move(x, y, bMoveFloaters);
            ++i;
        }
        this.m_bounds.x += x;
        this.m_bounds.y += y;
        this.m_tableBorder.x += x;
        this.m_tableBorder.y += y;
    }

    protected void moveRows(int yAmount, TableRow startRow) {
        int i = 0;
        while (i < this.m_children.length) {
            if (startRow == this.m_children[i]) {
                int j = i;
                while (j < this.m_children.length) {
                    ((TableRow)this.m_children[j]).move(0, yAmount, true);
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    protected void notifyBorderSize() {
        int cellBorderSize = this.m_borderSize > 0 ? 1 : 0;
        int row = 0;
        while (row < this.m_children.length) {
            TableRow rv = (TableRow)this.m_children[row];
            int cell = 0;
            while (cell < rv.m_children.length) {
                ((TableCell)rv.m_children[cell]).m_borderSize = cellBorderSize;
                ++cell;
            }
            ++row;
        }
    }

    protected int pageBreakAdjust(LayoutInfo info) {
        int adjustment = 0;
        int row = 0;
        while (row < this.m_children.length) {
            int rowAdjustment = this.m_children[row].pageBreakAdjust(info);
            if (rowAdjustment > 0 && row != this.m_children.length - 1) {
                int j = row + 1;
                while (j < this.m_children.length) {
                    this.m_children[j].move(0, rowAdjustment, true);
                    ++j;
                }
            }
            adjustment += rowAdjustment;
            ++row;
        }
        this.m_bounds.height += adjustment;
        return adjustment;
    }

    public void paint(Graphics g, Shape alloc) {
        Rectangle clip = alloc.getBounds();
        if (this.m_bounds.intersects(clip)) {
            int i = 0;
            while (i < this.m_topCaptions.length) {
                this.m_topCaptions[i].paint(g, alloc);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.m_bottomCaptions.length) {
                this.m_bottomCaptions[i2].paint(g, alloc);
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.m_children.length) {
                this.m_children[i3].paint(g, alloc);
                ++i3;
            }
            this.paintBorder(g);
        }
    }

    protected void paintBackground(Graphics g) {
        if (this.m_bgColor != null && this.m_bounds != null) {
            Color oldColor = g.getColor();
            g.setColor(this.m_bgColor);
            g.fillRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
            g.setColor(oldColor);
        }
    }

    protected void paintBorder(Graphics g) {
        Color oldColor = g.getColor();
        int x = this.m_tableBorder.x + this.m_insets.left;
        int y = this.m_tableBorder.y + this.m_insets.top;
        int w = this.m_tableBorder.width - 1 - (this.m_insets.left + this.m_insets.right);
        int h = this.m_tableBorder.height - 1 - (this.m_insets.bottom + this.m_insets.top);
        g.setColor(Utilities.getBrightBorderColor());
        int i = 0;
        while (i < this.m_borderSize) {
            g.drawLine(x + i, y + i, x + w - i, y + i);
            g.drawLine(x + i, y + i, x + i, y + h - i);
            ++i;
        }
        g.setColor(Utilities.getDarkBorderColor());
        int i2 = 0;
        while (i2 < this.m_borderSize) {
            g.drawLine(x + i2, y + h - i2, x + w - i2, y + h - i2);
            g.drawLine(x + w - i2, y + i2, x + w - i2, y + h - i2);
            ++i2;
        }
        g.setColor(oldColor);
    }

    protected void paintFocusBox(Graphics g, Shape alloc) {
        Rectangle clip = alloc.getBounds();
        if (this.m_bounds.intersects(clip)) {
            int i = 0;
            while (i < this.m_topCaptions.length) {
                this.m_topCaptions[i].paintFocusBox(g, alloc);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.m_bottomCaptions.length) {
                this.m_bottomCaptions[i2].paintFocusBox(g, alloc);
                ++i2;
            }
            int i3 = 0;
            while (i3 < this.m_children.length) {
                this.m_children[i3].paintFocusBox(g, alloc);
                ++i3;
            }
        }
    }

    protected void removeInvalidOccupiedColumns(Vector v, int row) {
        Vector<RowSpanColumns> temp = new Vector<RowSpanColumns>();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            RowSpanColumns x = (RowSpanColumns)e.nextElement();
            if (row > x.endRow) continue;
            temp.addElement(x);
        }
        v = temp;
    }

    protected ElementViewInfo viewToModel(int x, int y) {
        ElementViewInfo info = null;
        if (this.m_bounds.contains(x, y)) {
            int i;
            int i2 = 0;
            while (i2 < this.m_children.length) {
                info = this.m_children[i2].viewToModel(x, y);
                if (info != null) break;
                ++i2;
            }
            if (info == null) {
                i = 0;
                while (i < this.m_topCaptions.length) {
                    info = this.m_topCaptions[i].viewToModel(x, y);
                    if (info != null) break;
                    ++i;
                }
            }
            if (info == null) {
                i = 0;
                while (i < this.m_bottomCaptions.length) {
                    info = this.m_bottomCaptions[i].viewToModel(x, y);
                    if (info != null) break;
                    ++i;
                }
            }
            if (info == null) {
                info = new ElementViewInfo(this.m_elem, this);
            }
        }
        return info;
    }

    class RowSpanColumns {
        int[] columns;
        int endRow;

        RowSpanColumns() {
            TableView.this = TableView.this;
        }
    }
}

