/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.Utilities;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;

public class TextAttributes {
    static Color m_defaultColor = Color.black;
    Color m_color;
    Color m_focusColor = Color.red;
    String m_href;
    String m_target;
    boolean bUnderline = false;
    Font m_font;
    private Hashtable m_atts = new Hashtable();
    private static Hashtable m_fontMapping = new Hashtable();
    private static int m_downSizeIncrement = 2;
    private static int m_upSizeIncrement = 4;

    TextAttributes(TextAttributes copy) {
        Font copyFont = copy.m_font;
        this.m_font = new Font(copyFont.getName(), copyFont.getStyle(), copyFont.getSize());
        Hashtable ht = copy.m_atts;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.m_atts.get(key);
            if (value != null) {
                this.m_atts.put(key, value);
                continue;
            }
            this.m_atts.put(key, new String(""));
        }
        this.bUnderline = copy.bUnderline;
        this.m_color = copy.m_color;
        this.m_focusColor = copy.m_focusColor;
        this.m_href = copy.m_href;
        this.m_target = copy.m_target;
    }

    public TextAttributes(Font defFont) {
        this.m_font = defFont;
        int defaultSize = this.m_font.getSize();
        this.m_color = m_defaultColor;
        m_fontMapping.put("1", new Integer(defaultSize - 2 * m_downSizeIncrement));
        m_fontMapping.put("2", new Integer(defaultSize - m_downSizeIncrement));
        m_fontMapping.put("3", new Integer(defaultSize));
        m_fontMapping.put("4", new Integer(defaultSize + m_upSizeIncrement));
        m_fontMapping.put("5", new Integer(defaultSize + 2 * m_upSizeIncrement));
        m_fontMapping.put("6", new Integer(defaultSize + 3 * m_upSizeIncrement));
        m_fontMapping.put("7", new Integer(defaultSize + 4 * m_upSizeIncrement));
    }

    static Font createFont(Font f, String sz) {
        int size = TextAttributes.getFontSize(f.getSize(), sz);
        return new Font(f.getName(), f.getStyle(), size);
    }

    static int getFontSize(int origSize, String size) {
        int idx = (size = size.trim()).indexOf(43);
        if (idx != -1) {
            String val = size.substring(idx + 1);
            Integer i = Utilities.getInteger(val);
            if (i != null) {
                return origSize + i * m_upSizeIncrement;
            }
        } else {
            idx = size.indexOf(45);
            if (idx != -1) {
                Integer smallestSize = (Integer)m_fontMapping.get("1");
                String val = size.substring(idx + 1);
                Integer i = Utilities.getInteger(val);
                if (i != null) {
                    int sz = origSize - i * m_downSizeIncrement;
                    if (sz < smallestSize) {
                        return smallestSize;
                    }
                    return sz;
                }
            } else {
                Integer val = (Integer)m_fontMapping.get(size);
                if (val != null) {
                    return val;
                }
            }
        }
        return origSize;
    }

    void multiplexAttributes(Element elem) {
        elem.setAttribute("textcolor", this.m_color);
        elem.m_focusColor = this.m_focusColor;
        String value = (String)elem.getAttribute("underline");
        if (value == null || value.equals("false")) {
            value = this.bUnderline ? "true" : "false";
            elem.setAttribute("underline", value);
        }
        Enumeration e = this.m_atts.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            value = (String)this.m_atts.get(key);
            if (value == null || elem.getAttribute(key) != null) continue;
            elem.setAttribute(key, value);
        }
        if (this.m_href != null && this.m_href.length() > 0 && elem.getAttribute("href") == null) {
            elem.setAttribute("href", this.m_href);
        }
        if (this.m_target != null) {
            elem.setAttribute("target", this.m_target);
        }
    }

    void setAttribute(String key, Object value) {
        this.m_atts.put(key, value);
    }
}

