/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.ElementViewInfo;
import horst.FloatStackItem;
import horst.HTMLDocument;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.NBSPView;
import horst.TextView;
import horst.URLClassLoader;
import horst.Utilities;
import horst.ViewFactory;
import horst.ViewLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class View {
    public static final int Y_AXIS = 0;
    public static final int X_AXIS = 1;
    public static final int LEFT_ALIGN = 0;
    public static final int CENTER_ALIGN = 1;
    public static final int RIGHT_ALIGN = 2;
    static URLClassLoader m_classLoader = new URLClassLoader();
    protected View[] m_children;
    protected Rectangle m_bounds;
    protected Insets m_insets;
    protected Element m_elem;
    protected View m_parent;
    protected HTMLPane m_container;
    protected int m_alignment;
    protected ViewLine[] m_rows;
    protected View[] m_floaters;
    protected boolean m_bCanWrap;
    protected int m_prefWidth;
    protected int m_prefHeight;
    protected int m_minWidth;
    protected int m_minHeight;
    private Vector m_floats = new Vector();
    private int m_totalSpan;
    private int m_yPos;
    private int m_leftRenderingArea;
    private int m_targetWidth;
    private ViewLine m_line;
    private Vector m_layoutRows = new Vector();
    private View m_view;
    private Stack m_viewStack = new Stack();
    private Vector m_pushedViews = new Vector();

    public View(View parent, Element e, HTMLPane container) {
        this.m_container = container;
        this.m_parent = parent;
        this.m_elem = e;
        this.m_bCanWrap = true;
        this.m_insets = new Insets(0, 0, 0, 0);
        this.m_bounds = new Rectangle();
        this.m_children = new View[0];
        this.m_rows = new ViewLine[0];
        this.m_floaters = new View[0];
        this.m_alignment = 0;
        this.m_prefWidth = -1;
        this.m_prefHeight = -1;
        this.m_minWidth = -1;
        this.m_minHeight = -1;
        this.init();
    }

    protected boolean alignInBounds() {
        return false;
    }

    private boolean canBackTrack() {
        int sz;
        View v;
        int idx;
        if (this.m_view.getElementType() == 101) {
            int sz2 = this.m_line.vector.size();
            if (sz2 > 1) {
                View v2 = (View)this.m_line.vector.elementAt(sz2 - 2);
                if (v2.getElementType() != 101) {
                    v2 = this.m_line.getLastView();
                    this.m_totalSpan -= v2.getPreferredSpan(1);
                    this.m_viewStack.push(v2);
                    this.m_viewStack.push(this.m_view);
                    return true;
                }
            } else {
                return false;
            }
        }
        if ((idx = this.m_line.findNBSPBreak()) != -1 && (v = (View)this.m_line.vector.elementAt((sz = this.m_line.vector.size()) - 2)).getElementType() != 101) {
            int i = sz - 1;
            while (i >= idx) {
                v = this.m_line.removeView(i);
                this.m_totalSpan -= v.getPreferredSpan(1);
                this.m_viewStack.push(v);
                --i;
            }
            this.m_viewStack.push(this.m_view);
            return true;
        }
        return false;
    }

    protected boolean canSplit(int width) {
        return false;
    }

    protected boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    protected ViewLine createALine(int x, int y, int width) {
        ViewLine row = new ViewLine();
        row.x = x;
        row.y = y;
        row.alignment = this.m_alignment;
        row.parent = this;
        row.lineWidth = width;
        return row;
    }

    protected void dereference() {
        this.flushResources();
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].dereference();
            ++i;
        }
        this.m_elem = null;
        this.m_parent = null;
        this.m_container = null;
        this.m_rows = null;
        this.m_floaters = null;
    }

    protected View elementToView(Element e) {
        if (this.m_elem == e) {
            return this;
        }
        int row = 0;
        while (row < this.m_rows.length) {
            View[] views = this.m_rows[row].getViews();
            int j = 0;
            while (j < views.length) {
                View v = views[j].elementToView(e);
                if (v != null) {
                    return v;
                }
                ++j;
            }
            ++row;
        }
        return null;
    }

    protected synchronized void flushResources() {
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].flushResources();
            ++i;
        }
    }

    protected void forceLayout() {
        if (this.m_container != null) {
            this.m_container.forceLayout();
        }
    }

    protected Object getAttribute(Object key) {
        return this.m_elem.getAttributes().get(key);
    }

    public Rectangle getBounds() {
        return this.m_bounds;
    }

    protected int getDescent() {
        return 0;
    }

    protected HTMLDocument getDocument() {
        return this.m_container.getDocument();
    }

    protected int getElementType() {
        return this.m_elem.getType();
    }

    protected Font getFont() {
        Font f = this.m_elem.getFont();
        if (f == null) {
            f = new Font("Serif", 0, 12);
        }
        return f;
    }

    protected FontMetrics getFontMetrics() {
        return Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
    }

    protected int getMinimumSpan(int axis) {
        if (axis == 1) {
            if (this.m_minWidth != -1) {
                return this.m_minWidth;
            }
            boolean bLastNoBreakSpace = false;
            int maxRowSpan = 0;
            int span = 0;
            boolean bNewline = false;
            int nChildren = this.m_children.length;
            int i = 0;
            while (i < nChildren) {
                View v = this.m_children[i];
                if (bNewline || v.isNewlineView() || !bLastNoBreakSpace && this.m_bCanWrap && !v.isNoBreakSpace()) {
                    maxRowSpan = Math.max(maxRowSpan, span);
                    span = 0;
                    bNewline = false;
                }
                if (v instanceof TextView) {
                    boolean bCanWrap = this.m_bCanWrap;
                    if (bLastNoBreakSpace || i != nChildren - 1 && this.m_children[i + 1] instanceof NBSPView) {
                        bCanWrap = false;
                    }
                    span = bCanWrap ? (span += ((TextView)v).getMaximumTokenLength()) : (span += v.getMinimumSpan(1));
                } else {
                    span += v.getMinimumSpan(1);
                }
                bNewline = v.isNextViewOnNewLine();
                bLastNoBreakSpace = v.isNoBreakSpace();
                ++i;
            }
            maxRowSpan = Math.max(maxRowSpan, span);
            this.m_minWidth = maxRowSpan + this.m_insets.left + this.m_insets.right;
            return this.m_minWidth;
        }
        return 0;
    }

    protected int getPreferredSpan(int axis) {
        if (axis == 1) {
            if (this.m_prefWidth != -1) {
                return this.m_prefWidth;
            }
            int maxRowSpan = 0;
            int span = 0;
            boolean bNewline = false;
            int i = 0;
            while (i < this.m_children.length) {
                View v = this.m_children[i];
                if (v.isNewlineView() || bNewline) {
                    maxRowSpan = Math.max(maxRowSpan, span);
                    span = 0;
                    bNewline = false;
                }
                span += v.getPreferredSpan(1);
                bNewline = v.isNextViewOnNewLine();
                ++i;
            }
            maxRowSpan = Math.max(maxRowSpan, span);
            this.m_prefWidth = maxRowSpan + this.m_insets.left + this.m_insets.right;
            return this.m_prefWidth;
        }
        return 0;
    }

    protected Element getRootElement() {
        return this.m_container.getRootElement();
    }

    protected String getToolTipText() {
        return "";
    }

    protected void init() {
    }

    protected void invalidate() {
        this.m_prefWidth = -1;
        this.m_prefHeight = -1;
        this.m_minWidth = -1;
        this.m_minHeight = -1;
        View parent = this.m_parent;
        while (parent != null) {
            parent.invalidate();
            parent = parent.m_parent;
        }
    }

    protected boolean isAttributeDefined(Integer att) {
        return this.m_elem.getAttributes().containsKey(att);
    }

    protected boolean isBlockView() {
        return this.isNewlineView() && this.isNextViewOnNewLine();
    }

    protected boolean isContainerView() {
        return true;
    }

    protected boolean isDisplayableView() {
        return true;
    }

    protected boolean isFloater() {
        return false;
    }

    protected boolean isFloaterClearer() {
        return false;
    }

    protected boolean isLink() {
        return this.m_elem.getAttribute("href") != null;
    }

    protected boolean isNewlineView() {
        return false;
    }

    protected boolean isNextViewOnNewLine() {
        return false;
    }

    boolean isNoBreakSpace() {
        return false;
    }

    protected boolean isPlaceHolderView() {
        return false;
    }

    protected boolean isSelfContained() {
        return false;
    }

    protected boolean isSplittable() {
        return false;
    }

    protected boolean isWrappable() {
        return false;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        info.setPageBreak(y);
        this.m_bounds.setBounds(x, y, 0, 0);
        if (this.m_children.length == 0) {
            this.m_bounds.width += this.m_insets.right + this.m_insets.left;
            this.m_bounds.height += this.m_insets.top + this.m_insets.bottom;
            return this.m_bounds;
        }
        this.m_floats.removeAllElements();
        this.m_totalSpan = 0;
        this.m_viewStack.removeAllElements();
        int i = this.m_children.length - 1;
        while (i >= 0) {
            this.m_viewStack.push(this.m_children[i]);
            --i;
        }
        this.m_view = (View)this.m_viewStack.pop();
        this.m_yPos = y + this.m_insets.top;
        info.increaseInsetsRight(this.m_insets.right);
        info.increaseInsetsLeft(this.m_insets.left);
        this.m_leftRenderingArea = x + this.m_insets.left;
        width -= this.m_insets.left + this.m_insets.right;
        width = Math.max(0, width);
        this.m_line = this.createALine(this.m_leftRenderingArea, this.m_yPos, width);
        boolean bNewline = false;
        this.m_layoutRows.removeAllElements();
        this.m_targetWidth = Math.max(0, width - info.leftMargin - info.rightMargin);
        boolean bLastNoBreakSpace = false;
        while (true) {
            View[] splits;
            int availSpace;
            if (this.m_view.isPlaceHolderView()) {
                this.m_pushedViews.removeAllElements();
                this.pushOnViewStack(this.m_view.m_children, this.m_pushedViews);
                if (this.m_pushedViews.size() > 0) {
                    this.m_view = (View)this.m_viewStack.pop();
                    this.m_pushedViews.removeAllElements();
                }
            }
            if (this.m_view.isFloater()) {
                if (bNewline || this.m_line.isEmpty() || this.m_totalSpan == 0) {
                    if (!this.m_line.isEmpty()) {
                        this.startNewLine(width, info);
                    }
                    this.layoutFloater(width, info, this.m_view);
                    if (this.m_viewStack.empty()) break;
                    bLastNoBreakSpace = this.m_view.isNoBreakSpace();
                    this.m_view = (View)this.m_viewStack.pop();
                    continue;
                }
                if (!this.m_viewStack.empty()) {
                    info.pendingFloaters.addElement(this.m_view);
                    bLastNoBreakSpace = this.m_view.isNoBreakSpace();
                    this.m_view = (View)this.m_viewStack.pop();
                    continue;
                }
                if (!this.m_line.isEmpty()) {
                    this.startNewLine(width, info);
                }
                this.layoutFloater(width, info, this.m_view);
                break;
            }
            if (bNewline || this.m_view.isNewlineView()) {
                bNewline = false;
                if (!this.m_line.isEmpty()) {
                    this.startNewLine(width, info);
                }
                if (this.m_view.isBlockView()) {
                    this.m_line.addView(this.m_view);
                    this.startNewLine(width, info);
                    if (this.m_viewStack.empty()) break;
                    bLastNoBreakSpace = this.m_view.isNoBreakSpace();
                    this.m_view = (View)this.m_viewStack.pop();
                    continue;
                }
            }
            if ((this.m_totalSpan == 0 || this.m_line.isEmpty()) && !this.m_view.setToLineStarter()) {
                if (this.m_viewStack.empty()) break;
                this.m_view = (View)this.m_viewStack.pop();
                continue;
            }
            int span = this.m_view.getPreferredSpan(1);
            if (!this.m_bCanWrap || this.m_view.isNoBreakSpace() || bLastNoBreakSpace || this.m_totalSpan + span <= this.m_targetWidth) {
                String clearAtts;
                if (this.m_bCanWrap && this.m_totalSpan + span > this.m_targetWidth && this.canBackTrack()) {
                    this.startNewLine(width, info);
                    if (this.m_viewStack.empty()) break;
                    this.m_view = (View)this.m_viewStack.pop();
                    continue;
                }
                if (bLastNoBreakSpace && this.m_totalSpan + span > this.m_targetWidth && this.m_view.isSplittable()) {
                    availSpace = this.m_targetWidth - this.m_totalSpan;
                    splits = this.m_view.split(availSpace);
                    this.m_line.addView(splits[0]);
                    bLastNoBreakSpace = false;
                    this.startNewLine(width, info);
                    if (splits[1] != null) {
                        this.m_view = splits[1];
                        continue;
                    }
                    if (this.m_viewStack.empty()) break;
                    this.m_view = (View)this.m_viewStack.pop();
                    continue;
                }
                if (this.m_view.isDisplayableView()) {
                    this.m_line.addView(this.m_view);
                }
                if (this.m_view.getElementType() == 7 && (clearAtts = (String)this.m_view.getAttribute("clear")) != null) {
                    this.startNewLine(width, info);
                    int yEndPosition = -1;
                    if (clearAtts.equalsIgnoreCase("left")) {
                        yEndPosition = info.clearLeftMargin();
                    } else if (clearAtts.equalsIgnoreCase("right")) {
                        yEndPosition = info.clearRightMargin();
                    } else if (clearAtts.equalsIgnoreCase("all") || clearAtts.equalsIgnoreCase("both")) {
                        yEndPosition = info.clearMargins();
                    }
                    this.m_targetWidth = Math.max(0, width - info.leftMargin - info.rightMargin);
                    if (yEndPosition != -1 && yEndPosition > this.m_yPos) {
                        ViewLine emptyLine = this.createALine(this.m_leftRenderingArea, this.m_yPos, width);
                        emptyLine.bounds = new Rectangle(emptyLine.x, emptyLine.y, emptyLine.lineWidth, yEndPosition - this.m_yPos);
                        this.m_layoutRows.addElement(emptyLine);
                        this.m_yPos = yEndPosition;
                        this.m_line.y = yEndPosition;
                        if (this.m_viewStack.empty()) break;
                        bLastNoBreakSpace = this.m_view.isNoBreakSpace();
                        this.m_view = (View)this.m_viewStack.pop();
                        continue;
                    }
                }
                bNewline = this.m_view.isNextViewOnNewLine();
                this.m_totalSpan += span;
                if (!this.m_viewStack.empty()) {
                    bLastNoBreakSpace = this.m_view.isNoBreakSpace();
                    this.m_view = (View)this.m_viewStack.pop();
                    continue;
                }
                this.startNewLine(width, info);
                break;
            }
            availSpace = this.m_targetWidth - this.m_totalSpan;
            if (this.m_view.canSplit(availSpace)) {
                splits = this.m_view.split(availSpace);
                this.m_line.addView(splits[0]);
                this.startNewLine(width, info);
                this.m_view = splits[1];
                continue;
            }
            if (!this.m_line.isEmpty()) {
                this.startNewLine(width, info);
                continue;
            }
            if (this.m_view.isSplittable()) {
                splits = this.m_view.split(availSpace);
                this.m_line.addView(splits[0]);
                this.startNewLine(width, info);
                if (splits[1] != null) {
                    this.m_view = splits[1];
                    continue;
                }
                if (this.m_viewStack.empty()) break;
                this.m_view = (View)this.m_viewStack.pop();
                continue;
            }
            if (this.m_view.isDisplayableView()) {
                this.m_line.addView(this.m_view);
            }
            this.startNewLine(width, info);
            if (this.m_viewStack.empty()) break;
            bLastNoBreakSpace = this.m_view.isNoBreakSpace();
            this.m_view = (View)this.m_viewStack.pop();
        }
        this.m_rows = new ViewLine[this.m_layoutRows.size()];
        this.m_layoutRows.copyInto(this.m_rows);
        this.m_floaters = new View[this.m_floats.size()];
        this.m_floats.copyInto(this.m_floaters);
        int i2 = 0;
        while (i2 < this.m_rows.length) {
            this.m_bounds.add(this.m_rows[i2].bounds);
            ++i2;
        }
        if (this.m_alignment == 1 || this.m_alignment == 2) {
            int j = 0;
            while (j < this.m_rows.length) {
                this.m_rows[j].alignmentAdjust();
                ++j;
            }
            if (!this.alignInBounds() && this.m_bounds.width < width) {
                this.m_bounds.width = width;
            }
        }
        if (this.isFloaterClearer()) {
            int currentYEnd = this.m_bounds.y + this.m_bounds.height;
            int yEnd = info.clearMargins();
            if (yEnd > currentYEnd) {
                this.m_bounds.height += yEnd - currentYEnd;
            }
        }
        this.m_bounds.width += this.m_insets.right;
        this.m_bounds.height += this.m_insets.bottom;
        info.decreaseInsetsRight(this.m_insets.right);
        info.decreaseInsetsLeft(this.m_insets.left);
        return this.m_bounds;
    }

    protected void layoutFloater(int parentWidth, LayoutInfo info, View view) {
        LayoutInfo floaterInfo = new LayoutInfo();
        floaterInfo.bPaginate = info.bPaginate;
        int xOffset = view.m_alignment == 0 ? info.leftMargin : 0;
        Rectangle bounds = view.layout(this.m_leftRenderingArea + xOffset, this.m_yPos, this.m_targetWidth, floaterInfo);
        if (view.m_alignment == 2) {
            xOffset = Math.max(0, parentWidth - info.rightMargin - bounds.width);
            if (xOffset > 0) {
                view.move(xOffset, 0, true);
            }
            FloatStackItem item = new FloatStackItem(info.insetsRight + bounds.width, bounds.y + bounds.height);
            info.pushRight(item);
        } else {
            FloatStackItem item = new FloatStackItem(info.insetsLeft + bounds.width, bounds.y + bounds.height);
            info.pushLeft(item);
        }
        this.m_targetWidth = Math.max(0, parentWidth - info.leftMargin - info.rightMargin);
        this.saveFloater(view);
    }

    protected void layoutPendingFloaters(int x, int width, LayoutInfo info) {
        Rectangle bounds;
        int targetWidth;
        Vector<View> leftFloaters = new Vector<View>();
        Vector<View> rightFloaters = new Vector<View>();
        Enumeration e = info.pendingFloaters.elements();
        while (e.hasMoreElements()) {
            View floater = (View)e.nextElement();
            if (floater.m_alignment == 0) {
                leftFloaters.addElement(floater);
            } else {
                rightFloaters.addElement(floater);
            }
            this.saveFloater(floater);
        }
        int xPos = x;
        int renderingWidth = targetWidth = Math.max(0, width - info.rightMargin - info.leftMargin);
        Enumeration e2 = leftFloaters.elements();
        while (e2.hasMoreElements()) {
            View floater = (View)e2.nextElement();
            LayoutInfo subInfo = new LayoutInfo();
            bounds = floater.layout(xPos, this.m_yPos, renderingWidth, info);
            xPos += bounds.width;
            renderingWidth -= bounds.width;
            renderingWidth = Math.max(renderingWidth, 0);
            info.pushLeft(new FloatStackItem(bounds.width, bounds.y + bounds.height));
        }
        xPos = x;
        renderingWidth = targetWidth;
        Enumeration e3 = rightFloaters.elements();
        while (e3.hasMoreElements()) {
            View floater = (View)e3.nextElement();
            bounds = floater.layout(xPos, this.m_yPos, renderingWidth, new LayoutInfo());
            int xOffset = Math.max(0, renderingWidth - bounds.width);
            floater.move(xOffset, 0, true);
            renderingWidth -= bounds.width;
            renderingWidth = Math.max(renderingWidth, 0);
            info.pushRight(new FloatStackItem(bounds.width, bounds.y + bounds.height));
        }
        info.pendingFloaters.removeAllElements();
    }

    protected synchronized void loadResources() {
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].loadResources();
            ++i;
        }
    }

    protected void makeChildren(ViewFactory factory) {
        int nCount = this.m_elem.getElementCount();
        this.m_children = new View[nCount];
        int i = 0;
        while (i < nCount) {
            this.m_children[i] = factory.createView(this, this.m_elem.getElementAt(i), this.m_container);
            ++i;
        }
        int i2 = 0;
        while (i2 < nCount) {
            this.m_children[i2].makeChildren(factory);
            ++i2;
        }
    }

    protected View modelToView(int pos) {
        if (pos >= this.m_elem.m_p0 && pos <= this.m_elem.m_p1) {
            return this;
        }
        int row = 0;
        while (row < this.m_rows.length) {
            View[] views = this.m_rows[row].getViews();
            int j = 0;
            while (j < views.length) {
                View v = views[j].modelToView(pos);
                if (v != null) {
                    return v;
                }
                ++j;
            }
            ++row;
        }
        return null;
    }

    protected void move(int x, int y, boolean bMoveFloaters) {
        int i = 0;
        while (i < this.m_rows.length) {
            this.m_rows[i].move(x, y, bMoveFloaters);
            ++i;
        }
        if (bMoveFloaters) {
            Rectangle b = this.getBounds();
            int i2 = 0;
            while (i2 < this.m_floaters.length) {
                Rectangle floatBds = this.m_floaters[i2].getBounds();
                if (floatBds.x >= b.x && floatBds.x <= b.x + b.width) {
                    this.m_floaters[i2].move(x, y, bMoveFloaters);
                }
                ++i2;
            }
        }
        this.m_bounds.x += x;
        this.m_bounds.y += y;
    }

    protected int pageBreakAdjust(LayoutInfo info) {
        info.setPageBreak(this.getBounds().y);
        Rectangle origBounds = new Rectangle(this.m_bounds);
        int row = 0;
        while (row < this.m_rows.length) {
            int rowAdjustment = this.m_rows[row].pageBreakAdjust(info);
            if (rowAdjustment > 0 && row != this.m_rows.length - 1) {
                int j = row + 1;
                while (j < this.m_rows.length) {
                    this.m_rows[j].move(0, rowAdjustment, true);
                    ++j;
                }
            }
            ++row;
        }
        int i = 0;
        while (i < this.m_rows.length) {
            this.m_bounds.add(this.m_rows[i].bounds);
            ++i;
        }
        return this.m_bounds.height - origBounds.height;
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle clip = allocation.getBounds();
        if (this.m_bounds.intersects(clip)) {
            int row = 0;
            while (row < this.m_rows.length) {
                View[] views = this.m_rows[row].getViews();
                int j = 0;
                while (j < views.length) {
                    views[j].paint(g, clip);
                    ++j;
                }
                ++row;
            }
        }
    }

    protected void paintFocusBox(Graphics g, Shape allocation) {
        Rectangle clip = allocation.getBounds();
        if (this.m_bounds.intersects(clip)) {
            if (this.m_elem.getDrawFocusBox()) {
                g.setColor(Color.black);
                Utilities.drawDottedRectangle(g, this.m_bounds.x, this.m_bounds.y, this.m_bounds.width, this.m_bounds.height);
            }
            int row = 0;
            while (row < this.m_rows.length) {
                View[] views = this.m_rows[row].getViews();
                int j = 0;
                while (j < views.length) {
                    views[j].paintFocusBox(g, clip);
                    ++j;
                }
                ++row;
            }
        }
    }

    private void pushOnViewStack(View[] vws, Vector pushedViews) {
        if (vws != null) {
            int i = vws.length - 1;
            while (i >= 0) {
                if (vws[i] != null) {
                    if (vws[i].isPlaceHolderView()) {
                        this.pushOnViewStack(vws[i].m_children, pushedViews);
                    } else {
                        this.m_viewStack.push(vws[i]);
                        pushedViews.addElement(vws[i]);
                    }
                }
                --i;
            }
        }
    }

    protected void reset() {
        this.m_prefWidth = -1;
        this.m_minWidth = -1;
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].reset();
            ++i;
        }
    }

    protected void saveFloater(View v) {
        this.m_container.addFloater(v);
        this.m_floats.addElement(v);
    }

    protected void setCanWrap(boolean bWrap) {
        int i = 0;
        while (i < this.m_children.length) {
            if (!this.m_children[i].isSelfContained()) {
                this.m_children[i].setCanWrap(bWrap);
            }
            ++i;
        }
        this.m_bCanWrap = bWrap;
    }

    protected void setDimensions(int width, int height) {
        this.m_bounds.width += Math.max(0, width - this.m_bounds.width);
        this.m_bounds.height += Math.max(0, height - this.m_bounds.height);
    }

    protected void setInsets(int top, int left, int bottom, int right) {
        this.m_insets.top = top;
        this.m_insets.left = left;
        this.m_insets.bottom = bottom;
        this.m_insets.right = right;
    }

    protected boolean setToLineStarter() {
        return true;
    }

    protected View[] split(int width) {
        return null;
    }

    protected void startNewLine(int width, LayoutInfo info) {
        int yEnd;
        this.m_line.layout(width, this.m_targetWidth, info);
        this.m_yPos += this.m_line.height + this.m_line.descent;
        this.m_layoutRows.addElement(this.m_line);
        if (info.pendingFloaters.size() > 0) {
            this.layoutPendingFloaters(this.m_leftRenderingArea, width, info);
        }
        while (info.leftMargin > 0) {
            yEnd = info.getLeftYEnd();
            if (this.m_yPos < yEnd) break;
            info.popLeft();
        }
        while (info.rightMargin > 0) {
            yEnd = info.getRightYEnd();
            if (this.m_yPos < yEnd) break;
            info.popRight();
        }
        this.m_line = this.createALine(this.m_leftRenderingArea, this.m_yPos, width);
        this.m_totalSpan = 0;
        this.m_targetWidth = Math.max(0, width - info.leftMargin - info.rightMargin);
    }

    protected ElementViewInfo viewToModel(int x, int y) {
        ElementViewInfo info = null;
        Rectangle bounds = this.getBounds();
        if (bounds.contains(x, y)) {
            int row = 0;
            while (row < this.m_rows.length) {
                View[] views = this.m_rows[row].getViews();
                int j = 0;
                while (j < views.length) {
                    if (views[j].contains(x, y) && (info = views[j].viewToModel(x, y)) != null) break;
                    ++j;
                }
                ++row;
            }
            if (info == null) {
                info = new ElementViewInfo(this.m_elem, this);
            }
        }
        return info;
    }
}

