/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.BRView;
import horst.LayoutInfo;
import horst.View;
import java.awt.Rectangle;
import java.util.Vector;

public class ViewLine {
    Vector vector = new Vector();
    int x;
    int y;
    int alignment = 0;
    int descent = 0;
    int lineWidth;
    int height;
    Rectangle bounds;
    int xOffset;
    int renderedWidth;
    int savedTargetWidth;
    int savedParentWidth;
    View parent;

    ViewLine() {
    }

    void addView(View v) {
        this.vector.addElement(v);
    }

    void alignmentAdjust() {
        int availSpace;
        View[] vws = this.getViews();
        boolean bWrappableBlock = vws.length > 0 && vws[0].isBlockView() && vws[0].isWrappable();
        int n = availSpace = bWrappableBlock ? this.savedParentWidth - this.renderedWidth : this.savedTargetWidth - this.renderedWidth;
        if (availSpace > 0) {
            switch (this.alignment) {
                case 1: {
                    this.move(availSpace / 2, 0, true);
                    break;
                }
                case 2: {
                    this.move(availSpace, 0, true);
                    break;
                }
            }
        }
        if (bWrappableBlock) {
            this.bounds.width = this.savedTargetWidth;
        }
    }

    int findNBSPBreak() {
        int sz = this.vector.size();
        int i = sz - 1;
        while (i >= 0) {
            View v = (View)this.vector.elementAt(i);
            if (v.getElementType() == 101) {
                int idx = i - 2;
                if (idx < 0) break;
                View potentialView = (View)this.vector.elementAt(idx);
                if (potentialView.getElementType() != 101) {
                    return idx;
                }
            }
            --i;
        }
        return -1;
    }

    View getLastView() {
        int sz = this.vector.size();
        if (sz > 0) {
            return (View)this.vector.elementAt(sz - 1);
        }
        return null;
    }

    int getLastView(int type) {
        int sz = this.vector.size();
        int i = sz - 1;
        while (i >= 0) {
            View v = (View)this.vector.elementAt(i);
            if (v.getElementType() == 101) {
                return i;
            }
            --i;
        }
        return -1;
    }

    View[] getViews() {
        Object[] data = new View[this.vector.size()];
        this.vector.copyInto(data);
        return data;
    }

    boolean isEmpty() {
        return this.vector.size() == 0;
    }

    Rectangle layout(int parentWidth, int targetWidth, LayoutInfo info) {
        int xPos = this.x;
        int yPos = this.y;
        int rowHeight = 0;
        this.renderedWidth = 0;
        this.savedTargetWidth = targetWidth;
        this.savedParentWidth = parentWidth;
        int maxDescent = 0;
        int maxAboveBaseline = 0;
        View[] views = this.getViews();
        int nViews = views.length;
        int marginEnd = this.x + info.leftMargin;
        this.xOffset = 0;
        if (views.length == 1 && views[0] instanceof BRView) {
            int width = 0;
            this.height = ((BRView)views[0]).getBreakHeight();
            this.bounds = new Rectangle(this.x, this.y, width, rowHeight);
            views[0].layout(this.x, this.y, width, info);
            return this.bounds;
        }
        int i = 0;
        while (i < views.length) {
            View v = views[i];
            Rectangle bounds = null;
            boolean bContainerView = v.isContainerView();
            int layoutWidth = parentWidth;
            if (!v.isWrappable() && xPos < marginEnd) {
                this.x = xPos = (this.xOffset = marginEnd);
            }
            bounds = v.layout(xPos, yPos, layoutWidth, info);
            xPos += bounds.width;
            this.renderedWidth += bounds.width;
            maxDescent = Math.max(maxDescent, v.getDescent());
            int aboveBaseline = bounds.height;
            maxAboveBaseline = Math.max(maxAboveBaseline, aboveBaseline);
            ++i;
        }
        rowHeight = maxAboveBaseline;
        if (views.length > 1) {
            int i2 = 0;
            while (i2 < views.length) {
                View v = views[i2];
                int yAdjustment = maxAboveBaseline - v.getBounds().height;
                if (yAdjustment > 0) {
                    v.move(0, yAdjustment, true);
                }
                ++i2;
            }
        }
        if (info.bPaginate) {
            boolean bPageAdjustmentOccurred = false;
            int i3 = 0;
            while (i3 < views.length) {
                int yOffset;
                if (!views[i3].isContainerView() && views[i3].m_bounds.intersects(info.pageBreak) && (yOffset = info.pageBreak.y + info.pageBreak.height - views[i3].m_bounds.y) > 0 && views[i3].getMinimumSpan(0) <= info.pageHeight) {
                    views[i3].move(0, yOffset, false);
                    bPageAdjustmentOccurred = true;
                }
                ++i3;
            }
            if (bPageAdjustmentOccurred) {
                int topX = this.x;
                int topY = this.y;
                int lineWidth = this.renderedWidth;
                int biggestY = this.y;
                int i4 = 0;
                while (i4 < views.length) {
                    biggestY = Math.max(biggestY, views[i4].m_bounds.y + views[i4].m_bounds.height);
                    ++i4;
                }
                this.height = biggestY - topY;
            } else {
                this.height = rowHeight + maxDescent;
            }
            info.setPageBreak(this.y + this.height);
        } else {
            this.height = rowHeight + maxDescent;
        }
        this.descent = 0;
        this.bounds = new Rectangle(this.x, this.y, this.renderedWidth, this.height);
        info.setPageBreak(this.y + this.height);
        return this.bounds;
    }

    void move(int x, int y, boolean bMoveFloaters) {
        View[] views = this.getViews();
        int i = 0;
        while (i < views.length) {
            views[i].move(x, y, bMoveFloaters);
            ++i;
        }
        this.bounds.x += x;
        this.bounds.y += y;
    }

    int pageBreakAdjust(LayoutInfo info) {
        Rectangle origBounds = new Rectangle(this.bounds);
        info.setPageBreak(origBounds.y);
        View[] views = this.getViews();
        int i = 0;
        while (i < views.length) {
            if (!views[i].isContainerView()) {
                int yOffset;
                if (views[i].m_bounds.intersects(info.pageBreak) && (yOffset = info.pageBreak.y + info.pageBreak.height - views[i].m_bounds.y) > 0 && views[i].getMinimumSpan(0) <= info.pageHeight) {
                    views[i].move(0, yOffset, false);
                }
            } else {
                views[i].pageBreakAdjust(info);
            }
            ++i;
        }
        int biggestY = origBounds.y;
        int i2 = 0;
        while (i2 < views.length) {
            biggestY = Math.max(biggestY, views[i2].m_bounds.y + views[i2].m_bounds.height);
            ++i2;
        }
        this.height = biggestY - origBounds.y;
        this.bounds.setBounds(origBounds.x, origBounds.y, origBounds.width, this.height);
        return Math.max(0, this.bounds.height - origBounds.height);
    }

    View removeLastView() {
        View v = (View)this.vector.elementAt(this.vector.size() - 1);
        this.vector.removeElementAt(this.vector.size() - 1);
        return v;
    }

    View removeView(int idx) {
        View v = (View)this.vector.elementAt(idx);
        this.vector.removeElementAt(idx);
        return v;
    }
}

