/*
 * Decompiled with CFR 0.152.
 */
package horst.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ImageButton
extends Component
implements MouseListener {
    Image m_image;
    boolean m_bPressed = false;
    ActionEvent m_ae = new ActionEvent(this, 0, "");
    ActionListener m_al;

    public ImageButton() {
        this.addMouseListener(this);
    }

    public ImageButton(Image image) {
        this();
        this.m_image = image;
    }

    public void addActionListener(ActionListener al) {
        this.m_al = al;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(0, 0);
        if (this.m_image != null) {
            d.width = Math.max(0, this.m_image.getWidth(null));
            d.height = Math.max(0, this.m_image.getHeight(null));
        }
        return d;
    }

    public void mouseClicked(MouseEvent e) {
        this.m_bPressed = false;
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.m_bPressed) {
            this.m_bPressed = false;
            this.repaint();
        }
        this.m_bPressed = false;
    }

    public void mousePressed(MouseEvent e) {
        this.m_bPressed = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        boolean bPressed = this.m_bPressed;
        this.m_bPressed = false;
        this.repaint();
        if (this.m_al != null && bPressed) {
            this.m_al.actionPerformed(this.m_ae);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void removeActionListener(ActionListener al) {
        if (this.m_al == al) {
            this.m_al = null;
        }
    }

    public void setImage(Image img) {
        this.m_image = img;
    }

    public void update(Graphics g) {
        Dimension dim = this.getSize();
        g.setColor(Color.black);
        if (this.m_image != null) {
            double fRatio = Math.min((double)dim.width / (double)this.m_image.getWidth(this), (double)dim.height / (double)this.m_image.getHeight(this));
            int width = (int)(fRatio * (double)this.m_image.getWidth(this));
            int height = (int)(fRatio * (double)this.m_image.getHeight(this));
            int x = (dim.width - width) / 2;
            int y = (dim.height - height) / 2;
            if (!this.m_bPressed) {
                g.drawImage(this.m_image, x + 2, y + 2, width - 4, height - 4, this);
            } else {
                g.drawImage(this.m_image, x + 4, y + 4, width - 6, height - 6, this);
            }
        }
    }
}

