/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2Caret;
import horst.controls.o2.O2Choice;
import horst.controls.o2.O2Label;
import horst.controls.o2.O2Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;

public class O2 {
    public static final int C = 10;
    public static final int E = 13;
    public static final int N = 11;
    public static final int NE = 12;
    public static final int NW = 18;
    public static final int S = 15;
    public static final int SE = 14;
    public static final int SW = 16;
    public static final int W = 17;
    public static final int F = 100;
    public static final int R = 0;
    public static final int DEFAULT_PAD = 4;
    public static final int DEFAULT_DOUBLECLICKMS = 500;
    public static final int LAF_DEFAULT = 0;
    private static int lookAndFeel;
    private static int pad;
    private static int choiceNRows;
    private static int doubleClickMS;
    private static Font arrowFont;
    private static O2Caret o2Caret;

    static {
        pad = 4;
        choiceNRows = 8;
        doubleClickMS = 500;
    }

    public static void constrain(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, int insetAll, int anchor) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.gridheight = gridheight;
        c.weightx = weightx;
        c.weighty = weighty;
        c.insets = new Insets(insetAll, insetAll, insetAll, insetAll);
        c.anchor = anchor == 100 ? 17 : anchor;
        c.fill = anchor == 100 ? 1 : 0;
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    public static void drawBox(Graphics g, int x, int y, int width, int height, boolean raised, boolean wide, Color interior) {
        int[] xa = new int[3];
        int[] ya = new int[3];
        if (wide) {
            xa[0] = x;
            ya[0] = y + height - 1;
            xa[1] = x;
            ya[1] = y;
            xa[2] = x + width - 1;
            ya[2] = y;
            g.setColor(raised ? Color.white : Color.gray);
            g.drawPolyline(xa, ya, 3);
            xa[1] = x + width - 1;
            ya[1] = y + height - 1;
            g.setColor(raised ? Color.black : Color.white);
            g.drawPolyline(xa, ya, 3);
            xa[0] = x + 1;
            ya[0] = y + height - 2;
            xa[1] = x + 1;
            ya[1] = y + 1;
            xa[2] = x + width - 2;
            ya[2] = y + 1;
            g.setColor(raised ? Color.lightGray : Color.black);
            g.drawPolyline(xa, ya, 3);
            xa[1] = x + width - 2;
            ya[1] = y + height - 2;
            g.setColor(raised ? Color.gray : Color.lightGray);
            g.drawPolyline(xa, ya, 3);
            if (interior != null) {
                g.setColor(interior);
                g.fillRect(x + 2, y + 2, width - 4, height - 4);
            }
        } else {
            xa[0] = x;
            ya[0] = y + height - 1;
            xa[1] = x;
            ya[1] = y;
            xa[2] = x + width - 1;
            ya[2] = y;
            g.setColor(raised ? Color.white : Color.black);
            g.drawPolyline(xa, ya, 3);
            xa[1] = x + width - 1;
            ya[1] = y + height - 1;
            g.setColor(raised ? Color.black : Color.white);
            g.drawPolyline(xa, ya, 3);
            if (interior != null) {
                g.setColor(interior);
                g.fillRect(x + 1, y + 1, width - 2, height - 2);
            }
        }
    }

    public static void drawCheck(Graphics g, int left, int top, int size, boolean enabled) {
        int s2 = size / 2;
        int s4 = size / 4;
        int s8 = Math.max(size / 8, 1);
        int th = s4;
        int offset = (size - s2 - s4) / 2;
        int[] xa = new int[6];
        int[] ya = new int[6];
        xa[0] = (left += offset) + s4 + s2;
        ya[0] = top += offset;
        xa[1] = left + s4;
        ya[1] = top + s2;
        xa[2] = left;
        ya[2] = top + s2 - s4;
        xa[3] = left;
        ya[3] = top + s2 - s4 + th;
        xa[4] = left + s4;
        ya[4] = top + s2 + th;
        xa[5] = left + s4 + s2;
        ya[5] = top + th;
        g.setColor(enabled ? Color.black : Color.gray);
        g.fillPolygon(xa, ya, 6);
    }

    public static void drawCircularBox(Graphics g, int x, int y, int size, boolean wide, Color interior) {
        if (interior != null) {
            g.setColor(interior);
            if (wide) {
                g.fillOval(x + 2, y + 2, size - 4, size - 4);
            } else {
                g.fillOval(x + 1, y + 1, size - 2, size - 2);
            }
        }
        g.setColor(wide ? Color.gray : Color.black);
        g.drawArc(x, y, size, size, 45, 180);
        if (wide) {
            g.setColor(Color.black);
            g.drawArc(x + 1, y + 1, size - 2, size - 2, 45, 180);
        }
        g.setColor(Color.white);
        g.drawArc(x, y, size, size, 225, 180);
        if (wide) {
            g.setColor(Color.lightGray);
            g.drawArc(x + 1, y + 1, size - 2, size - 2, 225, 180);
        }
    }

    public static void drawCircularCheck(Graphics g, int x, int y, int size, boolean enabled) {
        int margin = size < 12 ? 1 : (size <= 18 ? 2 : 4);
        int size2 = size - 2 * (2 + margin);
        int offset = 2 + margin;
        g.setColor(enabled ? Color.black : Color.gray);
        g.fillOval(x + offset, y + offset, size2, size2);
    }

    public static void drawDottedRect(Graphics g, int x, int y, int width, int height) {
        int x2 = x + width;
        int y2 = y + height;
        int i = x;
        while (i <= x2) {
            g.drawLine(i, y, i, y);
            g.drawLine(i, y2, i, y2);
            i += 2;
        }
        i = y;
        while (i <= y2) {
            g.drawLine(x, i, x, i);
            g.drawLine(x2, i, x2, i);
            i += 2;
        }
    }

    public static void drawString(Graphics g, String s, int x, int y, boolean enabled, Color background, Color foreground) {
        if (enabled) {
            g.setColor(foreground);
            g.drawString(s, x, y);
            return;
        }
        g.setColor(Color.white);
        g.drawString(s, x + 1, y);
        g.setColor(background.darker());
        g.drawString(s, x, y - 1);
    }

    public static int ensureOnScreenX(int x, int width) {
        x = Math.min(x, O2.screenWidth() - width);
        x = Math.max(x, 0);
        return x;
    }

    public static int ensureOnScreenY(int y, int height) {
        y = Math.min(y, O2.screenHeight() - height - 30);
        y = Math.max(y, 0);
        return y;
    }

    public static String fileDialog(Frame frame, String windowTitle, int mode, String dir, String mask) {
        ((Component)frame).setCursor(Cursor.getPredefinedCursor(3));
        FileDialog fileDialog = new FileDialog(frame, windowTitle, mode);
        if (dir.length() > 0) {
            fileDialog.setDirectory(dir);
        }
        fileDialog.setFile(mask);
        fileDialog.pack();
        Rectangle bounds = frame.getBounds();
        O2.setLocation(fileDialog, bounds.x, bounds.y);
        ((Component)frame).setCursor(Cursor.getDefaultCursor());
        ((Component)fileDialog).setVisible(true);
        return fileDialog.getFile() == null ? "" : String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
    }

    public static Font getArrowFont() {
        if (arrowFont == null) {
            arrowFont = new Font("Dialog", 0, 12);
        }
        return arrowFont;
    }

    public static O2Caret getCaret() {
        if (o2Caret == null) {
            o2Caret = new O2Caret();
            Thread thread = new Thread(o2Caret);
            o2Caret.setThread(thread);
            thread.setPriority(Thread.currentThread().getPriority() + 1);
            thread.start();
            thread.suspend();
        }
        return o2Caret;
    }

    public static int getChoiceNRows() {
        return choiceNRows;
    }

    public static String getClipboard() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String s = "";
            Transferable transferable = clipboard.getContents(s);
            if (transferable == null) {
                return "";
            }
            Object o = transferable.getTransferData(DataFlavor.stringFlavor);
            if (o == null) {
                return "";
            }
            return (String)o;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static O2Spacer getCorner() {
        return new O2Spacer(14, 14);
    }

    public static int getDoubleClickMS() {
        return doubleClickMS;
    }

    public static Image getImage(String dir, String name, int waitMS) {
        try {
            if (!O2.isFile(dir, name)) {
                System.err.println("GUI.getImage: File doesn't exist: " + dir + name);
                return null;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(String.valueOf(dir) + name);
            int seconds10 = 0;
            int timeOut10 = waitMS / 100;
            while (seconds10 < timeOut10 && !toolkit.prepareImage(image, -1, -1, null)) {
                O2.sleep(100);
                ++seconds10;
            }
            if (seconds10 >= timeOut10) {
                System.err.println("GUI.getImage: Timeout while loading: " + dir + name);
                return null;
            }
            return image;
        }
        catch (Throwable t) {
            System.err.println("GUI.getImage threw exception:\n" + t.toString());
            return null;
        }
    }

    public static int getLookAndFeel() {
        return lookAndFeel;
    }

    public static int getPad() {
        return pad;
    }

    public static int getStringHeight(FontMetrics fm) {
        return fm.getHeight() * 7 / 10 - 1;
    }

    public static void init() {
    }

    public static boolean isFile(String dir, String name) {
        try {
            File file = new File(dir, name);
            return file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final int minMax(int min, int max, int current) {
        return current < min ? min : (current > max ? max : current);
    }

    public static Panel multiLineLabel(String message, int alignment, boolean monospaced, int fontSize) {
        char endOfLineChar = message.indexOf(10) >= 0 ? (char)'\n' : '\r';
        int messageLength = message.length();
        int maxBufferSize = 1000;
        char[] buffer = new char[maxBufferSize];
        int bufferSize = 0;
        Panel multi = new Panel();
        if (fontSize < 8 || fontSize > 24) {
            fontSize = 12;
        }
        --fontSize;
        Font monoFont = null;
        multi.setLayout(new GridLayout(0, 1));
        boolean nLines = false;
        int po = 0;
        while (po < messageLength) {
            char ch = message.charAt(po);
            if (ch != '\r' && ch != '\n' && bufferSize < maxBufferSize) {
                buffer[bufferSize++] = ch;
            }
            if (ch == endOfLineChar || po == messageLength - 1) {
                String s = new String(buffer, 0, bufferSize);
                if (s.startsWith("<")) {
                    if (s.startsWith("<tt>") || s.startsWith("<TT>")) {
                        monospaced = true;
                        s = s.substring(4);
                    }
                    if (s.startsWith("</tt>") || s.startsWith("</TT>")) {
                        monospaced = false;
                        s = s.substring(5);
                    }
                }
                O2Label label = new O2Label(s, alignment);
                if (monospaced) {
                    if (monoFont == null) {
                        monoFont = new Font("Monospaced", 0, fontSize);
                    }
                    label.setFont(monoFont);
                }
                multi.add(label);
                bufferSize = 0;
            }
            ++po;
        }
        return multi;
    }

    public static int screenHeight() {
        return Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    public static int screenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width;
    }

    public static void select(O2Choice choice, int index) {
        choice.select(index);
    }

    public static void select(O2Choice choice, String item) {
        choice.select(item);
    }

    public static void setBounds(Window w, int x, int y, int width, int height) {
        ((Component)w).setBounds(O2.ensureOnScreenX(x, width), O2.ensureOnScreenY(y, height), width, height);
    }

    public static void setChoiceNRows(int i) {
        choiceNRows = O2.validateChoiceNRows(i);
    }

    public static String setClipboard(String s) {
        try {
            if (s.length() > 500000 && System.getProperty("os.name").indexOf("Windows") >= 0) {
                return "Error: Too much data (>500,000 characters)" + System.getProperty("line.separator") + "for the Windows Clipboard.";
            }
            StringSelection ss = new StringSelection(s);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
            return "";
        }
        catch (Throwable t) {
            return t.toString();
        }
    }

    public static void setDefaultCursor(Component component) {
        component.setCursor(Cursor.getDefaultCursor());
    }

    public static void setDoubleClickMS(int ms) {
        doubleClickMS = O2.minMax(1, 5000, ms);
    }

    public static String setFrameIcon(Frame frame, String dir, String name) {
        Image image = O2.getImage(dir, name, 2000);
        if (image != null) {
            frame.setIconImage(image);
        }
        return "";
    }

    public static void setLocation(Window w, int x, int y) {
        ((Component)w).setLocation(O2.ensureOnScreenX(x, w.getSize().width), O2.ensureOnScreenY(y, w.getSize().height));
    }

    public static void setLookAndFeel(int laf) {
        lookAndFeel = O2.minMax(0, 0, laf);
    }

    public static void setPad(int p) {
        pad = O2.validatePad(p);
    }

    public static void setWaitCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void showLeftWindow(Window w, Rectangle bounds) {
        Dimension size = w.getSize();
        O2.showWindow(w, bounds.x - size.width, bounds.y);
    }

    public static void showOffsetWindow(Window w, Rectangle bounds) {
        O2.showWindow(w, bounds.x, bounds.y + 20);
    }

    public static void showWindow(Window w, int x, int y) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = w.getSize();
        int okHeight = screen.height - 50;
        int okWidth = screen.width - 10;
        if (window.height > okHeight || window.width > okWidth) {
            O2.showWindow(w, x, y, Math.min(window.width, okWidth), Math.min(window.height, okHeight));
            return;
        }
        O2.setLocation(w, x, y);
        ((Component)w).setVisible(true);
    }

    public static void showWindow(Window w, int x, int y, int width, int height) {
        O2.setBounds(w, x, y, width, height);
        ((Component)w).setVisible(true);
    }

    public static void sleep(int millis) {
        if (millis <= 0) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {}
    }

    public static int validateChoiceNRows(int i) {
        return O2.minMax(3, 50, i);
    }

    public static int validatePad(int p) {
        return O2.minMax(0, 20, p);
    }
}

