/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class O2Button
extends Component {
    public static final int CENTER = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    public static final String DOWN_TRIANGLE = "&dtrif;";
    public static final String LEFT_TRIANGLE = "&ltrif;";
    public static final String RIGHT_TRIANGLE = "&rtrif;";
    public static final String UP_TRIANGLE = "&utrif;";
    private String label;
    private String actionCommand;
    private int labelSpecial;
    private int alignment;
    private int pad = O2.getPad();
    private boolean pressed = false;
    private boolean hasFocus = false;
    private boolean focusTraversable = true;
    private int stringWidth = -1;
    private int stringHeight;
    private int maxDescent;
    private static final int borderWidth = 1;
    private ActionListener actionListener;
    private long lastActionTime;
    private static boolean respondToEnter;
    private static boolean twoClicksTwoEvents;

    public O2Button() {
        this("", 1);
    }

    public O2Button(String label) {
        this(label, 1);
    }

    public O2Button(String label, int alignment) {
        this.label = label;
        this.setLabelSpecial();
        this.alignment = alignment == 0 ? 0 : (alignment == 2 ? 2 : 1);
        this.enableEvents(60L);
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    private void calculateStringSize() {
        Font f = this.getFont();
        if (f == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.stringWidth = fm.stringWidth(this.label);
        this.stringHeight = O2.getStringHeight(fm);
        this.maxDescent = fm.getMaxDescent();
    }

    private void fireActionEvent() {
        long currentTime = System.currentTimeMillis();
        if (twoClicksTwoEvents || currentTime - this.lastActionTime > (long)O2.getDoubleClickMS()) {
            this.processEvent(new ActionEvent(this, 1001, this.getActionCommand()));
            this.lastActionTime = currentTime;
        } else {
            this.lastActionTime = 0L;
        }
    }

    public String getActionCommand() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getLabel() {
        return this.label;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPad() {
        return this.pad;
    }

    public Dimension getPreferredSize() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return new Dimension(14, 14);
            }
        }
        if (this.labelSpecial > 0) {
            int size = this.stringHeight + 2 * (1 + this.pad + 1);
            return new Dimension(size, size);
        }
        int descentPadBorder2 = 2 * (this.maxDescent + this.pad + 1);
        return new Dimension(this.stringWidth + descentPadBorder2, this.stringHeight + descentPadBorder2);
    }

    public static boolean getRespondToEnter() {
        return respondToEnter;
    }

    public static boolean getTwoClicksTwoEvents() {
        return twoClicksTwoEvents;
    }

    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public void myRepaint() {
        this.paint(this.getGraphics());
    }

    public void needsToBeRecalculated() {
        this.stringWidth = -1;
    }

    public void paint(Graphics g) {
        int offset;
        if (g == null) {
            return;
        }
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return;
            }
        }
        int width = this.getSize().width;
        int height = this.getSize().height;
        Color foreground = this.getForeground();
        Color background = this.getBackground();
        boolean enabled = this.isEnabled();
        O2.drawBox(g, 0, 0, width, height, !this.pressed, this.pad > 0, background);
        int n = offset = this.pressed ? 1 : 0;
        if (this.labelSpecial > 0) {
            g.setColor(enabled ? foreground : Color.white);
            int ox = offset + 1 + (this.alignment == 0 ? 1 + this.pad + 1 : (this.alignment == 2 ? width - 1 - this.pad - 1 - this.stringWidth : (width - this.stringHeight) / 2));
            int oy = offset + 1 + (height - this.stringHeight) / 2;
            int sh2 = (this.stringHeight - 2) / 2;
            int sh = sh2 + sh2;
            int pd = (this.stringHeight - 4 - sh2) / 2;
            int sh3 = sh2 + pd;
            int[] xa = null;
            int[] ya = null;
            if (this.labelSpecial == 1) {
                xa = new int[]{ox, ox + sh, ox + sh2};
                ya = new int[]{oy + pd, oy + pd, oy + sh3};
            } else if (this.labelSpecial == 2) {
                xa = new int[]{ox + pd, ox + sh3, ox + sh3};
                ya = new int[]{oy + sh2, oy, oy + sh};
            } else if (this.labelSpecial == 3) {
                xa = new int[]{ox + pd, ox + sh3, ox + pd};
                ya = new int[]{oy, oy + sh2, oy + sh};
            } else if (this.labelSpecial == 4) {
                xa = new int[]{ox, ox + sh2, ox + sh};
                ya = new int[]{oy + sh3, oy + pd, oy + sh3};
            }
            g.fillPolygon(xa, ya, 3);
            g.drawPolygon(xa, ya, 3);
            if (!enabled) {
                int i = 0;
                while (i < 3) {
                    int n2 = i;
                    xa[n2] = xa[n2] - 1;
                    int n3 = i++;
                    ya[n3] = ya[n3] - 1;
                }
                g.setColor(background.darker());
                g.fillPolygon(xa, ya, 3);
                g.drawPolygon(xa, ya, 3);
            }
        } else {
            g.setFont(this.getFont());
            O2.drawString(g, this.label, offset + (this.alignment == 0 ? this.maxDescent + this.pad + 1 : (this.alignment == 2 ? width - this.maxDescent - this.stringWidth - this.pad - 1 : (width - this.stringWidth) / 2)), offset + (height + this.stringHeight) / 2, enabled, background, foreground);
        }
        if (this.hasFocus) {
            O2.drawDottedRect(g, 2, 2, width - 5, height - 5);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null && e.getID() == 1001) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    public void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            if (!this.hasFocus) {
                this.hasFocus = true;
                this.myRepaint();
            }
        } else if (id == 1005 && this.hasFocus) {
            this.hasFocus = false;
            this.myRepaint();
        }
        super.processFocusEvent(e);
    }

    public void processKeyEvent(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (respondToEnter && e.getKeyCode() == 10) {
            if (e.getID() == 401 && !this.pressed) {
                if (!this.hasFocus) {
                    this.requestFocus();
                }
                this.pressed = true;
                this.myRepaint();
            }
            if (e.getID() == 402) {
                this.pressed = false;
                this.myRepaint();
                this.fireActionEvent();
            }
        }
        super.processKeyEvent(e);
    }

    public void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int id = e.getID();
        if (id == 501) {
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0 && !this.pressed) {
                this.pressed = true;
                this.myRepaint();
                if (!this.hasFocus) {
                    this.requestFocus();
                }
            }
        } else if (id == 502) {
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0 && this.pressed) {
                this.pressed = false;
                this.myRepaint();
                if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0) {
                    this.fireActionEvent();
                }
            }
        } else if (id == 505 && this.pressed) {
            this.pressed = false;
            this.myRepaint();
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    public void setActionCommand(String s) {
        this.actionCommand = s;
    }

    public void setAlignment(int a) {
        int n = a == 0 ? 0 : (a = a == 2 ? 2 : 1);
        if (a != this.alignment) {
            this.alignment = a;
            this.myRepaint();
        }
    }

    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            super.setEnabled(e);
            this.pressed = false;
            this.myRepaint();
        }
    }

    public void setFocusTraversable(boolean t) {
        this.focusTraversable = t;
    }

    public void setFont(Font f) {
        if (f != this.getFont()) {
            this.stringWidth = -1;
            super.setFont(f);
            this.myRepaint();
        }
    }

    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            super.setForeground(c);
            this.myRepaint();
        }
    }

    public void setLabel(String tLabel) {
        if (!tLabel.equals(this.label)) {
            this.stringWidth = -1;
            this.label = tLabel;
            this.setLabelSpecial();
            this.myRepaint();
        }
    }

    private void setLabelSpecial() {
        if (this.label.length() == 0 || this.label.charAt(0) != '&') {
            this.labelSpecial = 0;
            return;
        }
        this.labelSpecial = this.label.equals(DOWN_TRIANGLE) ? 1 : (this.label.equals(LEFT_TRIANGLE) ? 2 : (this.label.equals(RIGHT_TRIANGLE) ? 3 : (this.label.equals(UP_TRIANGLE) ? 4 : 0)));
    }

    public void setPad(int p) {
        if (this.pad != (p = O2.validatePad(p))) {
            this.pad = p;
            this.myRepaint();
        }
    }

    public static void setRespondToEnter(boolean b) {
        respondToEnter = b;
    }

    public static void setTwoClicksTwoEvents(boolean b) {
        twoClicksTwoEvents = b;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

