/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class O2Caret
implements Runnable {
    private boolean active = false;
    private boolean visible = false;
    private boolean drawInUse = false;
    private boolean wide = false;
    private int x;
    private int y1;
    private int y2;
    private int delay = 500;
    private Component component;
    private Thread thread;

    public void activate(Component tComponent, int tx, int ty1, int ty2) {
        if (tComponent != this.component) {
            return;
        }
        if (this.active) {
            this.deactivate(tComponent);
        }
        if (this.drawInUse) {
            this.waitForDrawNotInUse();
        }
        this.drawInUse = true;
        this.x = tx;
        this.y1 = ty1;
        this.y2 = ty2;
        this.draw();
        this.visible = true;
        this.active = true;
        this.drawInUse = false;
    }

    public void deactivate(Component tComponent) {
        if (tComponent != this.component) {
            return;
        }
        if (!this.active) {
            return;
        }
        if (this.drawInUse) {
            this.waitForDrawNotInUse();
        }
        this.drawInUse = true;
        if (this.visible) {
            this.draw();
            this.visible = false;
        }
        this.active = false;
        this.drawInUse = false;
    }

    private void draw() {
        Graphics g = this.component.getGraphics();
        if (g == null) {
            return;
        }
        g.setXORMode(Color.white);
        g.drawLine(this.x, this.y1, this.x, this.y2);
        if (Math.abs(this.y1 - this.y2) > 13) {
            g.drawLine(this.x + 1, this.y1, this.x + 1, this.y2);
        }
        g.setPaintMode();
    }

    public boolean getActive() {
        return this.active;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getDelay() {
        return this.delay;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.delay);
                    if (!this.active || this.drawInUse) continue;
                    this.drawInUse = true;
                    this.draw();
                    this.visible = !this.visible;
                    this.drawInUse = false;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public void setComponent(Component tComponent) {
        this.deactivate(this.component);
        this.component = tComponent;
        if (this.thread != null) {
            if (this.component == null) {
                this.thread.suspend();
            } else {
                this.thread.resume();
            }
        }
    }

    public void setDelay(int tDelay) {
        this.delay = O2.minMax(1, 10000, tDelay);
    }

    public void setThread(Thread tThread) {
        this.thread = tThread;
    }

    private void waitForDrawNotInUse() {
        int count = 0;
        int max = this.delay / 10 + 2;
        while (this.drawInUse && count < max) {
            O2.sleep(10);
            ++count;
        }
    }
}

