/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2;
import horst.controls.o2.O2CheckboxGroup;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class O2Checkbox
extends Component
implements ItemSelectable {
    String label;
    private int pad = O2.getPad();
    private int boxSize;
    private int boxX;
    private int boxY;
    private boolean state = false;
    private boolean pressed = false;
    private boolean hasFocus = false;
    private int stringWidth = -1;
    private int stringHeight;
    private int maxDescent;
    private O2CheckboxGroup o2CheckboxGroup;
    private ItemListener itemListener;
    private long lastItemTime;
    private static final int borderWidth = 1;
    private static boolean respondToEnter;
    private static boolean twoClicksTwoEvents;

    public O2Checkbox() {
        this("", false, null);
    }

    public O2Checkbox(String label) {
        this(label, false, null);
    }

    public O2Checkbox(String label, O2CheckboxGroup group, boolean state) {
        this(label, state, group);
    }

    public O2Checkbox(String label, boolean state) {
        this(label, state, null);
    }

    public O2Checkbox(String label, boolean state, O2CheckboxGroup group) {
        this.label = label;
        this.state = state;
        this.o2CheckboxGroup = group;
        this.enableEvents(60L);
    }

    public void addItemListener(ItemListener il) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, il);
    }

    private void calculateStringSize() {
        Font f = this.getFont();
        if (f == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.stringWidth = fm.stringWidth(this.label);
        this.stringHeight = O2.getStringHeight(fm);
        this.maxDescent = fm.getMaxDescent();
    }

    private void fireItemEvent() {
        if (this.o2CheckboxGroup != null && this.o2CheckboxGroup.getSelectedCheckbox() == this) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (twoClicksTwoEvents || currentTime - this.lastItemTime > (long)O2.getDoubleClickMS()) {
            this.setState(!this.state);
            this.processEvent(new ItemEvent(this, 701, this.getLabel(), this.state ? 1 : 2));
            this.lastItemTime = currentTime;
        } else {
            this.lastItemTime = 0L;
        }
    }

    public O2CheckboxGroup getCheckboxGroup() {
        return this.o2CheckboxGroup;
    }

    public String getLabel() {
        return this.label;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPad() {
        return this.pad;
    }

    public Dimension getPreferredSize() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return new Dimension(14, 14);
            }
        }
        int y = 1 + this.pad + this.maxDescent + this.stringHeight + this.maxDescent + this.pad + 1;
        return new Dimension(y - 2 * this.pad + 2 * this.maxDescent + this.stringWidth + this.maxDescent + 1, y);
    }

    public static boolean getRespondToEnter() {
        return respondToEnter;
    }

    public Object[] getSelectedObjects() {
        if (this.state) {
            return new Object[]{this.getLabel()};
        }
        return new Object[0];
    }

    public boolean getState() {
        return this.state;
    }

    public static boolean getTwoClicksTwoEvents() {
        return twoClicksTwoEvents;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void myRepaint() {
        this.paint(this.getGraphics());
    }

    public void needsToBeRecalculated() {
        this.stringWidth = -1;
    }

    public void paint(Graphics g) {
        if (g == null || !this.isVisible()) {
            return;
        }
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return;
            }
        }
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        this.boxSize = 2 + 2 * this.maxDescent + this.stringHeight;
        this.boxX = 0;
        this.boxY = (height - this.boxSize) / 2;
        if (this.o2CheckboxGroup == null) {
            O2.drawBox(g, this.boxX, this.boxY, this.boxSize, this.boxSize, false, true, null);
        } else {
            O2.drawCircularBox(g, this.boxX, this.boxY + 1, this.boxSize - 4, true, null);
        }
        this.paintInsideBox(g);
        if (this.stringWidth == 0) {
            return;
        }
        int textLeft = this.boxSize + 2 * this.maxDescent;
        int textBase = (height + this.stringHeight) / 2;
        g.setFont(this.getFont());
        O2.drawString(g, this.label, textLeft, textBase, this.isEnabled(), this.getBackground(), this.getForeground());
        if (this.hasFocus) {
            int left = textLeft - this.maxDescent;
            O2.drawDottedRect(g, left, textBase - this.stringHeight - this.maxDescent, this.stringWidth + 2 * this.maxDescent, this.stringHeight + 2 * this.maxDescent - 1);
        }
    }

    private void paintInsideBox(Graphics g) {
        if (g == null || !this.isVisible() || this.stringWidth < 0) {
            return;
        }
        if (this.o2CheckboxGroup == null) {
            g.setColor(this.pressed ? this.getBackground() : Color.white);
            g.fillRect(this.boxX + 2, this.boxY + 2, this.boxSize - 4, this.boxSize - 4);
            if (this.state) {
                O2.drawCheck(g, this.boxX + 2, this.boxY + 2, this.boxSize - 4, this.isEnabled());
            }
        } else {
            g.setColor(this.pressed ? this.getBackground() : Color.white);
            g.fillOval(this.boxX + 2, this.boxY + 3, this.boxSize - 8, this.boxSize - 8);
            if (this.state) {
                O2.drawCircularCheck(g, this.boxX, this.boxY + 1, this.boxSize - 4, this.isEnabled());
            }
        }
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    public void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            if (!this.hasFocus) {
                this.hasFocus = true;
                this.myRepaint();
            }
        } else if (id == 1005 && this.hasFocus) {
            this.hasFocus = false;
            this.myRepaint();
        }
        super.processFocusEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null && e.getID() == 701) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public void processKeyEvent(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (respondToEnter && e.getKeyCode() == 10) {
            if (e.getID() == 401 && !this.pressed) {
                if (!this.hasFocus) {
                    this.requestFocus();
                }
                this.pressed = true;
                this.myRepaint();
            }
            if (e.getID() == 402) {
                this.pressed = false;
                this.paintInsideBox(this.getGraphics());
                this.fireItemEvent();
            }
        }
        super.processKeyEvent(e);
    }

    public void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int id = e.getID();
        if (id == 501) {
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0 && !this.pressed) {
                this.pressed = true;
                this.paintInsideBox(this.getGraphics());
                if (!this.hasFocus) {
                    this.requestFocus();
                }
                this.fireItemEvent();
            }
        } else if (id == 502) {
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0) {
                this.pressed = false;
                this.paintInsideBox(this.getGraphics());
            }
        } else if (id == 505 && this.pressed) {
            this.pressed = false;
            this.paintInsideBox(this.getGraphics());
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public void removeItemListener(ItemListener il) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, il);
    }

    public void setCheckboxGroup(O2CheckboxGroup group) {
        this.o2CheckboxGroup = group;
        if (this.state) {
            group.setSelectedCheckbox(this);
        }
    }

    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            super.setEnabled(e);
            this.myRepaint();
        }
    }

    public void setFont(Font f) {
        if (f != this.getFont()) {
            this.stringWidth = -1;
            super.setFont(f);
            this.myRepaint();
        }
    }

    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            super.setForeground(c);
            this.myRepaint();
        }
    }

    public void setLabel(String tLabel) {
        if (!tLabel.equals(this.label)) {
            this.stringWidth = -1;
            this.label = tLabel;
            this.myRepaint();
        }
    }

    public void setPad(int p) {
        if (this.pad != (p = O2.validatePad(p))) {
            this.pad = p;
            this.myRepaint();
        }
    }

    public static void setRespondToEnter(boolean b) {
        respondToEnter = b;
    }

    public void setState(boolean b) {
        if (this.state != b) {
            if (b && this.o2CheckboxGroup != null) {
                O2Checkbox o2Checkbox = this.o2CheckboxGroup.getSelectedCheckbox();
                if (o2Checkbox != null) {
                    o2Checkbox.setState(false);
                }
                this.o2CheckboxGroup.setSelectedCheckbox(this);
            }
            this.state = b;
            this.paintInsideBox(this.getGraphics());
        }
    }

    public static void setTwoClicksTwoEvents(boolean b) {
        twoClicksTwoEvents = b;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

