/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2;
import horst.controls.o2.O2Button;
import horst.controls.o2.O2List;
import horst.controls.o2.O2Spacer;
import horst.controls.o2.O2TextField;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class O2Choice
extends Container
implements ItemSelectable {
    private boolean hasFocus = false;
    private int borderWidth;
    private int lastSelectedIndex = -1;
    private int rows = 8;
    private int stringWidth = -1;
    private static final int MinNRows = 3;
    private long openedListTime;
    private long closedListTime;
    private ItemListener itemListener;
    private O2TextField textField;
    protected O2Button button;
    private O2Spacer spacer0;
    private O2Spacer spacer2;
    private Window listWindow;
    private O2List list;
    private Window parentWindow;
    private Frame parentFrame;
    private static boolean respondToEnter;

    public O2Choice() {
        this(O2.getChoiceNRows());
    }

    public O2Choice(int tRows) {
        this.rows = Math.max(3, tRows);
        this.textField = new O2TextField();
        this.textField.setEditable(false);
        this.textField.addKeyListener(new 1());
        this.textField.addMouseListener(new 2());
        this.textField.addFocusListener(new 3());
        this.button = new O2Button("&dtrif;");
        this.button.setPad(1);
        this.button.setFont(O2.getArrowFont());
        this.button.setFocusTraversable(false);
        this.button.addFocusListener(new 4());
        this.button.addMouseListener(new 5());
        this.borderWidth = O2.getPad() == 0 ? 1 : 2;
        this.spacer0 = new O2Spacer(this.borderWidth, this.borderWidth);
        this.spacer2 = new O2Spacer(this.borderWidth, this.borderWidth);
        this.list = new O2List(this.rows);
        this.list.setFocusIndexAlwaysHighlighted(true);
        this.list.lowSelect(0, false);
        this.list.setRaisedBorder(false);
        this.list.addFocusListener(new 6());
        this.list.addItemListener(new 7());
        this.list.addKeyListener(new 8());
        this.list.addMouseListener(new 9());
        this.setLayout(new GridBagLayout());
        O2.constrain(this, this.textField, 0, 0, 1, 3, 1, 0, 0, 100);
        O2.constrain(this, this.button, 1, 1, 1, 1, 0, 1, 0, 100);
        O2.constrain(this, this.spacer0, 2, 0, 1, 1, 0, 0, 0, 17);
        O2.constrain(this, this.spacer2, 2, 2, 1, 1, 0, 0, 0, 17);
        this.doLayout();
        this.enableEvents(5L);
    }

    public void add(String item) {
        this.list.add(item);
        this.stringWidth = -1;
        if (this.getItemCount() == 1) {
            this.textField.setText(this.getItem(0));
        }
    }

    public void add(String[] item, int offset, int count) {
        this.list.add(item, offset, count);
        this.stringWidth = -1;
        if (this.getItemCount() == count) {
            this.textField.setText(this.getItem(0));
        }
    }

    public void addItem(String item) {
        this.add(item);
    }

    public void addItemListener(ItemListener il) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, il);
    }

    public void addNotify() {
        this.list.setFont(this.getFont());
        if (this.parentWindow == null) {
            Container parent = this.getParent();
            while (!(parent instanceof Window)) {
                parent = parent.getParent();
            }
            this.parentWindow = (Window)parent;
            this.parentWindow.addComponentListener(new 10());
            while (!(parent instanceof Frame)) {
                parent = parent.getParent();
            }
            this.parentFrame = (Frame)parent;
        }
        super.addNotify();
    }

    private void calculateStringSize() {
        this.stringWidth = this.list.getStringWidth();
    }

    protected boolean closeListWindow() {
        if (this.isListWindowShowing() && System.currentTimeMillis() - this.openedListTime > 500L) {
            ((Component)this.listWindow).setVisible(false);
            this.listWindow.dispose();
            this.list.setFocusIndex(this.list.getSelectedIndex());
            this.closedListTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    protected void closeOrShowList() {
        if (this.isListWindowShowing()) {
            this.closeListWindow();
            return;
        }
        if (System.currentTimeMillis() - this.closedListTime < 500L) {
            return;
        }
        Rectangle choiceBounds = this.getBounds();
        if (choiceBounds == null) {
            return;
        }
        Rectangle parentBounds = this.getParent().getBounds();
        this.listWindow = new Window(this.parentFrame);
        this.list.setRows(O2.minMax(1, this.rows, this.list.getItemCount()));
        this.listWindow.add(this.list);
        this.listWindow.pack();
        int listWindowHeight = this.listWindow.getSize().height;
        Point choiceLocation = this.getLocationOnScreen();
        if (choiceLocation.y + choiceBounds.height + listWindowHeight < O2.screenHeight() - 20) {
            O2.showWindow(this.listWindow, choiceLocation.x, choiceLocation.y + choiceBounds.height, choiceBounds.width, listWindowHeight);
        } else {
            O2.showWindow(this.listWindow, choiceLocation.x, choiceLocation.y - listWindowHeight, choiceBounds.width, listWindowHeight);
        }
        this.openedListTime = System.currentTimeMillis();
        this.textField.requestFocus();
    }

    public String getItem(int index) {
        return this.list.getItem(index);
    }

    public int getItemCount() {
        return this.list.getItemCount();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPad() {
        return this.textField.getPad();
    }

    public Dimension getPreferredSize() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return new Dimension(14, 14);
            }
        }
        if (this.lastSelectedIndex == -1) {
            this.textField.setText(this.getItem(0));
            this.lastSelectedIndex = 0;
        }
        return new Dimension(this.list.getPreferredSize().width + 1, this.textField.getPreferredSize().height);
    }

    public static boolean getRespondToEnter() {
        return respondToEnter;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public String getSelectedItem() {
        return this.list.getSelectedItem();
    }

    public Object[] getSelectedObjects() {
        return this.list.getSelectedObjects();
    }

    public void insert(String item, int where) {
        this.list.insert(item, where);
        this.stringWidth = -1;
        this.lastSelectedIndex = -1;
    }

    public void invalidate() {
        this.closeListWindow();
        super.invalidate();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isListWindowShowing() {
        return this.listWindow != null && this.listWindow.isShowing();
    }

    public void lowSelect(int index, boolean generateItemEvent) {
        if (index != this.lastSelectedIndex && index >= 0 && index < this.getItemCount()) {
            this.lastSelectedIndex = index;
            this.list.lowSelect(index, false);
            this.textField.setText(this.getItem(index));
            if (generateItemEvent) {
                this.processEvent(new ItemEvent(this, 701, this.getSelectedItem(), 1));
            }
        }
    }

    public void myRepaint() {
        this.paint(this.getGraphics());
    }

    public void needsToBeRecalculated() {
        this.stringWidth = -1;
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return;
            }
        }
        super.paint(g);
        O2.drawBox(g, 0, 0, this.getSize().width, this.getSize().height, false, this.borderWidth == 2, null);
    }

    public void processComponentEvent(ComponentEvent e) {
        int id = e.getID();
        if (id == 103 || id == 100 || id == 101) {
            this.closeListWindow();
        }
        super.processComponentEvent(e);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    public void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            this.textField.requestFocus();
        }
        super.processFocusEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null && e.getID() == 701) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public void remove(int index) {
        this.closeListWindow();
        this.list.remove(index);
        this.lastSelectedIndex = this.getSelectedIndex();
        this.textField.setText(this.getItem(this.lastSelectedIndex));
    }

    public void remove(String item) {
        this.closeListWindow();
        this.list.remove(item);
        this.lastSelectedIndex = this.getSelectedIndex();
        this.textField.setText(this.getItem(this.lastSelectedIndex));
    }

    public void removeAll() {
        this.closeListWindow();
        this.list.removeAll();
        this.textField.setText("");
        this.stringWidth = -1;
        this.lastSelectedIndex = -1;
        this.myRepaint();
    }

    public void removeItemListener(ItemListener il) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, il);
    }

    public void removeNotify() {
        this.closeListWindow();
        super.removeNotify();
    }

    protected void repackageKeyEvent(KeyEvent e) {
        KeyEvent e2 = new KeyEvent(this, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar());
        this.processEvent(e2);
    }

    protected void repackageMouseEvent(MouseEvent e, int xOffset, int yOffset) {
        MouseEvent e2 = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), e.getX() + xOffset, e.getY() + this.button.getBounds().y, e.getClickCount(), e.isPopupTrigger());
        this.processEvent(e2);
    }

    protected void repackageMouseEventButton(MouseEvent e) {
        Rectangle bounds = this.button.getBounds();
        this.repackageMouseEvent(e, e.getX() + bounds.x, e.getY() + bounds.y);
    }

    public void replaceItem(String newValue, int index) {
        this.list.replaceItem(newValue, index);
        if (index == this.getSelectedIndex()) {
            this.textField.setText(newValue);
        }
    }

    public void select(int index) {
        this.lowSelect(index, false);
    }

    public void select(String item) {
        int n = this.getItemCount();
        int i = 0;
        while (i < n) {
            if (this.list.getItem(i).equals(item)) {
                this.select(i);
                return;
            }
            ++i;
        }
    }

    public void setBackground(Color c) {
        this.textField.setBackground(c);
        this.list.setBackground(c);
        super.setBackground(c);
    }

    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            if (!e) {
                this.closeListWindow();
            }
            super.setEnabled(e);
            this.textField.setEnabled(e);
            this.button.setEnabled(e);
        }
    }

    public void setFont(Font f) {
        if (f != this.getFont()) {
            this.stringWidth = -1;
            this.list.setFont(f);
            this.textField.setFont(f);
            this.myRepaint();
        }
    }

    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            super.setForeground(c);
            this.textField.setForeground(c);
            this.button.setForeground(c);
            this.list.setForeground(c);
        }
    }

    public void setPad(int p) {
        p = O2.validatePad(p);
        if (this.textField.getPad() != p) {
            this.borderWidth = p == 0 ? 1 : 2;
            this.spacer0.setPreferredSize(this.borderWidth, this.borderWidth);
            this.spacer2.setPreferredSize(this.borderWidth, this.borderWidth);
            this.textField.setPad(p);
            this.button.setPad(p);
            this.myRepaint();
        }
    }

    public static void setRespondToEnter(boolean b) {
        respondToEnter = b;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this.closeListWindow();
        }
        super.setVisible(visible);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private final class 1
    implements KeyListener {
        /* synthetic */ 1() {
        }

        public void keyPressed(KeyEvent e) {
            boolean plain;
            boolean shift = e.isShiftDown();
            boolean control = e.isControlDown();
            boolean controlShift = control && shift;
            boolean alt = e.isAltDown();
            boolean bl = plain = !shift && !control && !alt;
            if (controlShift) {
                shift = false;
                control = false;
            }
            int vk = e.getKeyCode();
            char ch = e.getKeyChar();
            if (vk == 10) {
                if (O2Choice.this.isListWindowShowing()) {
                    O2Choice.this.lowSelect(O2Choice.this.list.getFocusIndex(), true);
                    O2Choice.this.closeListWindow();
                } else if (respondToEnter) {
                    O2Choice.this.closeOrShowList();
                }
            } else if (vk == 37 || vk == 38) {
                if (O2Choice.this.isListWindowShowing() && !O2List.getArrowFiresItemEvent()) {
                    O2Choice.this.list.setFocusIndex(O2Choice.this.list.getFocusIndex() - 1);
                } else {
                    O2Choice.this.lowSelect(O2Choice.this.getSelectedIndex() - 1, true);
                }
            } else if (vk == 39 || vk == 40) {
                if (O2Choice.this.isListWindowShowing() && !O2List.getArrowFiresItemEvent()) {
                    O2Choice.this.list.setFocusIndex(O2Choice.this.list.getFocusIndex() + 1);
                } else {
                    O2Choice.this.lowSelect(O2Choice.this.getSelectedIndex() + 1, true);
                }
            } else if (vk == 36) {
                if (O2Choice.this.isListWindowShowing() && !O2List.getArrowFiresItemEvent()) {
                    O2Choice.this.list.setFocusIndex(0);
                } else {
                    O2Choice.this.lowSelect(0, true);
                }
            } else if (vk == 35) {
                if (O2Choice.this.isListWindowShowing() && !O2List.getArrowFiresItemEvent()) {
                    O2Choice.this.list.setFocusIndex(O2Choice.this.getItemCount() - 1);
                } else {
                    O2Choice.this.lowSelect(O2Choice.this.getItemCount() - 1, true);
                }
            } else if (vk == 33) {
                if (O2Choice.this.isListWindowShowing() && !O2List.getArrowFiresItemEvent()) {
                    O2Choice.this.list.setFocusIndex(O2Choice.this.list.getFocusIndex() - (O2Choice.this.rows - 1));
                } else {
                    O2Choice.this.lowSelect(Math.max(0, O2Choice.this.getSelectedIndex() - (O2Choice.this.rows - 1)), true);
                }
            } else if (vk == 34) {
                if (O2Choice.this.isListWindowShowing() && !O2List.getArrowFiresItemEvent()) {
                    O2Choice.this.list.setFocusIndex(O2Choice.this.list.getFocusIndex() + (O2Choice.this.rows - 1));
                } else {
                    O2Choice.this.lowSelect(Math.min(O2Choice.this.getItemCount() - 1, O2Choice.this.getSelectedIndex() + (O2Choice.this.rows - 1)), true);
                }
            } else if (vk != 9 && vk == 27 && O2Choice.this.isListWindowShowing()) {
                O2Choice.this.closeListWindow();
                return;
            }
            O2Choice.this.repackageKeyEvent(e);
        }

        public void keyReleased(KeyEvent e) {
            O2Choice.this.repackageKeyEvent(e);
        }

        public void keyTyped(KeyEvent e) {
            O2Choice.this.repackageKeyEvent(e);
        }
    }

    private final class 2
    implements MouseListener {
        /* synthetic */ 2() {
        }

        public void mouseClicked(MouseEvent e) {
            O2Choice.this.repackageMouseEvent(e, 0, 0);
        }

        public void mouseEntered(MouseEvent e) {
            O2Choice.this.repackageMouseEvent(e, 0, 0);
        }

        public void mouseExited(MouseEvent e) {
            O2Choice.this.repackageMouseEvent(e, 0, 0);
        }

        public void mousePressed(MouseEvent e) {
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0) {
                O2Choice.this.closeOrShowList();
            }
            O2Choice.this.repackageMouseEvent(e, 0, 0);
        }

        public void mouseReleased(MouseEvent e) {
            O2Choice.this.repackageMouseEvent(e, 0, 0);
        }
    }

    private final class 3
    extends FocusAdapter {
        /* synthetic */ 3() {
        }

        public void focusLost(FocusEvent e) {
            Component focusOwner = O2Choice.this.parentWindow.getFocusOwner();
            if (focusOwner != null && O2Choice.this.parentWindow.isAncestorOf(focusOwner)) {
                O2Choice.this.closeListWindow();
            }
        }
    }

    private final class 4
    extends FocusAdapter {
        /* synthetic */ 4() {
        }

        public void focusGained(FocusEvent e) {
            O2Choice.this.textField.requestFocus();
        }
    }

    private final class 5
    extends MouseAdapter {
        /* synthetic */ 5() {
        }

        public void mouseClicked(MouseEvent e) {
            O2Choice.this.repackageMouseEventButton(e);
        }

        public void mouseEntered(MouseEvent e) {
            O2Choice.this.repackageMouseEventButton(e);
        }

        public void mouseExited(MouseEvent e) {
            O2Choice.this.repackageMouseEventButton(e);
        }

        public void mousePressed(MouseEvent e) {
            O2Choice.this.repackageMouseEventButton(e);
        }

        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0) {
                O2Choice.this.closeOrShowList();
            }
            O2Choice.this.repackageMouseEventButton(e);
        }
    }

    private final class 6
    extends FocusAdapter {
        /* synthetic */ 6() {
        }

        public void focusLost(FocusEvent e) {
            O2Choice.this.closeListWindow();
        }
    }

    private final class 7
    implements ItemListener {
        /* synthetic */ 7() {
        }

        public void itemStateChanged(ItemEvent e) {
            O2Choice.this.lowSelect(O2Choice.this.getSelectedIndex(), true);
        }
    }

    private final class 8
    extends KeyAdapter {
        /* synthetic */ 8() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                O2Choice.this.closeListWindow();
            }
        }
    }

    private final class 9
    extends MouseAdapter {
        /* synthetic */ 9() {
        }

        public void mousePressed(MouseEvent e) {
            O2Choice.this.parentWindow.requestFocus();
            O2Choice.this.textField.requestFocus();
            O2Choice.this.closeListWindow();
        }
    }

    private final class 10
    extends ComponentAdapter {
        /* synthetic */ 10() {
        }

        public void componentMoved(ComponentEvent e) {
            O2Choice.this.closeListWindow();
        }

        public void componentResized(ComponentEvent e) {
            O2Choice.this.closeListWindow();
        }
    }
}

