/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class O2Label
extends Component {
    public static final int CENTER = 1;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    private String text;
    private int alignment;
    private int pad = O2.getPad();
    private int stringWidth = -1;
    private int stringHeight;
    private int maxDescent;
    private static final int borderWidth = 1;

    public O2Label() {
        this("", 0);
    }

    public O2Label(String text) {
        this(text, 0);
    }

    public O2Label(String text, int alignment) {
        this.text = text;
        this.alignment = alignment == 0 ? 0 : (alignment == 2 ? 2 : 1);
        this.enableEvents(52L);
    }

    private void calculateStringSize() {
        Font f = this.getFont();
        if (f == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.stringWidth = fm.stringWidth(this.text);
        this.stringHeight = O2.getStringHeight(fm);
        this.maxDescent = fm.getMaxDescent();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPad() {
        return this.pad;
    }

    public Dimension getPreferredSize() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return new Dimension(14, 14);
            }
        }
        return new Dimension(this.stringWidth, this.stringHeight + (this.maxDescent + this.pad + 1) * 2);
    }

    public String getText() {
        return this.text;
    }

    public void myRepaint() {
        this.paint(this.getGraphics());
    }

    public void needsToBeRecalculated() {
        this.stringWidth = -1;
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth <= 0) {
                return;
            }
        }
        g.setFont(this.getFont());
        O2.drawString(g, this.text, this.alignment == 0 ? 0 : (this.alignment == 2 ? width - this.stringWidth : (width - this.stringWidth) / 2), (height + this.stringHeight) / 2, this.isEnabled(), this.getBackground(), this.getForeground());
    }

    public void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public void setAlignment(int a) {
        int n = a == 0 ? 0 : (a = a == 2 ? 2 : 1);
        if (a != this.alignment) {
            this.alignment = a;
            this.myRepaint();
        }
    }

    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            super.setEnabled(e);
            this.myRepaint();
        }
    }

    public void setFont(Font f) {
        if (f != this.getFont()) {
            this.stringWidth = -1;
            super.setFont(f);
            this.myRepaint();
        }
    }

    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            super.setForeground(c);
            this.myRepaint();
        }
    }

    public void setPad(int p) {
        if (this.pad != (p = O2.validatePad(p))) {
            this.pad = p;
            this.myRepaint();
        }
    }

    public void setText(String tText) {
        if (!tText.equals(this.text)) {
            this.stringWidth = -1;
            this.text = tText;
            this.myRepaint();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

