/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2;
import horst.controls.o2.O2ArrayString;
import horst.controls.o2.O2Spacer;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class O2List
extends Container
implements ItemSelectable {
    private static boolean arrowFiresItemEvent = true;
    private boolean hasFocus = false;
    private boolean raisedBorder = true;
    private boolean focusIndexAlwaysHighlighted = false;
    private int rows;
    private int topIndex;
    private int selectedIndex = -1;
    private int focusIndex;
    private int stringWidth = -1;
    private int stringHeight = 9;
    private int maxDescent = 3;
    private static final int MinNRows = 3;
    private double averageCharWidth = 6.0;
    private ActionListener actionListener;
    private long lastActionTime;
    private ItemListener itemListener;
    private O2ArrayString items = new O2ArrayString(8);
    private Scrollbar vbar;
    private static final int borderWidth = 2;
    private static final int scrollWidth = 16;
    private int vbarTopIndex = -1;
    private int vbarRows = -1;
    private int vbarMax = -1;
    private Image image;
    private int imageHeight;
    private int imageWidth;

    public O2List() {
        this(4);
    }

    public O2List(int rows) {
        this.rows = Math.max(3, rows);
        this.setBackground(Color.white);
        this.vbar = new Scrollbar(1, 0, rows, 0, 20);
        this.vbar.setBlockIncrement(Math.max(1, rows - 1));
        this.vbar.setUnitIncrement(1);
        this.vbar.addAdjustmentListener(new 1());
        this.setLayout(new GridBagLayout());
        O2.constrain(this, new O2Spacer(2, 2), 0, 0, 1, 1, 0, 0, 0, 17);
        O2.constrain(this, new O2Spacer(2, 2), 1, 1, 1, 1, 1, 1, 0, 100);
        O2.constrain(this, this.vbar, 2, 1, 1, 1, 0, 0, 0, 100);
        O2.constrain(this, new O2Spacer(2, 2), 3, 2, 1, 1, 0, 0, 0, 17);
        this.doLayout();
        this.enableEvents(60L);
    }

    public void add(String item) {
        this.items.add(item);
        this.stringWidth = -1;
    }

    public void add(String[] item, int offset, int count) {
        this.items.add(item, offset, count);
        this.stringWidth = -1;
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void addItemListener(ItemListener il) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, il);
    }

    private void calculateStringSize() {
        Font f = this.getFont();
        if (f == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(f);
        this.stringHeight = O2.getStringHeight(fm);
        this.maxDescent = fm.getMaxDescent();
        int checkN = 20;
        int n = Math.min(checkN, this.items.getSize());
        int cumChars = 0;
        int cumWidth = 0;
        this.stringWidth = 0;
        int i = 0;
        while (i < n) {
            int width = fm.stringWidth(this.items.get(i));
            cumChars += this.items.get(i).length();
            cumWidth += width;
            if (width > this.stringWidth) {
                this.stringWidth = width;
            }
            ++i;
        }
        this.averageCharWidth = cumChars == 0 ? 6.0 : (double)cumWidth / ((double)cumChars + 0.0);
        int widest = 0;
        i = checkN;
        while (i < this.items.getSize()) {
            widest = Math.max(widest, this.items.get(i).length());
            ++i;
        }
        this.stringWidth = Math.max(this.stringWidth, (int)Math.round(1.1 * this.averageCharWidth * (double)widest));
    }

    private void fireItemEvent() {
        this.processEvent(new ItemEvent(this, 701, this.getSelectedItem(), 1));
    }

    public static boolean getArrowFiresItemEvent() {
        return arrowFiresItemEvent;
    }

    public int getFocusIndex() {
        return this.focusIndex;
    }

    public boolean getFocusIndexAlwaysHighlighted() {
        return this.focusIndexAlwaysHighlighted;
    }

    public String getItem(int index) {
        return this.items.get(index);
    }

    public int getItemCount() {
        return this.items.getSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return new Dimension(14, 14);
            }
        }
        return new Dimension(this.stringWidth + 2 * this.maxDescent + 16 + 4, this.rows * (this.stringHeight + 2 * this.maxDescent) + 4);
    }

    public boolean getRaisedBorder() {
        return this.raisedBorder;
    }

    public int getRows() {
        return this.rows;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedItem() {
        return this.items.get(this.selectedIndex);
    }

    public Object[] getSelectedObjects() {
        if (this.selectedIndex < 0) {
            return new Object[0];
        }
        return new Object[]{this.getSelectedItem()};
    }

    public int getStringHeight() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
        }
        return this.stringHeight;
    }

    public int getStringWidth() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
        }
        return this.stringWidth;
    }

    public void insert(String item, int where) {
        this.items.insert(item, where);
        if (this.selectedIndex >= where) {
            ++this.selectedIndex;
        }
        this.stringWidth = -1;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean lowSelect(int index, boolean generateItemEvent) {
        if (index == this.selectedIndex) {
            this.setFocusIndex(index);
            return false;
        }
        if (index >= 0 && index < Math.max(1, this.items.getSize())) {
            this.selectedIndex = index;
            this.focusIndex = index;
            this.validateAndPaint();
            if (generateItemEvent) {
                this.fireItemEvent();
            }
            return true;
        }
        return false;
    }

    public void myRepaint() {
        this.paint(this.getGraphics());
    }

    public void needsToBeRecalculated() {
        this.stringWidth = -1;
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return;
            }
        }
        Color background = this.getBackground();
        Dimension size = this.getSize();
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.raisedBorder) {
            O2.drawBox(g, 0, 0, width, height, false, true, null);
        } else {
            g.setColor(Color.black);
            g.drawRect(0, 0, width - 1, height - 1);
            g.setColor(Color.white);
            g.drawRect(1, 1, width - 3, height - 3);
        }
        int itemsSize = this.items.getSize();
        boolean needScrollbar = itemsSize > this.rows;
        int x = 2;
        int y = 2;
        int textX = this.maxDescent;
        int textYOffset = this.maxDescent + this.stringHeight;
        int yInc = this.stringHeight + 2 * this.maxDescent;
        int fieldWidth = width - 4 - (needScrollbar ? 16 : 0);
        if (this.image == null || this.imageWidth != fieldWidth || this.imageHeight != yInc) {
            this.imageWidth = fieldWidth;
            this.imageHeight = yInc;
            try {
                this.image = this.createImage(this.imageWidth, this.imageHeight);
            }
            catch (Throwable throwable) {
                this.image = null;
                return;
            }
        }
        Graphics imageG = this.image.getGraphics();
        Color tForeground = this.isEnabled() ? this.getForeground() : Color.gray;
        g.setFont(this.getFont());
        int row = 0;
        while (row < this.rows) {
            boolean thisSelected = this.selectedIndex == row + this.topIndex;
            boolean thisFocus = this.focusIndex == row + this.topIndex && (this.focusIndexAlwaysHighlighted || this.hasFocus);
            String s = this.items.get(row + this.topIndex);
            imageG.setColor(thisSelected ? Color.blue.darker().darker() : background);
            imageG.fillRect(0, 0, fieldWidth, yInc);
            if (thisFocus) {
                imageG.setColor(thisSelected ? Color.white : Color.black);
                O2.drawDottedRect(imageG, 0, 0, fieldWidth - 1, yInc - 1);
            }
            O2.drawString(imageG, s, textX, textYOffset, this.isEnabled(), background, thisSelected ? Color.white : tForeground);
            g.drawImage(this.image, x, y, null);
            y += yInc;
            ++row;
        }
        int ty = height - 2 - y;
        if (ty > 0) {
            g.setColor(background);
            g.fillRect(x, y, fieldWidth, ty);
        }
        if (needScrollbar) {
            this.vbar.setVisible(true);
            this.vbar.setBounds(width - 2 - 16, 2, 16, height - 4);
            if (this.vbarTopIndex != this.topIndex || this.vbarRows != this.rows || this.vbarMax != itemsSize) {
                this.vbarTopIndex = this.topIndex;
                this.vbarRows = this.rows;
                this.vbarMax = itemsSize;
                this.vbar.setValues(this.vbarTopIndex, this.vbarRows, 0, this.vbarMax);
            } else {
                this.vbar.paint(g);
            }
        } else {
            this.vbar.setVisible(false);
        }
    }

    public int pixelWhichRow(int y) {
        int yInc = this.stringHeight + 2 * this.maxDescent;
        return this.topIndex + (y -= 2) / yInc;
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null && e.getID() == 1001) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    public void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            if (!this.hasFocus) {
                this.hasFocus = true;
                this.myRepaint();
            }
        } else if (id == 1005 && this.hasFocus) {
            this.hasFocus = false;
            if (this.focusIndex != this.selectedIndex) {
                this.setFocusIndex(this.selectedIndex);
            } else {
                this.myRepaint();
            }
        }
        super.processFocusEvent(e);
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.itemListener != null && e.getID() == 701) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public void processKeyEvent(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int id = e.getID();
        if (id == 401) {
            int vk = e.getKeyCode();
            if (vk == 10) {
                this.lowSelect(this.focusIndex, true);
            } else if (vk == 37 || vk == 38) {
                if (arrowFiresItemEvent) {
                    this.lowSelect(this.selectedIndex - 1, true);
                } else {
                    this.setFocusIndex(this.focusIndex - 1);
                }
            } else if (vk == 39 || vk == 40) {
                if (arrowFiresItemEvent) {
                    this.lowSelect(this.selectedIndex + 1, true);
                } else {
                    this.setFocusIndex(this.focusIndex + 1);
                }
            } else if (vk == 36) {
                if (arrowFiresItemEvent) {
                    this.lowSelect(0, true);
                } else {
                    this.setFocusIndex(0);
                }
            } else if (vk == 35) {
                if (arrowFiresItemEvent) {
                    this.lowSelect(this.items.getSize() - 1, true);
                } else {
                    this.setFocusIndex(this.items.getSize() - 1);
                }
            } else if (vk == 33) {
                if (arrowFiresItemEvent) {
                    this.lowSelect(Math.max(0, this.selectedIndex - (this.rows - 1)), true);
                } else {
                    this.setFocusIndex(this.focusIndex - (this.rows - 1));
                }
            } else if (vk == 34) {
                if (arrowFiresItemEvent) {
                    this.lowSelect(Math.min(this.items.getSize() - 1, this.selectedIndex + (this.rows - 1)), true);
                } else {
                    this.setFocusIndex(this.focusIndex + (this.rows - 1));
                }
            }
        }
        super.processKeyEvent(e);
    }

    public void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int id = e.getID();
        if (id == 501 && (e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0) {
            if (!this.hasFocus) {
                this.requestFocus();
            }
            super.processMouseEvent(e);
            this.lowSelect(this.pixelWhichRow(e.getY()), true);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastActionTime < (long)O2.getDoubleClickMS()) {
                this.processEvent(new ActionEvent(this, 1001, this.getSelectedItem()));
                this.lastActionTime = 0L;
            } else {
                this.lastActionTime = currentTime;
            }
            return;
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(e);
    }

    public void remove(int index) {
        if (index >= 0 && index < this.items.getSize()) {
            if (this.selectedIndex == index) {
                this.selectedIndex = -1;
            }
            if (this.selectedIndex > index) {
                --this.selectedIndex;
            }
            if (this.focusIndex > index) {
                --this.focusIndex;
            }
            this.items.delete(index, index);
            this.myRepaint();
        }
    }

    public void remove(String item) {
        int i = 0;
        while (i < this.items.getSize()) {
            if (this.items.get(i).equals(item)) {
                if (this.selectedIndex == i) {
                    this.selectedIndex = -1;
                }
                if (this.selectedIndex > i) {
                    --this.selectedIndex;
                }
                if (this.focusIndex > i) {
                    --this.focusIndex;
                }
                this.items.delete(i, i);
                this.myRepaint();
                return;
            }
            ++i;
        }
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    public void removeAll() {
        this.items.clear();
        this.selectedIndex = -1;
        this.focusIndex = 0;
        this.myRepaint();
    }

    public void removeItemListener(ItemListener il) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, il);
    }

    public void replaceItem(String newValue, int index) {
        this.items.set(index, newValue);
        this.myRepaint();
    }

    public void select(int index) {
        this.lowSelect(index, false);
    }

    public static void setArrowFiresItemEvent(boolean b) {
        arrowFiresItemEvent = b;
    }

    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            super.setEnabled(e);
            this.vbar.setEnabled(e);
            this.myRepaint();
        }
    }

    public void setFocusIndex(int fi) {
        if ((fi = Math.min(fi, this.items.getSize() - 1)) < 0) {
            fi = 0;
        }
        if (fi != this.focusIndex) {
            if (fi < this.topIndex) {
                this.topIndex = fi;
            } else if (fi > this.topIndex + this.rows - 1) {
                this.topIndex = fi - this.rows + 1;
            }
            this.focusIndex = fi;
            this.myRepaint();
        }
    }

    public void setFocusIndexAlwaysHighlighted(boolean b) {
        this.focusIndexAlwaysHighlighted = b;
    }

    public void setFont(Font f) {
        if (f != this.getFont()) {
            this.stringWidth = -1;
            super.setFont(f);
            this.myRepaint();
        }
    }

    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            super.setForeground(c);
            this.myRepaint();
        }
    }

    public void setRaisedBorder(boolean rb) {
        if (rb != this.raisedBorder) {
            this.raisedBorder = rb;
            this.myRepaint();
        }
    }

    public void setRows(int r) {
        this.rows = Math.max(1, r);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private void validateAndPaint() {
        if (this.selectedIndex >= 0) {
            if (this.selectedIndex < this.topIndex) {
                this.topIndex = this.selectedIndex;
            } else if (this.selectedIndex >= this.topIndex + this.rows) {
                this.topIndex = this.selectedIndex - this.rows + 1;
            }
        }
        this.myRepaint();
    }

    private final class 1
    implements AdjustmentListener {
        /* synthetic */ 1() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            int oTopIndex = O2List.this.topIndex;
            O2List.this.topIndex = Math.max(0, Math.min(O2List.this.items.getSize() - 1, e.getValue()));
            if (O2List.this.topIndex != oTopIndex) {
                O2List.this.myRepaint();
            }
            O2List.this.requestFocus();
        }
    }
}

