/*
 * Decompiled with CFR 0.152.
 */
package horst.controls.o2;

import horst.controls.o2.O2;
import horst.controls.o2.O2Caret;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class O2TextField
extends Component {
    private String text;
    private boolean hasFocus = false;
    private boolean editable = true;
    private int columns = -1;
    private int pad = O2.getPad();
    private int stringWidth = -1;
    private int stringBegin;
    private int stringEnd;
    private int selectionStart = -1;
    private int selectionEnd;
    private int caretPo;
    private int caretPixel;
    private int fieldWidth = 100;
    private int stringHeight = 9;
    private int maxDescent = 3;
    private Font font;
    private FontMetrics fontMetrics;
    private ActionListener actionListener;
    private TextListener textListener;
    private O2Caret caret;
    private static final int borderWidth = 1;

    public O2TextField() {
        this("", -1);
    }

    public O2TextField(int columns) {
        this("", columns);
    }

    public O2TextField(String text) {
        this(text, -1);
    }

    public O2TextField(String text, int columns) {
        this.text = text;
        this.columns = Math.max(-1, columns);
        this.setBackground(Color.white);
        this.caret = O2.getCaret();
        this.enableEvents(60L);
    }

    private void activateCaret() {
        if (this.stringWidth < 0) {
            return;
        }
        int baseY = (this.getSize().height + this.stringHeight) / 2;
        this.caret.activate(this, this.maxDescent + this.pad + 1 + this.caretPixel, baseY + this.maxDescent - 1, baseY - this.stringHeight - this.maxDescent + 1);
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, al);
    }

    public void addTextListener(TextListener tl) {
        this.textListener = AWTEventMulticaster.add(this.textListener, tl);
    }

    private void calculateStringSize() {
        int charWidth;
        if (this.fontMetrics == null) {
            Font f = this.getFont();
            if (f == null) {
                return;
            }
            this.fontMetrics = this.getFontMetrics(f);
            if (this.fontMetrics == null) {
                return;
            }
        }
        this.stringHeight = O2.getStringHeight(this.fontMetrics);
        this.maxDescent = this.fontMetrics.getMaxDescent();
        Dimension size = this.getSize();
        if (size == null) {
            return;
        }
        this.fieldWidth = size.width - 2 * (this.maxDescent + this.pad + 1);
        int textLength = this.text.length();
        if (this.caretPo < 0) {
            this.caretPo = 0;
        }
        if (this.caretPo > textLength) {
            this.caretPo = textLength;
        }
        if (textLength < 4 * this.fieldWidth / this.stringHeight) {
            this.stringWidth = this.fontMetrics.stringWidth(this.text);
            if (this.stringWidth < this.fieldWidth) {
                this.stringBegin = 0;
                this.stringEnd = textLength;
                this.caretPixel = this.caretPo == 0 ? 0 : (this.caretPo == textLength ? this.stringWidth : this.fontMetrics.stringWidth(this.text.substring(0, this.caretPo)));
                return;
            }
        }
        this.stringWidth = 0;
        this.stringEnd = this.caretPo;
        this.caretPixel = 0;
        if (this.caretPo < textLength) {
            charWidth = this.fontMetrics.charWidth(this.text.charAt(this.caretPo));
            ++this.stringEnd;
            this.stringWidth += charWidth;
        }
        int oStringBegin = this.stringBegin;
        this.stringBegin = this.caretPo;
        if (this.stringBegin > oStringBegin) {
            boolean done;
            do {
                done = true;
                charWidth = this.fontMetrics.charWidth(this.text.charAt(this.stringBegin - 1));
                if (this.stringWidth + charWidth >= this.fieldWidth) continue;
                done = false;
                --this.stringBegin;
                this.stringWidth += charWidth;
                this.caretPixel += charWidth;
            } while (this.stringBegin > oStringBegin && !done);
        }
        this.tryToIncreaseStringEnd();
    }

    public void deleteCharacterLeft() {
        if (this.selectionStart >= 0) {
            this.selectionStart = -1;
            this.myRepaint();
        }
        if (this.caretPo > 0) {
            char ch = this.text.charAt(this.caretPo - 1);
            this.text = String.valueOf(this.text.substring(0, this.caretPo - 1)) + this.text.substring(this.caretPo, this.text.length());
            --this.caretPo;
            --this.stringEnd;
            if (this.stringWidth == -1 || this.caretPo <= this.stringBegin) {
                this.stringBegin = Math.max(0, this.stringBegin - 5);
                this.stringWidth = -1;
            } else {
                int charWidth = this.fontMetrics.charWidth((int)ch);
                this.caretPixel -= charWidth;
                this.stringWidth -= charWidth;
                this.tryToIncreaseStringEnd();
            }
            this.myRepaint();
            this.fireTextEvent();
        }
    }

    public void deleteCharacterRight() {
        if (this.selectionStart >= 0) {
            this.selectionStart = -1;
            this.myRepaint();
        }
        if (this.caretPo < this.text.length()) {
            char ch = this.text.charAt(this.caretPo);
            this.text = String.valueOf(this.text.substring(0, this.caretPo)) + this.text.substring(this.caretPo + 1, this.text.length());
            --this.stringEnd;
            if (this.stringWidth != -1) {
                this.stringWidth -= this.fontMetrics.charWidth((int)ch);
                this.tryToIncreaseStringEnd();
            }
            this.myRepaint();
            this.fireTextEvent();
        }
    }

    private void fireTextEvent() {
        this.processEvent(new TextEvent(this, 900));
    }

    public int getCaretPosition() {
        return this.caretPo;
    }

    public int getColumns() {
        return this.columns;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPad() {
        return this.pad;
    }

    public Dimension getPreferredSize() {
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return new Dimension(14, 14);
            }
        }
        int descentPadBorder2 = 2 * (this.maxDescent + this.pad + 1);
        if (this.columns >= 0) {
            return new Dimension(this.columns * this.stringHeight * 4 / 5 + descentPadBorder2 + 1, this.stringHeight + descentPadBorder2);
        }
        return new Dimension(this.fontMetrics.stringWidth(this.text) + descentPadBorder2, this.stringHeight + descentPadBorder2);
    }

    public String getSelectedText() {
        return this.selectionStart < 0 ? "" : this.text.substring(Math.min(this.selectionStart, this.selectionEnd), Math.max(this.selectionStart, this.selectionEnd));
    }

    public int getSelectionEnd() {
        return this.selectionStart < 0 ? -1 : this.selectionEnd;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public String getText() {
        return this.text;
    }

    public void insertCharacter(char ch) {
        if (this.selectionStart >= 0) {
            this.selectionDelete();
        }
        this.text = String.valueOf(this.text.substring(0, this.caretPo)) + ch + this.text.substring(this.caretPo, this.text.length());
        ++this.caretPo;
        ++this.stringEnd;
        if (this.stringWidth >= 0) {
            int charWidth = this.fontMetrics.charWidth(ch);
            this.caretPixel += charWidth;
            this.stringWidth += charWidth;
            if (this.stringWidth >= this.fieldWidth) {
                if (this.caretPo >= this.stringEnd - 1) {
                    this.stringBegin = Math.min(this.caretPo - 1, this.stringBegin + 5);
                }
                this.stringWidth = -1;
            }
        }
        this.myRepaint();
        this.fireTextEvent();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void moveCaretBegin() {
        this.selectionStart = -1;
        this.caretPo = 0;
        this.stringWidth = -1;
        this.myRepaint();
    }

    public void moveCaretEnd() {
        this.selectionStart = -1;
        this.caretPo = this.text.length();
        this.stringWidth = -1;
        this.myRepaint();
    }

    public void moveCaretLeft() {
        if (this.selectionStart >= 0) {
            this.selectionStart = -1;
            this.myRepaint();
        }
        if (this.caretPo > 0) {
            if (this.stringWidth == -1 || this.caretPo <= this.stringBegin + 1) {
                --this.caretPo;
                this.stringBegin = Math.max(0, this.stringBegin - 5);
                this.stringWidth = -1;
                this.myRepaint();
            } else {
                Graphics g = this.getGraphics();
                this.caret.deactivate(this);
                --this.caretPo;
                this.caretPixel -= this.fontMetrics.charWidth(this.text.charAt(this.caretPo));
                this.activateCaret();
            }
        }
    }

    public void moveCaretRight() {
        if (this.selectionStart >= 0) {
            this.selectionStart = -1;
            this.myRepaint();
        }
        if (this.caretPo < this.text.length()) {
            if (this.stringWidth == -1 || this.caretPo >= this.stringEnd - 1 && this.text.length() > this.stringEnd) {
                this.stringBegin = Math.min(this.caretPo, this.stringBegin + 5);
                ++this.caretPo;
                this.stringWidth = -1;
                this.myRepaint();
            } else {
                Graphics g = this.getGraphics();
                this.caret.deactivate(this);
                this.caretPixel += this.fontMetrics.charWidth(this.text.charAt(this.caretPo));
                ++this.caretPo;
                this.activateCaret();
            }
        }
    }

    public void moveSelectionEnd() {
        if (this.selectionStart < 0) {
            this.selectionStart = this.caretPo;
        }
        this.selectionEnd = this.caretPo = this.text.length();
        this.stringWidth = -1;
        this.myRepaint();
    }

    public void moveSelectionLeft() {
        if (this.selectionStart < 0) {
            this.selectionStart = this.caretPo;
        }
        if (this.caretPo > 0) {
            --this.caretPo;
        }
        this.selectionEnd = this.caretPo;
        this.stringWidth = -1;
        this.myRepaint();
    }

    public void moveSelectionRight() {
        if (this.selectionStart < 0) {
            this.selectionStart = this.caretPo;
        }
        if (this.caretPo < this.text.length()) {
            ++this.caretPo;
        }
        this.selectionEnd = this.caretPo;
        this.stringWidth = -1;
        this.myRepaint();
    }

    public void moveSelectionStart() {
        if (this.selectionStart < 0) {
            this.selectionStart = this.caretPo;
        }
        this.caretPo = 0;
        this.selectionEnd = 0;
        this.stringWidth = -1;
        this.myRepaint();
    }

    public void moveSelectionTo(int xPixel) {
        if (this.stringWidth == -1) {
            return;
        }
        int oCaretPo = this.caretPo;
        if (this.stringEnd > this.stringBegin) {
            int cumulative = this.pad + 1 + this.maxDescent;
            int begin = this.stringBegin;
            int current = this.fontMetrics.charWidth(this.text.charAt(begin));
            while (begin < this.stringEnd - 1 && cumulative + current < xPixel) {
                cumulative += current;
                current = this.fontMetrics.charWidth(this.text.charAt(++begin));
            }
            this.caretPo = Math.abs(cumulative - xPixel) < Math.abs(cumulative + current - xPixel) ? begin : begin + 1;
        }
        if (this.selectionStart < 0 || this.caretPo != oCaretPo || this.selectionEnd != this.caretPo) {
            if (this.selectionStart < 0) {
                this.selectionStart = this.caretPo;
            }
            this.selectionEnd = this.caretPo;
            this.stringWidth = -1;
            this.myRepaint();
        }
    }

    public void myRepaint() {
        try {
            this.paint(this.getGraphics());
        }
        catch (Throwable throwable) {}
    }

    public void needsToBeRecalculated() {
        this.stringWidth = -1;
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        this.caret.deactivate(this);
        int width = this.getSize().width;
        if (this.stringWidth >= 0 && this.fieldWidth != width - 2 * (this.maxDescent - this.pad - 1)) {
            this.stringWidth = -1;
        }
        int height = this.getSize().height;
        Color background = this.getBackground();
        Color foreground = this.getForeground();
        O2.drawBox(g, 0, 0, width, height, false, this.pad > 0, background);
        if (this.stringWidth < 0) {
            this.calculateStringSize();
            if (this.stringWidth < 0) {
                return;
            }
        }
        int baseY = (height + this.stringHeight) / 2;
        g.setFont(this.getFont());
        int textLength = this.text.length();
        if (this.stringBegin < 0 || this.stringBegin > textLength) {
            this.stringBegin = O2.minMax(0, textLength, this.stringBegin);
        }
        if (this.stringEnd < 0 || this.stringEnd > textLength) {
            this.stringEnd = O2.minMax(0, textLength, this.stringEnd);
        }
        O2.drawString(g, this.stringBegin == 0 && this.stringEnd == textLength ? this.text : this.text.substring(this.stringBegin, this.stringEnd), this.maxDescent + this.pad + 1, baseY, this.isEnabled(), background, foreground);
        if (this.selectionStart >= 0 && this.isEnabled()) {
            int tSelectionStart = this.selectionStart;
            int tSelectionEnd = this.selectionEnd;
            if (tSelectionStart > tSelectionEnd) {
                int ti = tSelectionStart;
                tSelectionStart = tSelectionEnd;
                tSelectionEnd = ti;
            }
            if (tSelectionStart < this.stringEnd && tSelectionEnd > this.stringBegin) {
                int selectionStartPixel = this.maxDescent + this.pad + 1 + this.fontMetrics.stringWidth(this.text.substring(this.stringBegin, Math.max(this.stringBegin, tSelectionStart)));
                String visibleSelectionString = this.text.substring(Math.max(this.stringBegin, tSelectionStart), Math.min(this.stringEnd, tSelectionEnd));
                int selectionWidthPixel = this.fontMetrics.stringWidth(visibleSelectionString);
                g.setColor(Color.blue.darker().darker());
                g.fillRect(selectionStartPixel, baseY - this.stringHeight - this.maxDescent, selectionWidthPixel, this.stringHeight + 2 * this.maxDescent);
                g.setColor(Color.white);
                g.drawString(visibleSelectionString, selectionStartPixel, baseY);
            }
        }
        if (this.hasFocus) {
            if (this.editable) {
                this.activateCaret();
            } else {
                g.setColor(foreground);
                int offset = this.pad == 0 ? 0 : 1;
                O2.drawDottedRect(g, 2 + offset, 2 + offset, width - 5 - 2 * offset, height - 5 - 2 * offset);
            }
        }
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null && e.getID() == 1001) {
            this.actionListener.actionPerformed(e);
        }
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else if (e instanceof TextEvent) {
            this.processTextEvent((TextEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    public void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            if (!this.hasFocus) {
                this.hasFocus = true;
                this.caret.setComponent(this);
                this.myRepaint();
            }
        } else if (id == 1005 && this.hasFocus) {
            this.hasFocus = false;
            if (this.caret.getComponent() == this) {
                this.caret.setComponent(null);
            }
            this.myRepaint();
        }
        super.processFocusEvent(e);
    }

    public void processKeyEvent(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.editable) {
            super.processKeyEvent(e);
            return;
        }
        int id = e.getID();
        if (id == 401) {
            boolean plain;
            if (!this.hasFocus) {
                this.requestFocus();
            }
            boolean shift = e.isShiftDown();
            boolean control = e.isControlDown();
            boolean controlShift = control && shift;
            boolean alt = e.isAltDown();
            boolean bl = plain = !shift && !control && !alt;
            if (controlShift) {
                shift = false;
                control = false;
            }
            int vk = e.getKeyCode();
            char ch = e.getKeyChar();
            if (vk == 10) {
                if (plain || shift) {
                    this.processEvent(new ActionEvent(this, 1001, this.getText()));
                }
            } else if (vk != 16) {
                if (vk == 8) {
                    if (plain || shift) {
                        this.deleteCharacterLeft();
                    }
                } else if (vk == 37 || vk == 38) {
                    if (plain) {
                        this.moveCaretLeft();
                    } else if (shift) {
                        this.moveSelectionLeft();
                    }
                } else if (vk == 39 || vk == 40) {
                    if (plain) {
                        this.moveCaretRight();
                    } else if (shift) {
                        this.moveSelectionRight();
                    }
                } else if (vk == 36 || vk == 33) {
                    if (plain) {
                        this.moveCaretBegin();
                    } else if (shift) {
                        this.moveSelectionStart();
                    }
                } else if (vk == 35 || vk == 34) {
                    if (plain) {
                        this.moveCaretEnd();
                    } else if (shift) {
                        this.moveSelectionEnd();
                    }
                } else if (vk == 127) {
                    if (plain) {
                        this.deleteCharacterRight();
                    }
                } else if (vk == 155) {
                    if (shift) {
                        this.selectionPaste();
                    }
                } else if (vk != 9 && vk != 27) {
                    if (control) {
                        if (vk == 67) {
                            this.selectionCopy();
                        } else if (vk == 88) {
                            this.selectionCut();
                        } else if (vk == 86) {
                            this.selectionPaste();
                        } else if (vk == 65) {
                            this.selectAll();
                        } else if (vk == 127) {
                            this.selectionDelete();
                        }
                    } else if (!alt && !controlShift && ch != '\u0000') {
                        this.insertCharacter(ch);
                    }
                }
            }
        }
        super.processKeyEvent(e);
    }

    public void processMouseEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int id = e.getID();
        if (id == 501) {
            if ((e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0) {
                if (this.hasFocus) {
                    if (this.editable && this.caret.getComponent() != this) {
                        this.caret.setComponent(this);
                        this.myRepaint();
                    }
                } else {
                    this.requestFocus();
                }
                if (this.isEditable()) {
                    this.selectionStart = -1;
                    this.moveSelectionTo(e.getX());
                }
            }
        } else if (id == 502 && (e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0 && this.isEditable()) {
            this.moveSelectionTo(e.getX());
        }
        super.processMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int id = e.getID();
        if (id == 506 && (e.getModifiers() & 8) == 0 && (e.getModifiers() & 4) == 0 && this.isEditable()) {
            this.moveSelectionTo(e.getX());
            if (!this.hasFocus) {
                this.requestFocus();
            }
        }
        super.processMouseMotionEvent(e);
    }

    protected void processTextEvent(TextEvent e) {
        if (this.textListener != null && e.getID() == 900) {
            this.textListener.textValueChanged(e);
        }
    }

    public void removeActionListener(ActionListener al) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, al);
    }

    public void removeNotify() {
        if (this.caret.getComponent() == this) {
            this.caret.setComponent(null);
        }
    }

    public void removeTextListener(TextListener tl) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, tl);
    }

    public void select(int start, int end) {
        if (Math.min(start, end) < 0 || Math.max(start, end) > this.text.length()) {
            return;
        }
        this.selectionStart = O2.minMax(0, this.text.length(), start);
        this.selectionEnd = O2.minMax(0, this.text.length(), end);
        this.myRepaint();
    }

    public void selectAll() {
        this.select(0, this.text.length());
    }

    public void selectionCopy() {
        if (this.selectionStart < 0) {
            return;
        }
        O2.setClipboard(this.text.substring(Math.min(this.selectionStart, this.selectionEnd), Math.max(this.selectionStart, this.selectionEnd)));
    }

    public void selectionCut() {
        if (this.selectionStart < 0) {
            return;
        }
        int tBegin = Math.min(this.selectionStart, this.selectionEnd);
        int tEnd = Math.max(this.selectionStart, this.selectionEnd);
        O2.setClipboard(this.text.substring(tBegin, tEnd));
        this.text = String.valueOf(this.text.substring(0, tBegin)) + this.text.substring(tEnd, this.text.length());
        this.caretPo = tBegin;
        this.selectionStart = -1;
        this.stringWidth = -1;
        this.myRepaint();
        this.fireTextEvent();
    }

    public void selectionDelete() {
        if (this.selectionStart < 0) {
            return;
        }
        int tBegin = Math.min(this.selectionStart, this.selectionEnd);
        int tEnd = Math.max(this.selectionStart, this.selectionEnd);
        this.text = String.valueOf(this.text.substring(0, tBegin)) + this.text.substring(tEnd, this.text.length());
        this.caretPo = tBegin;
        this.selectionStart = -1;
        this.stringWidth = -1;
        this.myRepaint();
        this.fireTextEvent();
    }

    public void selectionPaste() {
        this.selectionStart = -1;
        String s = O2.getClipboard();
        this.text = String.valueOf(this.text.substring(0, this.caretPo)) + s + this.text.substring(this.caretPo, this.text.length());
        this.caretPo += s.length();
        this.stringWidth = -1;
        this.myRepaint();
        this.fireTextEvent();
    }

    public void setCaretPosition(int po) {
        po = Math.max(0, Math.min(this.text.length(), po));
        if (po != this.caretPo) {
            this.caretPo = po;
            this.stringWidth = -1;
            this.myRepaint();
        }
    }

    public void setColumns(int c) {
        if ((c = Math.max(-1, c)) != this.columns) {
            this.columns = c;
            this.stringWidth = -1;
            this.myRepaint();
        }
    }

    public void setEditable(boolean e) {
        if (e != this.editable) {
            this.editable = e;
            this.myRepaint();
        }
    }

    public void setEnabled(boolean e) {
        if (e != this.isEnabled()) {
            super.setEnabled(e);
            this.myRepaint();
        }
    }

    public void setFont(Font f) {
        if (f != this.getFont()) {
            this.stringWidth = -1;
            super.setFont(f);
            this.fontMetrics = null;
            this.myRepaint();
        }
    }

    public void setForeground(Color c) {
        if (c != this.getForeground()) {
            super.setForeground(c);
            this.myRepaint();
        }
    }

    public void setPad(int p) {
        if (this.pad != (p = O2.validatePad(p))) {
            this.pad = p;
            this.myRepaint();
        }
    }

    public void setSelectionEnd(int end) {
        this.selectionEnd = O2.minMax(0, this.text.length(), end);
        if (this.selectionStart == -1) {
            this.selectionStart = this.selectionEnd;
        }
        this.myRepaint();
    }

    public void setSelectionStart(int start) {
        if (this.selectionStart < 0) {
            this.selectionEnd = -1;
        }
        this.selectionStart = O2.minMax(0, this.text.length(), start);
        if (this.selectionEnd == -1) {
            this.selectionEnd = this.selectionStart;
        }
        this.myRepaint();
    }

    public void setText(String tText) {
        if (this.caretPo == 0 && this.selectionStart == -1 && tText.equals(this.text)) {
            return;
        }
        this.stringWidth = -1;
        this.selectionStart = -1;
        this.caretPo = 0;
        this.text = tText;
        this.myRepaint();
    }

    private void tryToIncreaseStringEnd() {
        int textLength = this.text.length();
        if (this.stringEnd < textLength) {
            boolean done;
            do {
                done = true;
                int charWidth = this.fontMetrics.charWidth(this.text.charAt(this.stringEnd));
                if (this.stringWidth + charWidth >= this.fieldWidth) continue;
                done = false;
                ++this.stringEnd;
                this.stringWidth += charWidth;
            } while (this.stringEnd < textLength && !done);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

