/*
 * Decompiled with CFR 0.152.
 */
package horst.parser;

import horst.parser.Escapes;
import horst.parser.HTMLDefs;
import horst.parser.HTMLTags;
import horst.parser.ParserCallback;
import horst.parser.Tag;
import horst.parser.TagGenerator;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class HTMLParser
implements ParserCallback {
    private static final int TEXT_STATE = 1;
    private static final int TAG_STATE = 2;
    private static final int COMMENT_STATE = 3;
    private static final int TAGQUOTE_STATE = 5;
    private static final int ENTITYREF_STATE = 6;
    private static final int SCRIPT_TAG_STATE = 7;
    private static final int CARRIAGE_RETURN = 13;
    private static final int NEWLINE = 10;
    private static final int TAB = 9;
    private static final char SINGLEQUOTE = '\'';
    private static final char DOUBLEQUOTE = '\"';
    private static final int TYPE_LEN = 256;
    private static final byte T_WHITESPACE = 1;
    private static char[] m_scriptTag = new char[9];
    private static byte[] m_ctype = new byte[256];
    private static Escapes m_escapes = new Escapes();
    ParserCallback m_callback = this;
    Reader m_in;
    int m_tagquote;
    int m_comment;
    int m_script;
    StringBuffer m_buf;
    StringBuffer m_entityBuffer;
    StringBuffer m_scriptBuffer;
    int m_parserState = 1;
    int m_lastState = 1;
    int m_ch;
    boolean m_bSpace;
    boolean m_bPreformat;
    boolean m_bNoBreakSpace;
    BufferedOutputStream m_out;
    TagGenerator m_generator = new HTMLTags();
    boolean m_bPlainText;
    Tag m_lastTag;

    static {
        HTMLParser.m_scriptTag[0] = 60;
        HTMLParser.m_scriptTag[1] = 47;
        HTMLParser.m_scriptTag[2] = 115;
        HTMLParser.m_scriptTag[3] = 99;
        HTMLParser.m_scriptTag[4] = 114;
        HTMLParser.m_scriptTag[5] = 105;
        HTMLParser.m_scriptTag[6] = 112;
        HTMLParser.m_scriptTag[7] = 116;
        HTMLParser.m_scriptTag[8] = 62;
        int len = m_ctype.length;
        int i = 0;
        while (i < len) {
            HTMLParser.m_ctype[i] = 0;
            ++i;
        }
        HTMLParser.m_ctype[32] = 1;
        HTMLParser.m_ctype[13] = 1;
        HTMLParser.m_ctype[10] = 1;
        HTMLParser.m_ctype[9] = 1;
        int i2 = 14;
        while (i2 <= 31) {
            HTMLParser.m_ctype[i2] = 1;
            ++i2;
        }
    }

    private void beginParsing(URLConnection con) throws IOException {
        String contentType = con.getContentType();
        if (contentType != null) {
            this.m_bPlainText = contentType.equals("text/plain");
        }
        InputStream istream = con.getInputStream();
        this.m_in = new BufferedReader(new InputStreamReader(istream), 16384);
        this.m_buf = new StringBuffer();
        this.m_entityBuffer = new StringBuffer();
        this.m_scriptBuffer = new StringBuffer();
        System.gc();
        this.m_callback.startingParsing(con.getURL());
        if (this.m_bPlainText) {
            this.m_callback.handleTag(this.m_generator.getTag("html"), true);
            this.m_callback.handleTag(this.m_generator.getTag("pre"), true);
        }
        this.parseContent();
        if (this.m_bPlainText) {
            this.m_callback.handleTag(this.m_generator.getTag("html"), false);
            this.m_callback.handleTag(this.m_generator.getTag("pre"), false);
        }
        this.m_callback.finishedParsing();
        this.m_callback = null;
    }

    private final void callbackContent() {
        this.m_lastTag = null;
        if (this.m_bNoBreakSpace) {
            this.m_bNoBreakSpace = false;
            int i = 0;
            int buflen = this.m_buf.length();
            int buflen_minus1 = buflen - 1;
            while (i < buflen) {
                if (Character.isWhitespace(this.m_buf.charAt(i))) break;
                ++i;
            }
            if (i == buflen_minus1 && buflen > 1) {
                StringBuffer temp = new StringBuffer();
                temp.append(this.m_buf.charAt(buflen_minus1));
                this.m_buf.setLength(buflen_minus1);
                if (this.m_buf.length() > 0) {
                    this.m_callback.handleContent(this.m_buf);
                }
                if (temp.length() > 0) {
                    this.m_callback.handleContent(temp);
                }
                this.m_buf.setLength(0);
                return;
            }
            if (i < buflen - 1 && buflen > 1) {
                StringBuffer temp = new StringBuffer();
                int j = i + 1;
                while (j < buflen) {
                    temp.append(this.m_buf.charAt(j));
                    ++j;
                }
                this.m_buf.setLength(i + 1);
                this.m_callback.handleContent(this.m_buf);
                this.m_buf.setLength(0);
                if (temp.length() > 0) {
                    this.splitLastWord(temp);
                }
                return;
            }
        }
        this.splitLastWord(this.m_buf);
    }

    private static final int checkRenderable(int c) {
        switch (c) {
            case 146: 
            case 8217: {
                return 39;
            }
            case 8212: {
                return 45;
            }
            case 8226: {
                return 183;
            }
            case 149: {
                return 42;
            }
        }
        return c;
    }

    private final void createStringBuffers() {
        this.m_buf = new StringBuffer(300);
        this.m_entityBuffer = new StringBuffer(50);
        this.m_scriptBuffer = new StringBuffer(200);
    }

    public final void deleteStringBuffers() {
        this.m_buf = null;
        this.m_entityBuffer = null;
        this.m_scriptBuffer = null;
    }

    public void finishedParsing() {
    }

    public File getSourceFile(URL u, String path) {
        File f = new File(path);
        try {
            try {
                FileOutputStream fs = new FileOutputStream(f);
                this.m_out = new BufferedOutputStream(fs);
                this.parse(u.openConnection());
                this.m_out.close();
            }
            catch (IOException e) {
                System.out.println("IOException getSourceFile: " + e);
                f = null;
            }
            Object var5_6 = null;
            this.m_out = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.m_out = null;
            throw throwable;
        }
        return f;
    }

    public void handleContent(StringBuffer txt) {
    }

    public void handleNoBreakSpace() {
    }

    public void handleTag(Tag t, boolean bStartTag) {
    }

    private void insertLineBreak() {
        this.m_callback.handleTag(this.m_generator.getTag(HTMLDefs.getName(7)), true);
    }

    private boolean isNewlineCharacter(int c) {
        switch (c) {
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private boolean isSpace(int c) {
        return c >= 0 && c < 256 ? (m_ctype[c] & 1) != 0 : false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean notifyTagEncountered() {
        tag = null;
        buf = this.m_buf.toString();
        len = buf.length();
        idx = 0;
        begin = 0;
        while (idx < len && this.isSpace(buf.charAt(idx))) {
            ++idx;
        }
        if (idx == len) {
            return false;
        }
        begin = idx;
        while (idx < len && !this.isSpace(buf.charAt(idx))) {
            ++idx;
        }
        token = buf.substring(begin, idx);
        bStartTag = token.charAt(0) != '/';
        tag = bStartTag == false ? this.m_generator.getTag(token.substring(1)) : this.m_generator.getTag(token);
        if (tag != null) ** GOTO lbl21
        return false;
lbl-1000:
        // 1 sources

        {
            ++idx;
lbl21:
            // 2 sources

            ** while (idx < len && this.isSpace((int)buf.charAt((int)idx)))
        }
lbl22:
        // 1 sources

        if (idx != len) {
            this.parseAttributes(tag, buf, idx);
        }
        if (tag.getID() == 28) {
            this.insertLineBreak();
        }
        if (bStartTag) {
            this.m_callback.handleTag(tag, true);
        } else {
            this.m_callback.handleTag(tag, false);
        }
        if (this.m_bSpace && this.m_lastTag != null && this.m_lastTag.breaksFlow()) {
            this.m_bSpace = false;
        }
        this.m_lastTag = tag;
        if (this.m_bPreformat && !bStartTag && tag.getID() == 28) {
            this.m_bPreformat = false;
        } else if (bStartTag && tag.getID() == 28) {
            this.m_bPreformat = true;
        }
        if (this.m_lastTag.getID() == 49 && bStartTag) {
            this.setParserState(7);
        } else {
            this.setParserState(1);
        }
        return true;
    }

    public void parse(Reader r, URL baseURL) throws IOException {
        this.m_in = r;
        this.m_buf.setLength(0);
        this.m_callback.startingParsing(null);
        this.parseContent();
        this.m_callback.finishedParsing();
    }

    public void parse(URL u) throws IOException {
        this.beginParsing(u.openConnection());
    }

    public void parse(URLConnection con) throws IOException {
        this.beginParsing(con);
    }

    /*
     * Unable to fully structure code
     */
    private void parseAttributes(Tag tag, String buf, int idx) {
        len = buf.length();
        begin = 0;
        ** GOTO lbl69
        {
            ++idx;
            do {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                if (idx < len && this.isSpace(buf.charAt(idx))) continue block0;
                                if (idx == len) continue;
                                begin = idx;
                                if (buf.charAt(idx) != '\"') break block13;
                                ++idx;
                                while (idx < len && buf.charAt(idx) != '\"') {
                                    ++idx;
                                }
                                if (idx == len) continue;
                                ++idx;
                                break block14;
                            }
                            if (buf.charAt(idx) != '\'') ** GOTO lbl27
                            ++idx;
                            while (idx < len && buf.charAt(idx) != '\'') {
                                ++idx;
                            }
                            if (idx == len) continue;
                            ++idx;
                            break block14;
lbl-1000:
                            // 1 sources

                            {
                                ++idx;
lbl27:
                                // 2 sources

                                ** while (idx < len && !this.isSpace((int)buf.charAt((int)idx)) && buf.charAt((int)idx) != '=')
                            }
                        }
                        name = buf.substring(begin, idx).toLowerCase();
                        if (idx < len && this.isSpace(buf.charAt(idx))) {
                            while (idx < len && this.isSpace(buf.charAt(idx))) {
                                ++idx;
                            }
                        }
                        if (idx == len || buf.charAt(idx) != '=') {
                            if (tag == null) continue;
                            tag.setAttribute(name, "");
                            continue;
                        }
                        if (++idx == len) continue;
                        if (buf.charAt(idx) == ' ') {
                            while (idx < len && this.isSpace(buf.charAt(idx))) {
                                ++idx;
                            }
                            if (idx == len) continue;
                        }
                        end = begin = idx;
                        if (buf.charAt(idx) != '\"') break block15;
                        begin = ++idx;
                        while (idx < len && buf.charAt(idx) != '\"') {
                            ++idx;
                        }
                        if (idx == len) continue;
                        end = idx++;
                        break block16;
                    }
                    if (buf.charAt(idx) != '\'') ** GOTO lbl63
                    begin = ++idx;
                    while (idx < len && buf.charAt(idx) != '\'') {
                        ++idx;
                    }
                    if (idx == len) continue;
                    end = idx++;
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        ++idx;
lbl63:
                        // 2 sources

                        ** while (idx < len && !this.isSpace((int)buf.charAt((int)idx)))
                    }
lbl64:
                    // 1 sources

                    end = idx;
                }
                value = buf.substring(begin, end);
                if (tag == null) continue;
                tag.setAttribute(name, value);
lbl69:
                // 12 sources

            } while (idx < len);
        }
    }

    private final void parseComment() {
        if (this.m_ch == 62 && this.m_comment >= 2) {
            this.m_buf.setLength(0);
            this.m_comment = 0;
            this.setParserState(1);
            return;
        }
        this.m_comment = this.m_ch == 45 ? ++this.m_comment : 0;
    }

    private void parseContent() throws IOException {
        this.createStringBuffers();
        boolean bPreformated = false;
        this.m_bSpace = false;
        block11: while (true) {
            this.readChar();
            if (this.m_ch < 0) {
                int state = this.m_parserState;
                if (this.m_buf.length() <= 0 || state != 1) break;
                this.m_callback.handleContent(this.m_buf);
                break;
            }
            this.m_ch = HTMLParser.checkRenderable(this.m_ch);
            switch (this.m_parserState) {
                default: {
                    continue block11;
                }
                case 1: {
                    this.parseText();
                    continue block11;
                }
                case 2: {
                    this.parseTag();
                    continue block11;
                }
                case 6: {
                    this.parseEntityReference();
                    continue block11;
                }
                case 3: {
                    this.parseComment();
                    continue block11;
                }
                case 7: {
                    int i;
                    switch (this.m_ch) {
                        case 60: {
                            if (this.m_script == 0) {
                                ++this.m_script;
                                this.m_scriptBuffer.append((char)this.m_ch);
                                continue block11;
                            }
                            this.m_script = 0;
                            if (this.m_scriptBuffer.length() <= 0) continue block11;
                            i = 0;
                            while (i < this.m_scriptBuffer.length()) {
                                this.m_buf.append(this.m_scriptBuffer.charAt(i));
                                ++i;
                            }
                            this.m_scriptBuffer.setLength(0);
                            this.m_buf.append((char)this.m_ch);
                            continue block11;
                        }
                    }
                    if (this.m_script > 0) {
                        if (m_scriptTag[this.m_script] == Character.toLowerCase((char)this.m_ch)) {
                            if (this.m_script == m_scriptTag.length - 1) {
                                this.m_script = 0;
                                this.m_scriptBuffer.setLength(0);
                                if (this.m_buf.length() > 0) {
                                    this.callbackContent();
                                }
                                this.m_callback.handleTag(this.m_generator.getTag(HTMLDefs.getName(49)), false);
                                this.setParserState(1);
                                continue block11;
                            }
                            this.m_scriptBuffer.append((char)this.m_ch);
                            ++this.m_script;
                            continue block11;
                        }
                        this.m_script = 0;
                        i = 0;
                        while (i < this.m_scriptBuffer.length()) {
                            this.m_buf.append(this.m_scriptBuffer.charAt(i));
                            ++i;
                        }
                        this.m_scriptBuffer.setLength(0);
                        this.m_buf.append((char)this.m_ch);
                        continue block11;
                    }
                    this.m_buf.append((char)this.m_ch);
                    continue block11;
                }
                case 5: 
            }
            if (this.m_ch == 62) {
                this.setParserState(2);
                continue;
            }
            if (this.m_ch == 38) {
                this.setParserState(6);
                continue;
            }
            this.m_buf.append((char)this.m_ch);
            if (this.m_ch != this.m_tagquote) continue;
            this.setParserState(2);
        }
    }

    private final void parseEntityReference() throws IOException {
        if (this.m_ch == 35) {
            int n = 0;
            this.readChar();
            if (this.m_ch >= 48 && this.m_ch <= 57) {
                while (this.m_ch >= 48 && this.m_ch <= 57) {
                    n = n * 10 + this.m_ch - 48;
                    this.readChar();
                }
                if (n == 9) {
                    int i = 0;
                    while (i < 3) {
                        this.m_buf.append(' ');
                        ++i;
                    }
                } else {
                    n = HTMLParser.checkRenderable(n);
                    this.m_buf.append((char)n);
                }
                if (this.m_ch == 59) {
                    this.m_parserState = this.m_lastState;
                } else {
                    this.resynchronize();
                }
            } else {
                if (this.m_buf.length() == 0 && this.m_lastTag != null && this.m_lastTag.breaksFlow()) {
                    this.m_bSpace = false;
                }
                if (this.m_bSpace) {
                    this.m_buf.append(' ');
                    this.m_bSpace = false;
                }
                this.m_buf.append('&');
                this.m_buf.append('#');
                this.m_parserState = this.m_lastState;
            }
        } else {
            Character c;
            if (this.m_buf.length() == 0 && this.m_lastTag != null && this.m_lastTag.breaksFlow()) {
                this.m_bSpace = false;
            }
            if (this.m_bSpace && this.m_lastState == 1) {
                this.m_buf.append(' ');
                this.m_bSpace = false;
            }
            if (this.parseIdentifier(false) && (c = (Character)m_escapes.get(this.m_entityBuffer.toString())) != null) {
                if (c.charValue() == ' ') {
                    int buflen = this.m_buf.length();
                    if (buflen > 0) {
                        this.callbackContent();
                    }
                    this.m_callback.handleNoBreakSpace();
                    this.m_bNoBreakSpace = true;
                } else {
                    this.m_buf.append(c.charValue());
                }
                if (this.m_ch == 59) {
                    this.m_parserState = this.m_lastState;
                } else {
                    this.resynchronize();
                }
                return;
            }
            this.m_buf.append('&');
            if (this.m_entityBuffer.length() > 0) {
                char[] dst = new char[this.m_entityBuffer.length()];
                this.m_entityBuffer.getChars(0, this.m_entityBuffer.length(), dst, 0);
                this.m_buf.append(dst);
            }
            this.resynchronize();
        }
    }

    private boolean parseIdentifier(boolean lower) throws IOException {
        char c = (char)this.m_ch;
        this.m_entityBuffer.setLength(0);
        switch (this.m_ch) {
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                if (!lower) break;
                this.m_ch = 97 + (this.m_ch - 65);
                break;
            }
            default: {
                return false;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
        }
        block8: while (true) {
            this.m_entityBuffer.append((char)this.m_ch);
            this.readChar();
            switch (this.m_ch) {
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block8;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    if (!lower) continue block8;
                    this.m_ch = 97 + (this.m_ch - 65);
                    continue block8;
                }
            }
            break;
        }
        return true;
    }

    private final void parseTag() throws IOException {
        switch (this.m_ch) {
            case 60: {
                if (this.m_buf.length() <= 0) break;
                if (this.notifyTagEncountered()) {
                    this.setParserState(2);
                    this.m_buf.setLength(0);
                    break;
                }
                this.m_buf.setLength(0);
                break;
            }
            case 62: {
                if (this.m_buf.length() <= 0) break;
                this.notifyTagEncountered();
                this.setParserState(1);
                this.m_buf.setLength(0);
                break;
            }
            case 34: 
            case 39: {
                this.m_tagquote = this.m_ch;
                this.m_buf.append((char)this.m_ch);
                this.setParserState(5);
                break;
            }
            case 38: {
                this.setParserState(6);
                break;
            }
            default: {
                if (this.m_ch == 45 && this.m_buf.length() == 2 && this.m_buf.charAt(1) == '-' && this.m_buf.charAt(0) == '!') {
                    this.m_buf.setLength(0);
                    this.setParserState(3);
                    break;
                }
                this.m_buf.append((char)this.m_ch);
            }
        }
    }

    private final void parseText() {
        if (this.m_bPlainText || this.m_bPreformat) {
            switch (this.m_ch) {
                case 60: {
                    if (this.m_bPlainText) break;
                    this.setParserState(2);
                    if (this.m_buf.length() <= 0) break;
                    this.callbackContent();
                    break;
                }
                case 38: {
                    this.setParserState(6);
                    break;
                }
                case 10: {
                    if (this.m_buf.length() > 0) {
                        this.callbackContent();
                    }
                    this.insertLineBreak();
                    break;
                }
                case 9: {
                    int i = 0;
                    while (i < 3) {
                        this.m_buf.append(' ');
                        ++i;
                    }
                    break;
                }
                default: {
                    this.m_buf.append((char)this.m_ch);
                }
                case 13: 
            }
            return;
        }
        switch (this.m_ch) {
            case 60: {
                this.setParserState(2);
                if (this.m_bSpace) {
                    this.m_buf.append(' ');
                    this.m_bSpace = false;
                }
                if (this.m_buf.length() <= 0) break;
                this.callbackContent();
                break;
            }
            case 38: {
                this.setParserState(6);
                break;
            }
            default: {
                if (this.isSpace(this.m_ch)) {
                    this.m_bSpace = true;
                    break;
                }
                if (this.m_buf.length() == 0 && this.m_lastTag != null && this.m_lastTag.breaksFlow()) {
                    this.m_bSpace = false;
                }
                if (this.m_bSpace) {
                    this.m_buf.append(' ');
                    this.m_bSpace = false;
                }
                this.m_buf.append((char)this.m_ch);
            }
        }
    }

    private final void readChar() throws IOException {
        this.m_ch = this.m_in.read();
        if (this.m_out != null && this.m_ch >= 0) {
            this.m_out.write(this.m_ch);
        }
    }

    private final void resynchronize() {
        switch (this.m_ch) {
            case 60: {
                this.m_parserState = 2;
                if (this.m_buf.length() <= 0) break;
                if (this.m_bSpace) {
                    this.m_buf.append(' ');
                }
                this.callbackContent();
                break;
            }
            case 38: {
                this.m_parserState = 6;
                break;
            }
            default: {
                if (this.m_bSpace) {
                    this.m_buf.append(' ');
                }
                this.m_buf.append((char)this.m_ch);
                this.m_parserState = this.m_lastState;
            }
        }
    }

    public void setCallback(ParserCallback cb) {
        this.m_bPlainText = false;
        this.m_callback = cb;
        this.setParserState(1);
        this.m_bPreformat = false;
        this.m_lastTag = null;
        this.m_bSpace = false;
    }

    private final void setParserState(int state) {
        this.m_lastState = this.m_parserState;
        this.m_parserState = state;
    }

    public void setTagGenerator(TagGenerator generator) {
        if (generator != null) {
            this.m_generator = generator;
        }
    }

    private final void splitLastWord(StringBuffer buf) {
        int buflen = buf.length();
        int i = buflen - 1;
        while (i >= 0) {
            if (Character.isWhitespace(buf.charAt(i))) break;
            --i;
        }
        if (i < 0) {
            this.m_callback.handleContent(buf);
        } else {
            StringBuffer temp = new StringBuffer();
            if (i == buflen - 1) {
                temp.append(buf.charAt(i));
                if (buflen > 1) {
                    buf.setLength(buflen - 1);
                    this.m_callback.handleContent(buf);
                }
                this.m_callback.handleContent(temp);
            } else {
                int j = i + 1;
                while (j <= buflen - 1) {
                    temp.append(buf.charAt(j));
                    ++j;
                }
                buf.setLength(i + 1);
                this.m_callback.handleContent(buf);
                if (temp.length() > 0) {
                    this.m_callback.handleContent(temp);
                }
            }
        }
        buf.setLength(0);
    }

    public void startingParsing(URL u) {
    }
}

