/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wbi.protocol.http.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;

public class FileGeneratorHelper {
    public static final String COPYRIGHT = " (C) Copyright IBM Corp. 1999, 2000. All Rights Reserved. ";
    String filename;
    File file;

    public FileGeneratorHelper(String s) {
        this.filename = s;
        this.file = new File(this.filename);
    }

    public FileGeneratorHelper(File file1) {
        this.file = file1;
        this.filename = file1.getAbsolutePath();
    }

    public FileGeneratorHelper(FileGeneratorHelper filegeneratorhelper, String s) {
        if (!filegeneratorhelper.isDirectory()) {
            this.filename = "";
            this.file = new File(this.filename);
        } else {
            this.file = new File(filegeneratorhelper.file, s);
            this.filename = this.file.getAbsolutePath();
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long length() {
        return this.file.length();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public File getFile() {
        return this.file;
    }

    public void writeData(OutputStream outputstream) {
        try {
            int i;
            FileInputStream fileinputstream = new FileInputStream(this.file);
            byte[] abyte0 = new byte[1024];
            while ((i = fileinputstream.read(abyte0)) != -1) {
                outputstream.write(abyte0, 0, i);
            }
            fileinputstream.close();
            outputstream.close();
        }
        catch (SocketException sx) {
            System.err.println("FileGeneratorHelper::writeData -- SocketException while copying file");
            System.err.println("Client closed socket too recently.");
        }
        catch (IOException ioexception) {
            System.err.println("FileGeneratorHelper::writeData -- IOException while copying file");
            ioexception.printStackTrace();
        }
    }
}

