/*
 * Decompiled with CFR 0.152.
 */
package evaluator.departureexperiment;

import evaluator.util.DataSourceInterface;
import evaluator.util.ExperimentController;
import evaluator.util.UIToolbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;

public class StartButtonWithTimeout
extends JButton
implements DataSourceInterface {
    private Long _timestamp;
    private boolean _written;
    private Component _toEnable;
    private TimerThread _timerThread = null;

    public StartButtonWithTimeout(ExperimentController experiment, String url) {
        this(experiment, url, 35000L);
    }

    public StartButtonWithTimeout(ExperimentController experiment, String url, long timeout) {
        final ExperimentController _experiment = experiment;
        final String _url = new String(url);
        this._timerThread = new TimerThread(_experiment, timeout);
        this._toEnable = null;
        this._timestamp = new Long(-1L);
        this._written = false;
        this.setEnabled(true);
        this.setText("Start >");
        this.setFont(UIToolbox.PLAINFONT);
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartButtonWithTimeout.this._timestamp = new Long(new Date().getTime());
                StartButtonWithTimeout.this.setEnabled(false);
                StartButtonWithTimeout.this._timerThread.start();
                if (_experiment != null) {
                    if (_url.startsWith("blank")) {
                        _experiment.browserControl("BlankPage", "");
                    } else if (_url.equalsIgnoreCase("BringToFront")) {
                        _experiment.browserControl("BringToFront", "");
                    } else if (_url.equalsIgnoreCase("BlurBrowser")) {
                        _experiment.browserControl("BlurBrowser", "");
                    } else {
                        _experiment.browserControl("BringToFront", _url);
                    }
                }
                if (StartButtonWithTimeout.this._toEnable != null) {
                    StartButtonWithTimeout.this._toEnable.setEnabled(true);
                }
            }
        });
    }

    public void setComponentToEnable(Component component) {
        this._toEnable = component;
        component.setEnabled(false);
    }

    public String getHeader() {
        return "STTS";
    }

    public String getData() {
        return this._timestamp.toString();
    }

    public void next() {
        this._written = true;
    }

    public boolean hasMoreData() {
        return !this._written;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(new Color(230, 230, 128));
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }

    class TimerThread
    extends Thread {
        private ExperimentController _experiment;
        private long _sleepTime;

        public TimerThread(ExperimentController ec, long sleepTime) {
            this._experiment = ec;
            this._sleepTime = sleepTime;
        }

        public void run() {
            if (this._sleepTime > 0L) {
                try {
                    TimerThread.sleep(this._sleepTime);
                    this._experiment.browserControl("BlurBrowser", "");
                    this._experiment.browserControl("BlankPage", "");
                    this._experiment.nextTask();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

