/*
 * Decompiled with CFR 0.152.
 */
package evaluator.hyperscoutexperiment;

import com.ibm.wbi.Meg;
import evaluator.util.BlankPageMeg;
import evaluator.util.EvaluatorFrame;
import evaluator.util.LogMessageJavaScriptAdder;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import scone.Plugin;
import scone.netobjects.AccessCache;
import scone.netobjects.DBTableAdapter;
import scone.util.ErrorLog;

public class HyperScoutEvaluator
extends Plugin {
    final String COMMAND1 = "resources\\scone\\ClearIEHistory.exe";
    final String COMMAND2 = "resources\\scone\\ClearIECache.exe";
    final String COMMAND3 = "resources\\scone\\StartIE.exe http://blank.scone.de/back";

    public int getRequirements() {
        return 0x1120001;
    }

    public void init() {
        System.out.println("");
        int results = 0;
        if (DBTableAdapter.useDb()) {
            try {
                Connection con = DBTableAdapter.getConnection();
                if (con == null) {
                    System.out.println("   Database not activated!!!");
                } else {
                    Statement stmt = con.createStatement();
                    System.out.println("   Delete access-events from NetNodeTable");
                    results = stmt.executeUpdate("update NetNodeTable set firstAccess=-1, lastAccess=-1, accessCounter=0;");
                    System.out.println("   Delete access-events from ServerTable");
                    results = stmt.executeUpdate("update ServerTable set firstAccess=-1, lastAccess=-1, accessCounter=0;");
                    System.out.println("   Delete access-events from AccessTable");
                    results = stmt.executeUpdate("delete from AccessTable;");
                }
            }
            catch (Exception e) {
                ErrorLog.log(this, "HyperscoutEvaluator", "Could not delete access events!", e);
            }
        }
        EvaluatorFrame evaluatorFrame = new EvaluatorFrame(this, "evaluator.hyperscoutexperiment.HyperScoutEvaluatorContentGenerator");
        AccessCache.putObserver(evaluatorFrame.getExperimentController());
        BlankPageMeg blankPageMeg = new BlankPageMeg();
        blankPageMeg.setup("BlankPageMeg - Returns only blank pages.", "host~blank.scone.de | host~_blank.scone.de", 100);
        this.addMeg((Meg)blankPageMeg);
        LogMessageJavaScriptAdder lmjsa = new LogMessageJavaScriptAdder(this);
        lmjsa.setup("LogMessageJavaScriptAdder", "!host=_* & !host=null & content-type=text/html", 60);
        this.addMeg((Meg)lmjsa);
        try {
            System.out.print("   Trying to clear IE history...");
            Process p = Runtime.getRuntime().exec("resources\\scone\\ClearIEHistory.exe");
            System.out.println("OK");
            System.out.print("   Trying to clear IE cache...");
            p = Runtime.getRuntime().exec("resources\\scone\\ClearIECache.exe");
            System.out.println("OK");
            System.out.print("   Trying to start IE...");
            p = Runtime.getRuntime().exec("resources\\scone\\StartIE.exe http://blank.scone.de/back");
            System.out.println("OK");
        }
        catch (IOException e) {
            System.out.println("Failed");
            e.printStackTrace();
        }
    }
}

