/*
 * Decompiled with CFR 0.152.
 */
package evaluator.util;

import evaluator.util.ContentGeneratorInterface;
import evaluator.util.ExperimentController;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import scone.Plugin;
import scone.Scone;

public class EvaluatorFrame
extends JFrame {
    Plugin _plugin;
    ExperimentController _experiment;
    ContentGeneratorInterface _contentGenerator;

    public static void main(String[] args) {
        new EvaluatorFrame(null, "evaluator.ContentGeneratorForDepartureExperiment");
    }

    public EvaluatorFrame(Plugin plugin, String generatorClassName) {
        this._plugin = plugin;
        ImageIcon img = new ImageIcon("resources/evaluator/logo.gif");
        this.setIconImage(img.getImage());
        this._experiment = new ExperimentController(this, this._plugin);
        try {
            this._contentGenerator = (ContentGeneratorInterface)Class.forName(generatorClassName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
        }
        this._contentGenerator.init(this, this._plugin);
        this._contentGenerator.generate(this._experiment);
        this.setTitle("Evaluator");
        this.setForeground(Color.black);
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height - 28);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EvaluatorFrame eframe = (EvaluatorFrame)windowEvent.getWindow();
                eframe.close();
            }
        });
        this._experiment.run();
    }

    public ExperimentController getExperimentController() {
        return this._experiment;
    }

    public void close() {
        this._experiment.browserControl("CloseBrowser", "");
        System.out.println("-> Scone: Closing Browser...\n");
        this.setVisible(false);
        Scone.shutdownWBI(10000);
    }
}

