/*
 * Decompiled with CFR 0.152.
 */
package evaluator.util;

import evaluator.util.DataSourceInterface;
import evaluator.util.EvaluatorFrame;
import evaluator.util.ExperimentOutputWriter;
import evaluator.util.TaskGroup;
import evaluator.util.TaskGroupList;
import evaluator.util.UIToolbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import scone.Plugin;
import scone.accesstracking.AppletConnector;
import scone.accesstracking.FrameAccess;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.util.AlertBox;

public class ExperimentController
implements Observer {
    private EvaluatorFrame _evaluatorFrame;
    private Plugin _plugin;
    private Long _participantNumber;
    private Long _experimentIndex;
    private TaskGroupList _taskGroupList;
    private int _currentTask;
    private int _currentTaskGroup;
    private static ExperimentOutputWriter _experimentOutputWriter;
    static /* synthetic */ Class class$evaluator$util$DataSourceInterface;

    public ExperimentController(EvaluatorFrame evaluatorFrame, Plugin plugin) {
        this._evaluatorFrame = evaluatorFrame;
        this._plugin = plugin;
        this._currentTask = 999999;
        this._experimentIndex = new Long(0L);
        this._participantNumber = new Long(ExperimentOutputWriter.getNextParticipantNumber(this._experimentIndex));
        this._taskGroupList = new TaskGroupList();
    }

    public void addTaskGroup(TaskGroup taskGroup) {
        this._taskGroupList.addTaskGroup(taskGroup);
    }

    public void run() {
        this._currentTaskGroup = 0;
        _experimentOutputWriter = new ExperimentOutputWriter(this._participantNumber, this._experimentIndex);
        this.startTask();
    }

    public void nextTask() {
        ++this._currentTask;
        if (this.isDone()) {
            _experimentOutputWriter.close();
            this._evaluatorFrame.close();
        } else if (this.taskIsDone()) {
            this.stopTask();
            this._currentTask = -1;
            ++this._currentTaskGroup;
            this.nextTask();
        } else {
            TaskGroup taskGroup = this._taskGroupList.getTaskGroup(this._currentTaskGroup);
            Component task = taskGroup.getTask(this._currentTask);
            Box box = Box.createVerticalBox();
            Box countBox = Box.createHorizontalBox();
            countBox.add(Box.createRigidArea(new Dimension(40, 0)));
            JLabel label = this._currentTaskGroup > 0 ? new JLabel("Aufgabe " + this._currentTaskGroup + " von " + (this._taskGroupList.size() - 1)) : new JLabel(" ");
            label.setForeground(Color.black);
            countBox.add(label);
            countBox.add(Box.createHorizontalGlue());
            box.add(countBox);
            box.add(Box.createRigidArea(new Dimension(0, 30)));
            Box itemBox = Box.createHorizontalBox();
            itemBox.add(Box.createRigidArea(new Dimension(40, 0)));
            itemBox.add(task);
            itemBox.add(Box.createHorizontalGlue());
            box.add(itemBox);
            box.add(Box.createRigidArea(new Dimension(0, 30)));
            Box codeBox = Box.createHorizontalBox();
            codeBox.add(Box.createRigidArea(new Dimension(40, 0)));
            JLabel codelabel = new JLabel("pagecode: " + this.calculateCurrentPage() + "." + ".3 ");
            codelabel.setForeground(Color.gray);
            codelabel.setFont(UIToolbox.SMALLFONT);
            codeBox.add(codelabel);
            codeBox.add(Box.createHorizontalGlue());
            box.add(codeBox);
            JPanel boxcapsule = new JPanel();
            boxcapsule.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 204), 1));
            boxcapsule.setAlignmentX(0.5f);
            JPanel capsule = new JPanel();
            Container contentPane = this._evaluatorFrame.getContentPane();
            contentPane.removeAll();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            contentPane.add(Box.createHorizontalGlue());
            capsule.setAlignmentX(0.5f);
            boxcapsule.add(box);
            capsule.add(Box.createHorizontalGlue());
            capsule.add(boxcapsule);
            capsule.add(Box.createHorizontalGlue());
            contentPane.add(capsule);
            contentPane.add(Box.createHorizontalGlue());
            contentPane.validate();
        }
    }

    public void startTask() {
        this._currentTask = -1;
        this.nextTask();
    }

    public void stopTask() {
        TaskGroup taskGroup = this._taskGroupList.getTaskGroup(this._currentTaskGroup);
        for (int task = 0; task < taskGroup.size(); ++task) {
            DataSourceInterface[] sources = this.getDataSources(taskGroup.getTask(task));
            _experimentOutputWriter.write("STEP;" + this._currentTaskGroup + "," + task);
            if (sources == null) continue;
            for (int i = 0; i < sources.length; ++i) {
                _experimentOutputWriter.write(sources[i]);
            }
        }
    }

    public void browserControl(String command, String parameter) {
        FrameAccess fa = FrameAccess.getInstance();
        Set frameNames = fa.getSetOfContents();
        String firstFrameName = "";
        boolean hasNext = false;
        int i = 0;
        do {
            Iterator myIterator;
            if ((hasNext = (myIterator = frameNames.iterator()).hasNext()) || command.equalsIgnoreCase("CloseBrowser")) {
                firstFrameName = (String)myIterator.next();
                continue;
            }
            AlertBox a = new AlertBox(this._evaluatorFrame, new String[]{"Achtung!", "Bitte starten Sie einen Browser, laden Sie eine beliebige Seite und klicken danach OK."});
        } while (!hasNext && ++i <= 2);
        AppletConnector ac = fa.get(firstFrameName);
        if (ac != null) {
            if (command.equalsIgnoreCase("OpenURL")) {
                ac.sendToApplet("OpenURL", parameter, "_top");
            } else if (command.equalsIgnoreCase("BringToFront") && parameter.length() != 0) {
                ac.sendToApplet("BringToFront", "", "");
                ac.sendToApplet("OpenURLDelayed", parameter, "");
            } else if (command.equalsIgnoreCase("BringToFront")) {
                ac.sendToApplet("BringToFront", "", "");
            } else if (command.equalsIgnoreCase("BringToFront")) {
                ac.sendToApplet("BringToFront", "", "");
            } else if (command.equalsIgnoreCase("BlurBrowser")) {
                ac.sendToApplet("BlurBrowser", "", "");
            } else if (command.equalsIgnoreCase("Maximize")) {
                ac.sendToApplet("anyFunction", "window.moveTo(0,0); window.resizeTo(screen.width-1,screen.height-30);", "");
            } else if (command.equalsIgnoreCase("BlankPage")) {
                ac.sendToApplet("OpenURL", "http://blank.scone.de", "_top");
            } else if (command.equalsIgnoreCase("CloseBrowser")) {
                ac.sendToApplet("anyFunction", "history.go(-999); window.close();", "");
            } else {
                System.out.println("ExperimentController.browserControl() -> Unknown command: " + command);
            }
        }
    }

    public void close() {
        this._evaluatorFrame.close();
    }

    private DataSourceInterface[] getDataSources(Component component) {
        Vector dataSources = new Vector();
        this.recursivelyCheckComponents(component, dataSources);
        if (dataSources.size() > 0) {
            return dataSources.toArray(new DataSourceInterface[1]);
        }
        return null;
    }

    private void recursivelyCheckComponents(Component parentComponent, Vector dataSources) {
        if (parentComponent instanceof Container) {
            Container container = (Container)parentComponent;
            for (int c = 0; c < container.getComponentCount(); ++c) {
                Component component = container.getComponent(c);
                this.testForDataSourceInterface(component, dataSources);
                this.recursivelyCheckComponents(component, dataSources);
            }
        }
    }

    private void testForDataSourceInterface(Component component, Vector dataSources) {
        Class<?> cls = component.getClass();
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals((class$evaluator$util$DataSourceInterface == null ? ExperimentController.class$("evaluator.util.DataSourceInterface") : class$evaluator$util$DataSourceInterface).getName())) continue;
            dataSources.add(component);
        }
    }

    private boolean isDone() {
        return this._currentTaskGroup >= this._taskGroupList.size();
    }

    private boolean taskIsDone() {
        if (this.isDone()) {
            return true;
        }
        return this._currentTask >= this._taskGroupList.getTaskGroup(this._currentTaskGroup).size();
    }

    public long getSubjectNumber() {
        return this._participantNumber;
    }

    protected void setSubjectNumber(long subjectNumber) {
        this._participantNumber = new Long(subjectNumber);
    }

    private int calculateCurrentPage() {
        int currentPage = 0;
        for (int t = 0; t < this._currentTaskGroup; ++t) {
            TaskGroup taskGroup = this._taskGroupList.getTaskGroup(t);
            currentPage += taskGroup.size();
        }
        return currentPage += this._currentTask;
    }

    private int calculateLength() {
        int length = 0;
        for (int t = 0; t < this._taskGroupList.size(); ++t) {
            TaskGroup taskGroup = this._taskGroupList.getTaskGroup(t);
            length += taskGroup.size();
        }
        return length;
    }

    public void update(Observable o, Object arg) {
        String action = null;
        if (o instanceof AccessCache) {
            AccessEvent e = (AccessEvent)arg;
            if (e.getNode() == null) {
                System.out.println("OT: Unknown NetNode!");
            } else {
                HtmlNode hNode = HtmlNodeCache.check(e.getNode());
                if (hNode == null) {
                    System.out.println("OT: AccessEvent to unknown or non-HTML-page:" + e.getNode().toString());
                } else if (e.getAccess().getAction() != 0) {
                    if (e.getAccess().getStayTime() == 0L) {
                        action = "SWWW;" + e.getAccess().getTime() + ";" + e.getAccess().getFrameName() + ";" + e.getNode().toString() + ";" + hNode.getTitle() + ";";
                        if ((e.getAccess().getAction() & 1) > 0) {
                            action = action + "link,";
                        }
                        if ((e.getAccess().getAction() & 2) > 0) {
                            action = action + "reference,";
                        }
                        if ((e.getAccess().getAction() & 4) > 0) {
                            action = action + "samePage,";
                        }
                        if ((e.getAccess().getAction() & 8) > 0) {
                            action = action + "submit,";
                        }
                        if ((e.getAccess().getAction() & 0x10) > 0) {
                            action = action + "reloaded,";
                        }
                        if ((e.getAccess().getAction() & 0x20) > 0) {
                            action = action + "back,";
                        }
                        if ((e.getAccess().getAction() & 0x40) > 0) {
                            action = action + "next,";
                        }
                        if ((e.getAccess().getAction() & 0x80) > 0) {
                            action = action + "multi,";
                        }
                        if ((e.getAccess().getAction() & 0x100) > 0) {
                            action = action + "new window,";
                        }
                        if ((e.getAccess().getAction() & 0x200) > 0) {
                            action = action + "bookmark";
                        }
                        _experimentOutputWriter.write(action);
                    } else {
                        action = "FWWW;" + (e.getAccess().getTime() + e.getAccess().getStayTime()) + ";" + e.getAccess().getFrameName() + ";" + e.getNode().toString() + ";" + e.getAccess().getStayTime() + "ms";
                        _experimentOutputWriter.write(action);
                    }
                }
            }
        }
    }

    public static void logMessage(String param) {
        String action = null;
        action = "ACTION;" + new Date().getTime() + ";" + param;
        _experimentOutputWriter.write(action);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

