/*
 * Decompiled with CFR 0.152.
 */
package evaluator.util;

import evaluator.util.DataSourceInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class ExperimentOutputWriter {
    private static final String FILEDIR = "log/experiment-output";
    private static final String SUBJNAME = "sub";
    private static final String EXPRNAME = "exp";
    private String _filename;
    private OutputStreamWriter _outputStreamWriter;
    private boolean _fileIsOpen;

    public ExperimentOutputWriter(long participantNumber, long experimentIndex) {
        this._filename = FILEDIR + File.separator + SUBJNAME + participantNumber + "_" + EXPRNAME + experimentIndex;
        ExperimentOutputWriter.checkOrCreateDirectory();
        File outputFile = new File(this._filename);
        if (outputFile.exists()) {
            File backupFile;
            int index = 0;
            do {
                backupFile = new File(outputFile.getPath() + ".bak" + Integer.toString(index));
                ++index;
            } while (backupFile.exists());
            outputFile.renameTo(backupFile);
        }
        try {
            this._outputStreamWriter = new OutputStreamWriter(new FileOutputStream(outputFile));
        }
        catch (FileNotFoundException fofe) {
            System.err.println(fofe.toString());
            System.exit(-1);
        }
        this._fileIsOpen = true;
    }

    public int close() {
        if (this._fileIsOpen) {
            try {
                this._outputStreamWriter.close();
            }
            catch (IOException ioexception) {
                System.err.println(ioexception.toString());
                return -1;
            }
            this._fileIsOpen = false;
        }
        return 0;
    }

    public int write(String string) {
        try {
            this._outputStreamWriter.write(string + "\r\n");
            this._outputStreamWriter.flush();
        }
        catch (IOException ioexception) {
            System.err.println(ioexception.toString());
            return -1;
        }
        return 0;
    }

    public int write(DataSourceInterface dataSource) {
        if (dataSource == null) {
            return -1;
        }
        try {
            while (dataSource.hasMoreData()) {
                this._outputStreamWriter.write(dataSource.getHeader() + ";");
                this._outputStreamWriter.write(dataSource.getData() + "\r\n");
                dataSource.next();
            }
            this._outputStreamWriter.flush();
        }
        catch (IOException ioexception) {
            System.err.println(ioexception.toString());
            return -1;
        }
        return 0;
    }

    public int write(Long timestamp) {
        try {
            this._outputStreamWriter.write("TIME;" + timestamp.toString() + "\r\n");
            this._outputStreamWriter.flush();
        }
        catch (IOException ioexception) {
            System.err.println(ioexception.toString());
            return -1;
        }
        return 0;
    }

    private static void checkOrCreateDirectory() {
        File dataDirectory = new File(FILEDIR);
        if (!dataDirectory.exists()) {
            System.out.println("\nData direcotry \"log/experiment-output\" missing!");
            System.out.print("Creating Directory...");
            if (dataDirectory.mkdir()) {
                System.out.println("OK");
            } else {
                System.out.println("ERROR!");
            }
        } else if (!dataDirectory.isDirectory()) {
            System.out.println("Error!!! log/experiment-output is no directory!");
        }
    }

    public static long getNextParticipantNumber(long experimentIndex) {
        int participant = 0;
        boolean keepLooking = true;
        ExperimentOutputWriter.checkOrCreateDirectory();
        while (keepLooking) {
            String testFilename = FILEDIR + File.separator + SUBJNAME + participant + "_" + EXPRNAME + experimentIndex;
            File testFile = new File(testFilename);
            if (testFile.exists()) {
                ++participant;
                continue;
            }
            keepLooking = false;
        }
        return participant;
    }
}

