/*
 * Decompiled with CFR 0.152.
 */
package evaluator.util;

import evaluator.util.DataSourceInterface;
import evaluator.util.UIToolbox;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class OptionsBox
extends Box
implements DataSourceInterface {
    String _heading;
    JRadioButton[] _buttons;
    boolean _written;
    int _right = -1;

    public OptionsBox(String heading, String label, String[] options) {
        this(heading, label, options, -1);
    }

    public OptionsBox(String heading, String label, String[] options, int right) {
        super(0);
        this._right = right;
        this._written = false;
        this._heading = heading;
        this._buttons = new JRadioButton[options.length];
        ButtonGroup group = new ButtonGroup();
        JLabel jLabel = new JLabel(label);
        jLabel.setFont(UIToolbox.PLAINFONT);
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(new Dimension(70, 20));
        this.add(jLabel);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        for (int i = 0; i < this._buttons.length; ++i) {
            this._buttons[i] = new JRadioButton(options[i]);
            this._buttons[i].setFont(UIToolbox.PLAINFONT);
            group.add(this._buttons[i]);
            this.add(this._buttons[i]);
            this.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        this.add(Box.createHorizontalGlue());
    }

    public String getHeader() {
        return this._heading;
    }

    public String getData() {
        String result = "";
        for (int i = 0; i < this._buttons.length; ++i) {
            if (this._right == -1) {
                if (!this._buttons[i].isSelected()) continue;
                result = this._buttons[i].getText();
                continue;
            }
            if (!this._buttons[i].isSelected()) continue;
            result = i == this._right ? "right" : "wrong";
        }
        return result;
    }

    public boolean hasMoreData() {
        return !this._written;
    }

    public void next() {
        this._written = true;
    }
}

