/*
 * Decompiled with CFR 0.152.
 */
package evaluator.util;

import evaluator.util.DataSourceInterface;
import evaluator.util.ExperimentController;
import evaluator.util.UIToolbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;

public class StartButton
extends JButton
implements DataSourceInterface {
    private Long _timestamp;
    private boolean _written;
    private Component _toEnable;

    public StartButton(ExperimentController experiment, String url) {
        final ExperimentController _experiment = experiment;
        final String _url = new String(url);
        this._toEnable = null;
        this._timestamp = new Long(-1L);
        this._written = false;
        this.setEnabled(true);
        this.setText("Start >");
        this.setFont(UIToolbox.PLAINFONT);
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartButton.this._timestamp = new Long(new Date().getTime());
                StartButton.this.setEnabled(false);
                if (_experiment != null) {
                    if (_url.equalsIgnoreCase("blank")) {
                        _experiment.browserControl("BlankPage", "");
                    } else if (_url.equalsIgnoreCase("front")) {
                        _experiment.browserControl("BringToFront", "");
                    } else {
                        _experiment.browserControl("BringToFront", _url);
                    }
                }
                if (StartButton.this._toEnable != null) {
                    StartButton.this._toEnable.setEnabled(true);
                }
            }
        });
    }

    public void setComponentToEnable(Component component) {
        this._toEnable = component;
        component.setEnabled(false);
    }

    public String getHeader() {
        return "STTS";
    }

    public String getData() {
        return this._timestamp.toString();
    }

    public void next() {
        this._written = true;
    }

    public boolean hasMoreData() {
        return !this._written;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            this.setBackground(new Color(230, 230, 128));
            this.requestFocus();
        } else {
            this.setBackground(new Color(204, 204, 204));
        }
    }
}

