/*
 * Decompiled with CFR 0.152.
 */
package evaluator.util;

import evaluator.util.DataSourceInterface;
import evaluator.util.UIToolbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class TextEntryBox
extends Box
implements DataSourceInterface {
    private JTextField _jTextField;
    private String _heading;
    private boolean _written;
    private Component _toEnable;

    public TextEntryBox(String heading, String label) {
        this(heading, label, 1300);
    }

    public TextEntryBox(String heading, String label, int width) {
        this(heading, label, width, false);
    }

    public TextEntryBox(String heading, String label, int width, boolean enabled) {
        super(1);
        this._heading = heading;
        this._written = false;
        this._toEnable = null;
        JLabel jLabel = new JLabel(label + "       ");
        jLabel.setFont(UIToolbox.PLAINFONT);
        jLabel.setForeground(Color.black);
        this.add(jLabel);
        this._jTextField = new JTextField();
        this._jTextField.setPreferredSize(new Dimension(width, 20));
        this._jTextField.setMaximumSize(new Dimension(width, 20));
        this._jTextField.setEnabled(enabled);
        this._jTextField.addActionListener(new TextEntryBoxListener());
        this.add(this._jTextField);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this._jTextField.setEnabled(enable);
        if (enable) {
            this._jTextField.setBackground(new Color(255, 255, 255));
            this._jTextField.requestFocus();
        } else {
            this._jTextField.setBackground(new Color(208, 208, 208));
        }
    }

    public void setComponentToEnable(Component component) {
        this._toEnable = component;
        component.setEnabled(false);
    }

    public String getHeader() {
        return this._heading;
    }

    public String getData() {
        return "\"" + this._jTextField.getText() + "\"";
    }

    public void next() {
        this._written = true;
    }

    public boolean hasMoreData() {
        return !this._written;
    }

    class TextEntryBoxListener
    implements ActionListener {
        TextEntryBoxListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (TextEntryBox.this._toEnable != null) {
                TextEntryBox.this._toEnable.setEnabled(true);
            }
            TextEntryBox.this._jTextField.setEnabled(false);
        }
    }
}

