/*
 * Decompiled with CFR 0.152.
 */
package hyperscout;

import com.ibm.wbi.Meg;
import com.ibm.wbi.RequestEvent;
import com.ibm.wbi.RequestRejectedException;
import com.ibm.wbi.ResponseToRequest;
import com.ibm.wbi.protocol.http.DocumentInfo;
import com.ibm.wbi.protocol.http.HttpGenerator;
import com.ibm.wbi.protocol.http.HttpRequest;
import com.ibm.wbi.protocol.http.HttpResponse;
import com.ibm.wbi.protocol.http.beans.StaticHtmlGenerator;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import scone.netobjects.DBTableAdapter;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.Link;
import scone.netobjects.LinkCache;
import scone.netobjects.NetNode;
import scone.netobjects.NetNodeCache;
import scone.netobjects.Server;
import scone.netobjects.ServerCache;

public class PopupGenerator
extends HttpGenerator {
    public static final String COPYRIGHT = "(C) Harald Weinreich & Volkert Buchmann";
    private String hyperScoutBaseUrl = "http://_hyperscout.scone.de/res/";
    private DocumentInfo documentInfo;
    private String file;
    private HttpRequest request;
    private HttpResponse response;
    private String baseNodeId;
    private NetNode baseNode;
    private HtmlNode baseDoc;
    private String query;
    private String popups;
    private Link link;
    private NetNode toNode;
    private HtmlNode doc;
    private static Hashtable mimeTypeTable = new Hashtable();
    private static Hashtable statusTable;

    public void handleRequest(RequestEvent e) throws RequestRejectedException {
        this.documentInfo = (DocumentInfo)e.getRequestInfo();
        this.file = this.documentInfo.getPath();
        this.query = this.documentInfo.getQuery();
        this.request = new HttpRequest((ResponseToRequest)e, true);
        this.popups = new String("");
        if (!this.query.startsWith("?baseNodeId=")) {
            throw new RequestRejectedException();
        }
        int endOfNodeId = this.query.indexOf("&") > 0 ? this.query.indexOf("&") : this.query.length();
        this.baseNodeId = this.query.substring(this.query.indexOf("=") + 1, endOfNodeId);
        System.out.println("Creating popups for " + this.baseNodeId);
        this.query = this.query.substring(endOfNodeId);
        this.baseNode = NetNodeCache.getById(this.baseNodeId);
        if (this.baseNode.getMimeType().equals("text/html") && Integer.parseInt(this.baseNode.getSize()) > 0) {
            this.baseDoc = HtmlNodeCache.get(this.baseNode);
        }
        while (this.query.length() > 0) {
            StringBuffer popupString = new StringBuffer(1024);
            this.query = this.query.substring(1);
            int endOfLinkId = this.query.indexOf("&") > 0 ? this.query.indexOf("&") : this.query.length();
            String linkId = this.query.substring(0, endOfLinkId);
            this.query = this.query.substring(endOfLinkId);
            this.link = LinkCache.getById(linkId);
            this.toNode = this.link.getToNode();
            this.doc = null;
            if (this.toNode.getMimeType().equals("text/html") && Integer.parseInt(this.toNode.getSize()) > 0) {
                this.doc = HtmlNodeCache.get(this.toNode);
            }
            this.addAccessInfo(popupString);
            this.addContentInfo(popupString);
            this.addUsageInfo(popupString);
            this.addTopologicalInfo(popupString);
            this.addActionInfo(popupString);
            this.addFormatInfo(popupString);
            if (popupString.length() == 0) {
                this.popups = this.popups + "hs_newMouseIcon('linkid" + this.link.getLinkId() + "','" + this.hyperScoutBaseUrl + "quest.gif');\n";
                this.popups = this.popups + "hs_noPopup('linkid" + this.link.getLinkId() + "');\n";
                continue;
            }
            this.popups = this.popups + "hs_newPopup('linkid" + this.link.getLinkId() + "','" + popupString.toString() + "');\n";
        }
        StaticHtmlGenerator sg = new StaticHtmlGenerator();
        this.response = sg.getHttpResponse();
        this.response.add("Pragma", "no-cache");
        sg.setStaticHtml(this.popups);
        sg.setContentType("application/x-javascript");
        try {
            this.forwardRequest((Meg)sg, e);
        }
        catch (IOException ex) {
            System.out.println("Error sending response in PopupGenerator!");
        }
    }

    private void addContentInfo(StringBuffer popupString) {
        String lang;
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return;
        }
        if (this.doc != null && this.doc.getTitle().length() > 0) {
            popupString.append(this.tableLine("Title", DBTableAdapter.escape(new StringBuffer(this.doc.getTitle())), "info.gif"));
        }
        if (this.doc != null && this.doc.getDescription().length() > 0) {
            popupString.append(this.tableLine("Description", this.doc.getDescription(), "colors/blank.gif"));
        }
        if (this.doc != null && this.doc.getBodyText().length() > 20 && this.doc.getNumberOfWords().length() > 0) {
            int bodylength = this.doc.getBodyText().length();
            popupString.append(this.tableLine("Content", this.doc.getBodyText().substring(0, Math.min(200, bodylength - 1)), "colors/blank.gif"));
        }
        if (this.doc != null && !this.doc.getLanguage().equals("") && !(lang = this.doc.getLanguage()).equals("?")) {
            if (lang.equals("en")) {
                lang = "English";
            }
            if (lang.equals("de")) {
                lang = "German";
            }
            if (lang.equals("es")) {
                lang = "Spanish";
            }
            if (lang.equals("fr")) {
                lang = "French";
            }
            popupString.append(this.tableLine("Language", lang, "language.gif"));
        }
        if (this.doc != null && this.doc.getAuthor().length() > 0) {
            popupString.append(this.tableLine("Author", this.doc.getAuthor(), "author.gif"));
        }
        if (this.doc != null && this.doc.getLastModified() != -1L) {
            long lastModified;
            long now = new Date().getTime();
            if (now - (lastModified = this.toNode.getLastModified()) < 3600000L) {
                popupString.append(this.tableLine("Updated", String.valueOf((now - lastModified) / 1000L / 60L) + " minutes ago", "clock.gif"));
            } else {
                Date lastModifiedDate = new Date(lastModified);
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd.MMM.yyyy HH:mm:ss", Locale.US);
                String dateString = formatter.format(lastModifiedDate);
                popupString.append(this.tableLine("Updated", dateString, "clock.gif"));
            }
        }
        if (this.doc != null && this.doc.getNumberOfParagraphs().length() > 0) {
            popupString.append(this.tableLine2("Paragraphs", DBTableAdapter.escape(new StringBuffer(this.doc.getNumberOfParagraphs())), "colors/blank.gif"));
        }
        if (this.doc != null && this.doc.getNumberOfWords().length() > 0) {
            popupString.append(this.tableLine2("W\u00f6rter", DBTableAdapter.escape(new StringBuffer(this.doc.getNumberOfWords())), "colors/blank.gif"));
        }
        if (this.doc != null && this.doc.getNumberOfImages().length() > 0) {
            popupString.append(this.tableLine2("Bilder", DBTableAdapter.escape(new StringBuffer(this.doc.getNumberOfImages())), "colors/blank.gif"));
        }
        if (this.doc != null && this.doc.getSpaceOfImages().length() > 0) {
            popupString.append(this.tableLine2("Space", DBTableAdapter.escape(new StringBuffer(this.doc.getSpaceOfImages())), "colors/blank.gif"));
        }
        if (this.doc != null && this.doc.getSpaceOfImages().length() > 2 && this.doc.getNumberOfWords().length() > 0) {
            popupString.append(this.tableLine2("Graphical?", "Space / Words:" + String.valueOf(Long.parseLong(this.doc.getSpaceOfImages()) / (long)Integer.parseInt(this.doc.getNumberOfWords())), "colors/blank.gif"));
        }
    }

    private void addUsageInfo(StringBuffer popupString) {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            return;
        }
        if (this.toNode.getLastAccess() > 0L) {
            long lastAccess;
            long now = new Date().getTime();
            if (now - (lastAccess = this.toNode.getLastAccess()) < 3600000L) {
                popupString.append(this.tableLine("Last visit", String.valueOf((now - lastAccess) / 1000L / 60L) + " minutes ago", "clock.gif"));
            } else {
                Date lastAccessDate = new Date(lastAccess);
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd.MMM.yyyy HH:mm:ss", Locale.US);
                String dateString = formatter.format(lastAccessDate);
                popupString.append(this.tableLine("Last visit", dateString, "clock.gif"));
            }
        }
        if (this.toNode.getAccessCounter() > 1) {
            popupString.append(this.tableLine("Frequency", String.valueOf(this.toNode.getAccessCounter()) + " times accessed", "colors/blank.gif"));
        }
    }

    private void addTopologicalInfo(StringBuffer popupString) {
        if (this.baseNode.toDocString().equals(this.toNode.toDocString())) {
            if (this.link.getFragment().length() > 0) {
                popupString.append(this.tableLine("Reference ", this.link.getFragment(), "updown.gif"));
            } else {
                popupString.append(this.tableLine("Identical", "Pointing to this document", "back.gif"));
            }
            return;
        }
        if ((this.toNode.getProtocol().equals("http") || this.toNode.getProtocol().equals("ftp")) && !this.baseNode.toHostString().equals(this.toNode.toHostString())) {
            popupString.append(this.tableLine("External", this.toNode.toHostString(), "out.gif"));
            Server remoteServer = ServerCache.get(this.toNode.toHostString());
            if (remoteServer.getAccessStatus().equals("err")) {
                popupString.append(this.tableLine("Status", "Server is propably unreachable!", "flash.gif"));
            } else if (remoteServer.getAccessStatus().length() > 0 && !remoteServer.getDelay().equals("0")) {
                popupString.append(this.tableLine("server title", DBTableAdapter.escape(new StringBuffer(remoteServer.getTitle()))));
                popupString.append(this.tableLine("mean delay", "medium", "clock.gif"));
            }
        }
        if (this.baseNode.toHostString().equals(this.toNode.toHostString()) && !this.baseNode.getPath().equals(this.toNode.getPath())) {
            if (this.baseNode.getPath().startsWith(this.toNode.getPath()) || this.toNode.getPath().startsWith(this.baseNode.getPath()) && this.toNode.getPath().endsWith("/../")) {
                popupString.append(this.tableLine("Survey", "Path: " + this.toNode.getPath(), "higher.gif"));
            } else if (this.toNode.getPath().startsWith(this.baseNode.getPath())) {
                popupString.append(this.tableLine("Detail", "Subdirectory: " + this.toNode.getPath().substring(this.baseNode.getPath().length()), "deeper.gif"));
            } else {
                popupString.append(this.tableLine("Associative", "Subdirectory: " + this.toNode.getPath(), "same.gif"));
            }
        }
        if (this.toNode.getQuery().length() > 0) {
            popupString.append(this.tableLine("Query", this.toNode.getQuery(), "questionmark.gif"));
        }
        if (this.toNode.getPath().equals("/") && this.toNode.getFile().equals("")) {
            popupString.append(this.tableLine("Home", "To homepage of server", "home.gif"));
        }
        if (this.doc != null && this.doc.getNumberOfLinks().equals("0")) {
            popupString.append(this.tableLine3("Links", "Dead End: No Links!", "deadend.gif"));
        }
        if (this.doc != null && Integer.parseInt(this.doc.getNumberOfExternalLinks()) > 10) {
            popupString.append(this.tableLine3("Hub page", "External Links: " + this.doc.getNumberOfExternalLinks(), "multilink.gif"));
        }
        if (this.doc != null && Integer.parseInt(this.doc.getNumberOfLinks()) > 20) {
            popupString.append(this.tableLine3("Link page", "Many Links: " + this.doc.getNumberOfLinks(), "multilink.gif"));
        }
    }

    private void addAccessInfo(StringBuffer popupString) {
        int size;
        String status = this.statusDescription(this.toNode.getAccessStatus());
        if (status != null && status.length() != 0 && !status.equals("200") && status.equals("304")) {
            popupString.append(this.tableLine("Status", this.statusDescription(this.toNode.getAccessStatus()), "flash.gif"));
        }
        try {
            size = new Integer(this.toNode.getSize());
        }
        catch (Exception ex) {
            size = 0;
        }
        if (size > 30000) {
            popupString.append(this.tableLine("Big Size", new Integer(size /= 1024).toString() + " kByte", "size.gif"));
        }
    }

    private void addActionInfo(StringBuffer popupString) {
        if (this.toNode.getProtocol().equals("mailto")) {
            popupString.append(this.tableLine("eMail to", this.toNode.getOpaquePart(), "e-mail.gif"));
        }
        if (this.link.getTarget() != null && this.link.getTarget().length() != 0) {
            if (this.link.getTarget().equalsIgnoreCase("_blank")) {
                popupString.append(this.tableLine2("Action", "Opens new window", "new.gif"));
            } else if (this.link.getTarget().equalsIgnoreCase("_parent") || this.link.getTarget().equalsIgnoreCase("_top")) {
                popupString.append(this.tableLine2("Action", "Removes Frames", "colors/blank.gif"));
            } else if (this.link.getTarget().toLowerCase().startsWith("JavaScript:")) {
                popupString.append(this.tableLine2("Action", "JavaScript!", "colors/blank.gif"));
            } else {
                popupString.append(this.tableLine2("Action", "Controls other frame", "colors/blank.gif"));
            }
        }
    }

    private void addFormatInfo(StringBuffer popupString) {
        String mimeType = this.toNode.getMimeType();
        if (mimeType != null && !mimeType.equals("null") && this.mimeTypeDescription(mimeType).length() != 0 && mimeType.indexOf("text/html") == -1) {
            popupString.append(this.tableLine("Type", this.mimeTypeDescription(mimeType), "eye.gif"));
        }
    }

    private String tableLine(String name, String value, String icon, String bgImage) {
        value = this.escapeForJavaScript(value);
        return "<TR><TD class=\"hs-tt1\" width=\"4%\"><IMG src=\"" + this.hyperScoutBaseUrl + icon + "\" width=12 height=12></TD><TD class=\"hs-tt1\" width=\"17%\">" + name + "</TD><TD class=\"hs-td1\" background=\"" + this.hyperScoutBaseUrl + bgImage + "\">" + value + "&nbsp;</TD></TR>";
    }

    private String tableLine(String name, String value, String icon) {
        value = this.escapeForJavaScript(value);
        return "<TR><TD class=\"hs-tt1\" width=\"4%\"><IMG src=\"" + this.hyperScoutBaseUrl + icon + "\" width=12 height=12></TD><TD class=\"hs-tt1\" width=\"17%\">" + name + "</TD><TD class=\"hs-td1\">" + value + "&nbsp;</TD></TR>";
    }

    private String tableLine2(String name, String value, String icon) {
        value = this.escapeForJavaScript(value);
        return "<TR><TD class=\"hs-tt2\" width=\"4%\"><IMG src=\"" + this.hyperScoutBaseUrl + icon + "\" width=12 height=12></TD><TD class=\"hs-tt2\" width=\"17%\">" + name + "</TD><TD class=\"hs-td2\">" + value + "&nbsp;</TD></TR>";
    }

    private String tableLine3(String name, String value, String icon) {
        value = this.escapeForJavaScript(value);
        return "<TR><TD class=\"hs-tt3\" width=\"4%\"><IMG src=\"" + this.hyperScoutBaseUrl + icon + "\" width=12 height=12></TD><TD class=\"hs-tt3\" width=\"17%\">" + name + "</TD><TD class=\"hs-td3\">" + value + "&nbsp;</TD></TR>";
    }

    private String tableLine(String name, String value) {
        value = this.escapeForJavaScript(value);
        return "<TR><TD class=\"hs-tt1\" width=\"21%\" colspan=\"2\">" + name + "</TD><TD class=\"hs-td1\">" + value + "&nbsp;</TD></TR>";
    }

    private String tableLine(String value) {
        value = this.escapeForJavaScript(value);
        return "<TR><TD class=\"hs-tt1\" width=\"4%\"><IMG src=\"" + this.hyperScoutBaseUrl + "url.gif\" width=12 height=12></TD><TD class=\"hs-td1\"  colspan=\"2\">" + value + "&nbsp;</TD></TR>";
    }

    private String escapeForJavaScript(String s) {
        return this.escapeForJavaScript(new StringBuffer(s));
    }

    public String escapeForJavaScript(StringBuffer s) {
        StringBuffer t = new StringBuffer(s.length() + 100);
        block9: for (int i = 0; i < s.length(); ++i) {
            char test = s.charAt(i);
            switch (test) {
                case '\u0000': {
                    t.append(' ');
                    continue block9;
                }
                case '\n': {
                    t.append('\\');
                    t.append('n');
                    continue block9;
                }
                case '\r': {
                    t.append('\\');
                    t.append('r');
                    continue block9;
                }
                case '\b': {
                    t.append('\\');
                    t.append('b');
                    continue block9;
                }
                case '\'': {
                    t.append('\\');
                    t.append('\'');
                    continue block9;
                }
                case '\"': {
                    t.append('\\');
                    t.append('\"');
                    continue block9;
                }
                case '\\': {
                    t.append('\\');
                    t.append('\\');
                    continue block9;
                }
                default: {
                    t.append(test);
                }
            }
        }
        return t.toString();
    }

    private String mimeTypeDescription(String type) {
        String description = "";
        if (type != null) {
            description = (String)mimeTypeTable.get(type);
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    private String statusDescription(String status) {
        String description = "";
        if (status != null) {
            description = (String)statusTable.get(status);
        }
        if (description == null) {
            description = "Unknown status of page!";
        }
        return description;
    }

    static {
        mimeTypeTable.put(new String("application/excel"), new String("Microsoft Excel Table"));
        mimeTypeTable.put(new String("application/mac-binhex40"), new String("Macintosh Compressed File (Binhex)"));
        mimeTypeTable.put(new String("application/pdf"), new String("Adobe Acrobat Document (pdf)"));
        mimeTypeTable.put(new String("application/zip"), new String("ZIP Compressed file"));
        mimeTypeTable.put(new String("image/gif"), new String("Graphics (gif)"));
        mimeTypeTable.put(new String("image/jpeg"), new String("Graphics (jpeg)"));
        mimeTypeTable.put(new String("image/png"), new String("Graphics (png)"));
        mimeTypeTable.put(new String("application/msword"), new String("Microsoft Word Document"));
        mimeTypeTable.put(new String("application/octet-stream"), new String(""));
        mimeTypeTable.put(new String("application/java-vm"), new String("Java Program"));
        mimeTypeTable.put(new String("application/pgp"), new String("Pretty Good Privacy Key"));
        mimeTypeTable.put(new String("application/postscript"), new String("Postscript File"));
        mimeTypeTable.put(new String("application/powerpoint"), new String("Microsoft Powerpoint Presentation"));
        mimeTypeTable.put(new String("application/rtf"), new String("Rich Text Format File (rtf)"));
        mimeTypeTable.put(new String("application/wordperfect5.1"), new String("Word Perfect Document"));
        mimeTypeTable.put(new String("application/x-cdlink"), new String(""));
        mimeTypeTable.put(new String("application/x-compress"), new String("Unix Compressed File"));
        mimeTypeTable.put(new String("application/x-cpio"), new String(""));
        mimeTypeTable.put(new String("application/x-csh"), new String(""));
        mimeTypeTable.put(new String("application/x-debian-package"), new String(""));
        mimeTypeTable.put(new String("application/x-director"), new String(""));
        mimeTypeTable.put(new String("application/x-dvi"), new String(""));
        mimeTypeTable.put(new String("application/x-gtar"), new String("Unix compressed archive"));
        mimeTypeTable.put(new String("application/x-gzip"), new String("Unix comressed file (gzip)"));
        mimeTypeTable.put(new String("application/x-hdf"), new String(""));
        mimeTypeTable.put(new String("application/x-httpd-php"), new String("Dynamic World Wide Web Document"));
        mimeTypeTable.put(new String("application/x-JavaScript"), new String("JavaScript Program Definition"));
        mimeTypeTable.put(new String("application/x-latex"), new String("Latex Document"));
        mimeTypeTable.put(new String("application/x-mif"), new String(""));
        mimeTypeTable.put(new String("application/x-msdos-program"), new String("Executeable programme for PCs"));
        mimeTypeTable.put(new String("application/x-netcdf"), new String(""));
        mimeTypeTable.put(new String("application/x-netcdf"), new String(""));
        mimeTypeTable.put(new String("application/x-perl"), new String("Perl program"));
        mimeTypeTable.put(new String("application/x-sh"), new String("Unix shell script"));
        mimeTypeTable.put(new String("application/x-stuffit"), new String(""));
        mimeTypeTable.put(new String("application/x-tar"), new String("Unix Archive (tar)"));
        mimeTypeTable.put(new String("application/x-tcl"), new String("TCL program file"));
        mimeTypeTable.put(new String("application/x-tex"), new String("TEX Document"));
        mimeTypeTable.put(new String("application/x-texinfo"), new String(""));
        mimeTypeTable.put(new String("application/x-troff-man"), new String("Unix manual pages file"));
        mimeTypeTable.put(new String("application/x-troff-me"), new String(""));
        mimeTypeTable.put(new String("application/x-troff-ms"), new String(""));
        mimeTypeTable.put(new String("application/x-ustar"), new String(""));
        mimeTypeTable.put(new String("application/x-wais-source"), new String("Source File"));
        mimeTypeTable.put(new String("audio/basic"), new String("Audio file"));
        mimeTypeTable.put(new String("audio/midi"), new String("Audio file (midi)"));
        mimeTypeTable.put(new String("audio/mpeg"), new String("Audio file (mp3)"));
        mimeTypeTable.put(new String("audio/x-aiff"), new String("Audio file"));
        mimeTypeTable.put(new String("audio/x-pn-realaudio"), new String("Realaudio file"));
        mimeTypeTable.put(new String("audio/x-wav"), new String("Audio file (wav)"));
        mimeTypeTable.put(new String("image/ief"), new String("Graphics (ief)"));
        mimeTypeTable.put(new String("image/tiff"), new String("Graphics (tiff)"));
        mimeTypeTable.put(new String("image/x-cmu-raster"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-anymap"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-bitmap"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-graymap"), new String(""));
        mimeTypeTable.put(new String("image/x-portable-pixmap"), new String(""));
        mimeTypeTable.put(new String("image/x-rgb"), new String(""));
        mimeTypeTable.put(new String("image/x-xbitmap"), new String(""));
        mimeTypeTable.put(new String("image/x-xpixmap"), new String(""));
        mimeTypeTable.put(new String("image/x-xwindowdump"), new String(""));
        mimeTypeTable.put(new String("model/iges"), new String(""));
        mimeTypeTable.put(new String("model/iges"), new String(""));
        mimeTypeTable.put(new String("model/mesh"), new String(""));
        mimeTypeTable.put(new String("model/vrml"), new String("3D world (VRML)"));
        mimeTypeTable.put(new String("text/css"), new String("Style Definition (CSS)"));
        mimeTypeTable.put(new String("text/html"), new String("Wold Wide Web Document"));
        mimeTypeTable.put(new String("text/plain"), new String("Plain Text Document"));
        mimeTypeTable.put(new String("text/richtext"), new String("Rich Text Format"));
        mimeTypeTable.put(new String("text/tab-separated-values"), new String("Text file"));
        mimeTypeTable.put(new String("text/x-setext"), new String(""));
        mimeTypeTable.put(new String("text/x-sgml"), new String("SGML file"));
        mimeTypeTable.put(new String("text/x-vCalendar"), new String(""));
        mimeTypeTable.put(new String("text/x-vCard"), new String(""));
        mimeTypeTable.put(new String("text/xml"), new String("XML file"));
        mimeTypeTable.put(new String("video/dl"), new String("Video file"));
        mimeTypeTable.put(new String("video/fli"), new String("Video file"));
        mimeTypeTable.put(new String("video/gl"), new String("Video file"));
        mimeTypeTable.put(new String("video/mpeg"), new String("Video file (mpeg)"));
        mimeTypeTable.put(new String("video/quicktime"), new String(""));
        mimeTypeTable.put(new String("video/x-msvideo"), new String("Microsoft video file"));
        mimeTypeTable.put(new String("video/x-sgi-movie"), new String(""));
        mimeTypeTable.put(new String("x-conference/x-cooltalk"), new String(""));
        statusTable = new Hashtable();
        statusTable.put(new String(""), new String(""));
        statusTable.put(new String("-1"), new String(""));
        statusTable.put(new String("100"), new String(""));
        statusTable.put(new String("101"), new String(""));
        statusTable.put(new String("200"), new String(""));
        statusTable.put(new String("201"), new String(""));
        statusTable.put(new String("202"), new String(""));
        statusTable.put(new String("203"), new String(""));
        statusTable.put(new String("204"), new String(""));
        statusTable.put(new String("205"), new String(""));
        statusTable.put(new String("206"), new String(""));
        statusTable.put(new String("300"), new String(""));
        statusTable.put(new String("301"), new String("Document at new address"));
        statusTable.put(new String("302"), new String(""));
        statusTable.put(new String("303"), new String(""));
        statusTable.put(new String("304"), new String("Document was not modified since last visit"));
        statusTable.put(new String("305"), new String(""));
        statusTable.put(new String("400"), new String("Unable to resolve server name"));
        statusTable.put(new String("401"), new String("Error"));
        statusTable.put(new String("402"), new String("Error"));
        statusTable.put(new String("403"), new String("Access to document denied"));
        statusTable.put(new String("404"), new String("Document does NOT exist!"));
        statusTable.put(new String("405"), new String("Error"));
        statusTable.put(new String("406"), new String("Error"));
        statusTable.put(new String("407"), new String("Error"));
        statusTable.put(new String("408"), new String("Error"));
        statusTable.put(new String("409"), new String("Error"));
        statusTable.put(new String("410"), new String("Error"));
        statusTable.put(new String("411"), new String("Error"));
        statusTable.put(new String("412"), new String("Error"));
        statusTable.put(new String("500"), new String("Server error"));
        statusTable.put(new String("501"), new String("Error"));
        statusTable.put(new String("502"), new String("Error"));
        statusTable.put(new String("503"), new String("Error"));
        statusTable.put(new String("504"), new String("Error"));
    }
}

