/*
 * Decompiled with CFR 0.152.
 */
package hyperscout2;

import hyperscout2.Plugin;
import java.util.Date;
import java.util.Hashtable;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.LinkToken;
import scone.netobjects.NetNode;
import scone.netobjects.Server;
import scone.netobjects.ServerCache;
import scone.netobjects.SimpleUri;
import scone.proxy.HtmlTokenEditor;
import scone.robot.NoHtmlNodeException;
import scone.robot.Robot;
import scone.robot.RobotHtmlNode;
import scone.robot.RobotTask;
import scone.robot.RobotUser;
import scone.util.ErrorLog;
import scone.util.tokenstream.HtmlTagToken;
import scone.util.tokenstream.SconePipe;
import scone.util.tokenstream.Token;
import scone.util.tokenstream.TokenInputStream;
import scone.util.tokenstream.TokenOutputStream;

public class LinkEventAdder
extends HtmlTokenEditor
implements RobotUser {
    private Plugin plugin;
    private Robot robot;
    private RobotTask rt;
    private int maxRobotThreads;
    private boolean showUriInStatusbar = true;
    private Hashtable serverlist = new Hashtable();
    private Hashtable nodelist = new Hashtable();

    public LinkEventAdder(Plugin plugin) {
        this.plugin = plugin;
        this.robot = Robot.instance();
        if (plugin.getProperties().get("Start robots") != null) {
            int d = Integer.parseInt(plugin.getProperties().get("Start robots"));
            if (d < 0 || d > 1000) {
                throw new NumberFormatException();
            }
            this.maxRobotThreads = d;
        }
        this.showUriInStatusbar = plugin.getProperties().get("Show URI in statusbar").equals("true");
    }

    public void handleRequest(SconePipe pipe) {
        try {
            TokenInputStream in = pipe.getTokenInputStream();
            TokenOutputStream out = pipe.getTokenOutputStream();
            LinkToken lt = null;
            HtmlTagToken tag = null;
            Token t = null;
            boolean isLink = false;
            int robotThreads = 0;
            while ((t = in.read()) != null) {
                block25: {
                    block26: {
                        if (t instanceof LinkToken) {
                            lt = (LinkToken)t;
                            isLink = true;
                            String onMouseOver = "hs_activate(event,'" + lt.getLink().getLinkId() + "');";
                            if (!this.showUriInStatusbar) {
                                onMouseOver = "window.statusbar='';" + onMouseOver;
                            }
                            String onMouseOut = "hs_deactivate();";
                            String onClick = "hs_deactivate();";
                            if (lt.hasParam("onmouseover")) {
                                onMouseOver = onMouseOver + lt.getParam("onmouseover");
                                lt.removeParam("onmouseover");
                            }
                            if (lt.hasParam("onmouseout")) {
                                onMouseOut = onMouseOut + lt.getParam("onmouseout");
                                lt.removeParam("onmouseout");
                            }
                            if (lt.hasParam("onclick")) {
                                onClick = onClick + lt.getParam("onclick");
                                lt.removeParam("onclick");
                            }
                            if (!this.showUriInStatusbar) {
                                onMouseOver = onMouseOver + ";return true;";
                            }
                            lt.setParam("onmouseover", onMouseOver, "onMouseOver");
                            lt.setParam("onmouseout", onMouseOut, "onMouseOut");
                            lt.setParam("onclick", onClick, "onClick");
                            if (lt.hasParam("title")) {
                                lt.removeParam("title");
                            }
                            if (lt.hasParam("alt")) {
                                lt.removeParam("alt");
                            }
                            NetNode baseNode = lt.getLink().getFromNode();
                            NetNode toNode = lt.getLink().getToNode();
                            Server server = ServerCache.get(lt.getLink().getToNode().getHost());
                            if (!baseNode.getHost().equals(toNode.getHost()) && toNode.getHost().length() >= 5 && this.serverlist.get(toNode.toHostString()) == null && robotThreads < this.maxRobotThreads) {
                                this.serverlist.put(toNode.toHostString(), toNode.toHostString());
                                try {
                                    this.rt = new RobotTask(new SimpleUri("http://" + toNode.getHost() + "/"), 0, 4, this);
                                    System.out.println("Robot gestartet: " + toNode.getHost() + "<");
                                    this.rt.setMaxPageSize(15000);
                                    this.rt.setMaxDownloadTime(7000L);
                                    this.rt.setExpiry(60000L);
                                    this.rt.setUpdateDate(new Date().getTime() - 300000L);
                                    this.robot.scan(this.rt);
                                    ++robotThreads;
                                }
                                catch (Exception ex) {
                                    System.err.println("Robot Error:" + ex.toString());
                                }
                            }
                            if (!(toNode.getHost().length() < 5 || toNode.getQuery().length() != 0 || HtmlNodeCache.check(toNode) != null && toNode.getAccessStatus().equals("200") || this.nodelist.get(toNode.toDocString()) != null || this.serverlist.get(toNode.toDocString()) != null || robotThreads >= this.maxRobotThreads)) {
                                this.nodelist.put(toNode.toDocString(), toNode.toDocString());
                                try {
                                    this.rt = new RobotTask(toNode.getSUri(), 0, 4, this);
                                    System.out.println("Robot gestartet: " + toNode.toDocString());
                                    if (toNode.getMimeType().indexOf("text") >= 0 || toNode.getMimeType().length() == 0) {
                                        this.rt.setMaxPageSize(15000);
                                        this.rt.setMaxDownloadTime(7000L);
                                        this.rt.setExpiry(60000L);
                                        this.rt.setUpdateDate(new Date().getTime() - 604800000L);
                                    } else {
                                        this.rt.setHeadOnly(true);
                                        this.rt.setExpiry(60000L);
                                    }
                                    this.robot.scan(this.rt);
                                    ++robotThreads;
                                }
                                catch (Exception ex) {
                                    System.err.println("Robot Error:" + ex.toString());
                                }
                            }
                        }
                        if (!(t instanceof HtmlTagToken)) break block25;
                        tag = (HtmlTagToken)t;
                        if (tag.getTagType() == 50 && isLink) {
                            tag.removeParam("alt");
                        }
                        if (tag.getTagType() == 1) break block26;
                        if (tag.getTagType() != 6) break block25;
                    }
                    if (tag.isEndTag()) {
                        isLink = false;
                    }
                }
                out.write(t);
            }
        }
        catch (Exception exc) {
            ErrorLog.log(this, "handleRequest()", "", exc);
        }
    }

    public void robotNewPage(RobotHtmlNode robotHtmlNode, RobotTask robotTask) {
        try {
            System.out.println("Seite geladen: " + robotHtmlNode.getHtmlNode().getTitle());
        }
        catch (NoHtmlNodeException e) {
            System.out.println("Head geladen: " + robotTask.getStartURI().toString());
        }
    }

    public void robotTaskFinished(RobotTask robotTask) {
        System.out.println("Auftrag: " + robotTask.getStartURI().toString() + " Tiefe: " + robotTask.getDepth() + " abgeschlossen");
    }
}

