/*
 * Decompiled with CFR 0.152.
 */
package hyperscout2;

import com.ibm.wbi.Meg;
import hyperscout2.LinkDataGenerator;
import hyperscout2.LinkEventAdder;
import hyperscout2.PopupCodeAdder;
import java.util.Observable;
import java.util.Observer;
import scone.netobjects.AccessCache;
import scone.netobjects.AccessEvent;
import scone.netobjects.HtmlNode;
import scone.netobjects.HtmlNodeCache;
import scone.netobjects.LinkCache;
import scone.netobjects.LinkVector;
import scone.proxy.GeneralResourceGenerator;

public class Plugin
extends scone.Plugin
implements Observer {
    public int getRequirements() {
        return 17956873;
    }

    public int getRasPort() {
        return 8084;
    }

    public void init() {
        GeneralResourceGenerator.addPath("/_hyperscout2/resources", "resources/hyperscout2");
        PopupCodeAdder pAdder = new PopupCodeAdder();
        pAdder.setup("hs2: PopupCodeAdder", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 60);
        this.addMeg((Meg)pAdder);
        LinkEventAdder lea = new LinkEventAdder(this);
        lea.setup("hs2: LinkEventAdder", "!host=null & !host=_* & !host=users.scone.de & !host=tracking.scone.de & content-type=text/html", 60);
        this.addMeg((Meg)lea);
        LinkDataGenerator.init(this);
    }

    public void update(Observable o, Object arg) {
        if (o instanceof AccessCache) {
            AccessEvent e = (AccessEvent)arg;
            System.out.println("HyperScout 2 ---> " + e.getUser().getUserName() + ": " + e.getNode().toString());
            HtmlNode hNode = HtmlNodeCache.check(e.getNode());
            if (hNode == null) {
                System.out.println("hm, das war keine html seite");
            } else {
                System.out.println("Title: " + hNode.getTitle());
                LinkVector lv = LinkCache.getLinksTo(e.getNode());
                System.out.println("Known links to this page: " + lv.size());
                for (int i = 0; i < lv.size(); ++i) {
                    System.out.print(HtmlNodeCache.check(lv.linkAt(i).getFromNode()));
                    if (lv.linkAt(i).getFragment().length() > 0) {
                        System.out.println("<-#" + lv.linkAt(i).getFragment());
                        continue;
                    }
                    System.out.println();
                }
                System.out.println("-END---");
            }
        }
    }
}

